% -------------------------------------------
%    ,
%     .
% -------------------------------------------
%  :
%   M     -     (.)
%   R     -     (.)
%   gamma -       (%)
%  :
%   T     -     (.)
%   Sy    -       (.)
%   tmax  -     
%   smax  -    
%   vye   -        
%
function [T,Sy,smax,tmax,vye]=f_asteroid(M,R,gamma)
%
% -------------------------------------------
G = 6.6740831e-11;           %  
disp(strcat('  (.) =', num2str(R/1000)));
disp(strcat(' (.) =', num2str(M)));
g=G*M/R^2;
disp(strcat('     (./.^2) =', num2str(g)));
VS1=sqrt(G*M/R);
disp(strcat('   (./) =', num2str(VS1)));
if abs(gamma) < 0.002
    gamma=0.002;
    disp('        0.002(%)');
end; 
%  
dt=(abs(gamma)*R)/(200*VS1);
disp(strcat('   (.) =', num2str(dt)));
%    
[V0,Vxb,Vyb,alpha]=f_dialogVyVx(VS1);
%            
tic                        %     
disp('-------------------------------------------------------');
disp('   !     ...');
disp('    ,    .');
disp('       Ctrl+Break ');
disp('-------------------------------------------------------');
[T,Sy,smax,tmax,vye]=f_Vy2Sy(M,R,Vyb,dt);
%   
disp(strcat('   (.) =',num2str(smax)));
disp(strcat('     (.) =',num2str(tmax)));
n=length(T);              %     
Tx=T(n);                  %         
disp(strcat('     (.) =',num2str(Tx)));
Lx=Vxb*Tx;                %   
disp(strcat('     (.) =',num2str(Lx)));
disp(strcat('   (./.) =',num2str(Vyb)));
disp(strcat('     (./.) =',num2str(vye)));
Vxy=sqrt(Vxb^2+vye^2);    %     
disp(strcat('     (./.) =',num2str(Vxy)));
disp(strcat('       (%) =',num2str(100*(Vxy-V0)/V0)));
%   
plot(T,Sy);
xlabel(' (.)');
ylabel('   (.) ');
title('  ');
grid on;
disp('-------------------------------------------------------');
disp('        = g');
t=2*Vyb/g;
L=Vxb*t;
h=(Vyb^2)/(2*g);
disp(strcat('(g=const)    (.) =',num2str(h)));
disp(strcat('(g=const)      (.) =',num2str(t/2)));
disp(strcat('(g=const)      (.) =',num2str(L)));
disp(strcat('(g=const)      (.) =',num2str(t)));
disp('-------------------------------------------------------');
% -------------------
ptime=toc;                %      
disp(strcat('   (.) =',num2str(ptime)));
disp('  ...');
