function [A]=LSM02Free(F,V)
% -------------------------------------------------------------------------
% Least Squares_Method
%        
% -------------------------------------------------------------------------
%  :
%                       [A]=LSM01Free(F,V)
% 
%  F -     :
%
%    x1 x2 x3 x4 .... xM
%    y1 y2 y3 y4 .... yM
%
%  V -       :
%
%    v1
%    v2
%   ....................
%    vN
% 
%   (  ): 
% 
%      x=[0:pi/100:2*pi];
%      y=eval('x+sin(x)-log(x+1)');
%      F=[x;y];
%
%      V = ['x^0     '; 'x       '; 'sin(x)  '; 'log(x+1)']; 
%      !         
%          .
%
%          V:
%      V = char('x^0', 'x', 'sin(x)', 'log(x+1)');
%
%   :
%  [A]=LSM01(F,V)
%
%  :
%     : 3.5527e-014
%  A =
%    0.0000
%    1.0000
%    1.0000
%   -1.0000
% -------------------------------------------------------------------------
% 
if isempty(F) || isempty(V)
   disp('     '); 
   A=NaN;
   return
end;
%   
if (size(F,1) ~= 2)
   disp('  [F]  '); 
   A=NaN;
   return
end;
nV=size(V,1);
if (size(F,2) < nV)
   disp('   [F]     [V]'); 
   A=NaN;
   return
end;
%   
C=zeros(nV,nV);
B=zeros(nV,1);
%      
%     'C'
for row=1:nV
    %   'x'  'F'
    B(row,1)=0;
    for k=1:size(F,2)
        x=F(1,k);
        B(row,1)=B(row,1)+eval(V(row,:))*F(2,k);  
    end;
    %     'C'
    for col=1:nV
        %   'x'  'F'
        C(row,col)=0;
        for k=1:size(F,2)
            x=F(1,k);
            C(row,col)=C(row,col)+eval(V(row,:))*eval(V(col,:));  
        end;
    end;
end;
%     
ab=cat(2,C,B);
A = fgauss01(ab);

%      
%   'x'  'F'
for k=1:size(F,2)
    x=F(1,k);
    y(1,k)=0;
    %     'V'
    for row=1:nV
        y(1,k)=y(1,k)+A(row,1)*eval(V(row,:)); 
    end;   
end;

clf;
hold on;

disp('   '); 
%     
plot(F(1,:),F(2,:),':b');
grid on;

disp('...'); 
reply=input('    ?  y/n [y]: ','s');
if isempty(reply)
    reply = 'y';
end;
if reply == 'y'
   %     
   plot(F(1,:),y,'-r');
end;   
grid on;
hold off;

disp('...');
delta=F(2,:)-y;
maxdelta=max(abs(delta));
disp(strcat('   : ', num2str(maxdelta)));

disp('...'); 
reply=input('    ?  y/n [y]: ','s');
if isempty(reply)
    reply = 'y';
end;
if reply == 'y'
   %    
   if max(abs(delta)) > 1e-16
      plot(F(1,:),delta);
      grid on;
   end;
end;

disp('...');
reply=input('   Enter...');
close all hidden;