function [A,rc,AbsErr]=TestLSM03(F,nV)
% Least Squares_Method
%       x^n
%  :
%                       [A,AbsErr]=LSM03(F,nV)
% 
%  F -     :
%
%    x1 x2 x3 x4 .... xM
%    y1 y2 y3 y4 .... yM
%  
%  nV -    
%
%   (  ): 
% 
%    x=[0:pi/100:2*pi];
%    y=eval('x+sin(x)-log(x+1)');
%
%    F=[x;y];
%
%   :
%  [A]=LSM03(F,10)
%
%  :
%     : 0.00028535
%  A =
%   -0.0003
%    1.0068
%    0.4619
%   -0.4028
%    0.1001
%   -0.0232
%    0.0070
%   -0.0013
%    0.0001
%   -0.0000    
%    
if isempty(F)
   disp(' [F]  '); 
   A=NaN;
   return
end;
%   
if (size(F,1) ~= 2)
   disp('  [F]  '); 
   A=NaN;
   return
end;
if (size(F,2) < nV)
   disp('   [F]     [V]'); 
   A=NaN;
   return
end;
%   
C=zeros(nV,nV);
B=zeros(nV,1);
%      
%     'C'
for row=1:nV
    %   'x'  'F'
    B(row,1)=0;
    for k=1:size(F,2)
        x=F(1,k);
        B(row,1)=B(row,1)+ (F(1,k)^(row-1))*F(2,k);  
    end;
    %     'C'
    for col=1:nV
        %   'x'  'F'
        C(row,col)=0;
        for k=1:size(F,2)
            x=F(1,k);
            C(row,col)=C(row,col)+(F(1,k)^(row-1))*(F(1,k)^(col-1));  
        end;
    end;
end;
%     
  ab=cat(2,C,B);
  A = fgauss01(ab);
%    ,     
% A=inv(C)*B;
% A=C\B;

rc = rcond(C);
   
%      
%   'x'  'F'
for k=1:size(F,2)
    x=F(1,k);
    y(1,k)=0;
    %     'V'
    for row=1:nV
        y(1,k)=y(1,k)+A(row,1)*(F(1,k)^(row-1)); 
    end;   
end;

%      
delta=F(2,:)-y;
AbsErr=max(abs(delta));
disp(strcat('nV : ', num2str(nV), ' RCOND : ', num2str(rc),' . .  : ', num2str(AbsErr)));

close all hidden;