function [A,AbsErr]=LSM03Free(F,V,b1,b2,b3)
% -------------------------------------------------------------------------
% Least Squares_Method
%        
% -------------------------------------------------------------------------
%  :
%                       [A,AbsErr]=LSM03Free(F,V,b1,b2,b3)
% 
%  F -     :
%
%    x1 x2 x3 x4 .... xM
%    y1 y2 y3 y4 .... yM
%
%  V -       :
%
%    v1
%    v2
%    v3
%   .....
%    vN
% 
%   (   ): 
% 
%          ( V):
%      v1='x.^0';
%      v2='1-exp(-x./b2)';
%      v3='sin(x.*b3)./(1+x.^2)';
%      ....
%      vN= '...';
%         
%      V=char(v1, v2, v3, ... vN);
%
%  
% -------------------------------------------------------------------------
% 
%   
if (size(F,1) ~= 2)
   disp('  [F]  '); 
   A=NaN;
   return
end;
nV=size(V,1);
if (size(F,2) < nV)
   disp('   [F]     [V]'); 
   A=NaN;
   return
end;
%    (    )
C=zeros(nV,nV);
B=zeros(nV,1);
%      
%     'C'
for row=1:nV
    %   'x'  'F'
    B(row,1)=0;
    for k=1:size(F,2)
        x=F(1,k);
        B(row,1)=B(row,1)+eval(V(row,:))*F(2,k);  
    end;
    %     'C'
    for col=1:nV
        %   'x'  'F'
        C(row,col)=0;
        for k=1:size(F,2)
            x=F(1,k);
            C(row,col)=C(row,col)+eval(V(row,:))*eval(V(col,:));  
        end;
    end;
end;
%     
ab=cat(2,C,B);
A = fgauss01(ab);

%      
%   'x'  'F'
for k=1:size(F,2)
    x=F(1,k);
    y(1,k)=0;
    %     'V'
    for row=1:nV
        y(1,k)=y(1,k)+A(row,1)*eval(V(row,:)); 
    end;   
end;

clf;
hold on;

disp('   '); 
%     
plot(F(1,:),F(2,:),':b');
grid on;

disp('...'); 
reply=input('    ?  y/n [y]: ','s');
if isempty(reply)
    reply = 'y';
end;
if reply == 'y'
   %     
   plot(F(1,:),y,'-r');
   grid on;
end;   

disp('...');
delta=F(2,:)-y;
AbsErr=max(abs(delta));
disp(strcat('   : ', num2str(AbsErr)));

disp('...'); 
reply=input('    ?  y/n [y]: ','s');
hold off;
if isempty(reply)
    reply = 'y';
end;
if reply == 'y'
   %    
   if max(abs(delta)) > 1e-16
      plot(F(1,:),delta);
      grid on;
   end;
end;

disp('...');
reply=input('    Enter...');
close all hidden;
