unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Math, MyMath1V2, GraphXYv50, Buttons;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    CBoxReportCmd: TComboBox;
    Label5: TLabel;
    MemoReport: TMemo;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    PanelP: TPanel;
    PanelI: TPanel;
    PanelD: TPanel;
    Panel2: TPanel;
    Label8: TLabel;
    EditNumP: TEdit;
    Label4: TLabel;
    EditXB: TEdit;
    Label7: TLabel;
    EditXE: TEdit;
    CmbBoxMhetod: TComboBox;
    Label12: TLabel;
    Panel3: TPanel;
    Label1: TLabel;
    ListBoxCoeff: TListBox;
    Panel5: TPanel;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Label13: TLabel;
    StaticTextCoffCount: TStaticText;
    Label14: TLabel;
    StaticTextMaxPower: TStaticText;
    StaticTextFileName: TStaticText;
    Label15: TLabel;
    SpButLoadCoeff: TSpeedButton;
    SpButSaveCoeff: TSpeedButton;
    Label6: TLabel;
    CmbBoxFuncInd: TComboBox;
    SpButLoadFuncCoeff: TSpeedButton;
    Label2: TLabel;
    EditCoeff: TEdit;
    EditPower: TEdit;
    SpButAddCoeff: TSpeedButton;
    SpButEditCoeff: TSpeedButton;
    SpButDelCoeff: TSpeedButton;
    Label10: TLabel;
    EditX: TEdit;
    SpButCalcPolinom: TSpeedButton;
    Label11: TLabel;
    EditPolinom: TEdit;
    CbBoxXbXeX: TComboBox;
    SpButCalcIntegral: TSpeedButton;
    SpButPi: TSpeedButton;
    SpButE: TSpeedButton;
    EditScale: TEdit;
    Panel4: TPanel;
    EditOp1: TEdit;
    EditOp2: TEdit;
    EditRes: TEdit;
    SpButPlus: TSpeedButton;
    SpButMinus: TSpeedButton;
    SpButMult: TSpeedButton;
    SpButDiv: TSpeedButton;
    SpButFunc: TSpeedButton;
    CbBoxSelFunc: TComboBox;
    Label3: TLabel;
    Label9: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Image2: TImage;
    Label18: TLabel;
    SpButSaveGraphIntegtal: TSpeedButton;
    Label19: TLabel;
    SpButSaveAbsErrorGraphic: TSpeedButton;
    SpButSavePolinomGraphic: TSpeedButton;
    Label20: TLabel;
    Label21: TLabel;
    SpButRunReportFunc: TSpeedButton;
    procedure ButtonAddClick(Sender: TObject);
    procedure ListBoxCoeffClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CmbBoxFuncIndClick(Sender: TObject);
    procedure SpButAddCoeffClick(Sender: TObject);
    procedure SpButEditCoeffClick(Sender: TObject);
    procedure SpButDelCoeffClick(Sender: TObject);
    procedure SpButCalcPolinomClick(Sender: TObject);
    procedure SpButSaveCoeffClick(Sender: TObject);
    procedure SpButLoadCoeffClick(Sender: TObject);
    procedure SpButLoadFuncCoeffClick(Sender: TObject);
    procedure SpButCalcIntegralClick(Sender: TObject);
    procedure SpButPiClick(Sender: TObject);
    procedure SpButEClick(Sender: TObject);
    procedure SpButPlusClick(Sender: TObject);
    procedure SpButMinusClick(Sender: TObject);
    procedure SpButMultClick(Sender: TObject);
    procedure SpButDivClick(Sender: TObject);
    procedure SpButFuncClick(Sender: TObject);
    procedure SpButSaveGraphIntegtalClick(Sender: TObject);
    procedure SpButSaveAbsErrorGraphicClick(Sender: TObject);
    procedure SpButSavePolinomGraphicClick(Sender: TObject);
    procedure SpButRunReportFuncClick(Sender: TObject);
  private
    //   ListBox
    procedure ShowListBoxParm();
    //     
    procedure SaveGraphAsJpg (RqGraph : TGraphXY);
  public
end;

var
  Form1: TForm1;

//  Edit.Text  
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;

// =================================================================
// =================================================================
implementation
{$R *.dfm}
// =================================================================
// =================================================================
//   
type TD1ArrA = array of extended;
// -----------------------------------------------------------------
//   
type TD1ArrP = array of record
                          Y,        //  
                          X,        //  
                          Ind,      //   
                          Itm       //   
                          : extended;
                        end;
// -----------------------------------------------------------------
//      
type TD1ArrI = array of record
                          Precise,  //  
                          Approx,   //   
                          Delta     // . 
                          : extended;
                        end;
// =================================================================
//  
var GraphP : TGraphXY;    //  
    GraphI : TGraphXY;    //  
    GraphD : TGraphXY;    //  
// -----------------------------------------------------------------
//   
var ArrA  : TD1ArrA;      //   
    ArrP  : TD1ArrP;      //   
    ArrI  : TD1ArrI;      //   
// -----------------------------------------------------------------
//   
var GArrP  : TGraphArr;   //   
    GArrI  : TGraphArr;   //   
    GArrD  : TGraphArr;   //   

// =================================================================
//          
// =================================================================
//  ,    
function Polynom (RqArrA : TD1ArrA; RqX : extended) : extended;
var Ind : integer;
    PwX : extended;
begin
  Result := 0;
  if Length(RqArrA) < 1 then Exit;
  PwX := 1;
  for Ind := Low(RqArrA) to High(RqArrA)
  do begin
    Result := Result + RqArrA[Ind] * PwX;
    PwX := PwX * RqX;
  end;
end;
// -----------------------------------------------------------------
//      (0..RqX)  ,
//    
function PolynomIntegral (RqArrA : TD1ArrA; RqX : extended) : extended;
var Ind : integer;
    PwX : extended;
begin
  Result := 0;
  if (Length(RqArrA) < 1) or (RqX = 0) then Exit;
  PwX := RqX;
  for Ind := Low(RqArrA) to High(RqArrA)
  do begin
    Result := Result + RqArrA[Ind] * PwX / (Ind + 1);
    PwX := PwX * RqX;
  end;
end;
// -----------------------------------------------------------------
//      (XB..RE)  ,
//    
function PolynomIntegralXBE (RqArrA : TD1ArrA; XB, XE : extended) : extended;
begin
  Result := PolynomIntegral(RqArrA, XE) - PolynomIntegral(RqArrA, XB);
end;

// -----------------------------------------------------------------
//    RqArrP   .  RqArrA
procedure MakeTabFunc (RqArrA : TD1ArrA;
                       XB, XE : extended;
                       NumPn   : integer;
                   var RqArrP : TD1ArrP);
const Delta = 1.e-20;
var Ok              :  boolean;
    Ind1, Ind2      : integer;
    dX, X, PwX, Itm : extended;
begin
  if (Length(RqArrA) < 1) or (XB >= XE) or (NumPn < 2)
  then begin
     SetLength(RqArrP, 0); Exit;
  end;
  //     
  SetLength(RqArrP, NumPn);
  dx := (XE - XB) / High(RqArrP);
  //   
  SetLength(GArrP, NumPn);
  //       . 
  for Ind1 := Low(RqArrP) to High(RqArrP)
  do begin
     X := XB + Ind1 * dx;
     RqArrP[Ind1].X := X;
     RqArrP[Ind1].Y := 0;
     PwX := 1;
     Ind2 := Low(RqArrA);  //   
     //   . 
     repeat
       Ok := False;
       if RqArrA[Ind2] <> 0
       then begin
          Itm := RqArrA[Ind2] * PwX;
          RqArrP[Ind1].Itm := Itm;
          RqArrP[Ind1].Y   := RqArrP[Ind1].Y + Itm;
          if (Abs(Itm) < Delta) then Ok := True;
       end;
       RqArrP[Ind1].Ind := Ind2;
       PwX  := PwX * X;
       Ind2 := Ind2 + 1;
     until (Ind2 > High(RqArrA)) or Ok;
     //   .   
     GArrP[Ind1].Y := RqArrP[Ind1].Y;
     GArrP[Ind1].X := X;
  end;
  //  
  if Length(GArrP) > 1
  then begin
    GraphP.FullEraseAreaXY;
    GraphP.ShowGraphXY(GArrP, RGB(0,127,0));
  end;
end;

// =================================================================
//         
// =================================================================
//     
function LeftRecIntegralXBE (RqArrP : TD1ArrP; XB, XE : extended) : extended;
var Ind : integer;
begin
  Result := 0;
  if Length(RqArrP) < 2 then Exit;
  for Ind := Low(RqArrP) to High(RqArrP) - 1
  do Result := Result + RqArrP[Ind].Y;
  Result := Result * ((XE - XB) / High(RqArrP));
end;
// -----------------------------------------------------------------
//        
function LeftRecIntegralIndBE (RqArrP : TD1ArrP;
                               IndB, IndE : integer;
                               dX: extended) : extended;
var Ind : integer;
begin
  Result := 0;
  //   
  if (Length(RqArrP) < 2) or (IndB >= IndE) or
     (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
  Ind := IndB;
  repeat
     Result := Result + RqArrP[Ind].Y;
     Ind := Ind + 1;
  until (Ind > IndE - 1);
  Result := Result * dX;
end;
// -----------------------------------------------------------------
//        
function RightRecIntegralIndBE (RqArrP : TD1ArrP;
                               IndB, IndE : integer;
                               dX: extended) : extended;
var Ind : integer;
begin
  Result := 0;
  //   
  if (Length(RqArrP) < 2) or (IndB >= IndE) or
     (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
  Ind := IndB + 1;
  repeat
     Result := Result + RqArrP[Ind].Y;
     Ind := Ind + 1;
  until (Ind > IndE);
  Result := Result * dX;
end;

// -----------------------------------------------------------------
//    
function TrapezIntegralXBE (RqArrP : TD1ArrP; XB, XE : extended) : extended;
var Ind : integer;
begin
  Result := 0;
  //   
  if Length(RqArrP) < 2 then Exit;
  for Ind := Low(RqArrP) to High(RqArrP) - 1
  do Result := Result + (RqArrP[Ind].Y + RqArrP[Ind + 1].Y) / 2;
  Result := Result * ((XE - XB) / High(RqArrP));
end;
// -----------------------------------------------------------------
//       
function TrapezIntegralIndBE (RqArrP : TD1ArrP;
                              IndB, IndE : integer;
                              dX: extended) : extended;
var Ind : integer;
begin
  Result := 0;
  //   
  if (Length(RqArrP) < 2) or (IndB >= IndE) or
     (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
  Ind := IndB;
  repeat
    Result := Result + (RqArrP[Ind].Y + RqArrP[Ind + 1].Y) / 2;
    Ind := Ind + 1;
  until (Ind > IndE - 1);
  Result := Result * dX;
end;
// -----------------------------------------------------------------
//         
function Simpson1IntegralIndBE (RqArrP : TD1ArrP;
                                IndB, IndE : integer;
                                dX: extended) : extended;
var Ind : integer;
begin
   Result := 0;
   //   
   if (Length(RqArrP) < 2) or (IndB >= IndE) or
      (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
   //   
   if (IndE - IndB) > 0
   then begin
      //     
      Ind := IndB;
      while (Ind <= (IndE - 2))
      do begin
       Result := Result + (RqArrP[Ind].Y
                        + 4 * RqArrP[Ind + 1].Y
                        + RqArrP[Ind + 2].Y);
       Ind := Ind + 2
      end;
      Result := Result / 3;
      if ((IndE - IndB) mod 2) > 0
      then begin
        //     
        Result := Result + (RqArrP[IndE - 1].Y + RqArrP[IndE].Y) / 2;
      end;
      Result := Result * dX;
    end;
end;

// -----------------------------------------------------------------
//        
//       
// .
function Simpson2IntegralIndBE (RqArrP : TD1ArrP;
                                IndB, IndE : integer;
                                dX: extended) : extended;
var Ind : integer;
begin
   Result := 0;
   //   
   if (Length(RqArrP) < 2) or (IndB >= IndE) or
      (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
   //    
   if (IndE - IndB) >= 2
   then begin
      //     
      Ind := IndB;
      while (Ind <= (IndE - 2))
      do begin
       Result := Result + (RqArrP[Ind].Y
                        + 4 * RqArrP[Ind + 1].Y
                        + RqArrP[Ind + 2].Y);
       Ind := Ind + 2
      end;
      Result := Result / 3;
      if ((IndE - IndB) mod 2) > 0
      then begin
        //       
        Result := Result
               + ( - RqArrP[IndE - 2].Y
               + 8 * RqArrP[IndE - 1].Y
               + 5 * RqArrP[IndE].Y ) / 12;
      end;
      Result := Result * dX;
    end
    //   
    else Result := TrapezIntegralIndBE (RqArrP, IndB, IndE, dX);
end;

// -----------------------------------------------------------------
//       IndB, IndE.
//       .
function Simpson3IntegralIndBE (RqArrP : TD1ArrP;
                                IndB, IndE : integer;
                                dX: extended) : extended;
var Ind : integer;
begin
   Result := 0;
   //   
   if (Length(RqArrP) < 2) or (IndB >= IndE) or
      (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
   //   
   if (IndE - IndB) >= 5
   then begin
         if ((IndE - IndB) mod 2 > 0)
         then begin
            //      
            Result := (RqArrP[IndB].Y
                       + 4*RqArrP[IndB+1].Y
                       + RqArrP[IndB+2].Y
                       );
            Result := Result + (13*(RqArrP[IndB+2].Y+RqArrP[IndB+3].Y)
                             - (RqArrP[IndB+1].Y+RqArrP[IndB+4].Y)
                               )/8;
            Ind := IndB + 3;
         end
         else Ind := IndB;
         //     
         while (Ind <= (IndE - 2))
         do begin
           Result := Result + (RqArrP[Ind].Y
                               + 4 * RqArrP[Ind + 1].Y
                               + RqArrP[Ind + 2].Y
                              );
           Ind := Ind + 2;
         end;
         Result := Result * dX / 3;
   end
   //   
   else Result := Simpson2IntegralIndBE (RqArrP, IndB, IndE, dX);
end;

// =================================================================
//         RqArrA
//       RqArrP
// =================================================================
//     RqArrA  ListBox
procedure MakeTabPCoef (RqList : TListBox;    //  ListBox
                    var RqArrA : TD1ArrA);    //  
var Ind : integer;
begin
  if (RqList.Count < 1)
  then begin
     SetLength(RqArrA, 0); Exit;
  end;
  SetLength(RqArrA, RqList.Count);
  for Ind := 0 to RqList.Count - 1
  do try
       RqArrA[Ind] := StrToFloat(RqList.Items[Ind]);
     except
       RqArrA[Ind] := 0;
     end;
end;

// -----------------------------------------------------------------
//    RqArrI    RqArrP
procedure IntegralIndAndXBE (RqArrA : TD1ArrA;      // . 
                             RqArrP : TD1ArrP;      // .  
                             XB, XE : extended;     //  . 
                             RqMhet : byte;         //  . 
                         var RqArrI : TD1ArrI);     //  . 
var Ind : integer;
    dX  : extended;
begin
  if (Length(RqArrP) < 2) or (XB >= XE)
  then begin
     SetLength(RqArrI, 0); Exit;
  end;
  //     
  SetLength(RqArrI, Length(RqArrP));
  dx := (XE - XB) / High(RqArrP);
  //   
  SetLength(GArrI, Length(RqArrP));
  SetLength(GArrD, Length(RqArrP));
  //   
  for Ind := Low(RqArrI) to High(RqArrI)
  do begin
     RqArrI[Ind].Precise := PolynomIntegralXBE (RqArrA, XB, XB + Ind * dx);
     case RqMhet of
     0 : RqArrI[Ind].Approx := LeftRecIntegralIndBE  (RqArrP, 0, Ind, dX);
     1 : RqArrI[Ind].Approx := RightRecIntegralIndBE (RqArrP, 0, Ind, dX);
     2 : RqArrI[Ind].Approx := TrapezIntegralIndBE   (RqArrP, 0, Ind, dX);
     3 : RqArrI[Ind].Approx := Simpson1IntegralIndBE (RqArrP, 0, Ind, dX);
     4 : RqArrI[Ind].Approx := Simpson2IntegralIndBE (RqArrP, 0, Ind, dX);
     5 : RqArrI[Ind].Approx := Simpson3IntegralIndBE (RqArrP, 0, Ind, dX);
     else RqArrI[Ind].Approx := 0;
     end;
     RqArrI[Ind].Delta   := RqArrI[Ind].Approx - RqArrI[Ind].Precise;
     //  
     GArrI[Ind].X := XB + Ind * dx;
     GArrD[Ind].X := GArrI[Ind].X;
     GArrI[Ind].Y := RqArrI[Ind].Approx;
     GArrD[Ind].Y := RqArrI[Ind].Delta;
  end;
  //  
  if Length(GArrP) > 1
  then begin
     GraphI.FullEraseAreaXY;
     GraphI.ShowGraphXY(GArrI, RGB(0,0,127));
     GraphD.FullEraseAreaXY;
     GraphD.ShowGraphXY(GArrD, RGB(127,0,0));
  end;
end;

// =================================================================
//     
// =================================================================
procedure ShowPolynom (XB, XE    : extended;   //  . 
                       RqArrP    : TD1ArrP;    //  
                       RqReport  : TMemo);
var dX, Y, X, IndI, Itm : extended;
    Ind   : integer;
    WStr  : string;
begin
  RqReport.Clear;
  if Length(RqArrP) < 1
  then begin
    RqReport.Lines.Add('  ');
    Exit;
  end;
  dx := (XE - XB) / High(RqArrP);
  with RqReport.Lines do
  begin
     Add('---    ---');
     Add('   X = ' + FloatToStr(dx));
     Add('---  ---');
     Add('  X             '
        + '        '
        + '.    '
        + ' . ');
     for Ind := Low(RqArrP) to High(RqArrP)
     do begin
       X := RqArrP[Ind].X;
       Y := RqArrP[Ind].Y;
       IndI := RqArrP[Ind].Ind;
       Itm := RqArrP[Ind].Itm;
       WStr := format('%8.4f', [X]) + ' '
             + format('%18.9f', [Y]) + '    ' + #09#09
             + IntToStr(Round(IndI)) + '    ' + #09#09
             + FloatToStr(Itm);
       Add(WStr);
     end;
  end;
end;
// -----------------------------------------------------------------
procedure ShowIntegral (XB, XE    : extended;     //  . 
                        RqArrI    : TD1ArrI;      //  
                        RqReport  : TMemo);
var dx, X, IntgP, IntgA, Delta: extended;
    Ind   : integer;
    WStr  : string;
begin
  //RqReport.Clear;
  if Length(RqArrI) < 1
  then begin
    RqReport.Lines.Add('  ');
    Exit;
  end;
  dx := (XE - XB) / High(RqArrI);
  with RqReport.Lines do
  begin
     Add('');
     Add('---    ---');
     Add('   X = ' + FloatToStr(dx));
     Add('---  ---');
     Add('  X             '
        + '        '
        + '         '
        + '. ');
     for Ind := Low(RqArrI) to High(RqArrI)
     do begin
       X := XB + Ind * dx;
       IntgP := RqArrI[Ind].Precise;
       IntgA := RqArrI[Ind].Approx;
       Delta := RqArrI[Ind].Delta;
       WStr := format('%8.4f', [X]) + ' '
             + format('%18.9f', [IntgP]) + '    '
             + format('%18.9f', [IntgA]) + '    '
             + format('%18.9f', [Delta]);
       Add(WStr);
     end;
  end;
end;
// -----------------------------------------------------------------
//     
procedure ShowCoeffToReport (RqCoeff   : TStrings;
                             RqReport  : TMemo);
var Ind  : integer;
    WStr : string;
begin
  if RqCoeff.Count > 0
  then begin
     WStr := ': ';
     for Ind :=0 to RqCoeff.Count -1 do
     begin
             WStr := WStr + 'c' + IntToStr(Ind)
                   + '=' + RqCoeff.Strings[Ind]
                   + ';  ';
     end;
     RqReport.Lines.Add(WStr);
  end
  else begin
     RqReport.Lines.Add('  ');
  end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButRunReportFuncClick(Sender: TObject);
begin
  case CBoxReportCmd.ItemIndex of
  0 : MemoReport.Clear;
  1 : ShowCoeffToReport(ListBoxCoeff.Items, MemoReport);
  end; // of case
end;

// =================================================================
//       
// =================================================================
//       
procedure TForm1.SpButCalcIntegralClick(Sender: TObject);
var NumP, XB, XE : extended;
    NumPn        : integer;
begin
   if EditToFloat (EditNumP, NumP) and
      EditToFloat (EditXB, XB) and
      EditToFloat (EditXE, XE)
   then begin
     MakeTabPCoef (ListBoxCoeff,  //  ListBox
                   ArrA);         //  
     if Length(ArrA) < 1 then Exit;
     NumPn := Round(NumP);
     //    RqArrP   .  RqArrA
     MakeTabFunc (ArrA,
                  XB, XE,
                  NumPn,
                  ArrP);
     // 
     ShowPolynom (XB, XE, ArrP, MemoReport);
     //
     IntegralIndAndXBE (ArrA,                     // . 
                        ArrP,                     // .  
                        XB, XE,                   //  . 
                        CmbBoxMhetod.ItemIndex,   // 
                        ArrI);                    //  . 
     // 
     ShowIntegral (XB, XE,        //  . 
                   ArrI,          //  
                   MemoReport);
   end;
end;

// =================================================================
//      
// =================================================================
//   
procedure CoeffToPolinom (Tailor  : boolean;
                          RqCoeff : array of extended;
                          RqList  : TListBox;
                      var RqArrA  : TD1ArrA);
var   Ind : integer;
begin
  RqList.Clear;
  if (Length(RqCoeff) < 2)
  then begin
     SetLength(RqArrA, 0); Exit;
  end;
  SetLength(RqArrA, Length(RqCoeff));
  for Ind := Low(RqCoeff) to High(RqCoeff)
  do begin
     if Tailor
     then RqArrA[Ind] := CoeffTailor(RqCoeff, Ind)
     else RqArrA[Ind] := RqCoeff[Ind];
     RqList.Items.Add(FloatToStr(RqArrA[Ind]));
  end;
end;
// -----------------------------------------------------------------
//    
procedure SelectCoeffToPolinom (RqFuncID : TComboBox; RqList : TListBox);
begin
   case RqFuncID.ItemIndex of
      0 : CoeffToPolinom(True, SinCoeff,   RqList, ArrA);
      1 : CoeffToPolinom(True, SiCoeff,    RqList, ArrA);
      2 : CoeffToPolinom(True, SinCCoeff,  RqList, ArrA);
      3 : CoeffToPolinom(True, ShCoeff,    RqList, ArrA);
      4 : CoeffToPolinom(True, CosCoeff,   RqList, ArrA);
      5 : CoeffToPolinom(True, ChCoeff,    RqList, ArrA);
      6 : CoeffToPolinom(True, ExpCoeff,   RqList, ArrA);
      // --------------------------------------------------
      7 : CoeffToPolinom(False, ArcSinCoeff,  RqList, ArrA);
      8 : CoeffToPolinom(False, ArcTgCoeff,   RqList, ArrA);
   end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButLoadFuncCoeffClick(Sender: TObject);
begin
   SelectCoeffToPolinom (CmbBoxFuncInd, ListBoxCoeff);
   ShowListBoxParm();
end;
//   
procedure TForm1.CmbBoxFuncIndClick(Sender: TObject);
begin
   SelectCoeffToPolinom (CmbBoxFuncInd, ListBoxCoeff);
   ShowListBoxParm();
end;
// -----------------------------------------------------------------
//  Pi       
procedure TForm1.SpButPiClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditXE.Text := FloatToStr(Val * Pi);
     1 : EditXB.Text := FloatToStr(Val * Pi);
     2 : EditX.Text  := FloatToStr(Val * Pi);
     end;
  end;
end;
// -----------------------------------------------------------------
//  Exp(1)       
procedure TForm1.SpButEClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditXE.Text := FloatToStr(Val * Exp(1));
     1 : EditXB.Text := FloatToStr(Val * Exp(1));
     2 : EditX.Text  := FloatToStr(Val * Exp(1));
     end;
  end;
end;

// =================================================================
//      
// =================================================================
//     
procedure TForm1.SaveGraphAsJpg (RqGraph : TGraphXY);
begin
  if Assigned(RqGraph)
  then begin
    SaveDialog1.Filter := 'Graphics files (*.jpg)|*.JPG';
    if SaveDialog1.Execute
    then begin
      RqGraph.SaveGraphXY(SaveDialog1.FileName,'J');
    end;
  end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSavePolinomGraphicClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphP);
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSaveGraphIntegtalClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphI);
end;
// -----------------------------------------------------------------
//        
procedure TForm1.SpButSaveAbsErrorGraphicClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphD);
end;

// =================================================================
//         
// =================================================================
// =================================================================
//      
// =================================================================
//  Edit.Text  
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
//   ListBox
procedure TForm1.ShowListBoxParm();
begin
   StaticTextCoffCount.Caption := IntToStr(ListBoxCoeff.Count);
   if ListBoxCoeff.Count > 0
   then StaticTextMaxPower.Caption := IntToStr(ListBoxCoeff.Count -1)
   else StaticTextMaxPower.Caption := '0';
end;

// =================================================================
//       
// =================================================================
//   
procedure TForm1.ButtonAddClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditCoeff, Val)
  then begin
    ListBoxCoeff.Items.Add(EditCoeff.Text);
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.ListBoxCoeffClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    EditCoeff.Text := ListBoxCoeff.Items[ListBoxCoeff.ItemIndex];
    EditPower.Text := IntToStr(ListBoxCoeff.ItemIndex);
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButAddCoeffClick(Sender: TObject);
var Val : extended;
begin
  if Trim(EditCoeff.Text) = ''
  then begin
       MessageDlg('   .',
                   mtInformation,[mbYes],0);
       Exit;
  end;
  if EditToFloat (EditCoeff, Val)
  then begin
    ListBoxCoeff.Items.Add(EditCoeff.Text);
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButEditCoeffClick(Sender: TObject);
var Val : extended;
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    if EditToFloat (EditCoeff, Val)
    then begin
        ListBoxCoeff.Items[ListBoxCoeff.ItemIndex] := EditCoeff.Text;
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure TForm1.SpButDelCoeffClick(Sender: TObject);
begin
  if ListBoxCoeff.ItemIndex >= 0
  then begin
    ListBoxCoeff.Items.Delete(ListBoxCoeff.ItemIndex);
    EditCoeff.Text := '';
    EditPower.Text := '';
    ShowListBoxParm();
  end;
end;
// -----------------------------------------------------------------
//     
function TryPolinomCalc(RqCoeff  : TListBox;
                        Argument : extended;
                    var Polinom  : extended) : boolean;
var Ind    : integer;
    WCoeff : extended;
    WPower : extended;
begin
    Result  := True;
    Polinom := 0;
    WPower  := 1;
    for Ind := 0 to RqCoeff.Count - 1
    do begin
       try
         WCoeff  := StrToFloat(RqCoeff.Items.Strings[Ind]);
         Polinom := Polinom + WCoeff * WPower;
         WPower  := WPower * Argument;
       except
         Result  := False;
       end;
       if not Result
       then begin
          ShowMessage('   ');
          Break;
       end;
    end;
end;
// -----------------------------------------------------------------
//      
procedure TForm1.SpButCalcPolinomClick(Sender: TObject);
var Argument, Polinom : extended;
begin
  if EditToFloat (EditX, Argument)
  then begin
     if TryPolinomCalc(ListBoxCoeff, Argument, Polinom)
     then EditPolinom.Text := FloatToStr(Polinom)
     else EditPolinom.Text := 'ERROR';
  end;
end;

// =================================================================
//      /     
// =================================================================
//     
procedure TForm1.SpButLoadCoeffClick(Sender: TObject);
var FileName : string;      //   
begin
   //  
   OpenDialog1.Filter := 'ListBox string files (*.lbx)|*.LBX';
   //   
   if OpenDialog1.Execute
   then begin
      //    ListBox
      FileName := OpenDialog1.FileName;
      ListBoxCoeff.Clear;
      ListBoxCoeff.Items.LoadFromFile(FileName);
      StaticTextFileName.Caption := ExtractFileName(FileName);
      ShowListBoxParm();
   end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSaveCoeffClick(Sender: TObject);
var FileName,             //   
    FileExt : string;     //   
begin
  //  
  SaveDialog1.Filter := 'ListBox string files (*.lbx)|*.LBX';
  if Trim(StaticTextFileName.Caption) <> ''
  then SaveDialog1.FileName := StaticTextFileName.Caption
  else SaveDialog1.FileName := '  .lbx';
  //   
  if SaveDialog1.Execute
  then begin
     FileName := SaveDialog1.FileName;
     FileExt  := UpperCase(ExtractFileExt(FileName));
     //     ,    
     if not (FileExt = '.LBX') then FileName := FileName + '.lbx';
     //   
     if FileExists(FileName)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrYes
        then begin
           //   
           ListBoxCoeff.Items.SaveToFile(FileName);
           StaticTextFileName.Caption := ExtractFileName(FileName);
        end;
     end
     else begin
           //    
           ListBoxCoeff.Items.SaveToFile(FileName);
           StaticTextFileName.Caption := ExtractFileName(FileName);
     end;
  end;
end;

// =================================================================
//      
// =================================================================
//   
procedure TForm1.SpButPlusClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 + Op2;
       EditRes.Text := FloatToStr(Res);
    except
       EditRes.Text := '';
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
    end;
  end;
end;
//   
procedure TForm1.SpButMinusClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 - Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButMultClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 * Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButDivClick(Sender: TObject);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 / Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
//   
procedure TForm1.SpButFuncClick(Sender: TObject);
var Op1, Op2 : extended;
begin
  if CbBoxSelFunc.ItemIndex < 0 then Exit;
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       case CbBoxSelFunc.ItemIndex of
       //   
       0 : EditRes.Text := FloatToStr(Op1 * Op1);        // (Op1)
       1 : EditRes.Text := FloatToStr(Sqrt(Op1));        // (Op1)
       2 : EditRes.Text := FloatToStr(Power(Op1, Op2));  // Power(Op1, Op2)
       //   
       3 : EditRes.Text := FloatToStr(Exp(Op1));         // Exp (Op1)
       4 : EditRes.Text := FloatToStr(Ln(Op1));          // Ln(Op1)
       5 : EditRes.Text := FloatToStr(Log2(Op1));        // Log2(Op1)
       6 : EditRes.Text := FloatToStr(Log10(Op1));       // Log10(Op1)
       7 : EditRes.Text := FloatToStr(20*Log10(Op1));    // 20 * Log10(Op1)
       // 
       8 : EditRes.Text := FloatToStr(DegToRad(Op1));    // DegToRad (Op1)
       9 : EditRes.Text := FloatToStr(RadToDeg(Op1));    // RadToDeg (Op1)
      10 : EditRes.Text := FloatToStr(Sin(Op1));         // Sin(Op1)
      11 : EditRes.Text := FloatToStr(ArcSin(Op1));      // ArcSin(Op1)
      12 : EditRes.Text := FloatToStr(Cos(Op1));         // Cos(Op1)
      13 : EditRes.Text := FloatToStr(ArcCos(Op1));      // ArcCos(Op1)
      14 : EditRes.Text := FloatToStr(Tan(Op1));         // Tan(Op1)
      15 : EditRes.Text := FloatToStr(ArcTan(Op1));      // ArcTan(Op1)
      16 : EditRes.Text := FloatToStr(CoTan(Op1));       // CoTan(Op1)
      17 : EditRes.Text := FloatToStr(ArcCot(Op1));      // ArcCoTan(Op1)
      18 : EditRes.Text := FloatToStr(Sec(Op1));         // Sec(Op1)
      19 : EditRes.Text := FloatToStr(ArcSec(Op1));      // ArcSec(Op1)
      //  
      20 : EditRes.Text := FloatToStr(SinH(Op1));         // SinH(Op1)
      21 : EditRes.Text := FloatToStr(ArcSinH(Op1));      // ArcSinH(Op1)
      22 : EditRes.Text := FloatToStr(CosH(Op1));         // CosH(Op1)
      23 : EditRes.Text := FloatToStr(ArcCosH(Op1));      // ArcCosH(Op1)
      24 : EditRes.Text := FloatToStr(TanH(Op1));         // TanH(Op1)
      25 : EditRes.Text := FloatToStr(ArcTanH(Op1));      // ArcTanH(Op1)
      26 : EditRes.Text := FloatToStr(CotH(Op1));         // CoTanH(Op1)
      27 : EditRes.Text := FloatToStr(ArcCotH(Op1));      // ArcCoTanH(Op1)
      28 : EditRes.Text := FloatToStr(SecH(Op1));         // SecH(Op1)
      29 : EditRes.Text := FloatToStr(ArcSecH(Op1));      // ArcSecH(Op1)
        end;
    except
       MessageDlg('  '+ #13#10
                   + CbBoxSelFunc.Items[CbBoxSelFunc.ItemIndex],
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;

// =================================================================
//      
// =================================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
  ShowListBoxParm();
  GraphP := TGraphXY.Create(PanelP);    //  
  GraphP.GraphTitul := '  Y = P(X)';
  GraphI := TGraphXY.Create(PanelI);    //  
  GraphI.GraphTitul := '  Y = F(X)';
  GraphD := TGraphXY.Create(PanelD);    //  
  GraphD.GraphTitul := ' Y = Abs- ';
  GraphD.PicAxesY := '%12.9f';
end;
// -----------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphP.Free;    //  
  GraphI.Free;    //  
  GraphD.Free;    //  
end;

// =================================================================
//    
// =================================================================






end.

