unit MyMath1V2;
//=============================================================================
//       .
//          DELPHI
//  (c)  ..  2.1.  16.02.2012.
//=============================================================================
//     INTERFACE
//=============================================================================
interface

uses SysUtils;

//   
const CoeffMaxNum = 63;

//=============================================================================
//         X=0
//=============================================================================

//     SIN  
const SinCoeff : array [0..CoeffMaxNum] of extended =
 ( 0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1,
   0,    1,   0,   -1,    0,   1,    0,   -1
 );

//     SI ( )  
const SiCoeff : array [0..CoeffMaxNum] of extended =
 ( 0,  1,     0,  -1/3,   0,  1/5,   0,  -1/7,
   0,  1/9,   0,  -1/11,  0,  1/13,  0,  -1/15,
   0,  1/17,  0,  -1/19,  0,  1/21,  0,  -1/23,
   0,  1/25,  0,  -1/27,  0,  1/29,  0,  -1/31,
   0,  1/33,  0,  -1/35,  0,  1/37,  0,  -1/39,
   0,  1/41,  0,  -1/43,  0,  1/45,  0,  -1/47,
   0,  1/49,  0,  -1/51,  0,  1/53,  0,  -1/55,
   0,  1/57,  0,  -1/59,  0,  1/61,  0,  -1/63
 );

//     SinC = Sin(X)/X  
const SinCCoeff : array [0..CoeffMaxNum] of extended =
 ( 1,     0,  -1/3,   0,  1/5,   0,  -1/7,   0,
   1/9,   0,  -1/11,  0,  1/13,  0,  -1/15,  0,
   1/17,  0,  -1/19,  0,  1/21,  0,  -1/23,  0,
   1/25,  0,  -1/27,  0,  1/29,  0,  -1/31,  0,
   1/33,  0,  -1/35,  0,  1/37,  0,  -1/39,  0,
   1/41,  0,  -1/43,  0,  1/45,  0,  -1/47,  0,
   1/49,  0,  -1/51,  0,  1/53,  0,  -1/55,  0,
   1/57,  0,  -1/59,  0,  1/61,  0,  -1/63,  0
 );

//     Sh ( )  
const ShCoeff : array [0..CoeffMaxNum] of extended =
 ( 0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1,
   0,     1,   0,    1,    0,    1,    0,    1
 );

//     COS  
const CosCoeff : array [0..CoeffMaxNum] of extended =
 ( 1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0,
   1,     0,  -1,    0,    1,    0,    -1,   0
 );

//     Ch ( )  
const ChCoeff : array [0..CoeffMaxNum] of extended =
 ( 1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0,
   1,     0,   1,    0,    1,    0,     1,   0
 );

//     SIN  
const ExpCoeff : array [0..CoeffMaxNum] of extended =
 ( 1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1,
   1,    1,   1,   1,    1,    1,    1,    1
 );

//=============================================================================
//     
//=============================================================================
//     ArcSin(X)
//   ( |X| <= 1 )
//   
const ArcSinCoeff : array [0..255] of extended =
(
0,   1,                     0,   0.166666666666667,
0,   0.075,                 0,   0.0446428571428571,
0,   0.0303819444444444,    0,   0.0223721590909091,
0,   0.0173527644230769,    0,   0.01396484375,
0,   0.0115518008961397,    0,   0.00976160952919408,
0,   0.00839033580961682,   0,   0.00731252587359885,
0,   0.00644721031188965,   0,   0.00574003767084192,
0,   0.0051533096823199,    0,   0.0046601434869151,
0,   0.00424090709367936,   0,   0.00388096455883767,
0,   0.00356920539382593,   0,   0.00329705950347348,
0,   0.00305782164925803,   0,   0.00284617840110894,
0,   0.00265787063820729,   0,   0.00248944867824688,
0,   0.00233809189211198,   0,   0.00220147397371014,
0,   0.00207766103251817,   0,   0.00196503361627728,
0,   0.00186222640640313,   0,   0.00176808112051542,
0,   0.00168160939358311,   0,   0.00160196327535144,
0,   0.00152841159612257,   0,   0.00146032089407912,
0,   0.00139713991763025,   0,   0.00133838695127518,
0,   0.00128363938762903,   0,   0.00123252509850002,
0,   0.00118471525616244,   0,   0.00113991833070222,
0,   0.00109787504659145,   0,   0.00105835412587224,
0,   0.00102114867971063,   0,   0.000986073136983331,
0,   0.000952960619742956,  0,   0.000921660692183633,
0,   0.00089203742309171,   0,   0.000863967712465868,
0,   0.000837339841602712,  0,   0.00081205221290867,
0,   0.000788012251358206,  0,   0.000765135444137165,
0,   0.000743344498795896,  0,   0.000722568603352561,
0,   0.000702742774361491,  0,   0.00068380728109655,
0,   0.000665707135776754,  0,   0.000648391641245871,
0,   0.00063181398876191,   0,   0.000615930899598475,
0,   0.000600702305042287,  0,   0.000586091060117561,
0,   0.000572062687001199,  0,   0.000558585144631529,
0,   0.000545628621472986,  0,   0.000533165348792246,
0,   0.000521169432138513,  0,   0.000509616699010401,
0,   0.000498484560941636,  0,   0.000487751888453423,
0,   0.000477398897508034,  0,   0.000467407046260082,
0,   0.00045775894104274,   0,   0.000448438250648757,
0,   0.000439429628073144,  0,   0.000430718638978008,
0,   0.000422291696221945,  0,   0.000414135999868434,
0,   0.000406239482150871,  0,   0.000398590756927665,
0,   0.00039117907320995,   0,   0.000383994272387908,
0,   0.00037702674882019,   0,   0.000370267413484946,
0,   0.000363707660421304,  0,   0.000357339335716989,
0,   0.000351154708821766,  0,   0.000345146445987738,
0,   0.000339307585656603,  0,   0.000333631515631024,
0,   0.000328111951882555,  0,   0.000322742918862199,
0,   0.000317518731192015,  0,   0.000312433976627184,
0,   0.000307483500187887,  0,   0.000302662389369289,
0,   0.000297965960345991,  0,   0.000293389745094576,
0,   0.000288929479364479,  0,   0.00028458109143333,
0,   0.00028034069158834,   0,   0.000276204562280167,
0,   0.000272169148900129,  0,   0.000268231051135686,
0,   0.00026438701486274,   0,   0.000260633924536659,
0,   0.000256968796046961,  0,   0.00025338877000336,
0,   0.000249891105423394,  0,   0.000246473173794189,
0,   0.000243132453482993,  0,   0.000239866524473051,
0,   0.000236673063403181,  0,   0.000233549838890999,
0,   0.000230494707121242,  0,   0.000227505607682008,
0,   0.000224580559632966,  0,   0.000221717657790764,
0,   0.000218915069217888,  0,   0.000216171029902246,
0,   0.000213483841615598,  0,   0.000210851868939829,
0,   0.000208273536450785,  0,   0.000205747326050136,
0,   0.000203271774436338,  0,   0.000200845470706413,
0,   0.000198467054080788,  0,   0.000196135211743974
);

//     ArTg ()
//  
//    
const ArcTgCoeff : array [0..CoeffMaxNum] of extended =
 ( 0,  1,     0,  -1/3,   0,  1/5,   0,  -1/7,
   0,  1/9,   0,  -1/11,  0,  1/13,  0,  -1/15,
   0,  1/17,  0,  -1/19,  0,  1/21,  0,  -1/23,
   0,  1/25,  0,  -1/27,  0,  1/29,  0,  -1/31,
   0,  1/33,  0,  -1/35,  0,  1/37,  0,  -1/39,
   0,  1/41,  0,  -1/43,  0,  1/45,  0,  -1/47,
   0,  1/49,  0,  -1/51,  0,  1/53,  0,  -1/55,
   0,  1/57,  0,  -1/59,  0,  1/61,  0,  -1/63
 );

//     ArTh ( )
//   ( |X| < 1 )
//    
const ArThCoeff : array [0..CoeffMaxNum] of extended =
 ( 0,    1,     0,   1/3,    0,    1/5,    0,   1/7,
   0,    1/9,   0,   1/11,   0,    1/13,   0,   1/15,
   0,    1/17,  0,   1/19,   0,    1/21,   0,   1/23,
   0,    1/25,  0,   1/27,   0,    1/29,   0,   1/31,
   0,    1/33,  0,   1/35,   0,    1/37,   0,   1/39,
   0,    1/41,  0,   1/43,   0,    1/45,   0,   1/47,
   0,    1/49,  0,   1/51,   0,    1/53,   0,   1/55,
   0,    1/57,  0,   1/59,   0,    1/61,   0,   1/63
 );

//     Ln( X + 1)
//   ( |X| <= 1 )
const LnXPlus1Coeff : array [0..CoeffMaxNum] of extended =
 ( 0,       1,     -1/2,    1/3,   -1/4,    1/5,   -1/6,    1/7,
   -1/8,    1/9,   -1/10,   1/11,  -1/12,   1/13,  -1/14,   1/15,
   -1/16,   1/17,  -1/18,   1/19,  -1/20,   1/21,  -1/22,   1/23,
   -1/24,   1/25,  -1/26,   1/27,  -1/28,   1/29,  -1/30,   1/31,
   -1/32,   1/33,  -1/34,   1/35,  -1/36,   1/37,  -1/38,   1/39,
   -1/40,   1/41,  -1/42,   1/43,  -1/44,   1/45,  -1/46,   1/47,
   -1/48,   1/49,  -1/50,   1/51,  -1/52,   1/53,  -1/54,   1/55,
   -1/56,   1/57,  -1/58,   1/59,  -1/60,   1/61,  -1/62,   1/63
 );

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

//=============================================================================
//   
//=============================================================================
//     
procedure InitLastValue (RqVal : extended);
// ----------------------------------------------------------------------------
//       
// RqCoeff -      
// RqX  -  
function Tailor (RqCoeff : array of extended; RqX : extended) : extended;
// ----------------------------------------------------------------------------
//      
// RqCoeff -         
// RqInd  -   
function CoeffTailor (RqCoeff : array of extended; RqInd : integer) : extended;

//=============================================================================
//     IMPLEMENTATION
//=============================================================================
implementation

var LastValue : extended;    //    

// ----------------------------------------------------------------------------
//     
procedure InitLastValue (RqVal : extended);
begin
  LastValue := RqVal;
end;
// ----------------------------------------------------------------------------
//       
// RqCoeff -         
// RqX  -  
function Tailor (RqCoeff : array of extended; RqX : extended) : extended;
var Ind  : integer;         //  
    Fn   : integer;         //    
    Elm  : extended;        //  
begin
    Result    := 0;         //    
    Fn        := 1;         //     
    Elm       := 1;         //    
    try
      for Ind := Low(RqCoeff) to High(RqCoeff)
      do begin
        if Abs(RqCoeff[Ind]) > 0 then Result := Result + RqCoeff[Ind] * Elm;
        Elm := Elm * (RqX / Fn);
        Inc(Fn);
      end;
      LastValue := Result;   //    
    except
      Result := LastValue;   //    
      Beep;
    end;
end;

// ----------------------------------------------------------------------------
//       ( / )
// RqCoeff -         
// RqInd  -   
function CoeffTailor (RqCoeff : array of extended; RqInd : integer) : extended;
var Ind  : integer;         //  
    Fn   : integer;         //    
    Elm  : extended;        //  
begin
    Fn     := 1;            //     
    Elm    := 1;            //    
    Ind := Low(RqCoeff);
    repeat
        Result := RqCoeff[Ind] * Elm;
        Elm := Elm / Fn;
        Inc(Ind);
        Inc(Fn);
    until (Ind > High(RqCoeff)) or (Ind > RqInd);
end;


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

end.
