unit Unit1;
(*
   
    a=1  b=X.   
 S = a * b = X * 1 = X.     ,  
  ,   ,    
 ,   .
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    EdX: TEdit;
    EdSqrt: TEdit;
    EdAE: TEdit;
    Button1: TButton;
    EdCT: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EdMath: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Image1: TImage;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure EditClear();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ---------------------------------------------------------------------------
//     
const EPS = 1e-17;
function sqrt_ab(X : extended; var Count : integer) : extended;
var s, a, b : extended;
begin
  Count := 0;
  Result := 0;
  if X < EPS then Exit;
  s := X; a := 1; b := X;
  while Abs(a-b) > EPS
  do begin
    a := (a+b)/2;
    b := s/a;
    Inc(Count);
  end;
  Result := (a+b)/2;
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.EditClear();
begin
   EdCT.Text   := '';
   EdSqrt.Text := '';
   EdMath.Text := '';
   EdAE.Text   := '';
end;
// ---------------------------------------------------------------------------
//  Image
procedure ClearImage(RqImg : TImage; RqColor : TColor);
begin
   RqImg.Width := RqImg.Height;
   with RqImg.Canvas
   do begin
      Brush.Style := bsSolid;
      Brush.Color := RqColor;
      FillRect(Rect(0,0, RqImg.Width, RqImg.Height));
   end;
end;
// ---------------------------------------------------------------------------
//
procedure ShowSqrt(X : extended; RqImg : TImage);
var s, a, b, m : extended;
    cl : Tcolor;
begin
    ClearImage(RqImg, clSilver);
    if Abs(X)< EPS then Exit;
    s := X; a := 1; b := s;
    if b > a
    then m := RqImg.Width/b
    else m := RqImg.Width/a;
    while Abs(a-b) > EPS
    do begin
      cl := RGB(127 + random(127), 127 + random(127), 127 + random(127));
      with RqImg.Canvas
      do begin
        Brush.Color := cl;
        Rectangle(0,0, Round(m*b), Round(m*a));
        RqImg.Repaint;
      end;
      a := (a+b)/2;
      b := s/a;
    end;
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
var X, Y, AE : extended;
    Count    : integer;
begin
    EditClear();
    if tryStrToFloat(EdX.Text,X)
    then begin
       Y := sqrt_ab(X, Count);
       Repaint;
       try
          AE := Y - Sqrt(X);
          // 
          EdCT.Text   := IntToStr(Count);
          EdSqrt.Text := FloatToStr(Y);
          EdMath.Text := FloatToStr(Sqrt(X));
          EdAE.Text   := FloatToStr(AE);
       except
          ShowMessage('   ');
       end;
       ShowSqrt(X, Image1);
    end
    else begin
      EditClear();
    end;
end;

end.
