unit Unit1;
(*
   
    a=1  b=X.   
 S = a * b = X * 1 = X.     ,  
  ,   ,    
 ,   .
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    EdX: TEdit;
    EdSqrt: TEdit;
    EdAE: TEdit;
    Button1: TButton;
    EdCT: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EdMath: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure EditClear();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ---------------------------------------------------------------------------
//     
const EPS = 1e-18;
function sqrt_ab(X : extended; var Count : integer) : extended;
var s, a, b : extended;
begin
  Count := 0;
  Result := 0;
  if X < EPS then Exit;
  s := Abs(X); a := 1; b := s;
  while Abs(1 - b/a) > EPS
  do begin
    if Count > 999999 then Break;
    a := (a+b)/2;
    b := s/a;
    Inc(Count);
  end;
  Result := (a+b)/2;
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.EditClear();
begin
   EdCT.Text   := '';
   EdSqrt.Text := '';
   EdMath.Text := '';
   EdAE.Text   := '';
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
var X, Y, AE : extended;
    Count    : integer;
begin
    EditClear();
    if tryStrToFloat(EdX.Text,X)
    then begin
       Y := sqrt_ab(X, Count);
       try
          AE := Y - Sqrt(X);
          // 
          EdCT.Text   := IntToStr(Count);
          EdSqrt.Text := FloatToStr(Y);
          EdMath.Text := FloatToStr(Sqrt(X));
          EdAE.Text   := FloatToStr(AE);
       except
          ShowMessage('   ');
       end;
    end
    else begin
      EditClear();
    end;
end;

end.
