unit Unit1;
(*
N-  
    (N-1)  a=1   b=X.
    V = (N-1) * a * b = 1 * X = X. 
   ,     ,  
   N-    .
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math;

type
  TForm1 = class(TForm)
    EdX: TEdit;
    EdSqrt: TEdit;
    EdAE: TEdit;
    Button1: TButton;
    EdCT: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EdMath: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    CbBox1: TComboBox;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure EditClear();
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ---------------------------------------------------------------------------
//      N
const EPS = 1e-18;
function RootN_ab(X : extended; N : word; var Count : integer) : extended;
var a, b : extended;
    i : integer;
begin
  Count  := 0;
  Result := 0;
  if (Abs(X) = 0) or (N < 2) then Exit;
  a := 1; b := Abs(X);
  while Abs(1 - b/a) > EPS
  do begin
    a := ((N-1)*a + b)/N;
    b := Abs(X);
    for i:=1 to (N-1) do b := b/a;
    Inc(Count);
  end;
  Result := ((N-1)*a + b)/N;
  if X < 0 then Result := - Result;
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.EditClear();
begin
   EdCT.Text   := '';
   EdSqrt.Text := '';
   EdMath.Text := '';
   EdAE.Text   := '';
end;
// ---------------------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
var X, Y, YM, AE : extended;
    N      : word;
    Count  : integer;
begin
    EditClear();
    Refresh;
    if tryStrToFloat(EdX.Text,X)
    then begin
       N := CbBox1.ItemIndex + 2;
       Y := RootN_ab(X, N, Count);
       try
          YM := Power(X, 1/N);
          AE := Y - YM;
          EdMath.Text := FloatToStr(YM);
          EdAE.Text   := FloatToStr(AE);
       except
          ShowMessage('   Power');
       end;
       // 
       EdCT.Text   := IntToStr(Count);
       //   
       if (N mod 2 = 0) and (X < 0)
       then EdSqrt.Text := 'i * ' + FloatToStr(Abs(Y))
       else EdSqrt.Text := FloatToStr(Y);
    end
    else begin
      EditClear();
    end;
end;

end.
