unit SpecialNumbers01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, Buttons, StdCtrls, ExtCtrls, ComCtrls, Math, GraphXYv51;

//=============================================================================
//       extended
type TD1AttExt = array of extended;

//=============================================================================
//    
//=============================================================================
//  
const BernoulliNumber  : array [0..259] of extended =
(
1,                    -0.5,   0.166666666666667,     0,
-0.0333333333333333,     0,   0.0238095238095238,    0,
-0.0333333333333333,     0,   0.0757575757575758,    0,
-0.253113553113553,      0,   1.16666666666667,      0,
-7.0921568627451,        0,   54.9711779448622,      0,
-529.124242424242,       0,   6192.1231884058,       0,
-86580.2531135531,       0,   1425517.16666667,      0,
-27298231.0678161,       0,   601580873.900642,      0,
-15116315767.0922,       0,   429614643061.167,      0,
-13711655205088.3,       0,   488332318973593,       0,
-1.92965793419401E16,    0,   8.41693047573683E17,   0,
-4.03380718540595E19,    0,   2.1150748638082E21,    0,
-1.20866265222965E23,    0,   7.50086674607696E24,   0,
-5.03877810148107E26,    0,   3.65287764848181E28,   0,
-2.84987693024509E30,    0,   2.38654274996836E32,   0,
-2.13999492572253E34,    0,   2.05009757234781E36,   0,
-2.09380059113464E38,    0,   2.27526964884635E40,   0,
-2.62577102862396E42,    0,   3.2125082102718E44,    0,
-4.15982781667947E46,    0,   5.69206954820353E48,   0,
-8.21836294197846E50,    0,   1.2502904327167E53,    0,
-2.00155832332484E55,    0,   3.36749829153644E57,   0,
-5.94709705031354E59,    0,   1.1011910323628E62,    0,
-2.13552595452535E64,    0,   4.33288969866412E66,   0,
-9.18855282416693E68,    0,   2.03468967763291E71,   0,
-4.70038339580357E73,    0,   1.13180434454842E76,   0,
-2.83822495706937E78,    0,   7.40642489796789E80,   0,
-2.00964548027566E83,    0,   5.66571700508059E85,   0,
-1.65845111541362E88,    0,   5.03688599504924E90,   0,
-1.58614682376582E93,    0,   5.17567436175456E95,   0,
-1.74889218402171E98,    0,   6.11605199949522E100,  0,
-2.21227769127078E103,   0,   8.2722776798771E105,   0,
-3.19589251114157E108,   0,   1.27500822233878E111,  0,
-5.25009230867741E113,   0,   2.23018178942416E116,  0,
-9.76845219309552E118,   0,   4.4098361978453E121,   0,
-2.05085708864641E124,   0,   9.82144332797913E126,  0,
-4.84126007982089E129,   0,   2.4553088801481E132,   0,
-1.28069268040847E135,   0,   6.86761671046686E137,  0,
-3.78464685819691E140,   0,   2.14261012506653E143,  0,
-1.24567271371837E146,   0,   7.43457875510002E148,  0,
-4.55357953046417E151,   0,   2.86121128168589E154,  0,
-1.84377235520339E157,   0,   1.2181154536221E160,   0,
-8.24821871853141E162,   0,   5.72258779378329E165,  0,
-4.06685305250591E168,   0,   2.95960920646421E171,  0,
-2.20495225651895E174,   0,   1.68125970728896E177,  0,
-1.3116736213557E180,    0,   1.0467894009478E183,   0,
-8.54328935788337E185,   0,   7.12878213224865E188,  0,
-6.08029314555359E191,   0,   5.29967764248499E194,  0,
-4.71942591687459E197,   0,   4.2928413791403E200,   0,
-3.98767449682322E203,   0,   3.78197804193589E206,  0,
-3.66142336836812E209,   0,   3.61760902723729E212,  0,
-3.64707726451914E215,   0,   3.75087554364544E218,  0,
-3.9345867296439E221,    0,   4.20882111481901E224,  0,
-4.59022962206179E227,   0,   5.10317257726296E230,  0,
-5.7822762303657E233,    0,   6.67624821678359E236,  0,
-7.85353076444504E239,   0,   9.41068940670587E242,  0,
-1.14849338734652E246,   0,   1.42729587428488E249,  0,
-1.80595595869093E252,   0,   2.32615353076608E255,  0,
-3.04957517154996E258,   0,   4.0685806076434E261,   0,
-5.52310313219744E264,   0,   7.62772793964344E267,  0,
-1.07155711196979E271,   0,   1.53102008959692E274,  0,
-2.22448916821798E277,   0,   3.28626791906901E280,  0,
-4.93559289559603E283,   0,   7.53495712008325E286,  0,
-1.16914851545842E290,   0,   1.84352614678389E293,  0,
-2.95368261729681E296,   0,   4.80793212775016E299,  0,
-7.95021250458853E302,   0,   1.33527841873546E306,  0
);
//=========================================================================
//  
const EulerNumber : array[0..255] of extended =
(
1,                      0,   -1,                      0,
5,                      0,   -61,                     0,
1385,                   0,   -50521,                  0,
2702765,                0,   -199360981,              0,
19391512145,            0,   -2404879675441,          0,
370371188237525,        0,   -6.93488743931379E16,    0,
1.55145341635571E19,    0,   -4.08707250929312E21,    0,
1.25225964140363E24,    0,   -4.41543893249023E26,    0,
1.77519391579539E29,    0,   -8.07232992358879E31,    0,
4.12220603395177E34,    0,   -2.34895805270431E37,    0,
1.4851150718115E40,     0,   -1.03646227335196E43,    0,
7.94757942259759E45,    0,   -6.66753751668554E48,    0,
6.09627864556854E51,    0,   -6.05328524818862E54,    0,
6.50616248668461E57,    0,   -7.54665993900874E60,    0,
9.42032189642024E63,    0,   -1.26220192518062E67,    0,
1.81089114965792E70,    0,   -2.77571017020716E73,    0,
4.53581033300179E76,    0,   -7.88628420666179E79,    0,
1.45618443801396E83,    0,   -2.85051783223698E86,    0,
5.90574720777544E89,    0,   -1.29297366418786E93,    0,
2.98692818328458E96,    0,   -7.27060171401686E99,    0,
1.86229157584127E103,   0,   -5.01310494081098E106,   0,
1.41652557597856E110,   0,   -4.19664316404024E113,   0,
1.30215959052405E117,   0,   -4.22724068613991E120,   0,
1.43432127919766E124,   0,   -5.08179907245804E127,   0,
1.87833293645293E131,   0,   -7.23653438103386E134,   0,
2.9035283466611E138,    0,   -1.21229373789292E142,   0,
5.26306424961699E145,   0,   -2.37407307193677E149,   0,
1.11189009424828E153,   0,   -5.40307865979529E156,   0,
2.72234108557223E160,   0,   -1.42130105480097E164,   0,
7.6842618206469E167,    0,   -4.29962192543975E171,   0,
2.48839157478299E175,   0,   -1.4887582089062E179,    0,
9.20261411885209E182,   0,   -5.87424445729244E186,   0,
3.87013355417593E190,   0,   -2.63038464627282E194,   0,
1.84342186190682E198,   0,   -1.331500760832E202,     0,
9.9077340794641E205,    0,   -7.59161615376087E209,   0,
5.98738690421595E213,   0,   -4.85853153680527E217,   0,
4.05474737750791E221,   0,   -3.47892371339091E225,   0,
3.06749738825108E229,   0,   -2.77857404780457E233,   0,
2.58465603902712E237,   0,   -2.46817048046364E241,   0,
2.41875397603671E245,   0,   -2.43169264709107E249,   0,
2.50718300057371E253,   0,   -2.65025200052581E257,   0,
2.87130197316668E261,   0,   -3.18736021623541E265,   0,
3.62424164505846E269,   0,   -4.22000551313026E273,   0,
5.0303455785315E277,    0,   -6.13696178494213E281,   0,
7.66062813846337E285,   0,   -9.78178011283967E289,   0,
1.27733166367198E294,   0,   -1.70535141854472E298,   0,
2.32725003482003E302,   0,   -3.24554745838925E306,   0,
4.62431772582652E310,   0,   -6.73012788703472E314,   0,
1.00027210754707E319,   0,   -1.51788001742577E323,   0,
2.35119349908735E327,   0,   -3.71689279117523E331,   0,
5.99547163501087E335,   0,   -9.86577088329267E339,   0,
1.65583659573557E344,   0,   -2.83399320159966E348,   0,
4.94530100009305E352,   0,   -8.79667520899327E356,   0,
1.59476655581152E361,   0,   -2.94612210146851E365,   0,
5.54502104976351E369,   0,   -1.06311359653345E374,   0,
2.0759013633952E378,    0,   -4.12773880499826E382,   0,
8.35651766405207E386,   0,   -1.72217205856861E391,   0,
3.612413768213E395,     0,   -7.71118376946409E399,   0,
1.67487061802601E404,   0,   -3.70095060044899E408,   0,
8.31866048362571E412,   0,   -1.90168660939481E417,   0,
4.42087603441719E421,   0,   -1.04496318839617E426,   0,
2.51106143056947E430,   0,   -6.13364695361925E434,   0,
1.52274665740171E439,   0,   -3.84173369351233E443,   0,
9.84831122735664E447,   0,   -2.56493431903933E452,   0
);

//=============================================================================
//                
//=============================================================================
//  Edit.Text  Extended-
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;
// ------------------------------------------------------------------------
//  Edit.Text  Integer-
function EditToInt (RqEdit : TEdit; var Val : integer) : boolean;
// ------------------------------------------------------------------------
//         
procedure SaveNumbersToFile(RqK,                    //  
                            RqSNI   : integer;      //   
                            RqSD    : TSaveDialog); //  

//=============================================================================
//               
//=============================================================================
// ----------------------------------------------------------------------------
// 
function Fact(RqInd : integer) : extended;
// ------------------------------------------------------------------------
//                    
// ------------------------------------------------------------------------
//  
function Ckn(k,              //  
             n : integer     //  
             ) : extended;
// ------------------------------------------------------------------------
//    
//     (k)
procedure MakeCknArr(RqK : integer; var Arr : TD1AttExt);
// ------------------------------------------------------------------------
//   RqMemo   RqArr  
procedure ShowCknArr(RqArr : TD1AttExt; RqMemo : TMemo);
//=========================================================================
//                    
//=========================================================================
// ------------------------------------------------------------------------
//                    
// ------------------------------------------------------------------------
//    Arr      RqN
// procedure MakeBernoulliArr(RqN : integer; var Arr : TD1AttExt);
procedure MakeBernoulliArr(RqK : integer; var Arr : TD1AttExt);
// ------------------------------------------------------------------------
//   RqMemo   RqArr   
procedure ShowBernoulliArr(RqArr : TD1AttExt; RqMemo : TMemo);
// ------------------------------------------------------------------------
//                    
// ------------------------------------------------------------------------
//    Arr       RqK
procedure MakeTEulerArr(RqK : integer; var Arr : TD1AttExt);
// ------------------------------------------------------------------------
//   RqMemo   RqArr    
procedure ShowTEulerArr(RqArr : TD1AttExt; RqMemo : TMemo);


//=========================================================================
//                  
//=========================================================================
// ------------------------------------------------------------------------
//                   
// ------------------------------------------------------------------------
//    Arr      RqK
procedure MakeEulerArr(RqN : integer; var Arr : TD1AttExt);
// ------------------------------------------------------------------------
//   RqMemo   RqArr   
procedure ShowEulerArr(RqArr : TD1AttExt; RqMemo : TMemo);


//=========================================================================
implementation
//=========================================================================


//=========================================================================
//               
//=========================================================================
// ------------------------------------------------------------------------
//  Edit.Text  Extended 
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;

// ------------------------------------------------------------------------
//  Edit.Text  Integer 
function EditToInt (RqEdit : TEdit; var Val : integer) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToInt(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// ------------------------------------------------------------------------
//         
function ComaToPoint(RqExt : extended) : string;
begin
   Result := FloatToStr(RqExt);
   //    
   while Pos(',', Result) > 0 do Result[Pos(',', Result)] := '.';
end;

//=========================================================================
//               
//=========================================================================
// ------------------------------------------------------------------------
// 
function Fact(RqInd : integer) : extended;
var Ind  : word;
begin
    Result := 1;
    if RqInd <= 0 then Exit;
    for Ind := 1 to RqInd do Result := Result * Ind;
end;
// ------------------------------------------------------------------------
//                 
// ------------------------------------------------------------------------
//  
function Ckn(k,              //  
             n : integer     //  
             ) : extended;
begin
   Result := Fact(k) / Fact(n);
   Result :=  Result / Fact(k-n);
end;

// ------------------------------------------------------------------------
//    
//     (k)
procedure MakeCknArr(RqK : integer; var Arr : TD1AttExt);
var n : integer;
begin
    SetLength(Arr, RqK + 1);
    for n := 0 to RqK do Arr[n] := Ckn(RqK, n);
end;
// ------------------------------------------------------------------------
//    
//     (n)
procedure MakeNCknArr(RqN : integer; var Arr : TD1AttExt);
var k : integer;
begin
    SetLength(Arr, RqN + 1);
    for k := 0 to RqN do Arr[k] := Ckn(k, RqN);
end;

// ------------------------------------------------------------------------
//   RqMemo   RqArr  
procedure ShowCknArr(RqArr : TD1AttExt; RqMemo : TMemo);
var n : integer;
begin
    RqMemo.Clear;
    if Length(RqArr) < 1 then Exit;
    RqMemo.Lines.Add(' ');
    for n := Low(RqArr) to High(RqArr)
    do RqMemo.Lines.Add('n = ' +IntToStr(n) + #09 + FloatToStr(RqArr[n]));
end;
//=========================================================================
//                    
//=========================================================================
// ------------------------------------------------------------------------
//    Arr      RqK
procedure MakeBernoulliArr(RqK : integer; var Arr : TD1AttExt);
var n, k, i    : integer;
begin
   SetLength(Arr, RqK + 1);
   Arr[0] := 1;
   for k := 1 to RqK
   do begin
      Arr[k] := 0;
      for n := 1 to k
      do Arr[k] := Arr[k] + (-1/(k+1)) * Ckn(k + 1, n + 1)* Arr[k - n];
   end;
   for i := 2 to RqK
   do if (i mod 2) <> 0 then Arr[i] := 0;
end;
// ------------------------------------------------------------------------
//   RqMemo   RqArr   
procedure ShowBernoulliArr(RqArr : TD1AttExt; RqMemo : TMemo);
var k : integer;
begin
  RqMemo.Clear;
  if Length(RqArr) < 1 then Exit;
  RqMemo.Lines.Add('    ');
  for k := Low(RqArr) to High(RqArr)
  do begin
    RqMemo.Lines.Add('k = ' + IntToStr(k) + #09 + FloatToStr(RqArr[k]));
  end;
end;

//=========================================================================
//                    
//=========================================================================
//    Arr      RqK
procedure MakeTEulerArr(RqK : integer; var Arr : TD1AttExt);
var k, n  : integer;
    Item  : extended;
    BArr  : TD1AttExt;
begin
   //   Arr   
   MakeBernoulliArr(RqK, BArr);
   //    
   SetLength(Arr, RqK + 1);
   Arr[0] := 1; Arr[1] := 0;
   for k := 2 to RqK
   do begin
     Arr[k] := 0;
     if BArr[k] <> 0
     then begin
        for n := 1 to k
        do begin
          Item := Ckn(k, n-1) * BArr[n] * (IntPower(2, n) - IntPower(4, n)) /n;
          Arr[k] := Arr[k] + Item;
        end;
     end;
   end;
end;
// ------------------------------------------------------------------------
//   RqMemo   RqArr   
procedure ShowTEulerArr(RqArr : TD1AttExt; RqMemo : TMemo);
var Ind : integer;
begin
  RqMemo.Clear;
  if Length(RqArr) < 1 then Exit;
  RqMemo.Lines.Add('    ');
  for Ind := Low(RqArr) to High(RqArr)
  do begin
    RqMemo.Lines.Add('k = ' + IntToStr(Ind) + #09 + FloatToStr(RqArr[Ind]));
  end;
end;

//=========================================================================
//                   
//=========================================================================
//    Arr      RqK
procedure MakeEulerArr(RqN : integer; var Arr : TD1AttExt);
var m, k : integer;
begin
   SetLength(Arr, RqN + 1);
   for m := 0 to RqN
   do begin
      Arr[m] := 0;
      for k := 0 to m
      do Arr[m] := Arr[m]
                 + Ckn(RqN + 1, k) * IntPower(m+1-k, RqN) * IntPower(-1, k);
   end;
end;
// ------------------------------------------------------------------------
//   RqMemo   RqArr   
procedure ShowEulerArr(RqArr : TD1AttExt; RqMemo : TMemo);
var Ind : integer;
begin
  RqMemo.Clear;
  if Length(RqArr) < 1 then Exit;
  RqMemo.Lines.Add(' ');
  for Ind := Low(RqArr) to High(RqArr)
  do begin
    RqMemo.Lines.Add('m = ' + IntToStr(Ind) + #09 + FloatToStr(RqArr[Ind]));
  end;
end;

//=========================================================================
//             
//=========================================================================
// ------------------------------------------------------------------------
//         
procedure SaveSpecialNumber(RqK,                     //   
                            RqSNI      : integer;    //   
                            RqFileName : string);
var Ind,  s : integer;      //  
    wArr    : TD1AttExt;    //    
    wName   : string;       //  
    wStr    : string;       //  
    List    : TStringList;  //  StringList
begin
  if RqK  < 1 then Exit;
  //        RqSNI
  case RqSNI of
      0: begin   //     
           wName := 'BernoulliNumber';
           MakeBernoulliArr(RqK, wArr);
         end;
      1: begin  //     
           wName := 'EulerNumber';
           MakeTEulerArr(RqK, wArr);
         end;
      else Exit;
  end;
  //    
  List := TStringList.Create;
  //   
  List.Add('const ' + wName  + ' : array[0..'
         + IntToStr(Abs(RqK))+ '] of extended = (');
  s  := 0;  wStr := '';
  // 
  for Ind := Low(wArr) to High(wArr)
  do begin
     //   
     wStr := wStr + ComaToPoint(wArr[Ind]);
     if Ind <> High(wArr) then wStr := wStr + ',';
     //    
     s := s + 1;
     if s > 3
     then begin
         List.Add(wStr);
         s := 0;  wStr := '';
     end;
  end;
  if wStr <> '' then List.Add(wStr);
  //   
  List.Add(');');
  List.SaveToFile(RqFileName);
  List.Free;
end;

// ------------------------------------------------------------------------
//         
procedure SaveNumbersToFile(RqK,                    //   
                            RqSNI   : integer;      //   
                            RqSD    : TSaveDialog); //  
var FileName,               //   
    FileExt : string;       //   
begin
  //  
  RqSD.Filter := 'Numbers file (*.txt)|*.TXT';

  //   
  if RqSD.Execute
  then begin
     FileName := RqSD.FileName;
     FileExt  := UpperCase(ExtractFileExt(FileName));
     //     ,    
     if not (FileExt = '.TXT') then FileName := FileName + '.txt';
     //   
     if FileExists(FileName)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrYes
        then begin
           //   
           SaveSpecialNumber (RqK, RqSNI, FileName);
        end;
     end
     else begin
           //    
           SaveSpecialNumber (RqK, RqSNI, FileName);
     end;
  end;
end;
//=========================================================================
//=========================================================================



end.
