unit MaclaurinSeries01;
//=========================================================================
//           
//       ( )
//        ( )  .
//      (convergence)    
//            .
//=========================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math,
  SpecialNumbers01, GraphXYv51;

// ========================================================================
//   
// ========================================================================
// ------------------------------------------------------------------------
//        
type TFuncDesc = record
     FName   :  string;   //  .
     FAddr   : pointer;   //     
                          //    .
     XB      : extended;  //    .
     XE      : extended;  //    .
     EpsX    : extended;  //   XB, XE   .
     AngX    : boolean;   //     .
     AngY    : boolean;   //     .
     SysFunc : pointer;   //  Sys  Math .
end;
type TPFuncDesc = ^TFuncDesc;
// ------------------------------------------------------------------------
//       .   
type TFuncCoeff  = function(RqInd : integer) : extended;

//       
type TSysFunc    = function(RqX : extended) : extended;

// ========================================================================
//    
// ========================================================================
// ------------------------------------------------------------------------
//  
var GraphIm : TGraphXY;   //    
    GraphSC : TGraphXY;   //   

// ------------------------------------------------------------------------
//   
var GArrIm : TGraphArr;   //      
    GArrSC : TGraphArr;   //     

// ========================================================================
//   
// ========================================================================
//        
procedure LoadFuncCoeffSelector (RqCbBox : TComboBox);

// ------------------------------------------------------------------------
//        
//   FuncDescArr
function GetFuncDesc (RqInd : integer) : TPFuncDesc;

// ------------------------------------------------------------------------
//       RqFunc
procedure MakeFuncCoeffArr (RqN          : integer;      // High - 
                            RqFunc       : TFuncCoeff;   // function
                        var OutCoeffArr  : TD1AttExt);   // Arr  - 

// ------------------------------------------------------------------------
//   OutCoeffArr      
//  Memo         
procedure FuncCoeffAndDerive(EdHighInd    : TEdit;      //   
                             CmbBoxFunc   : TComboBox;  //  
                             MemoCSeries  : TMemo;      // Memo 
                             MemoCDeriv   : TMemo;      // Memo 
                        var  OutCoeffArr  : TD1AttExt); // 

// ------------------------------------------------------------------------
//        X
//   ,     .
//     Sum,   HInd  
//        ,  
//     - Result.
function GraphicsSeriesForX
                         (RqCoeffArr : TD1AttExt; //  
                          RqX        : extended;  //  
                      var MCD        : extended;  // .  
                      var LPw        : integer;   //    
                      var Sum        : extended   //  
                          ) : boolean;

// ------------------------------------------------------------------------
//        X
//     Sum,   HInd  
//        ,  
//     - Result.
function CalcSeriesForX (RqCoeffArr : TD1AttExt; // 
                         RqX        : extended;  // 
                     var MCD        : extended;  // .  
                     var LPw        : integer;   //    
                     var Sum        : extended) : boolean;

implementation

const CoeffTitle = '    ';
      DerivTitle = '    ';

// ------------------------------------------------------------------------
// *                 SQRT(+1), |X| < 1
// ------------------------------------------------------------------------
// 21.05.2015
//        (+1)
// |X| <= 1
function CoeffSqrt1PlusX(RqInd : integer) : extended;
begin
    Result := Fact(2 * RqInd) / Fact(RqInd);
    Result := Result / Fact(RqInd);
    Result := Result / IntPower(4, RqInd);
    Result := Result / (1 - 2 * RqInd);
    Result := Result * IntPower(-1, RqInd);
end;
// ------------------------------------------------------------------------
// *                    1/(1-X), |X| < 1
// ------------------------------------------------------------------------
// 21.05.2015
//     1/(1-X)
function Coeff1Div1MinusX(RqInd : integer) : extended;
begin
    Result := 1;
end;
// ------------------------------------------------------------------------
// *                    EXP(X)
// ------------------------------------------------------------------------
// 21.05.2015
//     EXP()
function CoeffExp(RqInd : integer) : extended;
begin
    Result := 1 / Fact(RqInd);
end;
// ------------------------------------------------------------------------
// *                    Ln(X+1),  |X| < 1
// ------------------------------------------------------------------------
// 21.05.2015
//     Ln(X+1)
function CoeffLnPlus1(RqInd : integer) : extended;
begin
    if RqInd <> 0
    then Result := IntPower(-1, RqInd - 1) / (RqInd)
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    Ln(1-X),  |X| < 1
// ------------------------------------------------------------------------
// 21.05.2015
//     Ln(X+1)
function CoeffLn1MinusX(RqInd : integer) : extended;
begin
    if RqInd <> 0
    then Result := - 1 / RqInd
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    SIN(X)
// ------------------------------------------------------------------------
// 21.05.2015
//     SIN()
function CoeffSin(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := IntPower(-1, K) / Fact(2 * K + 1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    COS(X)
// ------------------------------------------------------------------------
// 21.05.2015
//     COS()
function CoeffCos(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) = 0
    then begin
        K := RqInd div 2;
        Result := IntPower(-1, K) / Fact(2 * K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//   *                  Tan(X), |X|< Pi/2
// ------------------------------------------------------------------------
// 21.05.2015
//     Tan(X)
function CoeffTan(RqInd : integer) : extended;
var K : integer;
begin
    if ((RqInd mod 2) > 0)
    then begin
       K := (RqInd div 2) + 1;
       Result := BernoulliNumber[2 * K];
       Result := Result / Fact(2 * K);
       Result := Result * IntPower(-4, K);
       Result := Result * (1 - IntPower(4, K));
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//  *                   Sec(X), |X|< Pi/2
// ------------------------------------------------------------------------
// 21.05.2015
//     Sec(X)
// |X| < Pi/2
function CoeffSec(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) = 0
    then begin
       K := RqInd div 2;
       Result := EulerNumber[2 * K];
       Result := Result / Fact(2 * K);
       Result := Result * IntPower(-1, K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//  *                   ArcSIN(X), |X| <= 1
// ------------------------------------------------------------------------
// 21.05.2015
//     arcsin()
// |X| <= 1
function CoeffArcSin(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := Fact(2 * K) / Fact(K);
        Result := Result / Fact(K);
        Result := Result / IntPower(4, K);
        Result := Result / (1 + 2 * K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//  *                  ArcTAN(X), |X| <= 1
// ------------------------------------------------------------------------
// 21.05.2015
//     arctan()
// |X| <= 1
function CoeffArcTan(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := 1 / (2 * K + 1);
        Result := Result * IntPower(-1, K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    SinH(X)
// ------------------------------------------------------------------------
// 21.05.2015
//     SinH(X)
function CoeffSinH(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := 1 / Fact(2 * K + 1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    CosH(X)
// ------------------------------------------------------------------------
// 21.05.2015
//     CosH(X)
function CoeffCosH(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) = 0
    then begin
        K := RqInd div 2;
        Result := 1 / Fact(2 * K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//   *                  TanH(X), |X|< Pi/2
// ------------------------------------------------------------------------
// 21.05.2015
//     TanH(X)
function CoeffTanH(RqInd : integer) : extended;
var K : integer;
begin
    if ((RqInd mod 2) > 0)
    then begin
       K := (RqInd div 2) + 1;
       Result := BernoulliNumber[2 * K];
       Result := Result / Fact(2 * K);
       Result := Result * IntPower(4, K);
       Result := Result * (IntPower(4, K)-1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//  *                   ArSinH(X), |X| <= 1
// ------------------------------------------------------------------------
// 21.05.2015
//     ArSinH(X)
// |X| <= 1
function CoeffArcSinH(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := Fact(2 * K) / Fact(K);
        Result := Result / Fact(K);
        Result := Result / IntPower(4, K);
        Result := Result / (1 + 2 * K);
        Result := Result * IntPower(-1, K);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
//  *                  ArTanH(X), |X| <= 1
// ------------------------------------------------------------------------
// 21.05.2015
//     arctan()
// |X| <= 1
function CoeffArcTanH(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := 1 / (2 * K + 1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
//  *                   Sin(X)/X
// ------------------------------------------------------------------------
// 23.05.2015
//     Sec(X)
function CoeffSinDivX(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) = 0
    then begin
       K := RqInd div 2;
       Result := IntPower(-1, K) / Fact(2 * K + 1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    Si(X)  ( )
// ------------------------------------------------------------------------
// 21.05.2015
//     Si()
function CoeffSi(RqInd : integer) : extended;
var K : integer;
begin
    if (RqInd mod 2) > 0
    then begin
        K := RqInd div 2;
        Result := IntPower(-1, K) / Fact(2 * K + 1);
        Result := Result / (2 * K + 1);
    end
    else Result := 0;
end;
// ------------------------------------------------------------------------
// *                    Wo(X)  (Wo- )
// ------------------------------------------------------------------------
// 21.05.2015
//     Wo()
function CoeffWo(RqInd : integer) : extended;
begin
    if RqInd <> 0
    then Result := IntPower(-RqInd, RqInd-1) / Fact(RqInd)
    else Result := 0;
end;
// ========================================================================
// *
// ========================================================================
// ------------------------------------------------------------------------
function SysSqrtXPlus1(X : extended) : extended;
begin
  Result := 0;
  try Result := Sqrt(X+1);  except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
function Sys1Div1MinusX(X : extended) : extended;
begin
  Result := 0;
  try Result := 1/(1-X); except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
function SysExp(X : extended) : extended;
begin
  Result := 0;
  try Result := Exp(X); except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
function SysLnXPlus1(X : extended) : extended;
begin
  Result := 0;
  try Result := Ln(X+1); except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
function SysLn1MinusX (X : extended) : extended;
begin
  Result := 0;
  try Result := Ln(1-X); except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
function SysSin (X : extended) : extended;
begin
  Result := Sin(X);
end;
// ------------------------------------------------------------------------
function SysCos (X : extended) : extended;
begin
  Result := Cos(X);
end;
// ------------------------------------------------------------------------
function SysArcTan (X : extended) : extended;
begin
  Result := 0;
  try Result := ArcTan(X); except ShowMessage(' '); end;
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
function SysSinDivX (X : extended) : extended;
begin
  Result := 0;
  try
     if X = 0
     then Result := 1
     else Result := Sin(X)/X;
  except ShowMessage(' '); end;
end;
// ========================================================================
//           
// ========================================================================

//   
const FuncDescArr : array [0..18] of TFuncDesc =
(
  (FName : 'Sqrt(X+1), |X| < 1';     FAddr : @CoeffSqrt1PlusX;
   XB   : -1;           XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : False;
   SysFunc : @SysSqrtXPlus1),
   // --------------------------------
  (FName : '1/(1-X), |X| < 1';       FAddr : @Coeff1Div1MinusX;
   XB   : -1;           XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : False;
   SysFunc : @Sys1Div1MinusX),
   // --------------------------------
  (FName : 'EXP(X)';                 FAddr : @CoeffExp;
   XB   : -1;           XE : 2;              EpsX : 0;
   AngX : False;        AngY : False;
   SysFunc : @SysExp),
   // --------------------------------
  (FName : 'Ln(X+1), |X| < 1';       FAddr : @CoeffLnPlus1;
   XB   : -1;           XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : False;
   SysFunc : @SysLnXPlus1),
   // --------------------------------
  (FName : 'Ln(1-X), |X| < 1';       FAddr : @CoeffLn1MinusX;
   XB   : -1;           XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : False;
   SysFunc : @SysLn1MinusX),
   // --------------------------------
  (FName : 'Sin(X)';                 FAddr : @CoeffSin;
   XB   : -2 * Pi;      XE : 2 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : @SysSin),
   // --------------------------------
  (FName : 'Cos(X)';                 FAddr : @CoeffCos;
   XB   : -2 * Pi;      XE : 2 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : @SysCos),
   // --------------------------------
  (FName : 'Tan(X), |X|< Pi/2';      FAddr : @CoeffTan;
   XB   : - Pi/2;       XE : Pi/2 ;         EpsX : 5e-1;
   AngX : True;         AngY : False;
   SysFunc : @Tan),
   // --------------------------------
  (FName : 'Sec(X), |X|< Pi/2';      FAddr : @CoeffSec;
   XB   : - Pi/2;       XE : Pi/2 ;         EpsX : 5e-1;
   AngX : True;         AngY : False;
   SysFunc : @Sec),
   // --------------------------------
  (FName : 'ArcSin(X), |X| <= 1';    FAddr : @CoeffArcSin;
   XB   : - 1;          XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : True;
   SysFunc : @ArcSin),
   // --------------------------------
  (FName : 'ArcTan(X), |X| <= 1';    FAddr : @CoeffArcTan;
   XB   : - 1;          XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : True;
   SysFunc : @SysArcTan),
   // --------------------------------
  (FName : 'SinH(X)';                FAddr : @CoeffSinH;
   XB   : -2 * Pi;      XE : 2 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : @SinH),
   // --------------------------------
  (FName : 'CosH(X)';                FAddr : @CoeffCosH;
   XB   : -2 * Pi;      XE : 2 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : @CosH),
   // --------------------------------
  (FName : 'TanH(X), |X|< Pi/2';     FAddr : @CoeffTanH;
   XB   : - Pi/2;       XE : Pi/2 ;         EpsX : 2e-1;
   AngX : True;         AngY : False;
   SysFunc : @TanH),
   // --------------------------------
  (FName : 'ArcSinH(X), |X| <= 1';   FAddr : @CoeffArcSinH;
   XB   : - 1;          XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : True;
   SysFunc : @ArcSinH),
   // --------------------------------
  (FName : 'ArcTanH(X), |X| < 1';    FAddr : @CoeffArcTanH;
   XB   : - 1;          XE : 1;              EpsX : 2e-1;
   AngX : False;        AngY : True;
   SysFunc : @ArcTanH),
   // --------------------------------
   // --------------------------------
  (FName : 'Sin(X)/X';               FAddr : @CoeffSinDivX;
   XB   : -8 * Pi;      XE : 8 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : @SysSinDivX),
   // --------------------------------
  (FName : 'Si(X)';                  FAddr : @CoeffSi;
   XB   : -8 * Pi;      XE : 8 * Pi;         EpsX : 0;
   AngX : True;         AngY : False;
   SysFunc : nil),
   // --------------------------------
  (FName : 'Wo(X)';                  FAddr : @CoeffWo;
   XB   : -0.367879441171442;   XE : 0.367879441171442;  EpsX : 0;
   AngX : False;        AngY : False;
   SysFunc : nil)
);

// ------------------------------------------------------------------------
// 21.05.2015
//        
//   FuncDescArr
function GetFuncDesc (RqInd : integer) : TPFuncDesc;
begin
   Result := nil;
   if (RqInd >= Low(FuncDescArr)) and (RqInd <= High(FuncDescArr))
   then Result := Addr(FuncDescArr[RqInd]);
end;

// ------------------------------------------------------------------------
// 21.05.2015
//       
//     
procedure LoadFuncCoeffSelector (RqCbBox : TComboBox);
var Ind : integer;
begin
    RqCbBox.Clear;
    for Ind := Low(FuncDescArr) to High(FuncDescArr)
    do RqCbBox.Items.Add(FuncDescArr[Ind].FName);
    RqCbBox.ItemIndex := 0;
end;

// ------------------------------------------------------------------------
// 21.05.2015
//       RqFunc
procedure MakeFuncCoeffArr (RqN          : integer;      // High - 
                            RqFunc       : TFuncCoeff;   // function
                        var OutCoeffArr  : TD1AttExt);   // Arr  - 
var Ind : integer;
begin
    SetLength(OutCoeffArr, RqN + 1);
    for Ind := Low(OutCoeffArr) to High(OutCoeffArr)
    do OutCoeffArr[Ind] := RqFunc(Ind);
end;

// ------------------------------------------------------------------------
// 21.05.2015
//    
procedure ShowCoeffArr(RqCoeffArr   : TD1AttExt;  // Arr  - 
                       RqFuncName   : string;     // Func - 
                       RqMemoCSeries,             // Memo - 
                       RqMemoCDeriv : TMemo);     // Memo -  )
var Ind   : integer;
    Coeff : extended;
begin
    RqMemoCSeries.Lines.Add(CoeffTitle + RqFuncName);
    RqMemoCDeriv.Lines.Add (DerivTitle + RqFuncName);
    for Ind := Low(RqCoeffArr) to High(RqCoeffArr)
    do begin
         Coeff := RqCoeffArr[Ind];
         RqMemoCSeries.Lines.Add(IntToStr(Ind) + #09 + FloatToStr(Coeff));
         if Abs(Coeff) > 0 then Coeff := Coeff * Fact(Ind);
         RqMemoCDeriv.Lines.Add (IntToStr(Ind) + #09 + FloatToStr(Coeff));
    end;
end;

// ------------------------------------------------------------------------
// 21.05.2015
//   OutCoeffArr      
//  Memo         
procedure FuncCoeffAndDerive(EdHighInd    : TEdit;      //   
                             CmbBoxFunc   : TComboBox;  //  
                             MemoCSeries  : TMemo;      // Memo 
                             MemoCDeriv   : TMemo;      // Memo 
                        var  OutCoeffArr  : TD1AttExt); // 
var HInd, Ind : integer;
    Func : TFuncCoeff;
begin
  MemoCSeries.Clear;
  MemoCDeriv.Clear;
  if EditToInt(EdHighInd, HInd)
  then begin
     Ind := CmbBoxFunc.ItemIndex;
     if (Ind < 0) or (Ind > High(FuncDescArr)) then Exit;
     Func := FuncDescArr[Ind].FAddr;
     MakeFuncCoeffArr (HInd, Func, OutCoeffArr);
     ShowCoeffArr(OutCoeffArr, FuncDescArr[Ind].FName,
                  MemoCSeries, MemoCDeriv);
  end;
end;


// ------------------------------------------------------------------------
// 01.06.2015
//        X
//   ,     .
//     Sum,   HInd  
//        ,  
//     - Result.
function GraphicsSeriesForX
                         (RqCoeffArr : TD1AttExt; //  
                          RqX        : extended;  //  
                      var MCD        : extended;  // .  
                      var LPw        : integer;   //    
                      var Sum        : extended   //  
                          ) : boolean;
var Ind       : integer;   //  
    CItm      : integer;   //   
    PwX       : extended;  // X   
    PItm      : extended;  //   
    Itm       : extended;  //   
    CD        : extended;  //   
    PSum      : extended;  //   
    Nz1, Nz2  : integer;   //   
begin
   Result := False;
   // -----------------------------------------
   //  
   CItm := 0;
   for Ind := Low(RqCoeffArr) to High(RqCoeffArr)
   do if Abs(RqCoeffArr[Ind]) > 0 then Inc(CItm);
   //  
   GraphSC.FullEraseAreaXY;
   GraphIm.FullEraseAreaXY;
   //   
   if CItm < 2
   then begin
      MessageDlg('   '
               + #13#10
               + ' .  = 2.',
                 mtInformation, [mbOk], 0);
      Exit;
   end;
   //   
   SetLength(GArrIm, CItm);
   SetLength(GArrSC, CItm - 1);
   // -----------------------------------------
   //     
   PwX := 1; PItm := 0;
   MCD := 0; LPw  := 0; Sum := 0;
   Nz1 := 0; Nz2  := 0;
   if Length(RqCoeffArr) < 1 then Exit;
   try
      for Ind := Low(RqCoeffArr) to High(RqCoeffArr)
      do begin
        PSum := Sum;
        if (Abs(RqCoeffArr[Ind]) > 0) and (Abs(PwX) > 0)
        then begin
          Itm := RqCoeffArr[Ind]* PwX;
          Sum := Sum + Itm;
          //      
          if Abs(PSum - Sum) > 0
          then LPw := Ind;
          //    
          if Nz1 <= High(GArrIm)
          then begin
             GArrIm[Nz1].X := Ind;
             GArrIm[Nz1].Y := Itm;
             Inc(Nz1);
          end;
          //    
          //   
          if (Abs(PItm) > 0)
          then begin
             CD := Itm/PItm;          //  
             if MCD < Abs(CD) then MCD := Abs(CD);
             if Abs(Itm) > 0 then PItm := Itm;
             //    
             if Nz2 <= High(GArrSC)
             then begin
                GArrSC[Nz2].X := Ind;
                GArrSC[Nz2].Y := CD;
                Inc(Nz2);
             end;
          end
          else if Abs(Itm) > 0 then PItm := Itm;
        end;
        PwX := PwX * RqX;
      end;
      //  
      GraphIm.ShowGraphXY(GArrIm, RGB(0,0,127));
      GraphSC.ShowGraphXY(GArrSC, RGB(127,0,0));
      Result  := True;   //  
    except
      Beep;
      MessageDlg('  '
               + #13#10
               + '   .',
                 mtError, [mbOk], 0);
    end;
end;

// ------------------------------------------------------------------------
// 01.06.2015
//        X
//     Sum,   HInd  
//        ,  
//     - Result.
function CalcSeriesForX (RqCoeffArr : TD1AttExt; // 
                         RqX        : extended;  // 
                     var MCD        : extended;  // .  
                     var LPw        : integer;   //    
                     var Sum        : extended) : boolean;
var Ind       : integer;   //  
    PwX       : extended;  // X   
    PItm      : extended;  //   
    Itm       : extended;  //   
    PSum      : extended;  //   
    CtIPL      : integer;   //    
begin
   Result := False;
   MCD := 0; LPw  := 0; CtIPL := 0;
   Ind := 0; PwX := 1;  PItm := 0; Sum := 0;
   if Length(RqCoeffArr) < 1 then Exit;
   try
      for Ind := Low(RqCoeffArr) to High(RqCoeffArr)
      do begin
        PSum := Sum;
        if (Abs(RqCoeffArr[Ind]) > 0) and (Abs(PwX) > 0)
        then begin
          Itm := RqCoeffArr[Ind]* PwX;
          Sum := Sum + Itm;
          LPw := Ind;
          //    
          if (Abs(PItm) > 0)
          then begin
             if MCD < Abs(Itm/PItm) then MCD := Abs(Itm/PItm);
             if Abs(Itm) > 0 then PItm := Itm;
          end
          else if Abs(Itm) > 0 then PItm := Itm;
          //   
          if Abs(PSum - Sum) = 0
          then begin
              Inc(CtIPL);
              if CtIPL > 1 then Break;
          end else CtIPL := 0;
        end;
        PwX := PwX * RqX;
      end;
      Result := True;
    except
      Beep;
      MessageDlg('   '
                + #13#10
                + '   : ' + IntToStr(Ind),
                  mtError, [mbOk], 0);
    end;
end;


// ------------------------------------------------------------------------


end.
