unit MAIN;
//=============================================================================
//       .
//          DELPHI
//  (c)  ..  1.0.  25.05.2015.
//=============================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons, Math,
  SpecialNumbers01, MaclaurinSeries01,
  GraphXYv51;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    MemoTab1: TMemo;
    Panel1: TPanel;
    Image1: TImage;
    Label4: TLabel;
    EditBernoulliNumb: TEdit;
    Label5: TLabel;
    Panel2: TPanel;
    Image2: TImage;
    Label7: TLabel;
    EditBinomNumb: TEdit;
    TabSheet4: TTabSheet;
    MemoCSeries: TMemo;
    CmbBoxFunc: TComboBox;
    EdSeriesHInd: TEdit;
    Panel3: TPanel;
    EditFatrorial: TEdit;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    MemoCDeriv: TMemo;
    Label15: TLabel;
    SpButCalcSeriesForX: TSpeedButton;
    SpButBernoulli: TSpeedButton;
    SpButBinomialCoef: TSpeedButton;
    SpButFactorial: TSpeedButton;
    Label6: TLabel;
    Panel5: TPanel;
    Label17: TLabel;
    Label18: TLabel;
    EdEulerBK: TEdit;
    SpButEulerB: TSpeedButton;
    Image4: TImage;
    PageControl2: TPageControl;
    TabSheet5: TTabSheet;
    PanelFunc: TPanel;
    TabSheet6: TTabSheet;
    PanelAE: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    SpButCalcFunc: TSpeedButton;
    EditXb: TEdit;
    EditXe: TEdit;
    CbBoxlFuncML: TComboBox;
    CbBoxRadDeg: TComboBox;
    Label8: TLabel;
    Label16: TLabel;
    Label19: TLabel;
    EdX: TEdit;
    Label20: TLabel;
    EdF: TEdit;
    SpButSaveCoeffTxt: TSpeedButton;
    PageControl3: TPageControl;
    TabSheet7: TTabSheet;
    TabSheet8: TTabSheet;
    PanelSC: TPanel;
    PanelIm: TPanel;
    StTxtLPw: TStaticText;
    StTxtMCD: TStaticText;
    SaveDialog1: TSaveDialog;
    CbBoxSaveFormat: TComboBox;
    TabSheet2: TTabSheet;
    PanelSL: TPanel;
    Label21: TLabel;
    Label22: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpButBinomialCoefClick(Sender: TObject);
    procedure SpButFactorialClick(Sender: TObject);
    procedure SpButEulerBClick(Sender: TObject);
    procedure SpButBernoulliClick(Sender: TObject);
    procedure CmbBoxFuncClick(Sender: TObject);
    procedure SpButCalcSeriesForXClick(Sender: TObject);
    procedure EdSeriesHIndChange(Sender: TObject);
    procedure CbBoxRadDegClick(Sender: TObject);
    procedure CbBoxlFuncMLClick(Sender: TObject);
    procedure SpButCalcFuncClick(Sender: TObject);
    procedure SpButSaveCoeffTxtClick(Sender: TObject);
  private
    // private
    //        
    procedure ShowCoeffAndDerive();
  public
    // public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const MaxInd = 255;

// ========================================================================
//    
// ========================================================================
// ------------------------------------------------------------------------
//  
var GraphF  : TGraphXY;   //  
    GraphAE : TGraphXY;   //     Math
    GraphSL : TGraphXY;   //       

// ------------------------------------------------------------------------
//   
var GArrF  : TGraphArr;   //    
    GArrAE : TGraphArr;   //     
                          //  Math
    GArrSL : TGraphArr;   //     
                          //    


//=========================================================================
//                     
//=========================================================================

//  RqArr  
var CmnArr : TD1AttExt;

//    
var BernoulliArr : TD1AttExt;

//    
var EulerArr : TD1AttExt;

//     
var  FuncCoeffArr1 : TD1AttExt;  //    
     FuncCoeffArr2 : TD1AttExt;  //    

//=========================================================================
//                    
//=========================================================================
// ------------------------------------------------------------------------
//   
procedure TForm1.SpButFactorialClick(Sender: TObject);
var Ind : integer;
    K   : integer;
begin
  MemoTab1.Clear;
  MemoTab1.Lines.Add(' ');
  if EditToInt(EditFatrorial, K)
  then begin
     for Ind := 0 to K
     do MemoTab1.Lines.Add(IntToStr(Ind) + #09 + FloatToStr(Fact(Ind)));
  end;
end;
// ------------------------------------------------------------------------
//       
procedure TForm1.SpButBinomialCoefClick(Sender: TObject);
var RqK : integer;
begin
    MemoTab1.Clear;
    if EditToInt(EditBinomNumb, RqK)
    then begin
       MakeCknArr(RqK, CmnArr);
       ShowCknArr(CmnArr, MemoTab1);
    end;
end;
// ------------------------------------------------------------------------
//       
procedure TForm1.SpButBernoulliClick(Sender: TObject);
var RqK : integer;
begin
     MemoTab1.Clear;
     if EditToInt(EditBernoulliNumb, RqK)
     then begin
        MakeBernoulliArr(RqK, BernoulliArr);
        ShowBernoulliArr(BernoulliArr, MemoTab1);
     end;
end;
// ------------------------------------------------------------------------
//       
procedure TForm1.SpButEulerBClick(Sender: TObject);
var RqK : integer;
begin
     MemoTab1.Clear;
     if EditToInt(EdEulerBK, RqK)
     then begin
         MakeTEulerArr(RqK, EulerArr);
         ShowTEulerArr(EulerArr, MemoTab1);
     end;
end;

//=========================================================================
// 25.05.2015
//           
//       ( )
//        ( )  .
//      (convergence)    
//            .
//=========================================================================
// ------------------------------------------------------------------------
// 21.05.2015
//     ,   CmbBoxFunc,
//        
procedure TForm1.ShowCoeffAndDerive();
begin
  FuncCoeffAndDerive(EdSeriesHInd,    //   
                     CmbBoxFunc,      //  
                     MemoCSeries,     // Memo 
                     MemoCDeriv,      // Memo 
                     FuncCoeffArr1);  //  
end;
// ------------------------------------------------------------------------
// 21.05.2015
//        
procedure TForm1.CmbBoxFuncClick(Sender: TObject);
begin
   ShowCoeffAndDerive();
end;
// 21.05.2015
//        
procedure TForm1.EdSeriesHIndChange(Sender: TObject);
begin
   ShowCoeffAndDerive();
end;
// ------------------------------------------------------------------------
// 21.05.2015
//        X
//   
procedure TForm1.SpButCalcSeriesForXClick(Sender: TObject);
var X          : extended;  // 
    MCD        : extended;  // .  
    LPw        : integer;   //   
    F          : extended;  //      
begin
    if MemoCSeries.Lines.Count < 1 then Exit;
    if EditToFloat(EdX, X)
    then begin
       if GraphicsSeriesForX(FuncCoeffArr1, X, MCD, LPw, F)
       then begin
          StTxtMCD.Caption := FloatToStr(MCD);
          StTxtLPw.Caption := IntToStr(LPw);
          EdF.Text := FloatToStr(F);
       end
       else begin
          StTxtMCD.Caption := '';
          StTxtLPw.Caption := '';
          EdF.Text := 'ERROR';
       end;
    end;
end;
// ------------------------------------------------------------------------
//       
//       DELPHI    ListBox
// ------------------------------------------------------------------------
//         
function ComaToPoint(RqExt : extended) : string;
begin
   Result := FloatToStr(RqExt);
   //    
   while Pos(',', Result) > 0 do Result[Pos(',', Result)] := '.';
end;

// ------------------------------------------------------------------------
// 25.05.2015
//       
//      Delphi
procedure SaveCoeffAsConstArr(RqFInd,          //  
                              RqK : integer;   //    
                              RqFileName : string);
var PFuncDesc : TPFuncDesc;
    CoeffArr  : TD1AttExt;
    Ind, sInd : integer;
    wStr      : string;
    List      : TStringList;
begin
  if RqK  < 1 then Exit;
  //-------------------
  PFuncDesc := GetFuncDesc (RqFInd);
  if PFuncDesc = nil then Exit;
  //       RqFunc
  MakeFuncCoeffArr (RqK,               // High - 
                    PFuncDesc^.FAddr,  // . .
                    CoeffArr);         // Arr  - 
  List := TStringList.Create;
  //   
  List.Add ('//      ' + PFuncDesc^.FName);
  List.Add('const CoeffArr : array[0..'
         + IntToStr(Abs(RqK))+ '] of extended = (');
  sInd := 0;  wStr := '';
  // 
  for Ind := Low(CoeffArr) to High(CoeffArr)
  do begin
     //   
     wStr := wStr + #09 + ComaToPoint(CoeffArr[Ind]);
     if Ind < High(CoeffArr) then wStr := wStr + ',';
     //    
     sInd := sInd + 1;
     if sInd > 3
     then begin
         List.Add(wStr);
         sInd := 0;  wStr := '';
     end;
  end;
  //   
  if wStr <> '' then List.Add(wStr);
  //   
  List.Add(');');
  List.SaveToFile(RqFileName);
  List.Free;
end;
// ------------------------------------------------------------------------
// 25.05.2015
//       
//   ListBox
procedure SaveCoeffAsListBox(RqFInd,          //  
                             RqK : integer;   //    
                             RqFileName : string);
var PFuncDesc : TPFuncDesc;
    CoeffArr  : TD1AttExt;
    Ind       : integer;
    List      : TStringList;
begin
  if RqK  < 1 then Exit;
  //-------------------
  PFuncDesc := GetFuncDesc (RqFInd);
  if PFuncDesc = nil then Exit;
  //       RqFunc
  MakeFuncCoeffArr (RqK,               // High - 
                    PFuncDesc^.FAddr,  // . .
                    CoeffArr);         // Arr  - 
  List := TStringList.Create;
  // 
  for Ind := Low(CoeffArr) to High(CoeffArr)
  do List.Add(FloatToStr(CoeffArr[Ind]));
  // 
  List.SaveToFile(RqFileName);
  List.Free;
end;
// -----------------------------------------------------------------
// 25.05.2015
//        
// : FileName := ExtSaveDialog(SaveDialog1, '.txt');
function ExtSaveDialog(RqDialog : TSaveDialog; RqExt : string) : string;
var FileExt : string;     //   
begin
  Result := '';
  //  
  RqDialog.Filter := 'Special files (*'
                    + LowerCase(RqExt) + ')|*' + UpperCase(RqExt);
  //   
  if RqDialog.Execute
  then begin
     Result := RqDialog.FileName;
     FileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (FileExt = UpperCase(RqExt))
     then Result := Result + LowerCase(RqExt);
     //   
     if FileExists(Result)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrNo
        then begin
           //   
           Result := '';
        end;
     end;
  end;
end;
// ------------------------------------------------------------------------
// 25.05.2015
//  
procedure TForm1.SpButSaveCoeffTxtClick(Sender: TObject);
var HInd     : integer;
    FileName : string;
begin
    if EditToInt(EdSeriesHInd, HInd)
     then begin
        FileName := ExtSaveDialog(SaveDialog1, '.txt');
        if FileName <> ''
        then begin
           case CbBoxSaveFormat.ItemIndex of
           0 : SaveCoeffAsConstArr(CmbBoxFunc.ItemIndex, HInd, FileName);
           1 : SaveCoeffAsListBox (CmbBoxFunc.ItemIndex, HInd, FileName);
           end;
        end;
    end;
end;

// ------------------------------------------------------------------------
// ========================================================================
// 25.05.2015
//       ,   
// ========================================================================
// ------------------------------------------------------------------------
//      
type TRangX = record
  Xb   : extended;   //  
  X    : extended;   //  
  Xe   : extended;   //  
  Angl : byte;       //   0 - , 1-
end;

var RangX : TRangX;

// ------------------------------------------------------------------------
//   
procedure AngleConvTo (RqCmd : char; var RqRangX : TRangX);
begin
  with RqRangX do
  begin
    case RqCmd of
    'R' : begin  //    
             if Angl = 1
             then begin
               Xb := DegToRad(Xb);
               Xe := DegToRad(Xe);
               Angl := 0;
             end;
          end;
    'D' : begin  //    
             if Angl = 0
             then begin
               Xb := RadToDeg(Xb);
               Xe := RadToDeg(Xe);
               Angl := 1;
             end;
          end;
    end;
  end;
end;
// ------------------------------------------------------------------------
//   EdXb, EdXe   
procedure EditAngleConvTo (RqCmd : char; EdXb, EdXe : TEdit;
                       var RqRangX : TRangX);
begin
   with RqRangX do
   begin
     if EditToFloat(EdXb, RangX.Xb) and EditToFloat(EdXe, RangX.Xe)
     then begin
       AngleConvTo (RqCmd, RangX);
       EdXb.Text := FloatToStr(RangX.Xb);
       EdXe.Text := FloatToStr(RangX.Xe);
     end;
   end;
end;

// ------------------------------------------------------------------------
//      EditXb  EditXe
procedure TForm1.CbBoxRadDegClick(Sender: TObject);
var Ind       : integer;
    PFuncDesc : TPFuncDesc;
begin
   Ind := CbBoxlFuncML.ItemIndex;
   PFuncDesc := GetFuncDesc (Ind);
   if PFuncDesc = nil then Exit;
   if PFuncDesc^.AngX
   then begin
      case CbBoxRadDeg.ItemIndex of
        0 : EditAngleConvTo ('R', EditXb, EditXe, RangX);
        1 : EditAngleConvTo ('D', EditXb, EditXe, RangX);
      end;
   end;
end;

// ------------------------------------------------------------------------
//        
procedure CalcAndShowFunc(RqFInd : integer; RqRangX : TRangX);
const NumPnt  = 256;
var Ind       : integer;
    PFuncDesc : TPFuncDesc;
    wRangX    : TRangX;
    SysFunc   : TSysFunc;
    dX        : extended;
    aX        : extended;
    HInd      : integer;
    MaxCD     : extended;
    Func      : extended;
    AE        : extended;
    OK        : boolean;
    ER        : boolean;
    // sX        : extended;  //     
begin
   //-------------------
   GraphF.FullEraseAreaXY;
   GraphAE.FullEraseAreaXY;
   GraphSL.FullEraseAreaXY;
   //-------------------
   PFuncDesc := GetFuncDesc (RqFInd);
   if PFuncDesc = nil then Exit;
   //       RqFunc
   MakeFuncCoeffArr (255,               // High - 
                     PFuncDesc^.FAddr,  // . .
                     FuncCoeffArr2);    // Arr  - 
   if (Length(FuncCoeffArr2) < 2) then Exit;
   wRangX := RqRangX;
   with wRangX do
   begin
         //    ,  
         //    
         if PFuncDesc^.AngX then AngleConvTo ('R', wRangX);
         //  
         if Xb >= Xe
         then begin
            MessageDlg('    X.'
                     + #13#10
                     + ' ...',
                     mtError, [mbOk], 0);
            Exit;
         end;
         //-------------------
         SetLength(GArrF,  NumPnt + 1);
         SetLength(GArrSL, NumPnt + 1);
         SetLength(GArrAE, NumPnt + 1);
         dX := (Xe - Xb)/(NumPnt);
         //-------------------
         ER := False;
         for Ind := Low(GArrF) to High(GArrF)
         do begin
             X := Xb + dX * Ind;
             (*
             //     
             sX := 2*Pi*Frac(X/(2*Pi));
             if Abs(sX) <= Pi
             then OK  := CalcSeriesForX (FuncCoeffArr2, sX, MaxCD, HInd, Func)
             else begin
               sX  := Abs(sX) - Pi;
               OK  := CalcSeriesForX (FuncCoeffArr2, sX, MaxCD, HInd, Func);
               if X >= 0 then Func  := - Func;

             end;
             *)
             OK  := CalcSeriesForX (FuncCoeffArr2, X, MaxCD, HInd, Func);
             if not OK then Exit;
             GArrSL[Ind].X := X;
             GArrSL[Ind].Y := HInd;
             //   
             if PFuncDesc^.SysFunc <> nil
             then begin
                SysFunc := PFuncDesc^.SysFunc;
                try AE := Func - SysFunc(X)
                except
                  AE := 0;
                  ER := True;
                end;
             end
             else AE := 0;
             //      
             if (RqRangX.Angl = 1) and PFuncDesc^.AngX
             then aX := RadToDeg(X)
             else aX := X;
             //-------------------   
             GArrF[Ind].X  := aX;
             GArrF[Ind].Y  := Func;
             //-------------------    
             GArrAE[Ind].X := aX;
             GArrAE[Ind].Y := AE;
         end;
         //  
         GraphF.GraphTitul := ' ' + PFuncDesc^.FName;
         GraphF.ShowGraphXY(GArrF, RGB(0,0,127));
         // ----------------
         GraphSL.ShowGraphXY(GArrSL, RGB(0,0,127));
         // ----------------
         if not ER
         then GraphAE.ShowGraphXY(GArrAE, RGB(127,0,0))
         else MessageDlg('  '
                       + #13#10
                       + '   Math.'
                       + #13#10
                       + ' .  .',
                       mtInformation, [mbOk], 0);
   end;
end;

// ------------------------------------------------------------------------
//      
procedure TForm1.SpButCalcFuncClick(Sender: TObject);
var Ind : integer;
begin
   with RangX do
   begin
      if EditToFloat(EditXb, Xb) and EditToFloat(EditXe, Xe)
      then begin
         Ind := CbBoxlFuncML.ItemIndex;
         CalcAndShowFunc (Ind, RangX);
      end;
   end;
end;

// ------------------------------------------------------------------------
//       
procedure SelectAndShowFunc(RqSelector : TComboBox;
                            RqRadDeg   : TComboBox;
                            EdXb, EdXe : TEdit);
var Ind       : integer;
    PFuncDesc : TPFuncDesc;
begin
    //-------------------
    GraphF.FullEraseAreaXY;
    GraphAE.FullEraseAreaXY;
    //-------------------
    //  
    Ind := RqSelector.ItemIndex;
    PFuncDesc := GetFuncDesc (Ind);
    if PFuncDesc = nil then Exit;
    with RangX
    do begin
       //      
       Xb := PFuncDesc^.XB + PFuncDesc^.EpsX;
       Xe := PFuncDesc^.XE - PFuncDesc^.EpsX;
       Angl := 0;
       //      
       RqRadDeg.ItemIndex := 0;
       //      
       EdXb.Text := FloatToStr(Xb);
       EdXe.Text := FloatToStr(Xe);
       if PFuncDesc^.SysFunc = nil
       then MessageDlg('!    .'
                       + #13#10
                       + ' .  . '
                       + #13#10
                       + '   .',
                       mtInformation, [mbOk], 0);
       //  
       CalcAndShowFunc (Ind, RangX);
    end;
end;

// ------------------------------------------------------------------------
//   "      "
procedure TForm1.CbBoxlFuncMLClick(Sender: TObject);
begin
    SelectAndShowFunc(CbBoxlFuncML, CbBoxRadDeg, EditXb, EditXe);
end;

// ========================================================================
//     /  
// ========================================================================
// ------------------------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  GraphF := TGraphXY.Create(PanelFunc);
  GraphF.GraphTitul := ' ';
  GraphF.RulFontNm  := 'Courier New';
  GraphF.RulFontSz  := 9;
  // -----------------------------
  GraphAE := TGraphXY.Create(PanelAE);
  GraphAE.GraphTitul := '  ';
  GraphAE.PicAxesY := '%2.1e';
  // -----------------------------
  //   
  GraphSL := TGraphXY.Create(PanelSL);
  GraphSL.GraphTitul := '  , Y -  . ';
  GraphSL.PicAxesY := '%3.0f';
  GraphSL.PicAxesX := '%2.1e';
  // -----------------------------
  //   
  GraphIm := TGraphXY.Create(PanelIm);
  GraphIm .GraphTitul := 'X-, Y- ';
  GraphIm.PicAxesY := '%2.1e';
  GraphIm.PicAxesX := '%3.0f';
  // -----------------------------
  //    
  GraphSC := TGraphXY.Create(PanelSC);
  GraphSC.GraphTitul := 'X-, Y- ';
  GraphSC.PicAxesY := '%2.1e';
  GraphSC.PicAxesX := '%3.0f';
  // -----------------------------
  //        
  LoadFuncCoeffSelector (CmbBoxFunc);
  ShowCoeffAndDerive();
  // -----------------------------
  //      
  LoadFuncCoeffSelector (CbBoxlFuncML);
  //       
  SelectAndShowFunc(CbBoxlFuncML, CbBoxRadDeg, EditXb, EditXe);
  // -----------------------------
end;
// ------------------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphF.Free;
  GraphAE.Free;
  GraphSL.Free;
  //-----------
  GraphIm.Free;
  GraphSC.Free;
end;

// ========================================================================
//                           
// ========================================================================



end.

