unit Unit1;
(*
 Ln(1+X)  .  -0,4 ... 1.
  .
Wall, H. S. Analytic Theory of Continued Fractions. New York: Chelsea, 1948.
p. 342.
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math, GraphXYv51, ExtCtrls;

type
  TForm1 = class(TForm)
    EdXe: TEdit;
    Button1: TButton;
    Label1: TLabel;
    PanelFunc: TPanel;
    PanelAE: TPanel;
    Label6: TLabel;
    EdXb: TEdit;
    ChkBoxMath: TCheckBox;
    CbBoxChainNum: TComboBox;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ------------------------------------------------------------------------
//  
var GraphF  : TGraphXY;   //  
    GraphAE : TGraphXY;   //     Math


// ------------------------------------------------------------------------
//   
var GArrF  : TGraphArr;   //     
    GArrMF : TGraphArr;   //      Math
    GArrAE : TGraphArr;   //     
                          //  Math

// ---------------------------------------------------------------------------
//     
{$OPTIMIZATION OFF}
function Ln1PlusX(RqN : integer; RqX : extended) : extended;

var   i, j: integer;
      g   : extended;
begin
     i := RqN;
     Result :=  i /(1+RqX);  //    /  
     repeat
         if (i mod 2) > 0
         then j := (i div 2) + 1
         else j := (i div 2);
         g :=  (j * j * RqX) / (i + Result);   //   
         Result := g;
         Dec(i);
     until (i < 1);
end;

{$OPTIMIZATION ON}
// ---------------------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
const NumP = 256;
var  Ind, ChainNum : integer;
     Xb, Xe, Scale, X, Y, AE : extended;
     ER : boolean;
begin
    case CbBoxChainNum.ItemIndex of
      0 : ChainNum := 2;
      1 : ChainNum := 3;
      2 : ChainNum := 4;
      3 : ChainNum := 5;
      4 : ChainNum := 6;
      5 : ChainNum := 7;
      else ChainNum := 8;
    end;
    //-------------------
    GraphF.FullEraseAreaXY;
    GraphAE.FullEraseAreaXY;
    //-------------------
    if tryStrToFloat(EdXb.Text,Xb) and tryStrToFloat(EdXe.Text,Xe)
    then begin
       Scale := (Xe - Xb)/NumP;
       SetLength(GArrF,   NumP + 1);
       SetLength(GArrMF,  NumP + 1);
       SetLength(GArrAE,  NumP + 1);
       ER := False;
       for Ind := Low(GArrF) to High(GArrF)
       do begin
          X := Xb + Scale * Ind;
          GArrF[Ind].X  := X;
          Y := Ln1PlusX(ChainNum, X);
          GArrF[Ind].Y := Y;
          try
             GArrMF[Ind].X := X;
             GArrMF[Ind].Y:= Ln(1+X);
             AE := Y - GArrMF[Ind].Y;
             GArrAE[Ind].X := X;
             GArrAE[Ind].Y := AE;
          except
             ER := True;
          end;
       end;
       GraphF.ShowGraphXY(GArrF, RGB(0,0,127));
       if not ER
       then begin
            if ChkBoxMath.Checked
            then GraphF.PaintGraphXY(GArrMF, RGB(0,127,0));
            GraphAE.ShowGraphXY(GArrAE, RGB(127,0,0));
       end
       else MessageDlg('  '
                       + #13#10
                       + '   Math.'
                       + #13#10
                       + ' .  .',
                       mtInformation, [mbOk], 0);
    end;
end;
// ---------------------------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  GraphF := TGraphXY.Create(PanelFunc);
  GraphF.GraphTitul := ' ';
  GraphF.PicAxesY := '%2.1e';
  // -----------------------------
  GraphAE := TGraphXY.Create(PanelAE);
  GraphAE.GraphTitul := '  ';
  GraphAE.PicAxesY := '%2.1e';
end;
// ---------------------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphF.Free;
  GraphAE.Free;
end;

end.
