unit Unit1;
(*
  Wall, H. S. Analytic Theory of Continued Fractions.
  New York: Chelsea, 1948. p. 348
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math, GraphXYv51, ExtCtrls;

type
  TForm1 = class(TForm)
    EdXe: TEdit;
    Button1: TButton;
    Label1: TLabel;
    PanelFunc: TPanel;
    PanelAE: TPanel;
    Label6: TLabel;
    EdXb: TEdit;
    CbBoxCNum: TComboBox;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// ------------------------------------------------------------------------
//  
var GraphF  : TGraphXY;   //  
    GraphAE : TGraphXY;   //     Math


// ------------------------------------------------------------------------
//   
var GArrF  : TGraphArr;   //    
    GArrAE : TGraphArr;   //     
                          //  Math

{$OPTIMIZATION OFF}
function Chain_ExpX(RqN : word; RqX : extended) : extended;
var i    : integer;
begin
     Result := 1;
     if RqX = 0 then Exit;
     if (RqN and $0001) > 0                  // Odd(RqN) // RqN mod 2 > 0
     then  i := RqN
     else  i := RqN + 1;
     repeat
        if Abs(Result) > 0
        then begin
         if (i and $0001) > 0                // Odd(i) // i mod 2 > 0
         then  Result := i + RqX / Result
         else  Result := 2 - RqX / Result;
        end;
         Dec(i);
     until (i < 2);
     if Abs(Result) > 0
     then begin
        Result := 1 + RqX / Result;
        Result := 1 - RqX / Result;
        Result := 1  / Result;
     end;   
end;
{$OPTIMIZATION ON}

// ---------------------------------------------------------------------------
//     
{$OPTIMIZATION OFF}
const EArr : array[0..15] of extended =
(1,                                   7.389056098930650227230427460575,
 54.598150033144239078110261202861,   403.42879349273512260838718054339,
 2980.9579870417282747435920994529,   22026.465794806716516957900645284,
 162754.79141900392080800520489849,   1202604.2841647767777492367707679,
 8886110.5205078726367630237407815,   65659969.13733051113878650325906,
 485165195.40979027796910683054154,   3584912846.1315915616811599459784,
 26489122129.843472294139162152812,   195729609428.8387642697763978761,
 1446257064291.4751736770474229969,   10686474581524.462146990468650741);

function ExpX(RqN : integer; RqX : extended) : extended;
var X, Y : extended;
    I    : integer;
begin
    if RqX > 0
    then begin
      X := 2 * Frac(RqX / 2);
      I := Round(Int (RqX / 2));
      Y := Chain_ExpX(RqN, X);
      if I <= High(EArr)
      then Result := Y * EArr[I]
      else Result := Y * EArr[High(EArr)];
    end
    else Result := Chain_ExpX(RqN, RqX);
end;

// ---------------------------------------------------------------------------
function MExp(RqX : extended) : extended;
var X, Y : extended;
    I    : integer;
begin
    if RqX > 0
    then begin
      X := 2 * Frac(RqX / 2);
      I := Round(Int (RqX / 2));
      Y := Exp(X);
      if I <= High(EArr)
      then Result := Y * EArr[I]
      else Result := Y * EArr[High(EArr)];
    end
    else Result := Exp(RqX);
end;

{$OPTIMIZATION ON}
// ---------------------------------------------------------------------------
//  
procedure TForm1.Button1Click(Sender: TObject);
const NumP = 256;
var  CNum : integer;
     Ind  : integer;
     Xb, Xe, Scale, X, Y, AE : extended;
begin
    case CbBoxCNum.ItemIndex of
    0 :  CNum := 50;
    1 :  CNum := 60;
    2 :  CNum := 70;
    3 :  CNum := 80;
    4 :  CNum := 90;
    5 :  CNum := 100;
    else CNum := 100;
    end;
    //-------------------
    GraphF.FullEraseAreaXY;
    GraphAE.FullEraseAreaXY;
    //-------------------
    if tryStrToFloat(EdXb.Text,Xb) and tryStrToFloat(EdXe.Text,Xe)
    then begin
       Scale := (Xe - Xb)/NumP;
       SetLength(GArrF,  NumP + 1);
       SetLength(GArrAE, NumP + 1);
       for Ind := Low(GArrF) to High(GArrF)
       do begin
          X := Xb + Scale * Ind;
          GArrF[Ind].X := X;
          Y := ExpX(CNum, X);
          GArrF[Ind].Y := Y;
          AE := Y - MExp(X);
          GArrAE[Ind].X := X;
          GArrAE[Ind].Y := AE;
       end;
       GraphF.ShowGraphXY(GArrF, RGB(0,0,127));
       GraphAE.ShowGraphXY(GArrAE, RGB(127,0,0))

    end;
end;
// ---------------------------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  GraphF := TGraphXY.Create(PanelFunc);
  GraphF.GraphTitul := ' ';
  GraphF.PicAxesY := '%2.1e';
  // -----------------------------
  GraphAE := TGraphXY.Create(PanelAE);
  GraphAE.GraphTitul := '  ';
  GraphAE.PicAxesY := '%2.1e';
end;
// ---------------------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphF.Free;
  GraphAE.Free;
end;

end.
