unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  Math, MiniCalc01, GraphXYv51, DTF03, Menus;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    CBoxReportCmd: TComboBox;
    Label5: TLabel;
    MemoReport: TMemo;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    PanelP: TPanel;
    PanelI: TPanel;
    PanelD: TPanel;
    Panel2: TPanel;
    Label4: TLabel;
    EditXB: TEdit;
    Label7: TLabel;
    EditXE: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    CbBoxXbXeX: TComboBox;
    SpButPi: TSpeedButton;
    SpButE: TSpeedButton;
    EditScale: TEdit;
    Label18: TLabel;
    SpButSaveGraphIntegtal: TSpeedButton;
    Label19: TLabel;
    SpButSaveAbsErrorGraphic: TSpeedButton;
    SpButSavePolinomGraphic: TSpeedButton;
    Label20: TLabel;
    Label21: TLabel;
    SpButRunReportFunc: TSpeedButton;
    Panel6: TPanel;
    Label12: TLabel;
    Label8: TLabel;
    EditNumP: TEdit;
    SpButCalcDTF: TSpeedButton;
    CmbBoxDTFMhet: TComboBox;
    Label22: TLabel;
    CheckBoxOutDeg: TCheckBox;
    ComboBoxReportStyle: TComboBox;
    ComboBoxDTFCoeffStyle: TComboBox;
    Label25: TLabel;
    Label26: TLabel;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    Spectrum1: TMenuItem;
    SpectrScope1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Panel4: TPanel;
    SpButPlus: TSpeedButton;
    SpButMinus: TSpeedButton;
    SpButMult: TSpeedButton;
    SpButDiv: TSpeedButton;
    SpButFunc: TSpeedButton;
    Label3: TLabel;
    Label9: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    EditOp1: TEdit;
    EditOp2: TEdit;
    EditRes: TEdit;
    CbBoxSelFunc: TComboBox;
    Panel3: TPanel;
    LBoxSelFunc: TListBox;
    EditSelectFunc: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    EditParm: TEdit;
    Label10: TLabel;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);








    procedure SpButCalcDTFClick(Sender: TObject);
    procedure SpButPiClick(Sender: TObject);
    procedure SpButEClick(Sender: TObject);
    procedure SpButPlusClick(Sender: TObject);
    procedure SpButMinusClick(Sender: TObject);
    procedure SpButMultClick(Sender: TObject);
    procedure SpButDivClick(Sender: TObject);
    procedure SpButFuncClick(Sender: TObject);
    procedure SpButSaveGraphIntegtalClick(Sender: TObject);
    procedure SpButSaveAbsErrorGraphicClick(Sender: TObject);
    procedure SpButSavePolinomGraphicClick(Sender: TObject);
    procedure SpButRunReportFuncClick(Sender: TObject);
    procedure SpectrScope1Click(Sender: TObject);
    procedure Spectrum1Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure LBoxSelFuncClick(Sender: TObject);


  private
    //     
    procedure SaveGraphAsJpg (RqGraph : TGraphXY);
  public
end;

var
  Form1: TForm1;

// =================================================================
// =================================================================
implementation
{$R *.dfm}
// =================================================================
// =================================================================
//    
type TD1ArrExt  = array of extended;
//    
type TD1ArrT = array of record
    X : extended;          //   
    Y : extended;          //   
end;

var IndFunc : integer;

// =================================================================
//    
var DTF : TDTF03;
// =================================================================
//  
var GraphP   : TGraphXY;  //  
    GraphDTF : TGraphXY;  //  DTF 
    GraphD   : TGraphXY;  //  
// -----------------------------------------------------------------
//   
var ArrY  : TD1ArrExt;    //  Y-  
    ArrT  : TD1ArrT;      //    

// -----------------------------------------------------------------
//   
var GArrT   : TGraphArr;   //    
    GArrDTF : TGraphArr;   //   DTF 
    GArrD   : TGraphArr;   //   

// =================================================================
//     
// =================================================================
// -----------------------------------------------------------------
//     .  
procedure ReportDTF03Coeff(RqDTF   : TDTF03;   //  DTF
                           RqStyle : integer;  //   (0,1,2)
                           RqRep   : TMemo);   // 
var   Ind  : integer;
      wTit, wStr : string;
begin
    if not Assigned(RqDTF) then Exit;
    if RqDTF.MaxIndGgm < 0 then Exit;

    RqRep.Lines.Add('');
    RqRep.Lines.Add('===     ===');
    RqRep.Lines.Add('    n -  ');
    wTit := '';
    case RqStyle of
         0: wTit := '    : n, Cn, Pn';
         1: wTit := '    : n, An, Bn';
    end;
    RqRep.Lines.Add(wTit);
    RqRep.Lines.Add('');
    for Ind := 0 to RqDTF.MaxIndGgm
    do begin
      wStr := '';
      case RqStyle of
        //   C  P
        0 : wStr := format('%4d', [Ind])
                  + '  '
                  + format('%22.16f',[RqDTF.Cn[Ind]])
                  +  '   '
                  + format('%22.16f',[RqDTF.Pn[Ind]]);
        1 : wStr := format('%3d', [Ind])
                  + '  '
                  + format('%22.16f',[RqDTF.An[Ind]])
                  +  '   '
                  + format('%22.16f',[RqDTF.Bn[Ind]]);
      end;
      RqRep.Lines.Add(wStr);
    end;
end;

// ---------------------------------------------------------------------------
//  .   
procedure ReporTDTF03Err(RqArrT   : TD1ArrT;    //  
                         RqArrDTF : TGraphArr;  //   
                         RqRep : TMemo);
var Ind,
    IndMaxDelta : integer;
    X, Y        : extended;
    Delta,
    AbsMaxY,
    AbsMaxDelta,
    MidDelta,
    DispDelta   : extended;
    wStr : string;
begin

    if Length(RqArrT)   < 1  then Exit;
    if Length(RqArrDTF) < 1  then Exit;

    AbsMaxY      := 0;
    IndMaxDelta  := 0;
    AbsMaxDelta  := 0;
    MidDelta     := 0;
    DispDelta    := 0;

    RqRep.Lines.Add('');
    RqRep.Lines.Add('===     ===');
    RqRep.Lines.Add('    i -    ');
    RqRep.Lines.Add('    : i, Xi, Yi, DTF-Yi, AbsError');
    RqRep.Lines.Add('');

    for Ind := 0 to High(RqArrT)
    do begin
      X := RqArrT[Ind].X;
      Y := RqArrT[Ind].Y;
      Delta := RqArrDTF[Ind].Y - Y;
      wStr  := format('%4d', [Ind])
             + '   ' + format('%12.6f', [X])
             + '   ' + format('%12.6f', [Y])
             + '   ' + format('%12.6f', [RqArrDTF[Ind].Y])
             + '   ' + format('%22.16f', [Delta]);
      RqRep.Lines.Add(wStr);

      // .  Y
      if Abs(Y) > AbsMaxY
      then AbsMaxY := Abs(Y);
      // .  Y
      if Abs(Delta) > AbsMaxDelta
      then begin
         AbsMaxDelta := Abs(Delta);
         IndMaxDelta := Ind;
      end;
      MidDelta  := MidDelta + Abs(Delta);
      DispDelta := DispDelta + Delta * Delta;
    end;
    with RqRep.Lines do
    begin
      Add('');
      Add(' ... = ' + IntToStr(IndMaxDelta));
      Add('..       = ' + FloatToStr(AbsMaxDelta));
      Add(' .    = ' + FloatToStr(MidDelta/High(RqArrT)));
      WStr := ' .  = '
            + FloatToStr(SQRT(DispDelta)/High(RqArrT));
      Add(WStr);
      WStr := '..   = '
            + FloatToStr(100 * AbsMaxDelta / AbsMaxY)
            + '(%)';
      Add(WStr);
    end;
end;

// ---------------------------------------------------------------------------
//       
//    . 
procedure BuildGraphDTF(RqArrT   : TD1ArrT;    //  
                        RqDTF    : TDTF03;     //  DTF
                    var RqArrDTF : TGraphArr;  //   
                    var RqArrD   : TGraphArr); //   .
var   Ind : integer;
begin
    if Length(RqArrT) < 5  then Exit;
    if not Assigned(RqDTF) then Exit;

    SetLength(RqArrDTF, Length(RqArrT));
    SetLength(RqArrD,   Length(RqArrT));
    for Ind := 0 to High(RqArrT)
    do begin
      RqArrDTF[Ind].X := RqArrT[Ind].X;
      RqArrDTF[Ind].Y := RqDTF.CalcFuncTDF(RqArrT[Ind].X);
      RqArrD[Ind].X   := RqArrT[Ind].X;
      RqArrD[Ind].Y   := RqArrDTF[Ind].Y - RqArrT[Ind].Y;
    end;
end;

// =================================================================
//          
// =================================================================
// -----------------------------------------------------------------
//   
function CalcFunc(IndF : integer; Op1, Op2 : extended;
                  var Rez : extended) : boolean;
begin
  Result := False;
  if IndF < 0 then Exit;
  try
       case IndF of
       //   
       0 : Rez := (Op1 * Op1);        // (Op1)
       1 : Rez := (Sqrt(Op1));        // (Op1)
       2 : Rez := (Power(Op1, Op2));  // Power(Op1, Op2)
       //   
       3 : Rez := (Exp(Op1));         // Exp (Op1)
       4 : Rez := (Ln(Op1));          // Ln(Op1)
       5 : Rez := (Log2(Op1));        // Log2(Op1)
       6 : Rez := (Log10(Op1));       // Log10(Op1)
       7 : Rez := (20*Log10(Op1));    // 20 * Log10(Op1)
       // 
       8 : Rez := (DegToRad(Op1));    // DegToRad (Op1)
       9 : Rez := (RadToDeg(Op1));    // RadToDeg (Op1)
      10 : Rez := (Sin(Op1));         // Sin(Op1)
      11 : Rez := (ArcSin(Op1));      // ArcSin(Op1)
      12 : Rez := (Cos(Op1));         // Cos(Op1)
      13 : Rez := (ArcCos(Op1));      // ArcCos(Op1)
      14 : Rez := (Tan(Op1));         // Tan(Op1)
      15 : Rez := (ArcTan(Op1));      // ArcTan(Op1)
      16 : Rez := (CoTan(Op1));       // CoTan(Op1)
      17 : Rez := (ArcCot(Op1));      // ArcCoTan(Op1)
      18 : Rez := (Sec(Op1));         // Sec(Op1)
      19 : Rez := (ArcSec(Op1));      // ArcSec(Op1)
      //  
      20 : Rez := (SinH(Op1));         // SinH(Op1)
      21 : Rez := (ArcSinH(Op1));      // ArcSinH(Op1)
      22 : Rez := (CosH(Op1));         // CosH(Op1)
      23 : Rez := (ArcCosH(Op1));      // ArcCosH(Op1)
      24 : Rez := (TanH(Op1));         // TanH(Op1)
      25 : Rez := (ArcTanH(Op1));      // ArcTanH(Op1)
      26 : Rez := (CotH(Op1));         // CoTanH(Op1)
      27 : Rez := (ArcCotH(Op1));      // ArcCoTanH(Op1)
      28 : Rez := (SecH(Op1));         // SecH(Op1)
      29 : Rez := (ArcSecH(Op1));      // ArcSecH(Op1)
      end;
      Result := True;
    except
       MessageDlg('  ' +  #13#10
                + ' X = ' + FloatToStr(Op1),
                   mtInformation,[mbOK],0);
    end;
end;

// -----------------------------------------------------------------
//        .  RqArrA
procedure BuildAndShowTabFunc (IndF : integer;
                               XB, XE : extended;
                               Op2    : extended;
                               NumPn  : integer);
var Ind   : integer;
    dX, X : extended;

begin
  if IndFunc < 0 then Exit;
  if (XB >= XE) or (NumPn < 2)  then Exit;
  //  
  SetLength(ArrY,   NumPn);    // Y- 
  SetLength(ArrT,   NumPn);    //    
  SetLength(GArrT,  NumPn);    //   
  //     
  dx := (XE - XB) / High(ArrT);
  for Ind := Low(ArrY) to High(ArrY)
  do begin
     X := XB + Ind * dx;
     if CalcFunc(IndF, X, Op2, ArrY[Ind])
     then begin
       ArrT[Ind].Y := ArrY[Ind];
       ArrT[Ind].X := X;
       GArrT[Ind].Y  := ArrY[Ind];
       GArrT[Ind].X  := X;
     end
     else begin
       //    
       SetLength(ArrY, 0);
       SetLength(ArrT, 0);
       SetLength(GArrT, 0);
       Exit;
     end;
  end;
  //    
  GraphP.FullEraseAreaXY;
  if Length(GArrT) > 1
  then GraphP.ShowGraphXY(GArrT, RGB(0,127,0));
  
end;

// =================================================================
//     
// =================================================================
// -----------------------------------------------------------------
//    
procedure ReportFileSave(Dialog     : TSaveDialog;     //   
                         memReport  : TMemo);          // 

var FileName,            //   
    FileExt : string;    //   
begin
  if memReport.Lines.Count < 1 then Exit;
  //  
  Dialog.Filter := 'Memo string files (*.txt)|*.TXT';
  //   
  if Dialog.Execute
  then begin
     FileName := Dialog.FileName;
     FileExt  := UpperCase(ExtractFileExt(FileName));
     //     ,    
     if not (FileExt = '.TXT') then FileName := FileName + '.txt';
     //   
     if FileExists(FileName)
     then begin
        if MessageDlg('   .'+ #13#10
                    + '   ?',
                       mtInformation,[mbYes,mbNo],0) = mrYes
        then begin
           //   
           try
              memReport.Lines.SaveToFile(FileName);
           except
              MessageDlg('    :'+ #13#10
                        + FileName+ #13#10
                        + '    .'+ #13#10
                        + '    ...',
                        mtError,[mbOK],0);
           end;
        end;
     end
     else begin
           //    
            try
              memReport.Lines.SaveToFile(FileName);
           except
              MessageDlg('    :'+ #13#10
                        + FileName+ #13#10
                        + '    .'+ #13#10
                        + '    ...',
                        mtError,[mbOK],0);
           end;
     end;
  end;
end;
// -----------------------------------------------------------------
//     
procedure ShowTabFunc (XB, XE    : extended;   //  . 
                       RqArrT    : TD1ArrT;    //  
                       RqReport  : TMemo);
var dX, Y, X : extended;
    Ind   : integer;
    WStr  : string;
begin
  if Length(RqArrT) < 1
  then begin
    RqReport.Lines.Add('  ');
    Exit;
  end;
  dx := (XE - XB) / High(RqArrT);
  with RqReport.Lines do
  begin
     Add('===     ===');
     Add('     ( X)   = ' + FloatToStr(dx));
     Add('    i -    ');
     Add('    : i, Xi, Yi');
     Add('');
     for Ind := Low(RqArrT) to High(RqArrT)
     do begin
       X := RqArrT[Ind].X;
       Y := RqArrT[Ind].Y;
       WStr := format('%3d', [Ind])
             + '   ' +  format('%24.16f', [X])
             + '   ' +  format('%24.16f', [Y]);
       Add(WStr);
     end;
  end;
end;

// -----------------------------------------------------------------
//     
procedure TForm1.SpButRunReportFuncClick(Sender: TObject);
begin
  case CBoxReportCmd.ItemIndex of
  0 : MemoReport.Clear;
  1 : ReportFileSave(SaveDialog1,     //   
                     MemoReport);     // 

  end; // of case
end;
// =================================================================
//      
// =================================================================
//       
procedure TForm1.SpButCalcDTFClick(Sender: TObject);
var NumP, XB, XE, Parm : extended;
    NumPn        : integer;
begin
   // --------------------------------------------
   //  
   MemoReport.Clear;
   //  
   GraphP.FullEraseAreaXY;
   GraphDTF.FullEraseAreaXY;
   GraphD.FullEraseAreaXY;
   // --------------------------------------------
   if IndFunc < 0
   then begin
      MessageDlg('    ... ',
                  mtInformation, [mbOk], 0);
      Exit;
   end;
   // --------------------------------------------
   if EditToFloat (EditNumP, NumP) and
      EditToFloat (EditXB, XB) and
      EditToFloat (EditXE, XE) and
      EditToFloat (EditParm, Parm)
   then begin
     // --------------------------------------------
     NumPn := Round(NumP);
     //     
     BuildAndShowTabFunc (IndFunc, XB, XE,
                          Parm,            // Op2
                          NumPn);
     if Length(ArrT) <= 0
     then begin
        MessageDlg('   ... ' +  #13#10
                 + '   ',
        mtInformation, [mbOk], 0);
        Exit;
     end;
     // --------------------------------------------
     //    
     ShowTabFunc(XB, XE, ArrT, MemoReport);

     // ===========================================
     // =====             ======
     // ===========================================
     //    /
     DTF.RqDegree := CheckBoxOutDeg.Checked;
     //   
     DTF.CodMet := CmbBoxDTFMhet.ItemIndex;
     //   
     DTF.XB := XB;
     DTF.XE := XE;
     DTF.RunDTF03(ArrY);
     // ===========================================
     BuildGraphDTF(ArrT,      //  
                   DTF,       //  DTF
                   GArrDTF,   //   
                   GArrD);
     // -------------------------------------------
     //     
     GraphDTF.ShowGraphXY(GArrT,    RGB(0,127,0));
     GraphDTF.PaintGraphXY(GArrDTF, RGB(0,0,127));
     GraphD.ShowGraphXY(GArrD,    RGB(0,127,0));
     // ===========================================
     //     
     ReporTDTF03Coeff(DTF, ComboBoxDTFCoeffStyle.ItemIndex, MemoReport);
     case ComboBoxReportStyle.ItemIndex of
      0 : DTF.LookDTF03(MemoReport);                    //  
      1 : ReporTDTF03Err (ArrT, GArrDTF, MemoReport);   //  
     end;
   end;
end;

// =================================================================
//         
// =================================================================
// -----------------------------------------------------------------
//  Pi       
procedure TForm1.SpButPiClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditXE.Text := FloatToStr(Val * Pi);
     1 : EditXB.Text := FloatToStr(Val * Pi);
     end;
  end;
end;
// -----------------------------------------------------------------
//  Exp(1)       
procedure TForm1.SpButEClick(Sender: TObject);
var Val : extended;
begin
  if EditToFloat (EditScale, Val)
  then begin
     case CbBoxXbXeX.ItemIndex of
     0 : EditXE.Text := FloatToStr(Val * Exp(1));
     1 : EditXB.Text := FloatToStr(Val * Exp(1));
     end;
  end;
end;
// =================================================================
//      
// =================================================================
//     
procedure TForm1.SaveGraphAsJpg (RqGraph : TGraphXY);
begin
  if Assigned(RqGraph)
  then begin
    SaveDialog1.Filter := 'Graphics files (*.jpg)|*.JPG';
    if SaveDialog1.Execute
    then begin
      RqGraph.SaveGraphXY(SaveDialog1.FileName,'J');
    end;
  end;
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSavePolinomGraphicClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphP);
end;
// -----------------------------------------------------------------
//     
procedure TForm1.SpButSaveGraphIntegtalClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphDTF);
end;
// -----------------------------------------------------------------
//        
procedure TForm1.SpButSaveAbsErrorGraphicClick(Sender: TObject);
begin
  SaveGraphAsJpg(GraphD);
end;

// =================================================================
//        
//       3.3 (31.08.2017)
// =================================================================
// --------------------------------------------------------------------
//        
// --------------------------------------------------------------------
//         
const Spectr_ID = ' Ver 1.01.';  //    
const Signal_ID = ' Ver 1.01.';  //    
const Comment_ID  = '//';              //   
const Comment_Dlm = ' ';               //    
const XB_ID = 'XB';                    //   XB
const XE_ID = 'XE';                    //   XE
const Data_Dlm = char($09);            //    
// -----------------------------------------------------------------
//   
procedure SaveSpectrToFile(RqFileName : string;      //    
                           RqExportFormat : integer; //  
                           RqDelimitor : char);      //  
var wList      : TStringList;
    wInd       : integer;
    wStr       : string;
    Amp, Phs   : extended;
begin

  if not Assigned(DTF) then Exit;
  if DTF.MaxIndGgm <= 0    then Exit;

  //   
  if FileExists(RqFileName)
  then begin
      if MessageDlg('    :'+ #13#10
                  +  RqFileName + #13#10
                  + '   ?',
                     mtInformation,[mbYes,mbNo],0) <> mrYes
      then Exit;
  end;
  wList := TStringList.Create;
  // ------------------------------
  //  
  try
    //    
       case RqExportFormat of
       0 : begin
              wList.Add(Comment_ID  + ' (Cn,Pn) Spectrum');
              wList.Add(Comment_ID  + '  : ' + RqFileName);
              wList.Add(Comment_ID  + Comment_Dlm + Spectr_ID);
              wList.Add(Comment_ID  + '   : ' + DateTimeToStr(Now()));
              wList.Add(Comment_ID  + Comment_Dlm + XB_ID
                      + Comment_Dlm +  FloatToStr(DTF.XB));
              wList.Add(Comment_ID  + Comment_Dlm + XE_ID
                      + Comment_Dlm + FloatToStr(DTF.XE));
              wList.Add(Comment_ID  + '  : Amp,  Phs(rad)');
              wList.Add(Comment_ID);
           end;
       1 : begin
              wList.Add(Comment_ID   + ' (Cn,Pn) SpectrScope');
              wList.Add(Comment_ID   + '  : ' + RqFileName);
              wList.Add(Comment_ID  + Comment_Dlm + Spectr_ID);
              wList.Add(Comment_ID  + '   : ' + DateTimeToStr(Now()));
              wList.Add(Comment_ID  + Comment_Dlm + XB_ID
                      + Comment_Dlm +  FloatToStr(DTF.XB));
              wList.Add(Comment_ID  + Comment_Dlm + XE_ID
                      + Comment_Dlm + FloatToStr(DTF.XE));
              wList.Add(Comment_ID + '  :  Num,  Amp,  Phs(rad)');
              wList.Add(Comment_ID);
           end;
       end;
    // ------------------------------
    // 
    for wInd := 0 to DTF.MaxIndGgm do
    begin
       Amp := DTF.Cn[wInd];
       Phs := DTF.Pn[wInd];
       //       
       wStr := '';
       case RqExportFormat of
          0 : begin  // (Cn,Pn) Ver 0.01. Spectrum'
                wStr := FloatToStr(Amp) + #09
                      + FloatToStr(Phs);
              end;
          1 : begin  // (Cn,Pn) Ver 1.01. SpectrScope'
                wStr := IntToStr(wInd) + #09
                      + FloatToStr(Amp) + #09
                      + FloatToStr(Phs);
              end;
        end;
       //  
       wList.Add(wStr);
       // ------------------------------
    end;
    wList.Add(Comment_ID + ' ');
    wList.Add(Comment_ID + ' ');
    //    
    wList.SaveToFile(RqFileName);
  except
       MessageDlg('   : '
                  +   #13#10 + RqFileName,
                  mtError, [mbOk], 0);
  end;
   wList.Free;

end;
// -----------------------------------------------------------------
//       
function DialogSaveSpectrToFile(RqExportFormat : integer) : string;
var wExt    : string;
    wDialog : TSaveDialog;
    wFileExt : string;     //   
begin
  Result := '';
  wExt   := '.txt';
  wDialog := TSaveDialog.Create(nil);
  //  
  wDialog.Filter := 'Spectr files (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     Result := wDialog.FileName;
     wFileExt  := UpperCase(ExtractFileExt(Result));
     //     ,    
     if not (wFileExt = UpperCase(wExt))
     then Result := Result + LowerCase(wExt);
     //  
     SaveSpectrToFile(Result, RqExportFormat, Data_Dlm);
  end;
  wDialog.Free;
end;
// -----------------------------------------------------------------
//      Spectrum
procedure TForm1.Spectrum1Click(Sender: TObject);
begin
   DialogSaveSpectrToFile(0);
end;

// -----------------------------------------------------------------
//      SpectrScope
procedure TForm1.SpectrScope1Click(Sender: TObject);
begin
    DialogSaveSpectrToFile(1);
end;

// =================================================================
//      
// =================================================================
//   
procedure TForm1.SpButPlusClick(Sender: TObject);
begin
  MCPlus(EditOp1,EditOp2,EditRes);
end;
//   
procedure TForm1.SpButMinusClick(Sender: TObject);
begin
  MCMinus(EditOp1,EditOp2,EditRes);
end;
//   
procedure TForm1.SpButMultClick(Sender: TObject);
begin
  MCMult(EditOp1,EditOp2,EditRes);
end;
//   
procedure TForm1.SpButDivClick(Sender: TObject);
begin
  MCDivision(EditOp1, EditOp2, EditRes);
end;
//   
procedure TForm1.SpButFuncClick(Sender: TObject);
begin
  MCFunc(CbBoxSelFunc.ItemIndex, EditOp1, EditOp2, EditRes);
end;

// =================================================================
//      
// =================================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
   IndFunc := -1;
   DTF := TDTF03.Create;

   GraphP := TGraphXY.Create(PanelP);    //  
   GraphP.GraphTitul := '  Y = P(X)';
   GraphDTF := TGraphXY.Create(PanelI);  //  DTF
   GraphDTF.GraphTitul := ' DTF';
   GraphD := TGraphXY.Create(PanelD);    //  
   GraphD.GraphTitul := ' Y = Abs- ';
   GraphD.PicAxesY := '%18.17f';
end;
// -----------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  DTF.Free;
  GraphP.Free;    //  
  GraphDTF.Free;  //  DTF
  GraphD.Free;    //  
end;
// -----------------------------------------------------------------
// 
procedure TForm1.N3Click(Sender: TObject);
begin
   Close();
end;

// =================================================================
//    
// =================================================================


procedure TForm1.LBoxSelFuncClick(Sender: TObject);
begin
    IndFunc := LBoxSelFunc.ItemIndex;
    EditSelectFunc.Text := LBoxSelFunc.Items[IndFunc];
end;

// 3,14159265358979

end.

