unit MiniCalc01;
// =================================================================
//     
// =================================================================
(*
    +,-,*,/,  
   ( IndF   ):
  (Op1)
  (Op1) 
 Power (Op1, Op2)
 Exp (Op1)
 Ln (Op1)
 Log2 (Op1)
 Log10 (Op1)
 20 * Log10 (Op1)
 DegToRad  (Op1) 
 RadToDeg (Op1)
 Sin (Op1)
 ArcSin (Op1)
 Cos (Op1)
 ArcCos (Op1)
 Tan (Op1)
 ArcTan (Op1)
 CoTan (Op1)
 ArcCoTan (Op1)
 Sec (Op1)
 ArcSec (Op1)
 SinH (Op1)
 ArcSinH (Op1)
 CosH (Op1)
 ArcCosH (Op1)
 TanH (Op1)
 ArcTanH (Op1)
 CoTanH (Op1)
 ArcCoTanH (Op1)
 SecH (Op1)
 ArcSecH (Op1)
*)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, StdCtrls,
  Math;

// -----------------------------------------------------------------
//        
function EditToFloat (RqEdit  : TEdit;
                  var RqFloat : extended) : boolean;
// -----------------------------------------------------------------
//        
function EditToInt (RqEdit  : TEdit;
                var RqInt : integer) : boolean;
// -----------------------------------------------------------------
//   
procedure MCPlus(EditOp1, EditOp2, EditRes : TEdit);
// -----------------------------------------------------------------
//   
procedure MCMinus(EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2, Res : extended;
// -----------------------------------------------------------------
//   
procedure MCMult(EditOp1, EditOp2, EditRes : TEdit);
// -----------------------------------------------------------------
//   
procedure MCDivision(EditOp1, EditOp2, EditRes : TEdit);
// -----------------------------------------------------------------
//   
procedure MCFunc(IndF : integer; EditOp1, EditOp2, EditRes : TEdit);

implementation

// =================================================================
//     
// =================================================================
// -----------------------------------------------------------------
// 07.03.2014
//        
function EditToFloat (RqEdit  : TEdit;
                  var RqFloat : extended) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result  := True;    //   
  except
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
// 07.03.2014
//        
function EditToInt (RqEdit  : TEdit;
                var RqInt : integer) : boolean;
begin
  Result  := False;     //   
  try
    RqInt := StrToInt(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result  := True;    //   
  except
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
//   
procedure MCPlus(EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 + Op2;
       EditRes.Text := FloatToStr(Res);
    except
       EditRes.Text := '';
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure MCMinus(EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 - Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure MCMult(EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 * Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure MCDivision(EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2, Res : extended;
begin
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       Res := Op1 / Op2;
       EditRes.Text := FloatToStr(Res);
    except
       MessageDlg('   ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
// -----------------------------------------------------------------
//   
procedure MCFunc(IndF : integer; EditOp1, EditOp2, EditRes : TEdit);
var Op1, Op2 : extended;
begin
  if IndF < 0 then Exit;
  if (EditToFloat (EditOp1, Op1)) and (EditToFloat (EditOp2, Op2))
  then begin
    try
       case IndF of
       //   
       0 : EditRes.Text := FloatToStr(Op1 * Op1);        // (Op1)
       1 : EditRes.Text := FloatToStr(Sqrt(Op1));        // (Op1)
       2 : EditRes.Text := FloatToStr(Power(Op1, Op2));  // Power(Op1, Op2)
       //   
       3 : EditRes.Text := FloatToStr(Exp(Op1));         // Exp (Op1)
       4 : EditRes.Text := FloatToStr(Ln(Op1));          // Ln(Op1)
       5 : EditRes.Text := FloatToStr(Log2(Op1));        // Log2(Op1)
       6 : EditRes.Text := FloatToStr(Log10(Op1));       // Log10(Op1)
       7 : EditRes.Text := FloatToStr(20*Log10(Op1));    // 20 * Log10(Op1)
       // 
       8 : EditRes.Text := FloatToStr(DegToRad(Op1));    // DegToRad (Op1)
       9 : EditRes.Text := FloatToStr(RadToDeg(Op1));    // RadToDeg (Op1)
      10 : EditRes.Text := FloatToStr(Sin(Op1));         // Sin(Op1)
      11 : EditRes.Text := FloatToStr(ArcSin(Op1));      // ArcSin(Op1)
      12 : EditRes.Text := FloatToStr(Cos(Op1));         // Cos(Op1)
      13 : EditRes.Text := FloatToStr(ArcCos(Op1));      // ArcCos(Op1)
      14 : EditRes.Text := FloatToStr(Tan(Op1));         // Tan(Op1)
      15 : EditRes.Text := FloatToStr(ArcTan(Op1));      // ArcTan(Op1)
      16 : EditRes.Text := FloatToStr(CoTan(Op1));       // CoTan(Op1)
      17 : EditRes.Text := FloatToStr(ArcCot(Op1));      // ArcCoTan(Op1)
      18 : EditRes.Text := FloatToStr(Sec(Op1));         // Sec(Op1)
      19 : EditRes.Text := FloatToStr(ArcSec(Op1));      // ArcSec(Op1)
      //  
      20 : EditRes.Text := FloatToStr(SinH(Op1));         // SinH(Op1)
      21 : EditRes.Text := FloatToStr(ArcSinH(Op1));      // ArcSinH(Op1)
      22 : EditRes.Text := FloatToStr(CosH(Op1));         // CosH(Op1)
      23 : EditRes.Text := FloatToStr(ArcCosH(Op1));      // ArcCosH(Op1)
      24 : EditRes.Text := FloatToStr(TanH(Op1));         // TanH(Op1)
      25 : EditRes.Text := FloatToStr(ArcTanH(Op1));      // ArcTanH(Op1)
      26 : EditRes.Text := FloatToStr(CotH(Op1));         // CoTanH(Op1)
      27 : EditRes.Text := FloatToStr(ArcCotH(Op1));      // ArcCoTanH(Op1)
      28 : EditRes.Text := FloatToStr(SecH(Op1));         // SecH(Op1)
      29 : EditRes.Text := FloatToStr(ArcSecH(Op1));      // ArcSecH(Op1)
        end;
    except
       MessageDlg('  ',
                   mtInformation,[mbOK],0);
       EditRes.Text := '';
    end;
  end;
end;
// -----------------------------------------------------------------
// -----------------------------------------------------------------

end.
