unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Math, GraphXYv51, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PanelT: TPanel;
    Panel1: TPanel;
    Label1: TLabel;
    CbBoxSelPoly: TComboBox;
    Label2: TLabel;
    edMaxIndP: TEdit;
    Button1: TButton;
    Panel2: TPanel;
    Label3: TLabel;
    edIndM: TEdit;
    butConv: TButton;
    Label4: TLabel;
    edIndN: TEdit;
    edConv: TEdit;
    stxtConv: TStaticText;
    Label5: TLabel;
    stxtAbsErrConvL: TStaticText;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    cbBoxSeries: TComboBox;
    Label9: TLabel;
    CbBoxMethod: TComboBox;
    edMaxIndX: TEdit;
    Label10: TLabel;
    stxtReportI: TStaticText;
    Label11: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure butConvClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// =================================================================
//  
var GraphP : TGraphXY;    //  

// -----------------------------------------------------------------
//   
var GArrP  : TGraphArr;   //   

// =================================================================
//  
// =================================================================
//  Edit.Text  
function EditToInt (RqEdit : TEdit; var Val : integer) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToInt(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
//  Edit.Text  
function EditToFloat (RqEdit : TEdit; var Val : extended) : boolean;
begin
  Result := False;     //   
  try
    Val := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    RqEdit.Color := RGB(240,127,127);
    ShowMessage('    ');
  end;
end;
// -----------------------------------------------------------------
function SignR(const AValue: extended): integer;
const Delta = 1e-20;
begin
  Result := 0;
  if AValue < -Delta then Result := -1;
  if AValue >  Delta then Result := 1;
end;
// -----------------------------------------------------------------
//     
//       
//        
type  TArrA = array[0..7, 0..7] of extended;
const LArrA : TArrA =
(
//     0        1       2       3        4         5       6       7
 (     1,       0,      0,      0,       0,        0,      0,      0),  // 0
 (     0,       1,      0,      0,       0,        0,      0,      0),  // 1
 (  -1/2,       0,    3/2,      0,       0,        0,      0,      0),  // 2
 (     0,    -3/2,      0,    5/2,       0,        0,      0,      0),  // 3
 (   3/8,       0,  -30/8,      0,    35/8,        0,      0,      0),  // 4
 (     0,    15/8,      0,  -70/8,       0,     63/8,      0,      0),  // 5
 ( -5/16,    0,    105/16,      0, -315/16,        0, 231/16,      0),  // 6
 (     0,  -35/16,      0, 315/16,       0,  -693/16,      0,  429/16)  // 7
 );
// -----------------------------------------------------------------
//  ,     
function Polynom (ArrA : TArrA;    //  
                  PInd : integer;  //  
                  X : extended ) : extended;
var Ind  : integer;
    PwX  : extended;
    Prev : extended;
    Pol  : extended;
begin
  if Length(ArrA) < 1 then Exit;
  PwX  := 1;
  Prev := 0;
  Pol  := 0;
  try
     for Ind := Low(ArrA) to High(ArrA)
     do begin
        if ArrA[PInd,Ind] <> 0 then
        begin
           if Pol <> 0 then Prev := Pol;
           Pol := Pol + ArrA[PInd,Ind] * PwX;
           if Pol = Prev then Break;  //     
        end;
        PwX := PwX * X;
     end;
     Result := Pol;
  except
     Result := 0;
     MessageDlg('   :',
                 mtError,[mbOK],0);
  end;
end;

// -----------------------------------------------------------------
//       
function TrapezIntegralIndBE (RqArr : TGraphArr;
                              IndB, IndE : integer;
                              dX: extended) : extended;
var Ind : integer;
begin
  Result := 0;
  //   
  if (Length(RqArr) < 2) or (IndB >= IndE) or
     (IndB < Low(RqArr)) or (IndE > High(RqArr)) then Exit;
  Ind := IndB;
  repeat
    Result := Result + (RqArr[Ind].Y + RqArr[Ind + 1].Y) / 2;
    Ind := Ind + 1;
  until (Ind > IndE - 1);
  Result := Result * dX;
  //   '
  Form1.stxtReportI.Caption := '';
end; // of function
// -----------------------------------------------------------------
//        IndB, IndE
function SimpsonIntegralIndBE (RqArr : TGraphArr;
                               IndB, IndE : integer;
                               dX: extended) : extended;
var Ind : integer;
begin
   //    
   if ((IndE - IndB) mod 2) > 0
   then begin
        //    
        Result := TrapezIntegralIndBE(RqArr, IndB, IndE, dX);
        Exit;
   end;
   Result := 0;
   //   
   if (Length(RqArr) < 2) or (IndB >= IndE) or
      (IndB < Low(RqArr)) or (IndE > High(RqArr)) then Exit;
   //   
   if (IndE - IndB) > 0
   then begin
      //     
      Ind := IndB;
      while (Ind <= (IndE - 2))
      do begin
       Result := Result + (RqArr[Ind].Y
                        + 4 * RqArr[Ind + 1].Y
                        + RqArr[Ind + 2].Y);
       Ind := Ind + 2
      end;
      Result := (Result / 3)* dX;
      //   '
      Form1.stxtReportI.Caption := '';
    end;
end; // of function
// -----------------------------------------------------------------
//    SMSS-   IndB, IndE.
//       .
function SMSS_SimpsonIntegralIndBE (RqArrP : TGraphArr;
                                    IndB, IndE : integer;
                                    dX: extended) : extended;
var Ind : integer;
begin
   Result := 0;
   //   
   if (Length(RqArrP) < 2) or (IndB >= IndE) or
      (IndB < Low(RqArrP)) or (IndE > High(RqArrP)) then Exit;
   //   
   if (IndE - IndB) >= 6
   then begin
         if ((IndE - IndB) mod 2 > 0)
         then begin
            //      
            //   
            Result := (RqArrP[IndB].Y
                       + 4*RqArrP[IndB+1].Y
                       + RqArrP[IndB+2].Y
                       );
            Result := Result + (13*(RqArrP[IndB+2].Y+RqArrP[IndB+3].Y)
                             - (RqArrP[IndB+1].Y+RqArrP[IndB+4].Y)
                               )/8;
            Ind := IndB + 3;
         end
         else Ind := IndB;
         //      () 
         while (Ind <= (IndE - 2))
         do begin
           Result := Result + (RqArrP[Ind].Y
                               + 4 * RqArrP[Ind + 1].Y
                               + RqArrP[Ind + 2].Y
                              );
           Ind := Ind + 2;
         end;
         Result := Result * dX / 3;
         //   '
        Form1.stxtReportI.Caption := 'SMSS-';
   end
   //   
   else Result := SimpsonIntegralIndBE (RqArrP, IndB, IndE, dX);
end; // of function
// -----------------------------------------------------------------
//    LMMR-    IndB, IndE
//       L-  R- 
function LMMR_SimpsonIntegralIndBE (RqArr : TGraphArr;
                                    IndB, IndE : integer;
                                    dX: extended) : extended;
var Ind        : integer;
    LS, MS1, MS2, RS : extended;
begin
   Result := 0;
   //    
   if (Length(RqArr) < 3) or (IndB >= IndE) or
      (IndB < Low(RqArr)) or (IndE > High(RqArr)) then Exit;
   //   
   if (IndE - IndB) >= 3
   then begin
      //  L-   
      LS := ( 5*RqArr[IndB].Y + 8*RqArr[IndB+1].Y - RqArr[IndB+2].Y )/12;
      //     
      MS1:=0; MS2 := 0;
      for Ind := IndB to IndE - 3
      do begin
         MS1 := MS1 + RqArr[Ind+1].Y + RqArr[Ind+2].Y;
         MS2 := MS2 + RqArr[Ind].Y   + RqArr[Ind+3].Y;
      end;
      MS1 := (13 * MS1 - MS2)/24;
      //  R-   
      RS := (-RqArr[IndE-2].Y + 8*RqArr[IndE-1].Y + 5*RqArr[IndE].Y)/12;
      //   
      Result := (LS + MS1 + RS) * dX;
      //   '
      Form1.stxtReportI.Caption := 'LMMR-';
    end
    else begin
        //   
        Result := SimpsonIntegralIndBE(RqArr, IndB, IndE, dX);
    end;
end; // of function

// =================================================================
//   
// =================================================================
//   X  (-1 .. 1)     N
function CalcL(X : extended; N : integer) : extended;
var TCurr, TPrev : extended;
    Ind : integer;
begin
    case N of
       0 :  Result := 1;        // L0
       1 :  Result := X;        // L1
       else begin               // L2 .. Ln
          TPrev  := 1;
          TCurr  := X;
          Result := TCurr;
          for Ind := 2 to N
          do begin
            Result := ((2*(Ind-1)+1)/Ind)*X*TCurr - ((Ind-1)/Ind)*TPrev;
            TPrev  := TCurr;
            TCurr  := Result;
          end;
       end;
    end;
end;

// -----------------------------------------------------------------
//      , 
// MaxIndX -     X
// MaxIndT -     
procedure ShowL(MaxIndX, MaxIndT : integer);
var StepX  : extended;
    X      : extended;
    IndT   : integer;
    IndX   : integer;
begin
   GraphP.FullEraseAreaXY;
   SetLength(GArrP, MaxIndX + 1);
   StepX := 2 / MaxIndX;
   for IndT := 1 to MaxIndT
   do begin
      X := -1;
      for IndX := Low(GArrP) to High(GArrP)
      do begin
         GArrP[IndX].X := X;
         //  
         GArrP[IndX].Y := CalcL(X, IndT);
         //  
         // Polynom(LArrA, IndT, X, GArrP[IndX].Y);
         X := X + StepX;
      end;
      if IndT = 1
      then GraphP.ShowGraphXY(GArrP, clBlue)
      else begin
          if  IndT = MaxIndT
          then begin
             GraphP.GraphTitul := '    : '
                                + IntToStr(MaxIndT);
             GraphP.PaintGraphXY(GArrP, RGB(127,0,0));
          end
          else GraphP.PaintGraphXY(GArrP, clBlue);
      end;
   end;
   SetLength(GArrP, 0);
end;


// =================================================================
//  
// =================================================================
//   X  (-1 .. 1)     N
function CalcT(X : extended; n : integer) : extended;
var TCurr, TPrev : extended;
    Ind : integer;
begin
    case N of
       0 :  Result := 1;      // T0
       1 :  Result := X;      // T1
       else begin             // T2 .. Tn
          TPrev  := 1;
          TCurr  := X;
          Result := TCurr;
          for Ind := 2 to n
          do begin
            Result := 2 * X * TCurr - TPrev;
            TPrev  := TCurr;
            TCurr  := Result;
          end;
       end;
    end;
end;
// -----------------------------------------------------------------
//      , 
// MaxIndX -     X
// MaxIndT -     
procedure ShowT(MaxIndX, MaxIndT : integer);
var StepX  : extended;
    X      : extended;
    IndT   : integer;
    IndX   : integer;
begin
   GraphP.FullEraseAreaXY;
   SetLength(GArrP, MaxIndX + 1);
   StepX := 2 / MaxIndX;
   for IndT := 1 to MaxIndT
   do begin
      X := -1;
      for IndX := Low(GArrP) to High(GArrP)
      do begin
         GArrP[IndX].X := X;
         GArrP[IndX].Y := CalcT(X, IndT);
         X := X + StepX;
      end;
      if IndT = 1
      then GraphP.ShowGraphXY(GArrP, clBlue)
      else begin
          if  IndT = MaxIndT
          then begin
             GraphP.GraphTitul := '    : '
                                + IntToStr(MaxIndT);
             GraphP.PaintGraphXY(GArrP, RGB(127,0,0));
          end
          else GraphP.PaintGraphXY(GArrP, clBlue);
      end;
   end;
   SetLength(GArrP, 0);
end;
// -----------------------------------------------------------------
// :     
procedure TForm1.Button1Click(Sender: TObject);
var MaxIndX, MaxIndP : integer;
begin
   GraphP.FullEraseAreaXY;
   if not (EditToInt (edMaxIndP, MaxIndP) and
           EditToInt (edMaxIndX, MaxIndX))
   then Exit;
   if MaxIndX < 32
   then begin
       ShowMessage(': .    X >= 32');
       Exit;
   end;
   case CbBoxSelPoly.ItemIndex of
     0 : ShowT(MaxIndX, MaxIndP);  //  
     1 : ShowL(MaxIndX, MaxIndP);  //  
   end;
end;

// =================================================================
//   
// =================================================================
// -----------------------------------------------------------------
//   X  (-1 .. 1) 
//   N  M,  MaxIndX -     X
function Convolution(Series, MaxIndX, N, M, Method : integer;
                  var Conv : extended) : boolean;
const XRange = 2;        //  
      XB     = -1;       //   
      CMT    = 5.7;      //      
var   Arr    : TGraphArr;
      dX, X  : extended;
      Ind    : integer;
begin
   GraphP.FullEraseAreaXY;
   Result := False;
   if (N < 0) or (M < 0) then Exit;
   //   
   SetLength(Arr, MaxIndX + 1);
   dX := 2 / MaxIndX;
   X := -1;
   for Ind := Low(Arr) to High(Arr)
   do begin
       Arr[Ind].X := X;
       case Series of
       0 : Arr[Ind].Y := sin(X * N * Pi) * sin(X * M * Pi);
       1 : Arr[Ind].Y := cos(X * N * Pi) * cos(X * M * Pi);
       2 : begin   //   
             //  
             // Arr[Ind].Y := Polynom(LArrA, N, X) * Polynom(LArrA, M, X);
             //  
             Arr[Ind].Y := CalcL(X, N) * CalcL(X, M);
           end;
       3 : begin  //   
             if not ((Ind = Low(Arr)) or (Ind = High(Arr)))
             then Arr[Ind].Y := CalcT(X, N) * CalcT(X, M) / sqrt(1 - X * X);
           end;
       4 : begin  //   
             Arr[Ind].Y := SignR(Cos(X * N * Pi))* SignR(Cos(X * M * Pi));
             if ((Ind = Low(Arr)) or (Ind = High(Arr))) then Arr[Ind].Y := 0;
           end;
       else Arr[Ind].Y := 0;
       end;
       X := X + dX;
   end;
   if Series = 3
   then begin
      //       
      //        
      Arr[Low(Arr)].Y  :=  CMT * Arr[Low(Arr)+1].Y;
      Arr[High(Arr)].Y :=  CMT * Arr[High(Arr)-1].Y;
   end;
   GraphP.GraphTitul := '   Pn * Pm';
   GraphP.ShowGraphXY(Arr, RGB(0,127,0));
   // 
   case Method of
        0 : Conv := TrapezIntegralIndBE (Arr, Low(Arr), High(Arr), dX);
        1 : Conv := SimpsonIntegralIndBE (Arr, Low(Arr), High(Arr), dX);
        2 : Conv := SMSS_SimpsonIntegralIndBE (Arr, Low(Arr), High(Arr), dX);
      else  Conv := LMMR_SimpsonIntegralIndBE (Arr, Low(Arr), High(Arr), dX);
   end;
   Result := True;
   SetLength(GArrP, 0);
end;


// -----------------------------------------------------------------
//    
procedure TForm1.butConvClick(Sender: TObject);
var MaxIndX, N, M : integer;
    Ort, Conv : extended;
begin
    if not (EditToInt(edIndN, N) and
            EditToInt(edIndM, M) and
            EditToInt(edMaxIndX, MaxIndX))
    then Exit;
    if MaxIndX < 32
    then begin
       ShowMessage(': .    X >= 32');
       Exit;
    end;
    if (M < 0) or (N < 0)
    then begin
        edConv.Text := '';
        stxtConv.Caption := '';
        stxtAbsErrConvL.Caption := '';
        ShowMessage(': (N >= 0)  (M >= 0)');
        Exit;
    end;
    if Convolution(cbBoxSeries.ItemIndex, MaxIndX, N, M,
                   CbBoxMethod.ItemIndex, Conv)
    then begin
        edConv.Text := FloatToStr(Conv);
        if N = M
        then begin
           case cbBoxSeries.ItemIndex of
           0 : begin  // SIN -  
                   stxtConv.Caption := '1';
                   stxtAbsErrConvL.Caption := FloatToStr(Conv-1);
               end;
           1 : begin  // COS -  
                   stxtConv.Caption := '1';
                   stxtAbsErrConvL.Caption := FloatToStr(Conv-1);
               end;
           2 : begin  //  
                   Ort := 0;
                   if (N = M) then Ort := 2 /(2 * N + 1);
                   stxtConv.Caption := FloatToStr(Ort);
                   stxtAbsErrConvL.Caption := FloatToStr(Conv-Ort);
               end;
           3 : begin  //  
                   Ort := 0;
                   if (N = M) and (N = 0)  then Ort := Pi;
                   if (N = M) and (N <> 0) then Ort := Pi / 2;
                   stxtConv.Caption := FloatToStr(Ort);
                   stxtAbsErrConvL.Caption := FloatToStr(Conv-Ort);
               end;
           4 : begin  //  
                   Ort := 0;
                   if (N = M) then Ort := 2;
                   stxtConv.Caption := FloatToStr(Ort);
                   stxtAbsErrConvL.Caption := FloatToStr(Conv-Ort);
               end;
           else begin
                   stxtConv.Caption := '';
                   stxtAbsErrConvL.Caption := '';
                   GraphP.GraphTitul := '';
               end;
           end;
        end
        else begin
           stxtConv.Caption := '0';
           stxtAbsErrConvL.Caption := FloatToStr(Conv);
        end;
    end
    else begin
        edConv.Text := 'ERROR';
        stxtConv.Caption := 'ERROR';
        stxtAbsErrConvL.Caption := '';
    end;
end;

// =================================================================
//      
// =================================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
   GraphP := TGraphXY.Create(PanelT);    // 
end;
// -----------------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  GraphP.Free;    // 
end;

// =================================================================
//    
// =================================================================







end.
