unit Report01;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, Grids, StrUtils;

// ==========================================================
//    PROJECT
// ==========================================================
const
   cDebugErrorReportOn = False;  //     


// ==========================================================
//    PROJECT
// ==========================================================
procedure InitReport01(RqMemo : TMemo; RqInfoPatel : TStatusPanel);
//       
procedure ReportClearAndTitulInit();
//   RqSep  
procedure SeparatotToReport(RqSep : string; RqCount : byte);
//   RqSep     
procedure TimeSeparatotToReport(RqSep : string; RqCount : byte);
//   () 
procedure HeadToReport(RqTxt : string);
//-----------------------------------------------------------
//  ,    
procedure SysErrorToReport(RqMsg : string);
// C   ,   
procedure MajorErrorToReport(RqTxt : string);
// C  ,   
procedure MinorErrorToReport(RqTxt : string);
//  ,   
procedure InfoToReport(RqTxt : string);
//     
procedure TextToReport(RqTxt : string);
//-----------------------------------------------------------
//    ()  ( HeadToReport)
procedure EndCodeReport(RqTxt : string);
//-----------------------------------------------------------
//     TXT
procedure SaveReportAsFileTxt(SDialog : TSaveDialog);
//-----------------------------------------------------------
//    (   )
procedure DebugErrorToReport(RqMsg : string);
// ==========================================================
//                  IMPLEMENTATION BEGIN
// ==========================================================
implementation

const
    cSysDebugFlag = True; //     
    cSeparatotLen = 100;  //    

// ==========================================================
//    UNIT
// ==========================================================
var ReportMemo  : TMemo;
    InfoPatel   : TStatusPanel;

// ==========================================================
//   UNIT
// ==========================================================
procedure InitReport01(RqMemo : TMemo; RqInfoPatel : TStatusPanel);
begin
   ReportMemo := RqMemo;
   InfoPatel  := RqInfoPatel;
   ReportClearAndTitulInit();
end;

// ----------------------------------------------------------
//
//       
procedure ReportClearAndTitulInit();
begin
  ReportMemo.Clear;
  SeparatotToReport('=', cSeparatotLen);
  TextToReport('     ****  ' + DateToStr(Date) + '  **** ');
  SeparatotToReport('=', cSeparatotLen);
end;
// ==========================================================
// ----------------------------------------------------------
//
procedure TimeSeparatotToReport(RqSep : string; RqCount : byte);
var MsgStr : string;
begin
  MsgStr := ' ****  ' + TimeToStr(Time) + ' **** ';
  MsgStr := MsgStr + DupeString(RqSep, RqCount);
  ReportMemo.Lines.Add(MsgStr);
end;
// ----------------------------------------------------------
//   RqSep  
procedure SeparatotToReport(RqSep : string; RqCount : byte);
var MsgStr : string;
begin
  MsgStr := DupeString(RqSep, RqCount) + DupeString(RqSep, 15);
  ReportMemo.Lines.Add(MsgStr);
end;
// ----------------------------------------------------------
//
//   () 
procedure HeadToReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(' ');
  TimeSeparatotToReport('=', cSeparatotLen);
  ReportMemo.Lines.Add(RqTxt);
end;
// ----------------------------------------------------------
//
//    ()  ( HeadToReport)
procedure EndCodeReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(RqTxt);
  TimeSeparatotToReport('=', cSeparatotLen);
  InfoPatel.Text := ' ' + RqTxt;
end;
// ----------------------------------------------------------
//
//     
procedure TextToReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(RqTxt);
end;
// ----------------------------------------------------------
//
// C   ,   
procedure MajorErrorToReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(RqTxt);
end;
// ==========================================================
// ----------------------------------------------------------
//
// C  ,   
procedure MinorErrorToReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(RqTxt);
  InfoPatel.Text := ' ' + RqTxt;
end;
// ----------------------------------------------------------
//
//  ,   
procedure InfoToReport(RqTxt : string);
begin
  ReportMemo.Lines.Add(RqTxt);
  InfoPatel.Text := ' ' + RqTxt;
end;
// ----------------------------------------------------------
//
//  ,    
procedure SysErrorToReport(RqMsg : string);
begin
  ReportMemo.Lines.Add(RqMsg);
  MessageDlg( RqMsg, mtError, [mbOk], 0);
end;
// ----------------------------------------------------------
//
//    (   )
procedure DebugErrorToReport(RqMsg : string);
begin
  if cDebugErrorReportOn
  then begin
    ReportMemo.Lines.Add(RqMsg);
    MessageDlg( RqMsg, mtError, [mbOk], 0);
  end;
end;
// ==========================================================
// ----------------------------------------------------------
//
//     TXT
procedure SaveReportAsFileTxt(SDialog : TSaveDialog);
var FullFileName, ShortFileName : string;
begin
    SDialog.Title := '  ...';
    SDialog.Filter:='Report text files (*.txt)|*.txt';
    if SDialog.Execute
    then begin
      FullFileName := Trim(SDialog.FileName);
      if UpperCase(RightStr(FullFileName,4)) <> '.TXT'
      //    (  )  
      then begin
         FullFileName := FullFileName + '.txt';
      end;
      //    
      ShortFileName:= ExtractFileName(FullFileName);

      if FileExists(FullFileName)
      then begin
        if MessageDlg( ': ' + ShortFileName + #13#10
                      + ' ' + #13#10
                      + '   ?',
                         mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
            //     
            ReportMemo.Lines.SaveToFile(FullFileName);
        end;
      end
      else begin
         //     
         ReportMemo.Lines.SaveToFile(FullFileName);
      end; {of FileExists(SDialog.FileName)}
    end; {of FileExists(SDialog.FileName)}
end; {of procedure}

// ==========================================================
// IMPLEMENTATION END
// ==========================================================
end.
