unit MainData;
interface
uses ComCtrls, ExtCtrls, StdCtrls, Grids, Graphics, SysUtils,
     GraphXYv50, Gauss01;
// ==========================================================
//   ( PROJECT)
// ==========================================================
//-----------------------------------------------------------
//         
type
  TSelectorData = record
   CodeM : word;     //   
   CodeF : word;     //     
   Title : string;   //     
   Func  : string;   //    
end;
//-----------------------------------------------------------
//       
//  .
type
 TFourierKoeff = record
   AKoeff  : extended;  //  
   BKoeff  : extended;  //  B
   CKoeff  : extended;  //  C ( )
   PKoeff  : extended;  //  P ( )
end;
//-----------------------------------------------------------
//      
//  .
type
  TAproxSatistic = record
    MaxAbsError   : extended;  //    
    MinAbsError   : extended;  //    
    AbsFuncArea   : extended;  //     
    AbsAproxArea  : extended;  //     
    AbsErrorArea  : extended;  //     
    RelativeError : extended;  //   AbsErrorArea / AbsFuncArea
end;

// ==========================================================
//   ( PROJECT)
// ==========================================================
const cAppVersion   = ' v.2.08. 2014.';
const cTitulSScript = ' Freeware.'
                   + ' .'
                   + cAppVersion
                   + '  : ';

const
   cTabFuncMinPCount = 3;     //     
                              // (  -   )
// ==========================================================
//   
const
   cmLSquares        = 1;     //    
   cmFourier         = 2;     //   
//-----------------------------------------------------------
//     
const
   //   
   cfPolinomX        = 1;     //     
   cfPolinom1DX      = 2;     //     1/
   cfPolinomExpX     = 3;     //     EXP()
   cfPolinomLnX      = 4;     //     Ln()
   //   
   cfFourierAB       = 101;   //     . A,B

// ==========================================================
//           
//        
//   :
//  --------------
//  :
//  1. MainData.cfPolinom{XXXXXX} (),  
//            
//  2. AprroxCentr01.TestPolinom{XXXXXX}   
//         .
//  --------------
//  :
//  1. MainData.ApproxSelectorList ()   
//           .
//  2. LeastSquares01.ReFuncArgument   
//         .
//  3. AprroxCentr01.VerifyAndRunLSquaresMethod   
//         .
// ==========================================================
//       
//    Code
const
   ApproxSelectorList : array[0..4] of TSelectorData =
   (
       // ----- 0
      (CodeM : cmLSquares;
       CodeF : cfPolinomX;
       Title : '       ';
       Func  : ' Un = An * ( X ^ n )' ),
       // ----- 1
      (CodeM : cmLSquares;
       CodeF : cfPolinom1DX;
       Title : '       (1 /  )';
       Func  : ' Un = An * (( 1 / X ) ^ n )' ),
       // ----- 2
      (CodeM : cmLSquares;
       CodeF : cfPolinomExpX;
       Title : '       Exp (  )';
       Func  : ' Un = An * Exp ( n * X )' ),
       // ----- 3
      (CodeM : cmLSquares;
       CodeF : cfPolinomLnX;
       Title : '       Ln (  )';
       Func  : ' Un = An * ( Ln ( X ) ^ n )' ),
       // ----- 4
      (CodeM : cmFourier;
       CodeF : cfFourierAB;
       Title: '     Sin  Cos '
                   + '  Period = X  - X .';
       Func : ' Un =  An * Sin ( n * ( 2 * Pi / Period ) * X ) + '
                   + 'Bn * Cos ( n * ( 2 * Pi / Period ) * X )' )
   );

// ==========================================================

//    
const cLSquaresMaxRqExp = Gauss01SupMaxRow - 1;
//-----------------------------------------------------------
//      
const  cMaxDetalGraph = 300;

// ==========================================================
//   ( PROJECT)
// ==========================================================
// ==========================================================
//     
// ==========================================================
//-----------------------------------------------------------
//    TableFuncionArray
var  TableFuncionFileName : string;
//   -      
var FlagNeedXSortTabFunc : boolean;

// ----------------------------------------------------------
//     
// TPointXY   UNIT: GraphXYv1
var TableFuncionArray    : TGraphArr;
var TableFuncionColor    : TColor;

// ==========================================================
//   
// ==========================================================
//  ComoBox -     
var RqApproximationVariant : integer;
//     
//  LastExecuteMethod   LastExecuteSeries
var LastExecuteMethod : integer; //   (-1)
    LastExecuteSeries : integer; //   (-1)

// ==========================================================
//       
var LSquaresKoeff   : array of extended;

//        
var FourierPeriod   : extended;
var FourierKoeff    : array of TFourierKoeff;

// ==========================================================
//   ,   
//  
var AproximationFuncTAB : TGraphArr;
var AproximationColor   : TColor;

// ==========================================================
//   ,    
//        
//   .
var AbsErrorFuncTAB : TGraphArr;
//      .
var AproxSatistic   : TAproxSatistic;

// ==========================================================
//     
var SpectrLineTab    : array of extended;
// ==========================================================
//       
var BasisSelectList : array of boolean;
var BasisColor      : TColor;

// ==========================================================
//    PROJECT
// ==========================================================
//     
//     
procedure InitMainData(RqCBoxAproxSelect : TComboBox;
                       RqGridEditor      : TStringGrid;
                       RqGridAproxKoeff  : TStringGrid;
                       RqSTxtTermSeries  : TStaticText;
                       RqLViewBasis      : TListView);
// ----------------------------------------------------------
//       
function TextToExtended (Text : string; var Digit : extended): boolean;
// ----------------------------------------------------------
//  SGridEditor    TableFuncionArray
procedure CleanTabFuncEditor();
// ----------------------------------------------------------
//  BasisViewList    BasisSelectList
procedure CleanBasisViewList();
// ----------------------------------------------------------
//    
// (        Grids)
procedure CleanAproximationResult();

// ==========================================================
// ==========================================================
//
//   
//
// ==========================================================
// ==========================================================
implementation

// ==========================================================
//   ( UNIT)
// ==========================================================

// ==========================================================
//   UNIT
// ==========================================================
 var
     CtrlCBoxAproxSelect : TComboBox;
     CtrlGridEditor      : TStringGrid;
     CtrlGridAproxKoeff  : TStringGrid;
     CtrlSTxtTermSeries  : TStaticText;
     CtrlLViewBasis      : TListView;

// ==========================================================
//    
// ==========================================================
//     
procedure InitMainData(RqCBoxAproxSelect : TComboBox;
                       RqGridEditor      : TStringGrid;
                       RqGridAproxKoeff  : TStringGrid;
                       RqSTxtTermSeries  : TStaticText;
                       RqLViewBasis      : TListView);

var Ind : word;
begin
     CtrlCBoxAproxSelect := RqCBoxAproxSelect;
     CtrlGridEditor      := RqGridEditor;
     CtrlGridAproxKoeff  := RqGridAproxKoeff;
     CtrlSTxtTermSeries  := RqSTxtTermSeries;
     CtrlLViewBasis      := RqLViewBasis;
     // --------------------------------------
     //   
     CtrlCBoxAproxSelect.Clear;
     for Ind := Low(ApproxSelectorList) to High(ApproxSelectorList) do
     begin
       CtrlCBoxAproxSelect.Items.Add(ApproxSelectorList[Ind].Title);
     end;
     CtrlCBoxAproxSelect.ItemIndex:=0;
end;

//-----------------------------------------------------------
// 02.10.2014
//       
function TextToExtended (Text : string; var Digit : extended): boolean;
var WStr : string;
    WExt : extended;
    Ind  : integer;
begin
  Result := False;
  WStr := Trim(Text);
  //  
  try
    WExt := StrToFloat(WStr);
    Digit := WExt;
    Result := True;
  except end;
  //     
  if not Result
  then begin
     for Ind := 1 to Length(WStr)
     do if WStr[Ind] = ',' then WStr[Ind] := '.';
     try
       WExt := StrToFloat(WStr);
       Digit := WExt;
       Result := True;
     except end;
  end;
  //     
  if not Result
  then begin
     for Ind := 1 to Length(WStr)
     do if WStr[Ind] = '.' then WStr[Ind] := ',';
     try
       WExt := StrToFloat(WStr);
       Digit := WExt;
       Result := True;
     except end;
  end;
end; {of function}

//-----------------------------------------------------------
//  SGridEditor    TableFuncionArray
procedure CleanTabFuncEditor();
var WCol : integer;
begin
   if CtrlGridEditor <> nil
   then begin
      with CtrlGridEditor do
      begin
        RowCount := FixedRows + 1;
        for WCol :=  FixedCols to ColCount do
        begin
           Cells[WCol,FixedRows]:= ' ';
        end;
      end;
      SetLength(TableFuncionArray, 0);
   end;
end;
//-----------------------------------------------------------
//  BasisViewList    BasisSelectList
procedure CleanBasisViewList();
begin
   if CtrlLViewBasis <> nil
   then begin
     CtrlLViewBasis.Clear;
     SetLength(BasisSelectList,0);
   end;
end;
//-----------------------------------------------------------
//    
// (        Grids)
procedure CleanAproximationResult();
var WCol : integer;
begin
   if CtrlGridEditor <> nil
   then begin
      //   Grid 
      with CtrlGridAproxKoeff do
      begin
        RowCount := FixedRows + 1;
        for WCol :=  FixedCols to ColCount do
        begin
           Cells[WCol,FixedRows]:= ' ';
        end;
      end;
      //       
      CtrlSTxtTermSeries.Caption := ' ';
      //    
      SetLength(LSquaresKoeff, 0);
      SetLength(FourierKoeff, 0);
      //     
      SetLength(AproximationFuncTAB, 0);
      SetLength(AbsErrorFuncTAB, 0);
      //  BasisViewList    BasisSelectList
      CleanBasisViewList();
      //  -    ;
      LastExecuteMethod := -1;  //   (-1)
      LastExecuteSeries := -1;  //   (-1)
   end;
end;
// ==========================================================
//                  IMPLEMENTATION END
// ==========================================================
end.
