unit ImportDialog01;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, ExtCtrls, Dialogs, StrUtils,
     MainData, Report01, GridEditor01;

// ==========================================================
//   ( PROJECT)
// ==========================================================
type
  TOKBottomDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    RadioGroup1: TRadioGroup;
    EditSep: TEdit;
    Label1: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    //  UNIT ImportDialog01
    procedure InitImportDialog01(RqOpenDialog : TOpenDialog);
  end;

// ==========================================================
//    PROJECT
// ==========================================================
var
  OKBottomDlg: TOKBottomDlg;   //    

// ==========================================================
implementation
{$R *.dfm}
// ==========================================================
//           
// ==========================================================

var  CtrlOpenDialog : TOpenDialog; //   OpenDialog

//-----------------------------------------------------------
// 26.09.2008
//  UNIT ImportDialog01
procedure TOKBottomDlg.InitImportDialog01(RqOpenDialog : TOpenDialog);
begin
  CtrlOpenDialog := RqOpenDialog;
end; // of procedure


//-----------------------------------------------------------
// 26.09.2008
function GetImportFileName(ODialog : TOpenDialog) : string;
begin
  GetImportFileName := '';
  ODialog.Filter:='Import Table Definition Function files (*.txt)|*.txt';
  if ODialog.Execute
  then begin
     GetImportFileName := ODialog.FileName;
  end;
end; // of function
//-----------------------------------------------------------
// 26.09.2008
//     TableFuncionArray
procedure CleanTableFuncionArray();
var Ind : word;
begin
  for Ind := Low(TableFuncionArray) to High(TableFuncionArray) do
  begin
    TableFuncionArray[Ind].X := 0;
    TableFuncionArray[Ind].Y := 0;
  end;
end; {of procedure}
//-----------------------------------------------------------
// 26.09.2008
//      X     
function XTextToTableFuncionArray (Ind : word; XText : string): boolean;
var WD     : extended;
    MsgStr : string;
begin
  XTextToTableFuncionArray := False;
  if TextToextended(XText, WD)
  then begin
     TableFuncionArray[Ind].X:=WD;
     XTextToTableFuncionArray := True;
  end
  else begin
    TableFuncionArray[Ind].X:=0;
    MsgStr := ':  ['+ XText +']   .'
            + ' :   ' + IntToStr(Ind)
            + '   X  .';
    MinorErrorToReport(MsgStr);
  end;
end;  // of function
//-----------------------------------------------------------
// 26.09.2008
//      Y     
function YTextToTableFuncionArray (Ind : word; YText : string): boolean;
var WD     : extended;
    MsgStr : string;
begin
  YTextToTableFuncionArray := False;
  if TextToextended(YText, WD)
  then begin
      TableFuncionArray[Ind].Y:=WD;
      YTextToTableFuncionArray := True;
  end
  else begin
    TableFuncionArray[Ind].Y:=0;
    MsgStr := ':  ['+ YText +']   .'
            + ' :   ' + IntToStr(Ind)
            + '   Y  .';
    MinorErrorToReport(MsgStr);
  end;
end; // of function
//-----------------------------------------------------------
// 17.10.2008
//     X  Y      TableFuncionArray
function XYtoTableFuncionArray (Ind : word; RqStrXY : string) : boolean;
var WStrXY, WStrX, WStrY, WSep  : string;
    WInd, SepPos : integer;
    TabStrXY : array [0..1] of string;
    OkX, OkY : boolean;
begin
  WStrXY := Trim(RqStrXY);
  OkX := False;
  OkY := False;
  //   ,  X  Y
  case OKBottomDlg.RadioGroup1.ItemIndex of
  1 : WSep := #09;  // 
  2 : WSep := ';';
  3 : begin
        WSep := OKBottomDlg.EditSep.Text;
        WSep := LeftStr(Trim(WSep),1);
      end;
  else WSep := ' ';
  end; // of case

  for WInd := Low(TabStrXY) to High(TabStrXY) do
  begin
    if Length(WStrXY) > 0
    then begin
      TabStrXY[WInd] := '';
      //   
      // (Pos = 0      = 1
      //        )
      SepPos := Pos(WSep, WStrXY);
      if SepPos <> 0
      then begin
        //   
        TabStrXY[WInd] := copy(WStrXY, 0, SepPos-1);
        Delete(WStrXY, 1, SepPos);
      end
      else begin
        TabStrXY[WInd] := WStrXY;
        WStrXY := '';
      end;
    end; // of Length(WStrXY) > 0
  end;
  WStrX :=  Trim(TabStrXY[Low(TabStrXY)]);
  WStrY :=  Trim(TabStrXY[Low(TabStrXY)+1]);
  if (Length(WStrX) > 0) and  (Length(WStrY) > 0)
  then begin
    //     
    OkX := XTextToTableFuncionArray (Ind, WStrX);
    OkY := YTextToTableFuncionArray (Ind, WStrY);
  end;
  //   
  Result := (OkX and OkY);
end; // of function

//-----------------------------------------------------------
//
//    TableFuncionArray
//     *.TXT
procedure ImportDataFromTxtFile(RqFullFileName : string);
var
  PackCode          : integer;  //   X  Y  
  PFlag             : boolean;  //  -  
  MaxDataRow        : word;     //     TableFuncionArray
  FInd, AInd        : word;     //   , TableFuncionArray
  SkipCount         : word;     //     
  BufTxt            : string;   //     TXT to extended
  MsgStr            : string;   //     
var
  //   
  TempList : TStringList;

begin
  //    
  MsgStr := ' : ' + RqFullFileName;
  HeadToReport(MsgStr);
  //     
  //-------------
  PFlag := True;
  SkipCount := 0;
  //-------------
  //   ()
  TempList := TStringList.Create;	{     }
  try
    TempList.Delimiter := #0;
    TempList.QuoteChar := #0;
    TempList.CommaText := '';
    TempList.LoadFromFile(RqFullFileName);
    //    
    case OKBottomDlg.RadioGroup1.ItemIndex of
         0 : begin // ( )
               PackCode := 1; //     
               //     TempList
               MaxDataRow  := (TempList.Count) div 2;
             end;
         else begin  // (   )
             PackCode := 2; //     
             //     TempList
             MaxDataRow  := TempList.Count;
         end;
    end;
    if MaxDataRow >= cTabFuncMinPCount   //    
    then begin
         //    TableFuncionArray
         SetLength(TableFuncionArray, MaxDataRow);
         //      
         CleanTableFuncionArray();
         //       Xi, Yi
         FInd  := 0; // .   TempList
         AInd  := Low(TableFuncionArray); // .   TableFuncionArray
         repeat
            //   
            //   X
            BufTxt := TempList.Strings[FInd];
            case PackCode of
            1 : begin
                //     X
                if not XTextToTableFuncionArray(AInd, BufTxt)
                then SkipCount := SkipCount + 1;
                //   TempList    Y
                FInd := FInd + 1;
                //       Y
                BufTxt := TempList.Strings[FInd];
                if not YTextToTableFuncionArray(AInd, BufTxt)
                then SkipCount := SkipCount + 1;
            end;
            2 : begin
                //     X  Y
                //      TableFuncionArray
                if not XYtoTableFuncionArray (AInd, BufTxt)
                then SkipCount := SkipCount + 1;
            end;
            end; // of case PackCode
            // ----------------------------------------
            //       Xi, Yi
            FInd := FInd + 1;
            AInd := AInd + 1;
         until FInd >= TempList.Count;
         if SkipCount = 0 then PFlag := False;
    end; // 0f if MaxDataRow
  // ----------------------------------------
  //      }
  finally
    TempList.Free;
    //   ()
  end;
  // ----------------------------------------
  //    
  if (not PFlag)
  then begin
     EndCodeReport('   ');
  end
  else begin
    //   
    MajorErrorToReport('     '
                     + '      = '
                     + IntToStr(SkipCount));
    EndCodeReport('     ');
  end; {of not PFlag}
end; {of procedure}

//-----------------------------------------------------------
//
//
procedure ImportTableFunctionFomFile(RqOpenDialog : TOpenDialog);
var FullFileName : string;
begin
  FullFileName := GetImportFileName(RqOpenDialog);
  if FullFileName <> ''
  then begin
      ImportDataFromTxtFile(FullFileName);
  end;
end; // of procedure

//===========================================================
//-----------------------------------------------------------
//
procedure TOKBottomDlg.CancelBtnClick(Sender: TObject);
begin
  //     
  OKBottomDlg.Close;
end;

procedure TOKBottomDlg.OKBtnClick(Sender: TObject);
begin
  //     
  MakeNewTableFuncion('    ');
  //  
  ImportTableFunctionFomFile(CtrlOpenDialog);
  //    SGridEditor    TableFuncionArray
  RefrechSGridFromTFA();
  //     
  OKBottomDlg.Close;
end;

end.
