unit GridEditor01;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, Grids, StrUtils,
  MainData, GraphXYv50, Report01, ShowGraph01;
// ==========================================================
//    INTERFACE
// ==========================================================
Const
   //   GrigEditor
   GridEdColCount   = 3;  {   Grid-                  }
   GridEdRowCount   = 2;  {   Grid-               }
   GridEdColN       = 0;  { Grid-              }
   GridEdColX       = 1;  { Grid-   X          }
   GridEdColY       = 2;  { Grid-  .  Y       }
   //   GrigEditor
   GridEdRowX0      = 1;  { Grid-    X }
   //   GrigEditor
   GridEditor01Title : array [0..GridEdColCount-1] of string =
   (' ',' X ',' Y ');

// ==========================================================
//    INTERFACE
// ==========================================================
//  UNIT  GridEditor01
procedure InitGridEditor01(RqCEmProjectForm : TForm;
                           RqCEmProjectDesc : TEdit;
                           RqCEmGridEditor  : TStringGrid;
                           RqCEmNeedSort    : TStaticText);
//    .
procedure MakeNewTableFuncion(RqCaption : string);
//     
procedure LoadTableFunctionFomFile(ODialog : TOpenDialog; SG : TStringGrid);
//      
procedure SaveAsTableFunctionToFile(SDialog : TSaveDialog);
//   
procedure ReSaveTableFunctionToFile();
// /     
procedure InsernDeleteOnePointTF (RqOp1, RqOp2 : char; RqInd : integer);
//    SGridEditor    TableFuncionArray
procedure RefrechSGridFromTFA();
//--------------------------------------------------------
//     
procedure XSortTableFuncionArray();
//-----------------------------------------------------------
//   OnSetEditText   TStringGrid
//   Grid    
procedure StringEditCell(Sender: TObject;
          ACol, ARow: Integer; const Value: String);

// ==========================================================
//    INTERFACE
// ==========================================================

// ==========================================================
//                   IMPLEMENTATION BEGIN
// ==========================================================
implementation
// ==========================================================
//    UNIT
// ==========================================================
Const
   //        (Xn, Yn)  
   cMinNumbPoints   = cTabFuncMinPCount;
Const
   //  =================================================================
   //   ()   *.TF1
   //  =================================================================
   HeadNumbStr     = 2;             {          }
   HeadNameStr0    = 'PROGRAMM';    {     }
   VersionID       = 'APPROX02';    {    }
   HeadNameStr1    = 'PROJECT';     {         }
   MyNameSeparator = '=';           {          }
   //        *.TF1
   HeadStr0        = HeadNameStr0 + MyNameSeparator + VersionID;
   //      *.TF1
   MinNumbStrTF1 = HeadNumbStr + (2 * cMinNumbPoints);
   //  =================================================================
   //     *.TF1
   //  =================================================================
   //  PROGRAMM=APPROX02             (  HEAD)
   //  PROJECT=   (  HEAD)
   //  ......................
   //  X0=  X
   //  Y0=  Y
   //  ......................
   //  Xn=  X
   //  Yn=  Y
   //  =================================================================


// ==========================================================
//    UNIT
// ==========================================================
//    
//    InitGridEditor01
var
   CEmProjectForm     : TForm;
   CEmProjectDesc     : TEdit;
   CEmGridEditor      : TStringGrid;
   CEmNeedSort        : TStaticText;
var
   TempTableFuncionFileName : string;  {     }
   TempList : TStrings;	          {    (  unit Classes)}
var
   FlagEditXValue  : boolean; { :     X  }
   FlagEditYValue  : boolean; { :     Y  }
// ==========================================================
//
//   UNIT
//
// ==========================================================
// ==========================================================
//  
// ==========================================================
//-----------------------------------------------------------
//  2.03
// 09.12.2009
//       
procedure SetInfoCurrentFileName();
begin
   if TableFuncionFileName <> ''
   then begin
      CEmProjectForm.Caption := cTitulSScript
                             +  ExtractFileName(TableFuncionFileName);
   end
   else begin
      CEmProjectForm.Caption := cTitulSScript + ' NoName';
   end;
end; {of procedure}
//-----------------------------------------------------------
// 10.10.2008
//        - FlagNeedXSortTabFunc
procedure SetNeedSortIndicator1(RqOp : char);
begin
  case UpCase(RqOp) of
  'U' : begin
          //  :  
          FlagNeedXSortTabFunc:= True;
          CEmNeedSort.Color := clYellow;
        end;
  'D' : begin
          FlagNeedXSortTabFunc := False;
          CEmNeedSort.Color := clBtnFace;
        end;
  end;
end; {of procedure}
//-----------------------------------------------------------
// 10.10.2008
//      : FlagNeedXSortTabFunc
procedure VerifyAndSetNeedSortFlag();
var Ind   : word;
    WFlag : boolean;
begin
  WFlag := False;
  for Ind := Low(TableFuncionArray) to High(TableFuncionArray) do
  begin
     if Ind > Low(TableFuncionArray)
     then begin
        if TableFuncionArray[Ind].X < TableFuncionArray[Ind-1].X
        then begin
           WFlag := True;
           Break;
        end;
     end;
  end;
  //   : FlagNeedXSortTabFunc
  if WFlag
  then SetNeedSortIndicator1('U')
  else SetNeedSortIndicator1('D');
end; // of procedure

//-----------------------------------------------------------
// 26.09.2008
//     TableFuncionArray
procedure CleanTableFuncionArray();
var Ind : word;
begin
  for Ind := Low(TableFuncionArray) to High(TableFuncionArray) do
  begin
    TableFuncionArray[Ind].X := 0;
    TableFuncionArray[Ind].Y := 0;
  end;
end; {of procedure}
//-----------------------------------------------------------
// 26.09.2008
//     StringGrid
procedure CleanStringGrid(SG : TStringGrid);
var IRow, ICol : word;
begin
  for IRow := 1 to (SG.RowCount -1) do
  for ICol := 1 to (SG.ColCount -1) do
  SG.Cells[ICol, IRow] := '';
end; {of procedure}
//-----------------------------------------------------------
// 26.09.2008
procedure GetFileName(ODialog : TOpenDialog);
begin
  TempTableFuncionFileName := ''; {   unit}
  ODialog.Filter:='Table Definition Function files (*.tf1)|*.tf1';
  if ODialog.Execute
  then begin
     TempTableFuncionFileName := ODialog.FileName;
  end;
end; {of procedure}

// ==========================================================
//         GridEditor
// ==========================================================
//-----------------------------------------------------------
// 26.09.2008
//      X     
function XTextToTableFuncionArray (IndTF : word; XText : string): boolean;
var WD     : extended;
    MsgStr : string;
begin
  XTextToTableFuncionArray := False;
  if TextToExtended(XText, WD)
  then begin
     TableFuncionArray[IndTF].X:=WD;
     XTextToTableFuncionArray := True;
  end
  else begin
    TableFuncionArray[IndTF].X:=0;
    MsgStr := ':  ['+ XText +']   .'
               + ' :   ' + IntToStr(IndTF)
               + '   X  .';
    MinorErrorToReport(MsgStr);
  end;
end; {of function}
//-----------------------------------------------------------
// 26.09.2008
//      Y     
function YTextToTableFuncionArray (IndTF : word; YText : string): boolean;
var WD     : extended;
    MsgStr : string;
begin
  YTextToTableFuncionArray := False;
  if TextToExtended(YText, WD)
  then begin
      TableFuncionArray[IndTF].Y:=WD;
      YTextToTableFuncionArray := True;
  end
  else begin
    TableFuncionArray[IndTF].Y:=0;
    MsgStr := ':  ['+ YText +']   .'
               + ' :   ' + IntToStr(IndTF)
               + '   Y  .';
    MinorErrorToReport(MsgStr);
  end;
end; {of function}
//-----------------------------------------------------------
// 26.09.2008
//     *.TF1
function VerifyFormatTF1() : boolean;
var MsgStr : string;
begin
  VerifyFormatTF1 := False;
  if TempList <> nil
  then begin
    TempList.NameValueSeparator := '=';
    if TempList.Count >= MinNumbStrTF1
    then begin
      if (TempList.Strings[0] = HeadStr0) and
         (TempList.Names[1]   = HeadNameStr1)
      then begin
        //  ,   
        //      
        VerifyFormatTF1 := True;
      end
      else begin
        MsgStr := ':  ( )  '
               + HeadNameStr0 + ',' + HeadNameStr1
               + '   . :   .';
        MajorErrorToReport(MsgStr);
      end;
    end
    else begin
       MsgStr := ':      .'
               + ' :   .';
       MajorErrorToReport(MsgStr);
    end;
  end;
end; {of function}
//-----------------------------------------------------------
// 26.09.2008
//   X, Y    *.TF1
function VerifyXYFormatTF1(LRow, ARow, SkipCount : word) : boolean;
var X, Y, MsgStr : string;
    Flag : boolean;
begin
  Flag := False;
  VerifyXYFormatTF1 := Flag;
  try
     X := TempList.Names[LRow];
     Y := TempList.Names[LRow+1];
     if (LeftStr(Trim(X),1) = 'X') and (LeftStr(Trim(Y),1) = 'Y')
     then begin
       Flag := True;
       VerifyXYFormatTF1 := Flag;
     end;
  except
    MsgStr := 'SYSTEM: GridEditor01.VerifyXYFormatTF1:  ';
    DebugErrorToReport(MsgStr);
  end;
  if not Flag
  then begin
    if SkipCount = 0
    then begin
        MsgStr := ':    [' + IntToStr(ARow) + ']'
               + '   '
               + 'X' + IntToStr(ARow) + '  Y' + IntToStr(ARow)
               + '.     '
               + X + '  ' + Y + '.'
               + ' :    ' + IntToStr(LRow)
               + ' .';
    end
    else begin
        MsgStr := ':       .'
               + ' :    ' + IntToStr(LRow)
               + ' .';
    end;
    MajorErrorToReport(MsgStr);
  end;
end; {of function}

// ==========================================================
//   /   
// ==========================================================
//-----------------------------------------------------------
// 26.09.2008 (Local)
//    TableFuncionArray    *.TF1
procedure LoadSaveDataFromFile(SG : TStringGrid);
var
  PFlag             : boolean;  {  -              }
  MaxDataRow        : word;     {     TableFuncionArray             }
  LRow, ARow, GRow  : word;     {   , TableFuncionArray, GridEditor  }
  SkipCount         : word;     {            }
  EDatCount         : word;     {    TXT to extended      }
  BufTxt            : string;   {     TXT to extended  }
  MsgStr            : string;   {             }
begin
  //    
  MsgStr := ' : ' + TempTableFuncionFileName;
  HeadToReport(MsgStr);
  //   
  PFlag := False;
  SkipCount := 0;
  EDatCount := 0;
  //   ()
  try
    TempList := TStringList.Create;	{     }
    TempList.LoadFromFile(TempTableFuncionFileName);
    if VerifyFormatTF1()
    then begin
      //    
      if TempList.Count >= MinNumbStrTF1
      then begin
         //     TempList
         MaxDataRow  := (TempList.Count - HeadNumbStr) div 2;
         //    TableFuncionArray  GridEditor
         SetLength(TableFuncionArray, MaxDataRow);
         SG.RowCount := MaxDataRow + 1;
         //      
         CleanTableFuncionArray();
         CleanStringGrid(SG);
         //    
         CEmProjectDesc.Text := TempList.ValueFromIndex[1];

         //       Xi, Yi
         LRow  := HeadNumbStr;  {     TempList}
         GRow  := 1;            {    GridEditor     }
         ARow  := 0;            {     TableFuncionArray }
         repeat
             //   
             if VerifyXYFormatTF1(LRow, ARow, SkipCount)
             //   X,Y     LRow
             then begin
               // ----------------------------------------
               //      GridEditor
               SG.Cells[GridEdColN,GRow] := IntToStr(ARow);
               // ----------------------------------------
               //       X
               BufTxt := TempList.ValueFromIndex[LRow];
               if XTextToTableFuncionArray(ARow, BufTxt)
               then begin
                  //   X  GridEditor
                  SG.Cells[GridEdColX,GRow] := BufTxt;
               end
               else begin
                  PFlag := True; {   }
                  //   X  GridEditor
                  SG.Cells[GridEdColX,GRow] := 'ERR[' + BufTxt + ']';
                  EDatCount := EDatCount + 1;
                  PFlag := True; {   }
               end;
               // ----------------------------------------
               //   TempList    Y
               LRow := LRow + 1;
               // ----------------------------------------
               //       Y
               BufTxt := TempList.ValueFromIndex[LRow];
               if YTextToTableFuncionArray(ARow, BufTxt)
               then begin
                  //   Y  GridEditor
                  SG.Cells[GridEdColY,GRow] := BufTxt;
               end
               else begin
                  PFlag := True; {   }
                  //   Y  GridEditor
                  SG.Cells[GridEdColY,GRow] := 'ERR[' + BufTxt + ']';
                  EDatCount := EDatCount + 1;
               end;
               // ----------------------------------------
               //       Xi, Yi
               LRow := LRow + 1;
               GRow := GRow + 1;
               ARow := ARow + 1;
             end
             else begin
                PFlag := True; {   }
                //       X,Y.
                //   X,Y  , 
                //   TempList   
                LRow := LRow + 1;
                SkipCount := SkipCount + 1;
             end;
         until LRow + 1 >= TempList.Count;
      end
      else begin
          PFlag := True; {   }
      end; {of TempList.Count >= MinNumbStrTF1 }
    end
    else begin
         PFlag := True; {   }
    end; {of VerifyFormatTF1()}
   // ----------------------------------------
   //      }
   finally  TempList.Free;
  //   ()
  end;
  // ----------------------------------------
  // ----------------------------------------
  //    
  if not PFlag
  then begin
     //      : FlagNeedXSortTabFunc
     VerifyAndSetNeedSortFlag();
     //  
     //       
     TableFuncionFileName := TempTableFuncionFileName;
     SetInfoCurrentFileName();
     //    
     CleanAproximationResult();
     EndCodeReport('   ');
  end
  else begin
    //   
    if (SkipCount = 0) and (EDatCount = 0)
    then begin
       EndCodeReport('  .   ');
    end
    else begin
       // ,     
       // ----------------------------------------
       //      
       if SkipCount > 0
       then begin
          MsgStr :='    (X,Y). '
                 + ' :      = '
                 + IntToStr(SkipCount);
          MajorErrorToReport(MsgStr);
       end;
       // ----------------------------------------
       //     TXT to extended
       if EDatCount > 0
       then begin
          MsgStr :='     X  Y. '
                 + '    = '
                 + IntToStr(EDatCount);
          MajorErrorToReport(MsgStr);
       end;
       //      : FlagNeedXSortTabFunc
       VerifyAndSetNeedSortFlag();
       //       
       TableFuncionFileName := TempTableFuncionFileName;
       SetInfoCurrentFileName();
       //    
       CleanAproximationResult();
       EndCodeReport('     ');
    end; {of (SkipCount = 0) and (EDatCount = 0)}
  end; {of not PFlag}
end; {of procedure}

//-----------------------------------------------------------
// 10.10.2008 (Local)
//    TableFuncionArray    *.TF1
procedure SaveDataToFile(RqSaveFileName : string);
var
  IndTF             : word;     {   TableFuncionArray  }
  WStr              : string;   {            }
begin
  //    
  WStr := ' : ' + RqSaveFileName;
  HeadToReport(WStr);
  if (Length(TableFuncionArray) >= cMinNumbPoints)
  //  .     
  then begin
     //   ()
     try
       TempList := TStringList.Create;	{     }
       // ----------------------------------------
       //  
       TempList.Add(HeadNameStr0 + MyNameSeparator + VersionID);
       TempList.Add(HeadNameStr1 + MyNameSeparator + CEmProjectDesc.Text);
       // ----------------------------------------
       for IndTF:=Low(TableFuncionArray) to High(TableFuncionArray) do
       begin
          WStr := 'X'+ IntToStr(IndTF) + MyNameSeparator
                +  FloatToStr(TableFuncionArray[IndTF].X);
          TempList.Add(WStr);
          WStr := 'Y'+ IntToStr(IndTF) + MyNameSeparator
                +  FloatToStr(TableFuncionArray[IndTF].Y);
          TempList.Add(WStr);
       end;{of for}
       //     
       TempList.SaveToFile(RqSaveFileName);
       TableFuncionFileName := RqSaveFileName;
       //       
       SetInfoCurrentFileName();
       EndCodeReport('   ');
       // ----------------------------------------
     finally
       //      }
       TempList.Free;
       //   ()
     end;
  end
  else begin
    MajorErrorToReport(':      .'
                     + ':   .');
    EndCodeReport('     ');
  end;
end; {of procedure}

// ==========================================================
//  (),   
// ==========================================================
//-----------------------------------------------------------
// 30.09.2008
//       
procedure LoadTableFunctionFomFile(ODialog : TOpenDialog; SG : TStringGrid);
begin
  GetFileName(ODialog);
  if TempTableFuncionFileName <> '' {   UNIT}
  then begin
      LoadSaveDataFromFile(SG);
      //      
      ALLGraphClean();
  end;
end; {of procedure}

//-----------------------------------------------------------
// 30.09.2008
//    ... (  )
procedure SaveAsTableFunctionToFile(SDialog : TSaveDialog);
var FullFileName, ShortFileName : string;
begin
    SDialog.Title := '  ...';
    SDialog.Filter:='Table-Definition Function files (*.tf1)|*.tf1';
    if SDialog.Execute
    then begin
      FullFileName := Trim(SDialog.FileName);
      if UpperCase(RightStr(FullFileName,4)) <> '.TF1'
      //    (  )  
      then begin
         FullFileName := FullFileName + '.tf1';
      end;
      //    
      ShortFileName:= ExtractFileName(FullFileName);

      if FileExists(FullFileName)
      then begin
        if MessageDlg( ': ' + ShortFileName + #13#10
                      + ' ' + #13#10
                      + '   ?',
                         mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
            //     
            SaveDataToFile(FullFileName);
        end;
      end
      else begin
         //     
         SaveDataToFile(FullFileName);
      end; {of FileExists(SDialog.FileName)}
    end; {of FileExists(SDialog.FileName)}

end; {of procedure}

//-----------------------------------------------------------
// 30.09.2008
//     
procedure ReSaveTableFunctionToFile();
begin
    if FileExists(TableFuncionFileName)
    then begin
      //     
      SaveDataToFile(TableFuncionFileName);
    end
    else begin
      HeadToReport(' : ' + TableFuncionFileName);
      EndCodeReport('     !'
                  + '    .');
    end;
end; {of procedure}

// ==========================================================
//   
// ==========================================================
//--------------------------------------------------------
// 28.08.2008  (Global)
//   OnSetEditText   TStringGrid
//   Grid  
procedure StringEditCell(Sender: TObject;
          ACol, ARow: Integer; const Value: String);
var TFRow    : integer;
    WD       : extended;
begin
  if (ACol = GridEdColX) or (ACol = GridEdColY)
  //  ACol    TableFuncionArray
  then begin
    //      TableFuncionArray
    TFRow := ARow - GridEdRowX0;
    if (TFRow >= Low(TableFuncionArray)) and (TFRow <= High(TableFuncionArray))
    //   TFRow    TableFuncionArray
    then begin
       //---------------------------------
       //    Grid
       if Sender is TStringGrid
       then begin
         with TStringGrid(Sender) do
         begin
           //---------------------------------
           if Value <> '-'
           //     
           then begin
             if Value <> ''
             //   
             then begin
                 //     
                 if TextToextended (Value, WD)
                 then begin
                     //     
                     //     TableFuncionArray
                     case ACol of
                     GridEdColX : begin
                                    TableFuncionArray[TFRow].X := WD;
                                    FlagEditXValue := True;
                                  end;
                     GridEdColY : begin
                                    TableFuncionArray[TFRow].Y := WD;
                                    FlagEditYValue := True;
                                  end;
                     end; {of case}
                 end
                 else begin
                    MessageDlg( ' : : ' + Value
                     + #13#10 + '    .'
                     + #13#10 + ' :   .',
                     mtWarning, [mbOk], 0);
                    //   
                    case ACol of
                     GridEdColX : begin
                       Cells[ACol, ARow] := FloatToStr(TableFuncionArray[TFRow].X);
                                  end;
                     GridEdColY : begin
                       Cells[ACol, ARow] := FloatToStr(TableFuncionArray[TFRow].Y);
                                  end;
                    end; {of case}
                 end;
             end
             else begin
                //    
                case ACol of
                GridEdColX : TableFuncionArray[TFRow].X := 0;
                GridEdColY : TableFuncionArray[TFRow].Y := 0;
                end; {of case}
             end;  {of if Value <> '' }
           end
           else begin
                //     
                case ACol of
                GridEdColX : TableFuncionArray[TFRow].X := 0;
                GridEdColY : TableFuncionArray[TFRow].Y := 0;
                end; {of case}
           end;  {of if Value <> '-' }
         end; {of with TStringGrid(Sender)}
       end; {of if Sender is TStringGrid}
       //   
       VerifyAndSetNeedSortFlag();
    end; {of (TFRow >= Low(TableFuncionArray)) and (TFRow <= High(TableFuncionArray))}
  end; {of (ACol = GridEdColX) or (ACol = GridEdColY)}
end; {of procedure}

//--------------------------------------------------------
// 29.09.2008  (Local)
//     TableFuncionArray
procedure InsernOnePointToTFA (RqOp : char; RqInd : integer);
var BufTFA : TGraphArr;
    IndBuf, IndTFA : integer;
    WLen   : word;
begin
   if (RqInd >= Low(TableFuncionArray)) and (RqInd <= High(TableFuncionArray))
   then begin
    WLen := Length(TableFuncionArray);
    SetLength(BufTFA, WLen);
    //   TableFuncionArray
    for IndTFA:= Low(TableFuncionArray) to High(TableFuncionArray)
    do BufTFA[IndTFA] := TableFuncionArray[IndTFA];
    //    TableFuncionArray
    WLen := WLen + 1;
    SetLength(TableFuncionArray, WLen);
    IndBuf := Low(BufTFA);
    for IndTFA := Low(TableFuncionArray) to High(TableFuncionArray) do
    begin
       case UpCase(RqOp) of
       'U' : begin  {    }
               if IndTFA = Low(TableFuncionArray)
               then begin
                 TableFuncionArray[IndTFA].X := 0;
                 TableFuncionArray[IndTFA].Y := 0;
                 InfoToReport('    ');
               end
               else begin
                 TableFuncionArray[IndTFA] := BufTFA[IndBuf];
                 IndBuf := IndBuf + 1;
               end;
             end;
       'D' : begin  {    }
               if IndTFA = High(TableFuncionArray)
               then begin
                 TableFuncionArray[IndTFA].X := 0;
                 TableFuncionArray[IndTFA].Y := 0;
                 InfoToReport('    ');
               end
               else begin
                 TableFuncionArray[IndTFA] := BufTFA[IndBuf];
                 IndBuf := IndBuf + 1;
               end;
             end;
       'C' : begin  {  }
               TableFuncionArray[IndTFA] := BufTFA[IndBuf];
               if IndTFA <> RqInd
               then begin
                  IndBuf := IndBuf + 1;
               end
               else begin
                  InfoToReport('     X = '
                              + FloatToStr(BufTFA[IndBuf].X));
               end;
             end;
       end; {of case}
    end; {for IndTFA}
   end; {of  RqInd}
end; {of procedure}
//--------------------------------------------------------
// 29.09.2008  (Local)
//     TableFuncionArray
procedure DeleteOnePointInTFA (RqInd : integer);
var BufTFA : array of TPointXY;
    IndBuf, IndTFA : integer;
    WLen   : word;
begin
  if (RqInd >= Low(TableFuncionArray)) and (RqInd <= High(TableFuncionArray))
  then begin
    WLen := Length(TableFuncionArray);
    if WLen > cMinNumbPoints //       
    then begin
       SetLength(BufTFA, WLen);
       //   TableFuncionArray
       for IndTFA:= Low(TableFuncionArray) to High(TableFuncionArray)
       do BufTFA[IndTFA] := TableFuncionArray[IndTFA];
       //    TableFuncionArray
       WLen := WLen - 1;
       SetLength(TableFuncionArray, WLen);
       IndTFA := Low(TableFuncionArray);
       for IndBuf := Low(BufTFA) to High(BufTFA) do
       begin
         if (IndBuf = RqInd)
         then begin
           InfoToReport('    X = '
                       + FloatToStr(BufTFA[IndBuf].X));
         end
         else begin
           TableFuncionArray[IndTFA] := BufTFA[IndBuf];
           IndTFA := IndTFA + 1;
         end;
       end; {for IndBuf}
    end
    else begin
      InfoToReport('  .   ');
    end;
  end; {of  RqInd}
end; {of procedure}
//--------------------------------------------------------
// 28.09.2008
//    SGridEditor    TableFuncionArray
procedure RefrechSGridFromTFA();
var WLen, Ind, Row : word;
begin
 WLen := Length(TableFuncionArray);
 CEmGridEditor.RowCount  := WLen + 1;
 Row := 1;
 for Ind := Low(TableFuncionArray) to High(TableFuncionArray)
 do begin
  CEmGridEditor.Cells[GridEdColN,Row] := IntToStr(Ind);
  CEmGridEditor.Cells[GridEdColX,Row] := FloatToStr(TableFuncionArray[Ind].X);
  CEmGridEditor.Cells[GridEdColY,Row] := FloatToStr(TableFuncionArray[Ind].Y);
  Row := Row + 1;
 end;
end; {of procedure}


// ==========================================================
//     ()
// ==========================================================
//--------------------------------------------------------
// 29.09.2008 (Global)
//      TableFuncionArray
//     
procedure XSortTableFuncionArray();
var IndTF, TopIndTF : integer;
    BufTF : TPointXY;
begin
  if Length(TableFuncionArray) > 1
  then begin
    CEmGridEditor.SetFocus;
    TopIndTF := High(TableFuncionArray);
    repeat
       IndTF := Low(TableFuncionArray);
       BufTF := TableFuncionArray[IndTF];
       //   Low       
       repeat
          BufTF := TableFuncionArray[IndTF];
          if (IndTF + 1) <= TopIndTF
          then begin
            if (TableFuncionArray[IndTF+1].X < BufTF.X)
            then begin
               //    
               TableFuncionArray[IndTF] := TableFuncionArray[IndTF+1];
               //    
               TableFuncionArray[IndTF+1] := BufTF;
            end;
          end;
          IndTF := (IndTF +1);
        until (IndTF >= TopIndTF);
        //       TopIndTF.
        //   TopIndTF    .
        TopIndTF := (TopIndTF -1);
    until (TopIndTF <= Low(TableFuncionArray));
  end;
  RefrechSGridFromTFA();
  //   -  
  SetNeedSortIndicator1('D');
  InfoToReport('     ');
end; {of procedure}

//--------------------------------------------------------
// 29.09.2008 (Global)
//      TableFuncionArray
procedure InsernDeleteOnePointTF (RqOp1, RqOp2 : char; RqInd : integer);
begin
   case UpCase(RqOp1) of
      'I' : begin
             InsernOnePointToTFA (RqOp2, RqInd);
             SetNeedSortIndicator1('U'); {  -  }
            end;
      'D' : begin
             DeleteOnePointInTFA (RqInd);
            end;
   end; {of case}
   RefrechSGridFromTFA();
end; {of procedure}

// ==========================================================
//   UNIT - 
// ==========================================================
// 03.11.2008
//    StringGrid
procedure ShowSGTitle(SG : TStringGrid; Title : array of string);
var Row, Col : word;
begin
 Row := 0;
 for Col := Low(Title) to High(Title) do  begin
     if (Col + 1) <= SG.ColCount
     then begin
        SG.Cells[Col,Row] := Title[Col];
     end;
 end; {for Col}
end; {of procedure}
//-----------------------------------------------------------
// 30.09.2008
//     .
procedure MakeNewTableFuncion(RqCaption : string);
var Ind : integer;
begin
   TableFuncionFileName := '';
   SetInfoCurrentFileName();
   CEmProjectDesc.Text := RqCaption;
   //    TableFuncionArray
   SetLength(TableFuncionArray, cMinNumbPoints);  //  
   //    
   for Ind := Low(TableFuncionArray) to High(TableFuncionArray) do
   begin
     TableFuncionArray[Ind].X := Ind + 1;
     TableFuncionArray[Ind].Y := 0;
   end;
   //    GridEditor
   CEmGridEditor.RowCount  := cMinNumbPoints + 1;
   RefrechSGridFromTFA();
end; {of procedure}
//-----------------------------------------------------------
// 30.09.2008  (Global)
//   UNIT  GridEditor01
procedure InitGridEditor01(RqCEmProjectForm : TForm;
                           RqCEmProjectDesc : TEdit;
                           RqCEmGridEditor  : TStringGrid;
                           RqCEmNeedSort    : TStaticText);
begin
   //     ,
   //    
   // .
   CEmProjectForm := RqCEmProjectForm;
   CEmNeedSort := RqCEmNeedSort;
   CEmProjectDesc := RqCEmProjectDesc; { TEdit }
   CEmGridEditor := RqCEmGridEditor; { TStringGrid }
   //     StringGrid
   CEmGridEditor.ColCount  := GridEdColCount;
   CEmGridEditor.FixedCols := 1;
   CEmGridEditor.FixedRows := 1;
   CEmGridEditor.DefaultRowHeight := 16;
   CEmGridEditor.Options   := [goFixedVertLine,goFixedHorzLine,
                               goVertLine,goHorzLine,
                               goDrawFocusSelected,
                               goEditing,goTabs];
   ShowSGTitle(CEmGridEditor, GridEditor01Title);
   //    .
   MakeNewTableFuncion('     ');
end; {of procedure}
// ==========================================================
// IMPLEMENTATION END
// ==========================================================
end.



