unit Gauss01;

interface
uses Dialogs, Report01;

  //        .
  //     , 
  //     (Gauss01SupMaxRow - 1)
  const Gauss01SupMaxRow = 100;

  //      
  const Gauss01Tolerance = 1.0E-100;

  // ,     
  //     .
  type TGaussEquationsSet = record
     // ==========   ==============
     //      
     MaxRow : integer;
     //     = MaxRow + 1
     MaxCol : integer;
     //        
     TAB : array [1..Gauss01SupMaxRow, 1..(Gauss01SupMaxRow+1)] of Extended;
     // ==========    ==========
     //   AI,     
     AI : array [1..Gauss01SupMaxRow] of Extended;
   end;

   //       
   // : ESDat.MaxRow, ESDat. MaxCol, ESDat. TAB
   function ExecGaussEquationsSet(var ESDat : TGaussEquationsSet) : boolean;

// ==========================================================
//                   IMPLEMENTATION BEGIN
// ==========================================================
implementation

  //      
  // (    )
  const SupMaxRow = Gauss01SupMaxRow;
  const SupMaxCol = SupMaxRow + 1;
// ==========================================================
// 15.10.2008
// ==========================================================
//      
//    :
// ESDat.MaxRow, ESDat. MaxCol, ESDat. TAB
// ==========================================================
function ExecGaussEquationsSet(var ESDat : TGaussEquationsSet) : boolean;
//---------------
var OkFlag : boolean;
//---------------
var MNum : integer;
var MRow : integer;  //   (master)
var MCol : integer;  //   (master)
var WRow : integer;  //  (work)  
var WCol : integer;  //  (work)  
var CRow : integer;
//---------------
var Work : Double;
//---------------
begin
  //   "    "
  OkFlag := False;
  ExecGaussEquationsSet := OkFlag;
  //     
  FillChar (ESDat.AI, SizeOF(ESDat.AI),#0);

  with ESDat do
  begin
  //===============
  for MNum := 1 to MaxRow do
  begin
      MRow := MNum;
      MCol := MNum;
     //--------------------
     //    (master)   
     Work := Abs(TAB[MRow, MCol]);
     CRow := MRow;
     for WRow := MRow to MaxRow do
     begin
        if Work < Abs(TAB[WRow, MCol]) then
        begin
           Work := Abs(TAB[WRow, MCol]);
           CRow := WRow;
        end; // if
     end; // for
     // CRow -     
     //--------------------
     //      
     //    .
     if MRow <> CRow then
     begin
        for WCol := 1 to MaxCol do
        begin
          Work := TAB[MRow, WCol];
          TAB[MRow, WCol] := TAB[CRow, WCol];
          TAB[CRow, WCol] := Work;
        end; // for WCol
     end; // if
     //--------------------
     //      ()
     Work := TAB[MRow, MCol];
     if Abs(Work) > Gauss01Tolerance then
     begin
        for WCol := 1 to MaxCol do
        begin
           TAB[MRow, WCol] := TAB[MRow, WCol] / Work;
        end; // for WCol
        OkFlag := True;
     end
     else begin
        OkFlag := False;
        FillChar (AI, SizeOF(AI),#0);
        DebugErrorToReport('Gauss01.ExecGaussEquationsSet:'
                         + '   ');
        Break;  //     (for MNum)
     end; // if
     //--------------------
     //      TAB(MRow, MCol)
     if MRow < MaxRow then
     begin
        //  
        for WRow := MRow + 1 To MaxRow do
        begin
           //    
           Work := TAB[WRow, MCol];
           for WCol := 1 To MaxCol do
           begin
               //   
               TAB[WRow, WCol] := TAB[WRow, WCol]
                                - TAB[MRow, WCol] * Work;
           end; // for WCol
        end; // for WRow
     end; // if
  end; // for MNum
  // -------------------------
  if OkFlag
  then begin
     //  
     AI[MaxRow] := TAB[MaxRow, MaxCol];
     for WRow := (MaxRow - 1) downto 1 do
     begin
        Work := TAB[WRow, MaxCol];
        for WCol := 1 to (MaxCol - 1) do
        begin
            Work := Work - AI[WCol] * TAB[WRow, WCol];
        end; // for WCol
        AI[WRow] := Work;
     end; // for WRow
     ExecGaussEquationsSet := True;  //    
  end;
  // -------------------------
  end; // with
end; // procedure

// ==========================================================
//                   IMPLEMENTATION END
// ==========================================================
end.
