unit SpectrumService01;

interface
uses Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
     Dialogs, ExtCtrls, StdCtrls, MMSystem,
     SpectrumDATA;

    //   
    function InitSignalArr(var RqMP : TMainParm) : boolean;
    //   
    function InitSpectrumArr (var RqMP : TMainParm) : boolean;
    //    
    procedure StartMMTimeStamp (var RqStamp  : TTimeStampsMM;
                                    RqReport : TStaticText);
    //       
    procedure StopMMTimeStamp (var RqStamp  : TTimeStampsMM;
                                   RqReport : TStaticText);

implementation

// =========================================================================
//   
// =========================================================================
// 10.03.2013
//   
function InitSignalArr(var RqMP : TMainParm) : boolean;
begin
  Result := False;
  try
    SetLength(RqMP.ArrSg, DigMaxNum);
    Result := True;
  except
    MessageDlg('     '
              + #13#10
              + 'Win-API' + SysErrorMessage(GetLastError),
               mtError, [mbOk], 0);
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//   
function InitSpectrumArr (var RqMP : TMainParm) : boolean;
begin
  Result := False;
  try
    SetLength(RqMP.ArrGrm, GrmMaxNum);
    Result := True;
  except
    MessageDlg('     '
              + #13#10
              + 'Win-API' + SysErrorMessage(GetLastError),
               mtError, [mbOk], 0);
  end;
end;

// =========================================================================
//       
// =========================================================================
// 10.03.2013
//    
procedure StartMMTimeStamp (var RqStamp  : TTimeStampsMM;
                                RqReport : TStaticText);
begin
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
       RqReport.Caption := '.';
   end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//       
procedure StopMMTimeStamp (var RqStamp  : TTimeStampsMM;
                               RqReport : TStaticText);
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then RqReport.Caption := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            RqReport.Caption := '.';
          end;
      end;
   end;
end;




end.
