unit SpectrumReport;

interface
uses Classes, SysUtils, Controls, ExtCtrls, Graphics, StdCtrls,
     JPEG, Dialogs, ExtDlgs,
     GlobalDATA,
     SpectrumDATA;

//   
procedure SaveMemoReport(RqSDialog : TSaveDialog;
                         RqReport : TMemo);


//     
procedure SaveGraphReport (RqSPDialog : TSavePictureDialog;
                           RqImg : TImage);


implementation

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//     
procedure ReportToFile (RqFileName : string; RqReport : TMemo);
begin
  try
    RqReport.Lines.SaveToFile(RqFileName);
  except
      //    
  end;
end;

// -------------------------------------------------------------------------
//   
procedure SaveMemoReport(RqSDialog : TSaveDialog;
                         RqReport : TMemo);
const UExt = '.TXT';
      LExt = '.txt';
var   wFileName : string;
begin
   //     
   if AppStartDir <> '' then RqSDialog.InitialDir := AppStartDir;
   //    
   RqSDialog.Filter := 'Report files (*' + LExt + ')|*' + UExt;
   if RqSDialog.Execute
   then begin
      wFileName := RqSDialog.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> UExt
      then wFileName := wFileName + LExt;
      //  
      if FileExists(wFileName)
      then begin
         if MessageDlg('   ! '
                      + #13#10
                      + '  : '
                      + ExtractFileName(wFileName),
                      mtWarning, [mbYes, mbNo], 0) = mrYes
         then begin
           //    
           ReportToFile (wFileName, RqReport);
         end;
      end
      else ReportToFile (wFileName, RqReport);
   end;
end;


// =========================================================================
//     
// =========================================================================
//  RqImg   RqFileName. (RqGF : 'J' - jpg   'B' -bmp)
procedure SavePicture(RqFileName : string; RqImg : TImage; RqGF : char);
var  Jpeg   : TJPEGImage;  //   unit jpeg.
     BitMap : TBitMap;
begin
    case UpCase(RqGF) of
    'J' : begin   //   Jpeg
            Jpeg := TJPEGImage.Create;
            try
              with Jpeg do
              begin            //  Bitmap  JPG
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
              end;
            finally
                 Jpeg.Free;    //   JPG
            end;
          end;
    'B': begin   //   BMP
            BitMap := TBitMap.Create;
            try
              with BitMap do   //  Bitmap  BMP
              begin
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
              end;
            finally
                 BitMap.Free;  //   BMP
            end;
         end;
       end; // of case
end;
// -------------------------------------------------------------------------
//     
procedure SaveGraphReport (RqSPDialog : TSavePictureDialog;
                           RqImg : TImage);
const UExt = '.JPG';
      LExt = '.jpg';
var   wFileName : string;
begin
  //     
  if AppStartDir <> '' then RqSPDialog.InitialDir := AppStartDir;
  //    
  RqSPDialog.Filter := 'Report files (*' + LExt + ')|*' + UExt;
  if RqSPDialog.Execute
  then begin
     wFileName := RqSPDialog.FileName;
     //      
     if UpperCase(ExtractFileExt(wFileName)) <> UExt
     then wFileName := wFileName + LExt;
     //  
     if FileExists(wFileName)
     then begin
        if MessageDlg('   ! '
                     + #13#10
                     + '  : '
                     + ExtractFileName(wFileName),
                     mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
           //     
           SavePicture(wFileName, RqImg, 'J');
        end;
     end
     //     
     else SavePicture(wFileName, RqImg, 'J');
  end;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
end.
