unit SpectrumMAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, StdCtrls, Buttons, MMSystem, ExtDlgs,
  GlobalDATA,
  SpectrumDATA,
  SpectrumDFT,
  SpectrumService01,
  SpectrumDisplay,
  SpectrumReport;

type
  TSpectrumForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    TabSheet1: TTabSheet;
    Panel1: TPanel;
    PanelGrmData: TPanel;
    LbGrmAmp: TLabel;
    LbGrmPhs: TLabel;
    LbGrmInd: TLabel;
    StTxtGrmAmp: TStaticText;
    StTxtGrmPhs: TStaticText;
    CmbBoxGrmInd: TComboBox;
    BitBtn4: TBitBtn;
    BitBtnRScSpectr: TBitBtn;
    PanelSpectr: TPanel;
    ImgSpectr: TImage;
    Panel2: TPanel;
    PanelSignal: TPanel;
    ImgSignal: TImage;
    PanelMAAmp: TPanel;
    ImgMAAmp: TImage;
    StTxtMAAmp: TStaticText;
    PanelMRAmp: TPanel;
    ImgMRAmp: TImage;
    StTxtMRAmp: TStaticText;
    BitBtnRScSg: TBitBtn;
    BitBtnSavePicSignal: TBitBtn;
    PanelMinMax: TPanel;
    LbMinSY: TLabel;
    LbMaxSY: TLabel;
    StTxtMinSY: TStaticText;
    StTxtMaxSY: TStaticText;
    PanelC0Amp: TPanel;
    ImgC0Amp: TImage;
    StTxtC0Amp: TStaticText;
    LbIntegralParm: TLabel;
    TabSheet3: TTabSheet;
    Panel3: TPanel;
    PanelAnalise: TPanel;
    LbSerTitle: TLabel;
    LbReportTitle: TLabel;
    PanelReportSg: TPanel;
    LbReportType: TLabel;
    CbBoxReportType: TComboBox;
    StTxtReportFull: TStaticText;
    BitBtnReportClear: TBitBtn;
    BitBtnReportToTxt: TBitBtn;
    PanelSeries: TPanel;
    LbLenSer: TLabel;
    LbSerNum: TLabel;
    LbSerMin: TLabel;
    LbSerMax: TLabel;
    LbSerMAAmp: TLabel;
    LbSerMRAmp: TLabel;
    StTxtSerLamp: TStaticText;
    CbBoxLenSer: TComboBox;
    StTxtSerNum: TStaticText;
    EdSerMin: TEdit;
    EdSerMax: TEdit;
    EdSerMAAmp: TEdit;
    EdSerMRAmp: TEdit;
    MemReport: TMemo;
    LbSignalTab: TLabel;
    PanelDPolar: TPanel;
    ImgPolar: TImage;
    SavePictureDialog1: TSavePictureDialog;
    SaveDialog1: TSaveDialog;
    Panel4: TPanel;
    LbReadType: TLabel;
    CbBoxGetSignal: TComboBox;
    BitBtn2: TBitBtn;
    LbWorkTime: TLabel;
    StTxtWorkTime: TStaticText;
    Panel5: TPanel;
    Image1: TImage;
    LbGrmPhsG: TLabel;
    StTxtGrmPhsG: TStaticText;
    LbGrmPhsT: TLabel;
    StTxtGrmPhsT: TStaticText;
    Panel6: TPanel;
    Label2: TLabel;
    StTxtGrmPeriod: TStaticText;
    StTxtGrmFreq: TStaticText;
    Label3: TLabel;
    Label4: TLabel;
    Panel7: TPanel;
    Label5: TLabel;
    LbMaxGrmInd: TLabel;
    LbMaxGrm: TLabel;
    StTxtMaxGrmInd: TStaticText;
    StTxtMaxGrm: TStaticText;
    Panel8: TPanel;
    Label6: TLabel;
    Panel9: TPanel;
    Label1: TLabel;
    StTxtPeriod: TStaticText;
    Label7: TLabel;
    StTxtFrequency: TStaticText;
    Label8: TLabel;
    Panel10: TPanel;
    LbFormCoef: TLabel;
    EdFormCoef: TEdit;
    StTxtGrmPresLamp: TStaticText;
    LbGrmPres: TLabel;
    LbAmpCoef: TLabel;
    EdAmpCoef: TEdit;
    Bevel1: TBevel;
    Label14: TLabel;
    LbDFTTime: TLabel;
    StTxtDFTTime: TStaticText;
    Label9: TLabel;
    Label10: TLabel;
    Bevel2: TBevel;
    procedure CbBoxLenSerClick(Sender: TObject);
    procedure BitBtnReportClearClick(Sender: TObject);
    procedure BitBtnRScSpectrClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ImgSpectrMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CmbBoxGrmIndClick(Sender: TObject);
    procedure BitBtnRScSgClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtnSavePicSignalClick(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtnReportToTxtClick(Sender: TObject);
  private
    { Private declarations }
    // --------------------------------------------------------
    //     
    procedure InitCmbBoxGrmInd(var RqMP : TMainParm);
    // --------------------------------------------------------
    // -  
    procedure ExecuteSpectrum (RqBufDat : TBufSignalData;
                           var RqMP : TMainParm);
    //    
    procedure RunSpectrum();
    // --------------------------------------------------------
    //         .
    function PrepareArrSg (RqBufDat : TBufSignalData;
                       var RqMP     : TMainParm) : boolean;
    //    
    procedure SignalShow (var RqRescale : boolean;
                          var RqMP : TMainParm);
    //     
    procedure ShowGrmData (RqInd : integer; RqMP : TMainParm);
    // --------------------------------------------------------
    //   
    procedure CalcStatSignal (var RqSS : TStatSignal;
                                  RqMP : TMainParm);
    //     
    procedure ShowCalcStatSignal (RqData : boolean;
                              var RqSS : TStatSignal);
    //  /   ,   
    procedure SetLenSer();
    // --------------------------------------------------------
  public
    { Public declarations }
  end;

//    
var  SpectrumForm : TSpectrumForm;

// =========================================================================
implementation
{$R *.dfm}
// =========================================================================
//     
var ExecStamps  :  TTimeStampsMM;

//    
var DFTStamps   :  TTimeStampsMM;

// =========================================================================
// 
// =========================================================================
// -------------------------------------------------------------------------
// 10.03.2013
//     
procedure TSpectrumForm.InitCmbBoxGrmInd(var RqMP : TMainParm);
const DefStartGrmInd = 1;
var Ind : integer;
begin
  CmbBoxGrmInd.Tag := 1;  //    
  CmbBoxGrmInd.Clear;
  if (RqMP.IndGrm >= 0)
  then begin
     for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm)
     do CmbBoxGrmInd.Items.Add ('  ' + IntToStr(Ind));
     CmbBoxGrmInd.ItemIndex := DefStartGrmInd;
  end;
  RqMP.IndGrm := DefStartGrmInd;
  //    
  CmbBoxGrmInd.Tag := 0;
end;
// -------------------------------------------------------------------------
// 10.03.2013
procedure TSpectrumForm.FormCreate(Sender: TObject);
begin
   //    
   Self.Caption := cAppTitle;
   //  
   AppStartDir := ExtractFilePath(Application.ExeName);
   //     
   FillChar(SpectrumMainParm, SizeOf(SpectrumMainParm), #0);
   //      
   SpectrumMainParm.NumGrm := GrmMaxNum;
   //   
   if not InitSignalArr(SpectrumMainParm) then Exit;
   //   
   if not InitSpectrumArr (SpectrumMainParm) then Exit;
   //      Image   
   SetImgToAllDisplays(ImgSpectr, ImgPolar, ImgSignal, SpectrumMainParm);
   //   SIN  COS   
   //   DigMaxNum  
   InitArrSnCs (ArrSnCs);
   //     
    InitCmbBoxGrmInd(SpectrumMainParm);
   //    
   SpectrumRunProc := RunSpectrum;
end;

// =========================================================================
// -  
// =========================================================================
// 10.03.2013
// -  
procedure TSpectrumForm.ExecuteSpectrum (RqBufDat : TBufSignalData;
                                     var RqMP     : TMainParm);
var Ind  : integer;

begin
    //   1 ------------------------------------
    // -------------------------------------
    //    
    StartMMTimeStamp (DFTStamps, StTxtDFTTime);
    // -------------------------------------
    //      
    //    RqBufDat,    
    //    
    CalcSimpsonMhetod(RqBufDat, ArrSnCs, TSimp, Arr3Folds);
    // -------------------------------------
    //       
    StopMMTimeStamp (DFTStamps, StTxtDFTTime);
    // -------------------------------------
    //   2 ------------------------------------
    //     
    StTxtC0Amp.Caption := Format(' A0 = %15.9f',[TSimp.SY.Amp]);
    StTxtMAAmp.Caption := Format('  = %15.9f',[TSimp.SYa.Amp]);
    StTxtMRAmp.Caption := Format('  = %15.9f',[TSimp.SYk.Amp]);
    RqMP.MAAmp := TSimp.SYa.Amp;   //    
    RqMP.MRAmp := TSimp.SYk.Amp;   //   
    //   3 ------------------------------------
    //      
    if not PrepareArrSg (RqBufDat, RqMP) then Exit;
    //      
    SignalShow (RqRescaleDSignal, RqMP);
    //   Min  Max   
    StTxtMinSY.Caption := Format(' %15.9f',[RqMP.minSY]);
    StTxtMaxSY.Caption := Format(' %15.9f',[RqMP.maxSY]);
    //   4 ------------------------------------
    //      
    if not RqMP.DSpectr.DSShow
    then begin
      PrepareAndShowSpectr (True, TSimp, RqMP);
      RqRescaleDSpectr := False;    //   
    end
    else PrepareAndShowSpectr (False, TSimp, RqMP);
    //     CmbBoxGrmInd 
    ShowGrmData (RqMP.IndGrm, RqMP);
    //   5 ------------------------------------
    //     
    CalcStatSignal (StatSignal, RqMP);
    //   6 ------------------------------------
    //         
    if ( not(CbBoxGetSignal.ItemIndex > 0)) and
       ( CbBoxReportType.ItemIndex = 1)
    then begin
       MemReport.Clear;
       MemReport.Lines.Add(' ');
       for Ind := 0 to High(SignalBufer.Signal)
       do MemReport.Lines.Add(
                       IntToStr(Ind)
                       + ' :   '
                       + FloatToStr(SignalBufer.Signal[Ind]));
    end;
end;
// =========================================================================
//    
// =========================================================================
// 10.03.2013
//    
//        
procedure TSpectrumForm.RunSpectrum();
var Ind : integer;
begin
   // -----------------------------------------
   //        
   with SignalBufer do
   begin
     //     ms
     Period := GLSignalBufer.Period;
     SpectrumMainParm.Period := Period;
     //     Hz
     if Period > 0
     then begin
        SpectrumMainParm.Frequency := 1000/Period;
        StTxtFrequency.Caption := Format('%8.6f Hz',
                                         [SpectrumMainParm.Frequency]);
     end
     else StTxtFrequency.Caption := '*****';
     //   
     for Ind := Low(Signal) to High(Signal)
     do begin
       if (Ind >= Low (GLSignalBufer.Signal)) and
          (Ind <= High(GLSignalBufer.Signal))
       then Signal[Ind] := GLSignalBufer.Signal[Ind]
       else Signal[Ind] := 0;
     end;
     //  
     StTxtPeriod.Caption := Format('%10.6f ms',[Period]);
   end;
   // -----------------------------------------
   //    
   StartMMTimeStamp (ExecStamps, StTxtWorkTime);
   // -----------------------------------------
   if CbBoxGetSignal.ItemIndex > 0
   then ExecuteSpectrum (SignalBufer.Signal, SpectrumMainParm)
   else begin
        //       
        if RqGetSignal
        then begin
           ExecuteSpectrum (SignalBufer.Signal, SpectrumMainParm);
           RqGetSignal := False;
        end;
   end;
   // -----------------------------------------
   //       
   StopMMTimeStamp (ExecStamps, StTxtWorkTime);
end;
// -------------------------------------------------------------------------
// 10.03.2013
//    
procedure TSpectrumForm.BitBtn2Click(Sender: TObject);
begin
   RqGetSignal := True;
end;

// =========================================================================
//     
// =========================================================================
// 10.03.2013
//         .
//          
//      .  
//  
//
function TSpectrumForm.PrepareArrSg (RqBufDat : TBufSignalData;
                                 var RqMP     : TMainParm) : boolean;
const  TRad = 2 * Pi;            //    
var    XS, A1 : double;          //    
       Ind    : integer;         //  
begin
   Result := False;
   if Length(RqMP.ArrSg) <> Length(RqBufDat) then Exit;
   with RqMP
   do begin
      //    
      DigNum := Length(RqBufDat);                //    
      XS := TRad / High(RqBufDat);               //     
      // -------------------------------
      minSY := 0;
      maxSY := 0;
      for Ind := Low(RqBufDat) to High(RqBufDat)
      do begin
         //    
         ArrSg[Ind].X := XS * Ind;               //    
         A1 := RqBufDat[Ind];                    //  
         ArrSg[Ind].Y := A1;
         //       
         if A1 < minSY then minSY := A1;
         if A1 > maxSY then maxSY := A1;
      end;
      Result := True;
   end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//    
procedure TSpectrumForm.SignalShow (var RqRescale : boolean;
                                    var RqMP : TMainParm);
begin
  with RqMP do begin
    //       
    if RqRescale
    then begin
      //   Signal - 
      ShowDSignal (RqMP);
      RqRescale := False;           //     
    end else begin
      //   ,   ,   
      if not RqMP.DSignal.SgShow
      then ShowDSignal (RqMP)
      else ReShowDSignal (RqMP);
    end;
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//      
procedure TSpectrumForm.BitBtnRScSgClick(Sender: TObject);
begin
  RqRescaleDSignal := True;         //   
  SignalShow (RqRescaleDSignal, SpectrumMainParm);
end;

// =========================================================================
//    
//        SpectrumDFT
//    PrepareAndShowSpectr
// =========================================================================
// 10.03.2013
//     
procedure TSpectrumForm.ShowGrmData (RqInd : integer; RqMP : TMainParm);
begin
  with RqMP
  do begin
    if (RqInd < Low(ArrGrm)) or (RqInd > High(ArrGrm)) then Exit;
    StTxtGrmAmp.Caption  := Format(' %15.9f', [ArrGrm[RqInd].AmpM]);
    //      ,   
    StTxtGrmPhs.Caption  := Format(' %15.9f', [ArrGrm[RqInd].PhsM]);
    StTxtGrmPhsG.Caption := Format(' %15.9f', [ArrGrm[RqInd].PhsG]);
    StTxtGrmPhsT.Caption := Format(' %15.9f', [ArrGrm[RqInd].PhsT]);
    //     
    StTxtGrmPeriod.Caption := Format(' %10.8f ms', [ArrGrm[RqInd].PrdM]);
    StTxtGrmFreq.Caption   := Format(' %8.4f Hz',  [ArrGrm[RqInd].FrqM]);
    //      
    StTxtMaxGrmInd.Caption := ' ' + IntToStr(RqMP.MaxGrmInd);
    StTxtMaxGrm.Caption  := Format(' %15.9f', [RqMP.MaxGrm]);
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//      Image 
procedure TSpectrumForm.ImgSpectrMouseDown(Sender: TObject;
          Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var wX, Ind, RqInd : integer;
begin
  RqInd := -1;
  with SpectrumMainParm.DSpectr do
  begin
    if (Length(SpectrumMainParm.ArrGrm) < 1) or (XSc <= 0) then Exit;
    for Ind := Low(SpectrumMainParm.ArrGrm) to High(SpectrumMainParm.ArrGrm)
    do begin
      wX := OffX + Trunc(XSc * Ind);
      if (X >= wX - 4) and (X <= wX + 4)
      then RqInd := Ind;
    end;
    if RqInd >=0
    then begin
       //    
       SpectrumMainParm.IndGrm := RqInd;
       ShowDSpectrXCaption(SpectrumMainParm);
       CmbBoxGrmInd.Tag := 1;
       CmbBoxGrmInd.ItemIndex := RqInd;
       CmbBoxGrmInd.Tag := 0;
       //    
       ShowGrmData (RqInd, SpectrumMainParm);
       //       Polar - 
       ShowDPolar (SpectrumMainParm);
    end;
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//       ComboBox
procedure TSpectrumForm.CmbBoxGrmIndClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrmInd.ItemIndex;
  if Ind >=0
  then begin
     //    
     SpectrumMainParm.IndGrm := Ind;
     ShowDSpectrXCaption(SpectrumMainParm);
     //     
     if CmbBoxGrmInd.Tag = 0
     then ShowGrmData (CmbBoxGrmInd.ItemIndex, SpectrumMainParm);
     //       Polar - 
     ShowDPolar (SpectrumMainParm);
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//      
procedure TSpectrumForm.BitBtnRScSpectrClick(Sender: TObject);
begin
   if not RqRescaleDSpectr    //  
   then PrepareAndShowSpectr (True, TSimp, SpectrumMainParm);
end;

// =========================================================================
//      
// =========================================================================
// 10.03.2013
//   
//      ExecuteSpectrum
procedure TSpectrumForm.CalcStatSignal (var RqSS : TStatSignal;
                                            RqMP : TMainParm);
begin
  with RqSS do
  begin
    //    0,    
    if SerLen = 0 then Exit;
    //  
    Inc(SerCt);
    if SerCt > SerLen
    then begin
      //       
      // ------------------------------------
      //    
      //    
      SerMAAmp  := SerMAAmp / SerLen;
      //    
      SerMRAmp  := SerMRAmp / SerLen;
      // ------------------------------------
      //     
      ShowCalcStatSignal (True, RqSS);
      // ------------------------------------
      //  
      SerMinSY := 0; SerMaxSY := 0;
      SerMAAmp := 0; SerMRAmp := 0;
      SerCt := 0;
    end
    else begin
      //  
      if RqMP.minSY < SerMinSY then SerMinSY := RqMP.minSY;
      if RqMP.maxSY > SerMaxSY then SerMaxSY := RqMP.maxSY;
      SerMAAmp  := SerMAAmp + RqMP.MAAmp;
      SerMRAmp  := SerMRAmp + RqMP.MRAmp;
    end;
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//     
procedure TSpectrumForm.ShowCalcStatSignal (RqData : boolean;
                                        var RqSS : TStatSignal);
var AbsMax : double;
begin
  if RqData
  then begin
    with RqSS do
    begin
       //      
       EdSerMin.Text   := Format(' %10.6f',[SerMinSY]);
       EdSerMax.Text   := Format(' %10.6f',[SerMaxSY]);
       //  - , -   
       EdSerMAAmp.Text := Format('  = %10.6f',[SerMAAmp]);
       EdSerMRAmp.Text := Format('  = %10.6f',[SerMRAmp]);
       //      
       if SerMAAmp > 0
       then EdFormCoef.Text := Format(' K = %8.4f',[SerMRAmp/SerMAAmp])
       else EdFormCoef.Text := '---';
       //      
       if Abs(SerMaxSY) > Abs(SerMinSY)
       then AbsMax := Abs(SerMaxSY)
       else AbsMax := Abs(SerMinSY);
       if SerMRAmp > 0
       then EdAmpCoef.Text := Format(' K = %8.4f',[AbsMax/SerMRAmp])
       else EdAmpCoef.Text := '---';
       //   
       if Abs((AbsMax/SerMRAmp) - 1.4142135623731) > 0.01
       then StTxtGrmPresLamp.Color := clYellow
       else StTxtGrmPresLamp.Color := clBtnFace;
       //   
       Inc(SerNum);
       StTxtSerNum.Caption := IntToStr(SerNum);
    end;
    //    
    if (CbBoxReportType.ItemIndex = 2)
    then begin
       if MemReport.Lines.Count <= MaxCountSeries
       then begin
          with MemReport.Lines do
          begin
              Add('');
              Add('   = '
                 + StTxtSerNum.Caption
                 + ' ( ' + IntToStr(RqSS.SerLen)
                 +  ' -  )');
              Add('Min.. = ' + EdSerMin.Text);
              Add('Max.. = ' + EdSerMax.Text);
              Add(EdSerMAAmp.Text);  Add(EdSerMRAmp.Text);
              Add(EdFormCoef.Text);  Add(EdAmpCoef.Text);
          end;
       end
       else begin
          //  
          StTxtReportFull.Color := RGB(255,64,64);
       end;
    end;
  end else begin
    // 
    EdSerMin.Text   := '';  EdSerMax.Text   := '';
    EdSerMAAmp.Text := '';  EdSerMRAmp.Text := '';
    RqSS.SerNum := 0;       StTxtSerNum.Caption := '';
    EdFormCoef.Text := '';  EdAmpCoef.Text := '';
    if CbBoxReportType.ItemIndex = 2 then MemReport.Clear;
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//  /   ,   
procedure TSpectrumForm.SetLenSer();
begin
   //   
   ShowCalcStatSignal (False, StatSignal);
   if CbBoxLenSer.ItemIndex <= 0
   then begin
       //    
       StatSignal.SerLen := 0;
       StTxtSerLamp.Color := clBtnFace;
       StTxtGrmPresLamp.Color := clBtnFace;
   end else begin
     //       
     StatSignal.SerLen := 10 * CbBoxLenSer.ItemIndex;
     StTxtSerLamp.Color := clLime;
   end;
   //    
   StatSignal.SerNum := 0;
   StTxtSerNum.Caption := '';
end;
// -------------------------------------------------------------------------
// 10.03.2013
//  /   ,   
procedure TSpectrumForm.CbBoxLenSerClick(Sender: TObject);
begin
   SetLenSer();
end;
// -------------------------------------------------------------------------
// 10.03.2013
//  
procedure TSpectrumForm.BitBtnReportClearClick(Sender: TObject);
begin
  MemReport.Clear;
  StTxtReportFull.Color := clBtnFace;
end;

// =========================================================================
//    
// =========================================================================
// 10.03.2013
//    .
procedure TSpectrumForm.BitBtnSavePicSignalClick(Sender: TObject);
begin
   if CbBoxGetSignal.ItemIndex = 0
   then begin
     //     
     SaveGraphReport (SavePictureDialog1, ImgSignal);
   end
   else MessageDlg('  '
                  + #13#10
                  + '    .',
                  mtInformation	, [mbYes], 0);
end;
// -------------------------------------------------------------------------
// 10.03.2013
//    .
procedure TSpectrumForm.BitBtn4Click(Sender: TObject);
begin
   if CbBoxGetSignal.ItemIndex = 0
   then begin
     //     
     SaveGraphReport (SavePictureDialog1, ImgSpectr);
   end
   else MessageDlg('  '
                  + #13#10
                  + '    .',
                  mtInformation	, [mbYes], 0);
end;
// -------------------------------------------------------------------------
// 10.03.2013
//       .
procedure TSpectrumForm.BitBtnReportToTxtClick(Sender: TObject);
begin
   if CbBoxGetSignal.ItemIndex = 0
   then begin
       if MemReport.Lines.Count > 0
       then begin
          //   
          SaveMemoReport(SaveDialog1, MemReport);
       end
       else MessageDlg('  .'
                      + #13#10
                      + ' .',
                       mtInformation	, [mbYes], 0);
   end
   else MessageDlg('  '
                  + #13#10
                  + '    .',
                  mtInformation	, [mbYes], 0);
end;

// =========================================================================
//  
// =========================================================================






// =========================================================================
//                    END OF IMPLEMENTATION
// =========================================================================
end.
