unit SpectrumDisplay;

interface
uses Windows, Classes, Graphics, SysUtils, ExtCtrls,
     SpectrumDATA;

// =========================================================================
//  Image   
procedure SetImgToAllDisplays (DImg,           // Image  
                               PImg,           // Image  
                               SImg : TImage;  // Image  
                           var RqMP  : TMainParm);
// =========================================================================
//       
//  Polar - 
procedure ReShowDPolar (var RqMP : TMainParm);
//  Spectr -       
procedure ReShowDSpectr (var RqMP : TMainParm);
//        
procedure ReShowDSignal (var RqMP : TMainParm);
//      -   Spectr - 
procedure ShowDSpectrXCaption (var RqMP : TMainParm);
//     Spectr - 
procedure ShowDSpectr (var RqMP : TMainParm);
//     Signal - 
procedure ShowDSignal (var RqMP : TMainParm);
//     Polar - 
procedure ShowDPolar (var RqMP : TMainParm);
// =========================================================================

implementation

// =========================================================================
//  
// =========================================================================
//      (  )
function FindAbsMaxAmp (var RqMP  : TMainParm) : double;
var Ind : integer;
begin
  with RqMP do
  begin
     Result := 0;
     if Length(ArrGrm) < 1 then Exit;
     for Ind := Low(ArrGrm) to High(ArrGrm)
     do if Abs(ArrGrm[Ind].Amp) > Result
        then Result := Abs(ArrGrm[Ind].Amp);
  end;
end;

// =========================================================================
//   
// =========================================================================
//  Image   
procedure SetImgToAllDisplays (DImg,           // Image  
                               PImg,           // Image  
                               SImg : TImage;  // Image  
                           var RqMP  : TMainParm);
begin
   RqMP.DSpectr.Img := DImg;
   RqMP.DSpectr.DPolar.Img := PImg;
   RqMP.DSignal.Img := SImg;
end;

// =========================================================================
//  
// =========================================================================
//  RqImage
procedure ClearImage (RqImage : TImage);
var clImg : TColor;
begin
  // clImg := RGB(131, 153, 177);  // RainDay - clBtnFace;
  clImg := RGB($90, $90, $90);     //  
  with RqImage do
  begin
    Canvas.Pen.Color   := clImg;
    Canvas.Pen.Mode    := pmCopy;
    Canvas.Brush.Style := bsSolid;
    Canvas.Brush.Color := clImg;
    Canvas.FillRect(Rect(0,0,Width,Height));
  end;
end;

// =========================================================================
//      
// =========================================================================
//   Polar - 
procedure MarkupDPolar (var RqMP : TMainParm);
const DefOffX    = 10;      // X -       Img
      DefOffY    = 10;      // Y -       Img

begin
  with RqMP.DSpectr.DPolar do
  begin
    //   DSpectr
    OffX := DefOffX;          // X -       Img
    OffY := DefOffY;          // Y -       Img
    cnX := Img.Width  div 2;  // X -    
    cnY := Img.Height div 2;  // Y -    
  end;
end;

//   Polar - 
procedure ShowDPolarAxes (var RqMP : TMainParm);
begin
  with RqMP.DSpectr.DPolar do
  begin
    Img.Canvas.Pen.Mode  := pmCopy;
    Img.Canvas.Pen.Color := clBlack;
    //   
    Img.Canvas.MoveTo(cnX, OffY);
    Img.Canvas.LineTo(cnX, Img.Height  - OffY);
    //   
    Img.Canvas.MoveTo(OffX, cnY);
    Img.Canvas.LineTo(Img.Width - OffX, cnY);
    //    
    Img.Canvas.TextOut(Img.Width - OffX, cnY, '0 ');
    Img.Canvas.TextOut(cnX, OffY, ' 90 ');
    Img.Canvas.TextOut(2, cnY, '180 ');
    Img.Canvas.TextOut(cnX, Img.Height  - 2 * OffY, ' 270 ');

  end;
end;

//       
procedure ReShowDPolar (var RqMP : TMainParm);
const MGrad = 180 / Pi;
var   Ind    : integer;
      Phase  : double;
      VLen   : integer;
begin
  Ind   := RqMP.IndGrm;
  Phase := RqMP.ArrGrm[Ind].PhsM;
  with RqMP.DSpectr.DPolar do
  begin
    Img.Canvas.Pen.Mode  := pmNotXor;
    Img.Canvas.Pen.Color := clGreen;
    if PShow
    then begin
       Img.Canvas.MoveTo(cnX, cnY);
       Img.Canvas.LineTo(VX, VY);
       //  -   
       PShow := False;
    end;
    if not PShow
    then begin
       VLen := (Img.Height - (4 * OffY)) div 2;
       VX   := cnX + Trunc(VLen * Cos(Phase));
       VY   := cnY - Trunc(VLen * Sin(Phase));
       Img.Canvas.MoveTo(cnX, cnY);
       Img.Canvas.LineTo(VX, VY);
       //     
       Img.Canvas.TextOut(4, 16, Format(' %5.2f  ',[MGrad * Phase]));
       //  -   
       PShow := True;
    end;
  end;
end;

//   Polar - 
procedure ShowDPolar (var RqMP : TMainParm);
begin
   //  RqImage
   ClearImage (RqMP.DSpectr.DPolar.Img);
   //   Polar -
   MarkupDPolar (RqMP);
   //   Polar -
   ShowDPolarAxes (RqMP);
   //   ReShowDPolar
   with RqMP.DSpectr.DPolar do
   begin
     //    
     Img.Canvas.TextOut(4, 4,
                        Format('. %2d  ', [RqMP.IndGrm]));
     //   -   
     PShow := False;
   end;
   //    
   ReShowDPolar (RqMP);
end;

// =========================================================================
//   
// =========================================================================
//       
procedure MarkupDSpectr (var RqMP : TMainParm);
const DefMaxYPn  = 10;      // .    Y
      DefOffX    = 44;      // X -       Img
      DefOffY    = 26;      // Y -       Img
      DefPntL    = 6;       //    
begin
  with RqMP.DSpectr do
  begin
    //   DSpectr
    MaxYPn := DefMaxYPn;      // .    Y
    OffX   := DefOffX;        // X -       Img
    OffY   := DefOffY;        // Y -       Img
    PntL   := DefPntL;        //    
  end;
end;

//         
procedure ScaleDSpectr (var RqMP : TMainParm);
var LenX  : integer;
    LenY  : integer;
begin
  with RqMP.DSpectr do
  begin
    XSc := 0;  //   X
    YSc := 0;  //   Y
    if (Length(RqMP.ArrGrm) < 1) then Exit;
    //    
    AmpMax  := FindAbsMaxAmp(RqMP);
    //     
    LenX := Img.Width  - OffX - OffX div 4;
    LenY := Img.Height - 2 * OffY;
    //     X
    XSc := LenX / GrmMaxNum;
    //     Y
    if AmpMax > 0  then YSc := LenY / AmpMax;
  end;
end;

//      -   Spectr - 
procedure ShowDSpectrXCaption (var RqMP : TMainParm);
var   Ind        : integer;
      wX, wY     : integer;
begin
  with RqMP.DSpectr do
  begin
    wY := Img.Height - OffY;
    if (Length(RqMP.ArrGrm) < 1) or (XSc <= 0) then Exit;
    for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm) do
    begin
      //     X
      wX := OffX + Trunc(XSc * Ind);
      //    
      Img.Canvas.Font.Color := clBlack;
      // -----------------------------------
      //   
      if (RqMP.ArrGrm[Ind].ModATp > 0)
      then Img.Canvas.Font.Color := clLime;
      if (RqMP.ArrGrm[Ind].ModPTp > 0)
      then Img.Canvas.Font.Color := clBlue;
      if (RqMP.ArrGrm[Ind].ModATp > 0) and (RqMP.ArrGrm[Ind].ModPTp > 0)
      then Img.Canvas.Font.Color := clYellow;
      // -----------------------------------
      if Ind = RqMP.IndGrm then Img.Canvas.Font.Color := clRed;
      //  
      Img.Canvas.TextOut(wX, wY + PntL, IntToStr(Ind));
    end;
    Img.Canvas.Font.Color := clBlack;
  end;
end;

//       
procedure ShowDSpectrAxes (var RqMP : TMainParm);
var   Ind               : integer;
      wX, wXB, zY, wY   : integer;
      wStr              : string;
begin
  with RqMP.DSpectr do
  begin
    if Length(RqMP.ArrGrm) < 1 then Exit;
    //   
    Img.Canvas.Font.Name := 'Arial';
    Img.Canvas.Font.Size := 8;
    Img.Canvas.Pen.Color := clBlack;
    Img.Canvas.Pen.Mode  := pmCopy;
    //   X
    Img.Canvas.MoveTo (OffX, Img.Height - OffY);
    Img.Canvas.LineTo(Img.Width - OffX div 2, Img.Height - OffY);
    zY := Img.Height - OffY;

    for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm) do
    begin
     wX := OffX + Trunc(XSc * Ind);
     Img.Canvas.MoveTo (wX, zY);
     Img.Canvas.LineTo (wX, zY + PntL);
     Img.Canvas.TextOut(wX, zY + PntL, IntToStr(Ind));
    end;
    //   Y
    Img.Canvas.MoveTo (OffX, OffY);
    Img.Canvas.LineTo (OffX, Img.Height - OffY);
    wX := OffX;
    for Ind := 0 to MaxYPn do
    begin
     wY := zY - Trunc((Img.Height - 2 * OffY) * Ind / MaxYPn);
     Img.Canvas.MoveTo (wX, wY);
     Img.Canvas.LineTo (wX - PntL, wY);
     if AmpMax >= 10
     then wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 3, 0)
     else wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 1, 4);
     wXB := Img.Canvas.TextWidth(wStr);
     Img.Canvas.TextOut(OffX - wXB - PntL,  wY, wStr);
    end;
  end;
end;

//        
procedure ReShowDSpectr (var RqMP : TMainParm);
var Ind        : integer;
    wX, zY, wY : integer;
begin
  with RqMP.DSpectr do
  begin
    //   
    Img.Canvas.Pen.Mode := pmNotXor;
    //    Y
    zY := Img.Height - OffY;
    //    
    if (Length(RqMP.ArrGrm) > 0) and DSShow
    then begin
      for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm)
      do begin
        Img.Canvas.Pen.Color := RqMP.ArrGrm[Ind].DCL;
        Img.Canvas.MoveTo(RqMP.ArrGrm[Ind].DXP, RqMP.ArrGrm[Ind].DYP);
        Img.Canvas.LineTo(RqMP.ArrGrm[Ind].DXP, zY);
      end;
      DSShow := False;  //  
    end;
    //   
    if (Length(RqMP.ArrGrm) > 0) and (not DSShow)
    then begin
       for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm)
       do begin
         if not RqMP.ArrGrm[Ind].ModTOn
         then begin
           //  X -   () 
           wX := OffX + Trunc(XSc * Ind);
           RqMP.ArrGrm[Ind].DCL := clGreen;
         end
         else begin
            //  X -   
            wX := OffX + Trunc(XSc * (Ind + RqMP.ArrGrm[Ind].PrdMM));
            RqMP.ArrGrm[Ind].DCL := RGB($80,$20,$20);
         end;
         //     
         RqMP.ArrGrm[Ind].DXP := wX;
         //   Y -  
         wY := zY -  Trunc(YSc * Abs(RqMP.ArrGrm[Ind].AmpM));
         RqMP.ArrGrm[Ind].DYP := wY;
         //   
         Img.Canvas.Pen.Color := RqMP.ArrGrm[Ind].DCL;
         Img.Canvas.MoveTo(wX, wY);
         Img.Canvas.LineTo(wX, zY);
       end;
       DSShow := True;  //  
    end;
  end;
end;

//      
procedure ShowDSpectr (var RqMP : TMainParm);
begin
  //  RqImage
  ClearImage (RqMP.DSpectr.Img);
  //       
  MarkupDSpectr (RqMP);
  //   
  if Length(RqMP.ArrGrm) < 1 then Exit;
  //    
  RqMP.DSpectr.AmpMax  := FindAbsMaxAmp(RqMP);
  //   
  ScaleDSpectr (RqMP);
  //       
  ShowDSpectrAxes (RqMP);
  //        
  RqMP.DSpectr.DSShow := False;
  ReShowDSpectr (RqMP);
end;

// =========================================================================
//   
// =========================================================================
//    
procedure MarkupDSignal (var RqMP : TMainParm);
const DefMaxYPn  = 5;       //   Y    X
      DefOffX    = 44;      // X -       Img
      DefOffY    = 20;      // Y -       Img
      DefPntL    = 4;       //    
begin
  with RqMP.DSignal do
  begin
    //   DSignal
    MaxXPn := RqMP.DigNum;         //    X
    MaxYPn := DefMaxYPn;           //   Y    X
    OffX   := DefOffX;             // X -    Img
    OffY   := DefOffY;             // Y -    Img
    LenX   := (Img.Width  - 2 * OffX);
    LenY   := (Img.Height - 2 * OffY);
    PntL   := DefPntL;             //    
    XZero := OffX;                 //    X
    YZero := OffY + (LenY div 2);  //    Y
  end;
end;

//    
procedure ShowDSignalAxes (var RqMP : TMainParm);
const DefXTit    : array [0..8] of string =
      ('','45','90','135','180','225','270','315','360');
var wX, wY : integer;
    Ind    : integer;
    wStr   : string;
begin
  with RqMP.DSignal
  do begin
    //   
    Img.Canvas.Font.Name := 'Arial';
    Img.Canvas.Font.Size := 8;
    Img.Canvas.Pen.Color := clBlack;
    Img.Canvas.Pen.Mode  := pmCopy;
    //   X
    Img.Canvas.MoveTo(XZero, YZero);
    Img.Canvas.LineTo(Img.Width - OffX, YZero);
    //    X
    for Ind := 0 to High(DefXTit) do
    begin
      wX := XZero + Trunc( LenX * Ind / High(DefXTit) );
      Img.Canvas.MoveTo (wX, YZero);
      Img.Canvas.LineTo (wX, YZero + PntL);
      Img.Canvas.TextOut(wX, YZero + PntL, DefXTit[Ind]);
    end;
    //   Y
    Img.Canvas.MoveTo (XZero, OffY);
    Img.Canvas.LineTo (XZero, Img.Height - OffY);
    //     
    for Ind := 0 to MaxYPn do
    begin
     wY := YZero - Trunc((LenY div 2) * Ind / MaxYPn);
     Img.Canvas.MoveTo (XZero, wY);
     Img.Canvas.LineTo (XZero - PntL, wY);
     if AmpMax >= 10
     then wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 3, 0)
     else wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 1, 4);
     wX := XZero - PntL - Img.Canvas.TextWidth(wStr);
     Img.Canvas.TextOut(wX,  wY,  wStr);
    end;
    //     
    for Ind := 1 to MaxYPn do
    begin
     wY := YZero + Trunc((LenY div 2) * Ind / MaxYPn);
     Img.Canvas.MoveTo (XZero, wY);
     Img.Canvas.LineTo (XZero - PntL, wY);
     if AmpMax >= 10
     then wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 3, 0)
     else wStr := FloatToStrF(AmpMax * Ind / MaxYPn, ffFixed, 1, 4);
     wStr := '-' + wStr;
     wX := XZero - PntL - Img.Canvas.TextWidth(wStr);
     Img.Canvas.TextOut(wX,  wY, wStr);
    end;
  end;
end;

//          
procedure ReShowDSignal (var RqMP : TMainParm);
var   Ind : integer;
begin
  with RqMP.DSignal do
  begin
    if (Length(RqMP.ArrSg) > 1) and SgShow
    then begin
      //  pmNotXor -  
      for Ind := Low(RqMP.ArrSg) to High(RqMP.ArrSg)
      do begin
        if Ind = Low(RqMP.ArrSg)
        then Img.Canvas.MoveTo(RqMP.ArrSg[Ind].XP, RqMP.ArrSg[Ind].YP)
        else Img.Canvas.LineTo(RqMP.ArrSg[Ind].XP, RqMP.ArrSg[Ind].YP);
      end;
      SgShow := False;  //  pmNotXor -   
    end;
    if (Length(RqMP.ArrSg) > 1) and (not SgShow)
    then begin
      //   pmNotXor -  
      for Ind := Low(RqMP.ArrSg) to High(RqMP.ArrSg)
      do begin
        //      
        RqMP.ArrSg[Ind].YP := YZero - Trunc(YSc * RqMP.ArrSg[Ind].Y);
        RqMP.ArrSg[Ind].XP := XZero + Trunc(XSc * Ind);
        //    
        if Ind = Low(RqMP.ArrSg)
        then Img.Canvas.MoveTo(RqMP.ArrSg[Ind].XP, RqMP.ArrSg[Ind].YP)
        else Img.Canvas.LineTo(RqMP.ArrSg[Ind].XP, RqMP.ArrSg[Ind].YP);
      end;
      SgShow := True;   //  pmNotXor -  
    end;
  end;
end;

//    
procedure ShowDSignal (var RqMP : TMainParm);
begin
    //  RqImage
    ClearImage (RqMP.DSignal.Img);
    //    
    MarkupDSignal (RqMP);
    with RqMP.DSignal do
    begin
       //    
       if Abs(RqMP.maxSY) > Abs(RqMP.minSY)
       then AmpMax := Abs(RqMP.maxSY)
       else AmpMax := Abs(RqMP.minSY);
       //    YSc  XSc
       if AmpMax > 0 then YSc := (LenY div 2)/AmpMax else YSc := 0;
       XSc := LenX / High(RqMP.ArrSg);
       //  Image DSignal
       ClearImage (Img);
       //   
       ShowDSignalAxes(RqMP);
       //   
       Img.Canvas.Pen.Color := clGreen;
       Img.Canvas.Pen.Mode  := pmNotXor;
       SgShow := False;
       ReShowDSignal (RqMP);
    end;
end;


end.
