unit SpectrumDFT;
// ================================================================
//
//   
//
//       
//     .   
//    TArr3Folds,    
//         .
//      
//  ,      
//  TTSimp.
//     , 
//    PrepareAndShowSpectr.
//
//   :
// 1. InitArrSnCs           //   SIN  COS
// 2. CalcSimpsonMhetod     //   
// 3. PrepareAndShowSpectr  //    
//
// ================================================================
interface
uses Math, GlobalDATA, SpectrumDATA, SpectrumDisplay;

// ================================================================
//   
// ================================================================
//    SIN  COS   
type TSnCs = record
   Ph  : double;     //   
   Sn  : double;     //  SIN
   Cs  : double;     //  COS
end;
//   SIN  COS   
type TArrSnCs = array[0..DigMaxNum-1] of TSnCs;

// ----------------------------------------------------------------
//         
type TFolds = record
   Y  : double;                            //    
   Ya : double;                            //     
   Yk : double;                            //     
   Fs : array [1..GrmMaxNum-1] of double;  //    SIN's  
   Fc : array [1..GrmMaxNum-1] of double;  //    COS's  
end;

//         
type TArr3Folds = array[0..2] of TFolds;

// ----------------------------------------------------------------
//       
type TSSum = record
   S0   : double;     //      : ( 0  2 )
   S1   : double;     //      : ( 1 )
   S2   : double;     //      
   SUM  : double;     //    
   Amp  : double;     //   
end;

//          
type TTSimp = record
   SY  : TSSum;                            // . 
   SYa : TSSum;                            // .  
   SYk : TSSum;                            // .  
   SFs : array [1..GrmMaxNum-1] of TSSum;  // .    SIN's
   SFc : array [1..GrmMaxNum-1] of TSSum;  // .    COS's
end;

// ================================================================
//   
// ================================================================
//  SIN  COS   
var ArrSnCs : TArrSnCs;

// ----------------------------------------------------------------
//        
var Arr3Folds : TArr3Folds;

//         
var TSimp    : TTSimp;

// ================================================================
//
// ================================================================
// ----------------------------------------------------------------
//   SIN  COS
procedure InitArrSnCs (var RqArrSnCs : TArrSnCs);
// ----------------------------------------------------------------
//       
procedure CalcSimpsonMhetod   (
                 RqBufDat     : TBufSignalData;  //  
                 RqArrSnCs    : TArrSnCs;        //  SIN  COS
             var RqTSimp      : TTSimp;
             var RqArr3Folds  : TArr3Folds
                              );
// ----------------------------------------------------------------
//      .
procedure PrepareAndShowSpectr(
                      RqRSC   : boolean;    //   
                      RqTSimp : TTSimp;
                  var RqMP    : TMainParm
                              );

// ================================================================
// ================================================================
implementation
// ================================================================
// ================================================================

// ----------------------------------------------------------------
//   SIN  COS
procedure InitArrSnCs (var RqArrSnCs : TArrSnCs);
var StepSnCs : double;   //     RqArrSnCs
    Ind      : integer;  //  
begin
  StepSnCs := 2 * Pi / High(RqArrSnCs);
  for Ind := 0 to High(RqArrSnCs)
  do begin
     RqArrSnCs[Ind].Ph := StepSnCs * Ind;
     RqArrSnCs[Ind].Sn := SIN(RqArrSnCs[Ind].Ph);
     RqArrSnCs[Ind].Cs := COS(RqArrSnCs[Ind].Ph);
  end;
end;
// ----------------------------------------------------------------
//        RqArr3Folds 
//      (IndP)  () .
//      CalcSimpsonMhetod
procedure CalcFolds(
       IndPMax     : integer;    //   
       IndP        : integer;    //   
       YP          : double;     //     IndP
       IndG        : integer;    //   
       RqArrSnCs   : TArrSnCs;   //  SIN  COS
       IndW        : integer;    //    RqArr3Folds
   var RqArr3Folds : TArr3Folds  //    
                   );
var   wIndP  : integer;          //    
      wIndG  : integer;          //   
begin
    //        RqArr3Folds
    RqArr3Folds[IndW].Y :=  YP;        //   
    RqArr3Folds[IndW].Ya := Abs(YP);   //    
    RqArr3Folds[IndW].Yk := YP * YP;   //    
    //        RqArr3Folds
    wIndP := IndP;
    wIndG := 1;
    while wIndG <= IndG do
    begin
      //    (wIndP)   
      if wIndP > IndPMax then wIndP := wIndP - IndPMax;
      // ----------------------------------------
      //  SIN    
      RqArr3Folds[IndW].Fs[wIndG] := YP * RqArrSnCs[wIndP].Sn;
      //  COS    
      RqArr3Folds[IndW].Fc[wIndG] := YP * RqArrSnCs[wIndP].Cs;
      // ----------------------------------------
      wIndP := wIndP + IndP;
      Inc(wIndG);
    end;
end;
// ----------------------------------------------------------------
//         
//     CalcSimpsonMhetod
procedure CalcSimpPartSum (
                  IndR0   : integer;    //    0
                  IndR1   : integer;    //    1
                  IndR2   : integer;    //    2
                  IndG    : integer;    //   
              var RqTSimp : TTSimp;     //   
              var RqFolds : TArr3Folds  //    
                          );
var  wIndG : integer;
begin
   with RqTSimp
   do begin
      // ---------------------------------------------
      //      
      SY.S0 := SY.S0 + RqFolds[IndR0].Y + RqFolds[IndR2].Y;
      SY.S1 := SY.S1 + RqFolds[IndR1].Y;
      //
      SYa.S0 := SYa.S0 + RqFolds[IndR0].Ya + RqFolds[IndR2].Ya;
      SYa.S1 := SYa.S1 + RqFolds[IndR1].Ya;
      //
      SYk.S0 := SYk.S0 + RqFolds[IndR0].Yk  + RqFolds[IndR2].Yk;
      SYk.S1 := SYk.S1 + RqFolds[IndR1].Yk;
      // ---------------------------------------------
      for wIndG := 1 to IndG
      do begin
         SFs[wIndG].S0 := SFs[wIndG].S0 + RqFolds[IndR0].Fs[wIndG]
                                        + RqFolds[IndR2].Fs[wIndG];
         SFs[wIndG].S1 := SFs[wIndG].S1 + RqFolds[IndR1].Fs[wIndG];

         SFc[wIndG].S0 := SFc[wIndG].S0 + RqFolds[IndR0].Fc[wIndG]
                                        + RqFolds[IndR2].Fc[wIndG];
         SFc[wIndG].S1 := SFc[wIndG].S1 + RqFolds[IndR1].Fc[wIndG];
      end;
   end;
end;
// ----------------------------------------------------------------
//        
//    .    
// CalcSimpsonMhetod.
procedure CalcTrapezPartSum (
                    IndR0   : integer;    //    0
                    IndR1   : integer;    //    1
                    IndG    : integer;    //   
                var RqTSimp : TTSimp;     //   
                var RqFolds : TArr3Folds  //    
                            );
var  wIndG : integer;
begin
  with RqTSimp
  do begin
   //     
   SY.S2  := (RqFolds[IndR0].Y  + RqFolds[IndR1].Y) /2;
   SYa.S2 := (RqFolds[IndR0].Ya + RqFolds[IndR1].Ya)/2;
   SYk.S2 := (RqFolds[IndR0].Yk + RqFolds[IndR1].Yk)/2;
   for wIndG := 1 to IndG
   do begin
     SFs[wIndG].S2 := (RqFolds[IndR0].Fs[wIndG] + RqFolds[IndR1].Fs[wIndG])/2;
     SFc[wIndG].S2 := (RqFolds[IndR0].Fc[wIndG] + RqFolds[IndR1].Fc[wIndG])/2;
   end;
  end;
end;
// ----------------------------------------------------------------
//       
//   : B[i]*COS(i*X) + A[i]*SIN(i*X). 
//    CalcSimpsonMhetod.
procedure CalcSignalParm(
                IndPMax : Word;     // High(RqBufDat) .   
                IndG    : integer;  //   
            var RqTSimp : TTSimp    //   
                        );
var  wIndG : integer;
begin
  with RqTSimp do
  begin
    //      
    //      
    SY.SUM  := SY.S2  + (SY.S0  + 4 * SY.S1 )/3;
    SYa.SUM := SYa.S2 + (SYa.S0 + 4 * SYa.S1)/3;
    SYk.SUM := SYk.S2 + (SYk.S0 + 4 * SYk.S1)/3;
    for wIndG := 1 to IndG
    do begin
      SFs[wIndG].SUM := SFs[wIndG].S2 + (SFs[wIndG].S0 + 4 * SFs[wIndG].S1)/3;
      SFc[wIndG].SUM := SFc[wIndG].S2 + (SFc[wIndG].S0 + 4 * SFc[wIndG].S1)/3;
    end;
    //   
    SY.Amp   := SY.SUM  / IndPMax;
    SYa.Amp  := SYa.SUM / IndPMax;
    SYk.Amp  := Sqrt(SYk.SUM / IndPMax);
    //    
    for wIndG := 1 to IndG
    do begin
      SFs[wIndG].Amp := 2 * SFs[wIndG].SUM / IndPMax;
      SFc[wIndG].Amp := 2 * SFc[wIndG].SUM / IndPMax;
    end;
  end;
end;

// ----------------------------------------------------------------
//       
procedure CalcSimpsonMhetod  (
                 RqBufDat    : TBufSignalData;   //  
                 RqArrSnCs   : TArrSnCs;         //  SIN  COS
             var RqTSimp     : TTSimp;
             var RqArr3Folds : TArr3Folds
                             );
//   
const ArrC : array [0..2, 0..2] of word =
(
  (0,1,2),  //    RqArr3Folds   IndC = 0
  (2,0,1),  //    RqArr3Folds   IndC = 1
  (1,2,0)   //    RqArr3Folds   IndC = 2
);
var   IndPMax  : Word;    // High(RqBufDat) .   
      IndP     : Word;    //     RqBufDat
      YP       : double;  //   
      IndW     : Word;    //     RqArr3Folds
      IndL     : Word;    //      
      //     RqArr3Folds
      IndWMax  : word;    // High(RqArr3Folds)    RqArr3Folds
      IndC     : Word;    //     RqArr3Folds
      IndR0    : Word;    //    0   RqArr3Folds
      IndR1    : Word;    //    1   RqArr3Folds
      IndR2    : Word;    //    2   RqArr3Folds
begin
    //   
    IndPMax := High(RqBufDat);        // .   
    IndWMax := High(RqArr3Folds);     //    RqArr3Folds
    //   
    IndW := 0; IndL := 0; IndC := 0;
    //  
    FillChar(RqTSimp, SizeOF(RqTSimp), #0);
    //     
    for IndP := 0 to IndPMax
    do begin
       //     
       YP := RqBufDat[IndP];
       // -----------------------------
       //      RqArr3Folds
       if IndW > IndWMax then IndW := 0;
       CalcFolds(IndPMax, IndP, YP,
                 GrmMaxNum-1, RqArrSnCs, IndW,RqArr3Folds);
       Inc(IndW);             //  
       // -----------------------------
       //   
       if (IndP and $00000001) = 0  //  
       then begin
          if IndP > 0
          then begin
             if IndC > High(ArrC) then IndC := 0;
             //      
             // ---------------------------------------------
             //      
             IndR0 := ArrC[IndC, 0]; //    0
             IndR1 := ArrC[IndC, 1]; //    1
             IndR2 := ArrC[IndC, 2]; //    2
             //       
             CalcSimpPartSum (IndR0, IndR1, IndR2,
                              GrmMaxNum-1, RqTSimp, RqArr3Folds);
             // ---------------------------------------------
             IndL := IndP;  //   ,   
             Inc(IndC);     //   
          end;
       end; // of    
       // ---------------------------------------------
       //     
       //    High(RqBufDat) 
       if IndP = IndPMax
       then begin
         if IndL < IndP
         then begin
            //   
            if IndC > High(ArrC) then IndC := 0;
            //      
            IndR0 := ArrC[IndC, 0]; //    0
            IndR1 := ArrC[IndC, 1]; //    1
            CalcTrapezPartSum (IndR0, IndR1, GrmMaxNum-1,
                               RqTSimp, RqArr3Folds);
         end;
       end;
       // ---------------------------------------------
    end; // of for IndP
    //    
    CalcSignalParm(IndPMax, GrmMaxNum-1, RqTSimp);
end;

// ----------------------------------------------------------------
//      
procedure PrepareAndShowSpectr(
                      RqRSC   : boolean;   //   
                      RqTSimp : TTSimp;
                  var RqMP    : TMainParm);
//
const TwoPi = 2 * Pi;   // "   "
var   Ind   : integer;
      wAmp  : double;
      wPhs  : double;
begin
    //    
    if RqRSC then RqMP.ArrGrm[0].Amp := Abs(RqTSimp.SY.Amp);
    RqMP.ArrGrm[0].AmpM  := Abs(RqTSimp.SY.Amp);
    RqMP.ArrGrm[0].PhsM  := 0;
    RqMP.ArrGrm[0].PhsG  := 0;
    RqMP.ArrGrm[0].PhsT  := 0;
    //      
    RqMP.MaxGrm := RqMP.ArrGrm[0].Amp;
    RqMP.MaxGrmInd := 0;
    //     
    for Ind := 1 to High(RqTSimp.SFs)
    do begin
       //    
       wAmp := Sqrt(IntPower(RqTSimp.SFs[Ind].Amp,2)
                  + IntPower(RqTSimp.SFc[Ind].Amp,2));
       //       
       if wAmp > RqMP.MaxGrm
       then begin
           RqMP.MaxGrm := wAmp;
           RqMP.MaxGrmInd := Ind;
       end;
       //    
       wPhs := 0;
       if wAmp > 1e-10       //   
       then begin
          // I 
          wPhs := ARCSIN(Abs(RqTSimp.SFc[Ind].Amp) / wAmp);
          if RqTSimp.SFc[Ind].Amp >= 0
          then begin         // I  II    ( b + )
             if RqTSimp.SFs[Ind].Amp < 0
             then wPhs := Pi - wPhs;       // II 
          end
          else begin         // III  IV  ( b - )
             if RqTSimp.SFs[Ind].Amp < 0
             then wPhs := wPhs + Pi        // III 
             else wPhs := TwoPi - wPhs;    // IV  
          end;
       end;
       //    
       with RqMP
       do begin
         if RqRSC then ArrGrm[Ind].Amp := wAmp;
         ArrGrm[Ind].AmpM := wAmp;
         ArrGrm[Ind].PhsM := wPhs;             //   
         ArrGrm[Ind].PhsG := wPhs * 180 / Pi;  //   
         //     (  )
         if Frequency > 0
         then begin
            ArrGrm[Ind].FrqM := RqMP.Frequency * Ind;
            ArrGrm[Ind].PrdM := RqMP.Period / Ind;
            //    
            ArrGrm[Ind].PhsT := wPhs * ArrGrm[Ind].PrdM / TwoPi; //   ms
         end
         else begin
            ArrGrm[Ind].FrqM := 0;
            ArrGrm[Ind].PrdM := 0;
            ArrGrm[Ind].PhsT := 0;
         end;
       end;
    end;
    //      
    if RqRSC or (not RqMP.DSpectr.DSShow)
    then ShowDSpectr (RqMP)
    else ReShowDSpectr (RqMP);
    //       Polar - 
    if not RqMP.DSpectr.DPolar.PShow
    then ShowDPolar (RqMP)
    else ReShowDPolar (RqMP);
end;

// ================================================================
// ================================================================
end.
