unit SpectrumDATA;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, GlobalDATA;

// =========================================================================
const cAppVersion   = ' v.5.02. 2013.';
const cAppTitle = '  Freeware.'
                   + '  .'
                   + cAppVersion;

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//        
// -------------------------------------------------------------------------
//        
type TGarmonics = record
   //-----------------------
   //    (   )
   Amp    : double;         //   
   AmpM   : double;         //   
   //-----------------------
   //     
   FrqM   : double;         //    
   PrdM   : double;         //    ms
   //-----------------------
   //   
   PhsM   : double;         //    
   PhsG   : double;         //     
   PhsT   : double;         //     (ms)
   //-----------------------
   //   
   //     
   //    .
   ModATp : integer;        //  ( <> 0)  
   ModPTp : integer;        //  ( <> 0)  
   ModTOn : boolean;        //    
   PrdMM  : double;         //    (GrmInd (+..-) 0,X)
   //-----------------------
   //      
   DXP    : integer;        //  X - 
   DYP    : integer;        //  Y - 
   DCL    : TColor;         //   
end;

//     
type TArrGarmonics = array of TGarmonics;

// -------------------------------------------------------------------------
//      
// -------------------------------------------------------------------------
//       
type TSignal = record
     //     ( Y := Func(X))
     X   : double;       //  X  
     Y   : double;       //  Y
     //   
     XP  : integer;      //  X - 
     YP  : integer;      //  Y - 
end;

//    
type TArrSignal = array of TSignal;

// -------------------------------------------------------------------------
//   
type TDSignal = record
     Img    : TImage;       // Image   
     MaxXPn : byte;         // .    X
     MaxYPn : byte;         // .    Y
     PntL   : byte;         //    
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     LenX   : integer;      // X -     
     LenY   : integer;      // Y -     
     XZero  : integer;      // X -     
     YZero  : integer;      // Y -     
     AmpMax : double;       //    
     YSc    : double;       // .   Y
     XSc    : double;       // .   X
     SgShow : boolean;      //    
end;
// -------------------------------------------------------------------------
//      
type TDPolar = record
     Img    : TImage;       // Image   
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     cnX    : integer;      // X -    
     cnY    : integer;      // Y -    
     PShow  : boolean;      //     
     VX     : integer;      //  X -   
     VY     : integer;      //  Y -   
end;
// -------------------------------------------------------------------------
//    
type TDSpectr = record
     Img    : TImage;       // Image   
     MaxYPn : byte;         // .    Y
     PntL   : byte;         //    
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     AmpMax : double;       //    
     YSc    : double;       // .   Y
     XSc    : double;       // .   X
     DSShow : boolean;      //     
     //       
     DPolar : TDPolar;
end;

// =========================================================================
//         
// =========================================================================
type TMainParm = record
   // -------------------------------------------------
   //  
   // -------------------------------------------------
   //   
   ArrSg     : TArrSignal;  //  
   //   
   Period    : double;      //     (ms)
   Frequency : double;      //   
   DigNum    : integer;     //   
   // -------------------------------------------------
   //  
   // -------------------------------------------------
   //   
   NumGrm    : integer;     //   
   IndGrm    : integer;     //   
   ArrGrm    : TArrGarmonics;  //   
   MaxGrm    : double;      //     
   MaxGrmInd : integer;     //  .    
   //   
   minSY     : double;      //   
   maxSY     : double;      //   
   MAAmp     : double;      //   
   MRAmp     : double;      //  () 
   //    
   LenSer    : integer;     //     
   minYSer   : double;      //    
   maxYSer   : double;      //    
   //       
   DSpectr   : TDSpectr;    //    
   DSignal   : TDSignal;    //    
end;

// =========================================================================
//       
// =========================================================================
//    
type TStatSignal = record
   SerNum    : integer;     //   
   SerLen    : integer;     //     
   SerCt     : integer;     //   
   SerMinSY  : double;      //     
   SerMaxSY  : double;      //     
   SerMAAmp  : double;      //    
   SerMRAmp  : double;      //    
end;

// =========================================================================
//     
// =========================================================================
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;


// =========================================================================
//   ()  
// =========================================================================
//     
//     
const GrmMaxNum  = GlobalGrmMaxNum;

//      (8   32 )
// !         
const DigMaxNum = 8 * GrmMaxNum + 1;

// =========================================================================
//   
// =========================================================================
// .      
const MaxCountMessages = 1000;

// .      
const MaxCountSeries = 250;

// =========================================================================
//   
// =========================================================================

//   
var AppStartDir : string;

//     
var  SpectrumMainParm      : TMainParm;

// -------------------------------------------------------------------------
//      
// -------------------------------------------------------------------------
//     
var RqGetSignal : boolean;

//        
var RqRescaleDSignal : boolean;

//        
var RqRescaleDSpectr : boolean;

// =========================================================================
//    
// =========================================================================

var SignalBufer : TGLSignalBufer;

// =========================================================================
//       
// =========================================================================

//    
var   StatSignal : TStatSignal;

// =========================================================================
//    
// =========================================================================

//     " "
function NormalizePhase (RqPhs : double) : double;

implementation

//     " "
function NormalizePhase (RqPhs : double) : double;
const TwoPi = 2 * Pi;
begin
  if RqPhs > TwoPi
  then Result := Frac(RqPhs / TwoPi) * TwoPi
  else Result := RqPhs;
end;

end.
