unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ExtDlgs, ComCtrls,
  GlobalDATA,
  GeneratorMAIN, SpectrumMAIN;

type
  TMainForm = class(TForm)
    BttRunGenerator: TButton;
    BttRunSpectrum: TButton;
    PanelArrow: TPanel;
    ImgArrow: TImage;
    lbNumPoint: TLabel;
    sttxtNumPoint: TStaticText;
    sttxtNumPackets: TStaticText;
    lbNumPacket: TLabel;
    procedure BttRunGeneratorClick(Sender: TObject);
    procedure BttRunSpectrumClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
     procedure MoveImgArrow();

  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;


implementation
{$R *.dfm}

//      
var NumPackets : cardinal;

// =========================================================================
//  
// =========================================================================
//  
procedure TMainForm.BttRunGeneratorClick(Sender: TObject);
begin
 GeneratorFrm.Show;
end;
// -------------------------------------------------------------------------
//   
procedure TMainForm.BttRunSpectrumClick(Sender: TObject);
begin
  SpectrumForm.Show;
end;
// -------------------------------------------------------------------------
//       
procedure TMainForm.MoveImgArrow();
const Step = 2;
begin
   if (ImgArrow.Left + Step) > (PanelArrow.Width - ImgArrow.Width)
   then ImgArrow.Left := 0
   else ImgArrow.Left := ImgArrow.Left + Step;
   if NumPackets > 4200000000
   then NumPackets := 0
   else begin
     sttxtNumPackets.Caption := IntToStr(NumPackets);
     NumPackets := NumPackets + 1;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TMainForm.FormCreate(Sender: TObject);
begin
   TraficInfoRunProc := MoveImgArrow;
   sttxtNumPoint.Caption := IntToStr(GlobalDigMaxNum);
   NumPackets := 0;
end;
 // -------------------------------------------------------------------------
//  
procedure TMainForm.FormDestroy(Sender: TObject);
begin
   SpectrumRunProc   := nil;
   TraficInfoRunProc := nil;
   Sleep(10);
end;
// =========================================================================
// 
// =========================================================================
end.
