unit GeneratorToExcel;

interface

uses SysUtils, Dialogs,
     ComObj,
     GeneratorDATA;

//     Excel
procedure ExportToExcel();

implementation

// =========================================================================
//    EXCEL
// =========================================================================
type TXLTitle = record
  S1   : string;    //    
  S2   : string;    //    
  CW   : byte;      //  
  AH   : byte;      //     
  AV   : byte;      //     
end;

const BegRow       = 3;  //  
const
      SpectrBegCol = 2;   //    
      SignalBegCol = 8;   //    

const ArrXlsSpectr : array[0..4] of TXLTitle =
(
 (S1 : '';      S2 : 'n (.)';     CW : 12; AH : 4; AV : 2),
 (S1 : '';   S2 : 'A[n]';          CW : 14; AH : 4; AV : 2),
 (S1 : '. ';   S2 : 'P[n] ( .)'; CW : 14; AH : 4; AV : 2),
 (S1 : '. ';   S2 : '( .)';     CW : 14; AH : 4; AV : 2),
 (S1 : '. '; S2 : '( msec)';      CW : 14; AH : 4; AV : 2)
);
const ArrXlsSignal : array[0..4] of TXLTitle =
(
 (S1 : '';      S2 : ' ';       CW : 8;  AH : 4; AV : 2),
 (S1 : '. ';   S2 : 'X ( .)';    CW : 14; AH : 4; AV : 2),
 (S1 : '. ';   S2 : '( .)';     CW : 14; AH : 4; AV : 2),
 (S1 : '. ';   S2 : '( msec)';      CW : 14; AH : 4; AV : 2),
 (S1 : '';      S2 : '';              CW : 38; AH : 4; AV : 2)
);

//      Excel
procedure WriteToExcelSheet(XLApp : Variant);
var Sheet             : Variant;   //    Excel
    wIndR, wIndC, Ind : Integer;
begin
   //     
   Sheet := XLApp.Workbooks[1].WorkSheets[1];
   //     
   for Ind := Low(ArrXlsSpectr) to High(ArrXlsSpectr)
   do begin
     wIndC := SpectrBegCol + Ind;
     with ArrXlsSpectr[Ind] do
     begin
       Sheet.Cells[BegRow,     wIndC]:= S1;
       Sheet.Cells[BegRow + 1, wIndC]:= S2;
     end;
   end;
   //     
   for Ind := Low(ArrXlsSignal) to High(ArrXlsSignal)
   do begin
     wIndC := SignalBegCol + Ind;
     with ArrXlsSignal[Ind] do
     begin
       Sheet.Cells[BegRow, wIndC]:= S1;
       if Ind = High(ArrXlsSignal)
       then begin
          if MainParm.RqCos
          then Sheet.Cells[BegRow + 1, wIndC]:= SumCosTxt
          else Sheet.Cells[BegRow + 1, wIndC]:= SumSinTxt;
       end
       else Sheet.Cells[BegRow + 1, wIndC]:= S2;
     end;
   end;
   //   
   wIndR := BegRow + 2;     //  
   wIndC := SpectrBegCol;
   for Ind := Low(MainParm.ArrGrm) to High(MainParm.ArrGrm) do
   begin
     with MainParm.ArrGrm[Ind] do
     begin
       Sheet.Cells[wIndR + Ind, wIndC] := Ind;          //  
       Sheet.Cells[wIndR + Ind, wIndC + 1] := AmpM;     // 
       Sheet.Cells[wIndR + Ind, wIndC + 2] := PhsM;     //   
       Sheet.Cells[wIndR + Ind, wIndC + 3] := PhsM * 180 / Pi;
       Sheet.Cells[wIndR + Ind, wIndC + 4] := PhsT;     //   (ms)
     end;
   end;
   //   
   wIndR := BegRow + 2;     //  
   wIndC := SignalBegCol;
   for Ind := Low(MainParm.ArrSg) to High(MainParm.ArrSg) do
   begin
     with MainParm.ArrSg[Ind] do
     begin
       Sheet.Cells[wIndR + Ind, wIndC]     := Ind;      //  
       Sheet.Cells[wIndR + Ind, wIndC + 1] := X;        //   
       Sheet.Cells[wIndR + Ind, wIndC + 2] := X  * 180 / Pi;
       Sheet.Cells[wIndR + Ind, wIndC + 3] := T;        //   (ms)
       Sheet.Cells[wIndR + Ind, wIndC + 4] := Y;        // 
     end;
   end;
end;

//      Excel
procedure MarkupExcelSheet(XLApp : Variant);
var wList : Variant;   //      
    Ind   : integer;
    wInd  : integer;
begin
   //      
   wList := XLApp.Workbooks[1].WorkSheets[1].Columns;
   //     
   for Ind := Low(ArrXlsSpectr) to High(ArrXlsSpectr)
   do begin
     wInd := SpectrBegCol + Ind;
     with ArrXlsSpectr[Ind] do
     begin
      wList.Columns[wInd].ColumnWidth := CW;
      wList.Columns[wInd].HorizontalAlignment := AH;
      wList.Columns[wInd].VerticalAlignment := AV;
     end;
   end;
   //     
   for Ind := Low(ArrXlsSignal) to High(ArrXlsSignal)
   do begin
     wInd := SignalBegCol + Ind;
     with ArrXlsSignal[Ind] do
     begin
      wList.Columns[wInd].ColumnWidth := CW;
      wList.Columns[wInd].HorizontalAlignment := AH;
      wList.Columns[wInd].VerticalAlignment := AV;
     end;
   end;
end;

//     Excel
procedure ExportToExcel();
//   OLE unit: ComObj
const xlWorksheet = $FFFFEFB9;  //  (-4167)   
var   XLApp       : Variant;    //   Excel.Application

begin
    try
      //  OLE -   Excel
      XLApp:= CreateOleObject('Excel.Application');
      //  Excel
      XLApp.Visible := True;
      //   
      XLApp.Workbooks.Add(xlWorksheet);
      //    
      XLApp.Workbooks[1].WorkSheets[1].Name := 'Generator';
      //      Excel
      MarkupExcelSheet(XLApp);
      //      Excel
      WriteToExcelSheet(XLApp);
    except
      on EOleSysError
      do begin
         MessageDlg('   EXCEL'
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      on E1: EOleError
      do begin
         MessageDlg('    EXCEL'
                    + #13#10
                    + 'Excel : ' + E1.Message
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
      end;
      // .  : EOleSysError, EOleError, EOleException
    end;
end;


end.
