unit GeneratorSignal;

interface

uses Windows, SysUtils, Dialogs,
     GlobalDATA,
     GeneratorDATA;

//     
procedure MakeSignal (var RqMP  : TMainParm);

//     
function InitGrmFreqPrd (var RqMP : TMainParm) : boolean;

implementation
// =========================================================================
//  
// =========================================================================
// -------------------------------------------------------------------------
//  .  
// -------------------------------------------------------------------------
//        .
//          
function RndModCoeff (RqModLn : integer) : double;
begin
  Result := 0;
  if (RqModLn >= Low(ArrModLen)) and (RqModLn <= High(ArrModLen))
  then begin
    if ArrModLen[RqModLn].Len <> 0
    then begin
      //      
      Result := Random(ArrModLen[RqModLn].Len) / ArrModLen[RqModLn].Len;
    end;
  end;
end;
// -------------------------------------------------------------------------
//        .
//          
function LinModCoeff (RqModLn : integer; var RqCtLn : integer) : double;
begin
  Result := 0;
  if (RqModLn >= Low(ArrModLen)) and (RqModLn <= High(ArrModLen))
  then begin
    if ArrModLen[RqModLn].Len <> 0
    then begin
      //      
      Result := RqCtLn / ArrModLen[RqModLn].Len;
      Inc(RqCtLn);
      if (RqCtLn >= ArrModLen[RqModLn].Len) then RqCtLn := 0;
    end;
  end;
end;
// -------------------------------------------------------------------------
//        
//          
function TrianModCoeff (RqModLn  : integer;
                    var RqModSw  : boolean;
                    var RqCtLn   : integer) : double;
begin
  Result := 0;
  if (RqModLn >= Low(ArrModLen)) and (RqModLn <= High(ArrModLen))
  then begin
    if ArrModLen[RqModLn].Len <> 0
    then begin
       //      
       Result := RqCtLn / ArrModLen[RqModLn].Len;
       //        
       if RqModSw       //    (True) /  (False)
       then begin
          Inc(RqCtLn);
          if RqCtLn >= ArrModLen[RqModLn].Len then RqModSw := False;
       end else begin
          Dec(RqCtLn);
          if RqCtLn < 1 then RqModSw := True;
       end;
    end;
  end;
end;
// -------------------------------------------------------------------------
//       
procedure MakeModAmp (var RqArrGrm : TArrGarmonics);
const RNumM   = 30;       //   Random 
var   wM1,wA1 : double;
      Ind     : integer;
begin
  if Length(RqArrGrm) < 1 then Exit;
  for Ind := Low(RqArrGrm) to High(RqArrGrm)
  do begin
    wA1 := RqArrGrm[Ind].Amp;  //  
    if RqArrGrm[Ind].ModAOn    //   
    then begin
       //       
       wM1 := ArrModAmp[RqArrGrm[Ind].ModADp] / 100;
       case RqArrGrm[Ind].ModATp of
         1 : begin  // Random - 
               wA1 := wA1 - wM1 * wA1 * RndModCoeff(RqArrGrm[Ind].ModALn);
             end;
         2 : begin  //  (-) 
               wA1 := wA1 - wM1 * wA1 * LinModCoeff(RqArrGrm[Ind].ModALn,
                                                    RqArrGrm[Ind].ModACt);
             end;
         3 : begin  //  (+) 
               wA1 := wA1 + wM1 * wA1 * LinModCoeff(RqArrGrm[Ind].ModALn,
                                                    RqArrGrm[Ind].ModACt);
             end;
         4 : begin  //  (-) 
               wA1 := wA1 - wM1 * wA1 * TrianModCoeff(RqArrGrm[Ind].ModALn,
                                                      RqArrGrm[Ind].ModASw,
                                                      RqArrGrm[Ind].ModACt);
             end;
         5 : begin  //  (+) 
               wA1 := wA1 + wM1 * wA1 * TrianModCoeff(RqArrGrm[Ind].ModALn,
                                                      RqArrGrm[Ind].ModASw,
                                                      RqArrGrm[Ind].ModACt);
             end;
       end; // case
    end;
    //   
    RqArrGrm[Ind].AmpM := wA1;
  end;
end;
// -------------------------------------------------------------------------
//       
procedure MakeModPhase(var RqArrGrm : TArrGarmonics);
const RNumM   = 36;        //     
      TRad    = Pi * 2;    //    
var   wM1,wP1 : double;
      Ind     : integer;
begin
  if Length(RqArrGrm) < 1 then Exit;
  for Ind := Low(RqArrGrm) to High(RqArrGrm)
  do begin
     wP1 := 0;
     if RqArrGrm[Ind].ModPOn    //   
     then begin
        //       
        wM1 := ArrModPhs[RqArrGrm[Ind].ModPWd] / 100;
        //   
        case RqArrGrm[Ind].ModPTp of
          1 : begin  // Random - 
                wP1 := wM1 * TRad * RndModCoeff(RqArrGrm[Ind].ModPLn);
              end;
          2 : begin  //  
                wP1 := wM1 * TRad * TrianModCoeff (RqArrGrm[Ind].ModPLn,
                                                   RqArrGrm[Ind].ModPSw,
                                                   RqArrGrm[Ind].ModPCt);
              end;
          3 : begin  //  
                wP1 := wM1 * TRad * LinModCoeff(RqArrGrm[Ind].ModPLn,
                                                RqArrGrm[Ind].ModPCt);
              end;
          else wP1 := 0;
        end; // case
     end;
     //   
     RqArrGrm[Ind].PhsM := RqArrGrm[Ind].Phs + wP1;
     RqArrGrm[Ind].PhsT := RqArrGrm[Ind].Prd
                         * RqArrGrm[Ind].PhsM / TRad;
  end;
end;

// -------------------------------------------------------------------------
//       
procedure MakeModPeriod (var RqMP : TMainParm);
const RNumM   = 36;        //    
      MRan    = 1;         //   
var   wM1,wPMM : double;
      Ind      : integer;
begin
  if Length(RqMP.ArrGrm) < 1 then Exit;
  with RqMP
  do begin
     for Ind := Low(ArrGrm) to High(ArrGrm)
     do begin
        wPMM := 0;             //    
        if ArrGrm[Ind].ModTOn  //   
        then begin
           //      
           wM1 := ArrModPrd[ArrGrm[Ind].ModTWd] / 100;
           //   
           case ArrGrm[Ind].ModTTp of
             1 : begin  // Random - 
                   wPMM := wM1 * MRan * RndModCoeff(ArrGrm[Ind].ModTLn);
                 end;
             2 : begin  //  
                   wPMM := wM1 * MRan * TrianModCoeff (ArrGrm[Ind].ModTLn,
                                                       ArrGrm[Ind].ModTSw,
                                                       ArrGrm[Ind].ModTCt);
                 end;
             3 : begin  //  
                   wPMM := wM1 * MRan * LinModCoeff(ArrGrm[Ind].ModTLn,
                                                    ArrGrm[Ind].ModTCt);
                 end;
             else wPMM := 0;
           end; // of case
        end;  //  of if ArrGrm[Ind].ModTOn
        //       
        ArrGrm[Ind].PrdMM := wPMM;
        //      
        if Ind = 0
        then begin
           ArrGrm[Ind].FrqM  := 0;
           ArrGrm[Ind].PrdM  := Period;
        end
        else begin
           if (Ind + wPMM) > 0
           then begin
              ArrGrm[Ind].FrqM := Frequency * (Ind + wPMM);
              ArrGrm[Ind].PrdM := Period    / (Ind + wPMM);
           end;
        end;
     end;
  end;
end;

// -------------------------------------------------------------------------
//  .   
// -------------------------------------------------------------------------
//     
procedure MakeSignal (var RqMP  : TMainParm);
const
    TRad       = 2 * Pi;
var XS         : double;    //   
    wA1, wP1   : double;    //     
    wPMM       : double;
    X1, X2, Y1 : double;    //      
    Ind1, Ind2 : integer;
begin
  with RqMP do
  begin
    if (DigNum > 0) and (Length(ArrSg) = DigNum)
    then begin
        //   
        MakeModAmp (ArrGrm);
        //    
        MakeModPhase(ArrGrm);
        //    
        MakeModPeriod (RqMP);
        //     / 
        minSY := 0;
        maxSY := 0;
        //   
        XS := TRad / High(ArrSg);
        //      
        for Ind1 := Low(ArrSg) to High(ArrSg)
        do begin
          //      
          X1 := XS * Ind1;
          ArrSg[Ind1].X := X1;
          //      (ms)
          ArrSg[Ind1].T := RqMP.Period * Ind1 / High(ArrSg);
          //     
          Y1 := 0;
          for Ind2 := Low(ArrGrm) to High(ArrGrm)
          do begin
            //     
            wA1 := ArrGrm[Ind2].AmpM;    //  
            wP1 := ArrGrm[Ind2].PhsM;    //   
            wPMM := ArrGrm[Ind2].PrdMM;  //    
            //  
            if Ind2 = 0
            then Y1 := wA1
            else begin
              //    
              X2 := (Ind2 + wPMM) * X1 + wP1;
              if RqMP.RqCos
              then Y1 := Y1 + wA1 * Cos(X2)
              else Y1 := Y1 + wA1 * Sin(X2);
            end;
          end;
          ArrSg[Ind1].Y := Y1;
          //       
          if Y1 < minSY then minSY := Y1;
          if Y1 > maxSY then maxSY := Y1;
       end;
     end;
  end;
end;

// =========================================================================
//       
// =========================================================================
// 10.03.2013
//      
function InitGrmFreqPrd (var RqMP : TMainParm) : boolean;
var Ind : integer;
begin
  Result := False;
  with RqMP do
  begin
    if (Frequency > 0)
    then begin
        //      ms
        Period  := 1000 / Frequency;
        //       ms
        for Ind := Low(ArrGrm) to High(ArrGrm)
        do begin
           if Ind = 0
           then begin
              //      
              ArrGrm[Ind].Frq  := 0;
              ArrGrm[Ind].Prd  := 0;
           end
           else begin
              //      
              ArrGrm[Ind].Frq := Frequency * Ind;
              ArrGrm[Ind].Prd := Period    / Ind;
           end;
           ArrGrm[Ind].FrqM := ArrGrm[Ind].Frq;
           ArrGrm[Ind].PrdM := ArrGrm[Ind].Prd;
        end;
        Result := True;
    end;
  end;
end;

end.
