unit GeneratorReport;

interface
uses Classes, SysUtils, ExtCtrls, Graphics, JPEG,
     GeneratorDATA;

//       
procedure ReportToFile (RqFileName : string; RqMP : TMainParm);

//       
//  RqImg   RqFileName. (RqGF : 'J' - jpg   'B' -bmp)
procedure SavePicture(RqFileName : string; RqImg : TImage; RqGF : char);

implementation

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//  
procedure MakeReport(RqSSist : TStringList; RqMP : TMainParm);
var Ind  : integer;
    wStr : string;
begin
  RqSSist.Clear;
  //    
  wStr := #09 + ' ';
  RqSSist.Add(wStr);
  wStr := #09 + '      '
       +  #09 + '   '
       +  #09 + '.    '
       +  #09 + '.    '
       +  #09 + '.    ';
  RqSSist.Add(wStr);
  wStr := #09 + 'n (.)   '
       +  #09 + 'A[n]        '
       +  #09 + 'P[n] (. )'
       +  #09 + 'P[n] (.)'
       +  #09 + 'P[n] (msec.)';
  RqSSist.Add(wStr);
  //    
  for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm) do
  begin
    with RqMP.ArrGrm[Ind] do
    begin
      wStr := #09 + IntToStr(Ind)
            + #09#09 + Format('%4.4f',[AmpM])
            + #09#09 + Format('%2.6f',[PhsM])
            + #09#09 + Format('%4.4f',[PhsM * 180 / Pi])
            + #09#09 + Format('%4.4f',[PhsT]);
      RqSSist.Add(wStr);
    end;
  end;

  RqSSist.Add('');
  //    
  wStr := #09 + ' ';
  RqSSist.Add(wStr);
  wStr := #09 + '      '
       +  #09 + '.    '
       +  #09 + '.    '
       +  #09 + '.    '
       +  #09 + '   ';
  RqSSist.Add(wStr);
  wStr := #09 + 'n ()   '
       +  #09 + 'X[n] (. )'
       +  #09 + 'X[n] (.)'
       +  #09 + 'X[n] (msec.)'
       +  #09;
  if MainParm.RqCos
  then wStr := wStr + SumCosTxt
  else wStr := wStr + SumSinTxt;
  RqSSist.Add(wStr);
  //    
  for Ind := Low(RqMP.ArrSg) to High(RqMP.ArrSg) do
  begin
    with RqMP.ArrSg[Ind] do
    begin
      wStr := #09 + IntToStr(Ind)
            + #09#09 + Format('%2.6f',[X])
            + #09#09 + Format('%4.4f',[X * 180 / Pi])
            + #09#09 + Format('%4.4f',[T])
            + #09#09 + Format('%4.4f',[Y]);
      RqSSist.Add(wStr);
    end;
  end;
end;
// -------------------------------------------------------------------------
//     
procedure ReportToFile (RqFileName : string; RqMP : TMainParm);
var SSist : TStringList;
begin
  SSist := nil;
  try
    SSist := TStringList.Create;
    MakeReport(SSist, RqMP);
    SSist.SaveToFile(RqFileName);
  except
      //    
  end;
  if SSist <> nil
  then SSist.Free;
end;

// =========================================================================
//     
// =========================================================================
//  RqImg   RqFileName. (RqGF : 'J' - jpg   'B' -bmp)
procedure SavePicture(RqFileName : string; RqImg : TImage; RqGF : char);
var  Jpeg   : TJPEGImage;  //   unit jpeg.
     BitMap : TBitMap;
begin
    case UpCase(RqGF) of
    'J' : begin   //   Jpeg
            Jpeg := TJPEGImage.Create;
            try
              with Jpeg do
              begin            //  Bitmap  JPG
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
              end;
            finally
                 Jpeg.Free;    //   JPG
            end;
          end;
    'B': begin   //   BMP
            BitMap := TBitMap.Create;
            try
              with BitMap do   //  Bitmap  BMP
              begin
                 Assign(RqImg.Picture.Bitmap);
                 SaveToFile(RqFileName);
              end;
            finally
                 BitMap.Free;  //   BMP
            end;
         end;
       end; // of case
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
end.
