unit GeneratorNewSpectr;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  GeneratorDATA;

type
  TNewSpectrFrm = class(TForm)
    BtnRun: TButton;
    BtnCancel: TButton;
    Label1: TLabel;
    CmbBoxGrmNum: TComboBox;
    CmbBoxAmpProfile: TComboBox;
    Label2: TLabel;
    EditAmp: TEdit;
    Label3: TLabel;
    Bevel1: TBevel;
    CmbBoxPhsProfile: TComboBox;
    LbPhaseProfile: TLabel;
    Label5: TLabel;
    CmbBoxBasePhs: TComboBox;
    PanelEvens: TPanel;
    ChBoxNotEven: TCheckBox;
    ChBoxEven: TCheckBox;
    Label6: TLabel;
    procedure BtnRunClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CmbBoxAmpProfileClick(Sender: TObject);
    procedure EditAmpChange(Sender: TObject);
    procedure CmbBoxPhsProfileClick(Sender: TObject);
    procedure CmbBoxBasePhsClick(Sender: TObject);
    procedure ChBoxEvenClick(Sender: TObject);
    procedure ChBoxNotEvenClick(Sender: TObject);
  private
    { Private declarations }
    //      
    procedure InitCmbBoxGrmNum(var RqMP : TMainParm);
  public
    { Public declarations }
  end;

var
  NewSpectrFrm : TNewSpectrFrm;

//       
procedure InitNewGrmData();
//   
function InitNewGarmonics (RqGrmNum   : integer;  //  
                       var RqMP       : TMainParm) : boolean;

implementation
{$R *.dfm}

const DefBaseAmp   = 1;        //     

var   BaseAmp      : double;   //   
      BasePhs      : double;   //    
      RqEven       : boolean;  //   
      RqNotEven    : boolean;  //   
      AmpProfInd   : integer;  //    
      PhsProfInd   : integer;  //    

// =========================================================================
//      
// =========================================================================
// -------------------------------------------------------------------------
//  Edit.Text  
function EditTextToDouble (RqEdit : TEdit; var OutDbl : double) : boolean;
var BufDbl  : double;
begin
  Result := False;     //   
  BufDbl := OutDbl;
  try
    if RqEdit.Text <> ''
    then OutDbl := StrToFloat(RqEdit.Text)
    else OutDbl := 0;
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    OutDbl := BufDbl;
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TNewSpectrFrm.InitCmbBoxGrmNum(var RqMP : TMainParm);
const Step = 4;
var Grm, Ind : integer;
begin
   CmbBoxGrmNum.Clear;
   Ind := 0;
   Grm := Step;
   Setlength (NewGrmNums, (GrmMaxNum div Step));
   repeat
      //     
      NewGrmNums[Ind] := Grm;
      CmbBoxGrmNum.Items.Add(' ' + IntToStr(Grm));
      Ind := Ind + 1;
      Grm := Grm + Step;
   until (Ind > High(NewGrmNums));
   NewGrmNums[High(NewGrmNums)]:= GrmMaxNum;
   //       
   CmbBoxGrmNum.ItemIndex := Low(NewGrmNums);
end;
// -------------------------------------------------------------------------
//   RqInd -    
procedure PhaseProfile (RqInd : integer; var RqArrGrm  : TArrGarmonics);
begin
    case PhsProfInd of
    0 : begin
          RqArrGrm[RqInd].Phs := BasePhs;
        end;
    1 : begin //   
          RqArrGrm[RqInd].Phs := BasePhs
                               + (2 * Pi) * RqInd/High(RqArrGrm);
        end;
    2 : begin //   
          RqArrGrm[RqInd].Phs := BasePhs
                               + (2 * Pi) * (1 - RqInd/High(RqArrGrm));
        end;
    end;
end;
// -------------------------------------------------------------------------
//        
procedure AmpAndPhsProfile (var RqArrGrm  : TArrGarmonics);
var Ind : integer;
begin
  for Ind := 0 to High(RqArrGrm)
  do begin
    //      
    FillChar(RqArrGrm[Ind], SizeOf(RqArrGrm[Ind]), #0);
    if Ind > 0
    then begin
       case AmpProfInd of
          0 :  begin  //   
                 if Ind = 1
                 then begin
                    RqArrGrm[Ind].Amp := BaseAmp;
                    RqArrGrm[Ind].Phs := BasePhs;
                 end;
               end;
          1 :  begin  //  
                 RqArrGrm[Ind].Amp := BaseAmp * Random(100)/100;
                 RqArrGrm[Ind].Phs := 2 * Pi  * Random(100)/100;
                 //     
                 RqArrGrm[Ind].ModATp := 1;
                 RqArrGrm[Ind].ModADp := High(ArrModAmp);
                 RqArrGrm[Ind].ModAOn := True;
                 RqArrGrm[Ind].ModPTp := 1;
                 RqArrGrm[Ind].ModPWd := High(ArrModPhs);
                 RqArrGrm[Ind].ModPOn := True;
              end;
          2 : begin  //  
                 if RqEven and ((Ind and $01) = 0)
                 then begin
                    RqArrGrm[Ind].Amp := BaseAmp * (1 - Ind/High(RqArrGrm));
                    PhaseProfile(Ind, RqArrGrm);
                 end;
                 if RqNotEven and ((Ind and $01) <> 0)
                 then begin
                    RqArrGrm[Ind].Amp := BaseAmp * (1 - Ind/High(RqArrGrm));
                    PhaseProfile(Ind, RqArrGrm);
                 end;
              end;
          3 : begin  //  (1/x)
                  if RqEven and ((Ind and $01) = 0)
                  then begin
                     RqArrGrm[Ind].Amp := BaseAmp/Ind;
                     PhaseProfile(Ind, RqArrGrm);
                  end;
                  if RqNotEven and ((Ind and $01) <> 0)
                  then begin
                    RqArrGrm[Ind].Amp := BaseAmp/Ind;
                    PhaseProfile(Ind, RqArrGrm);
                  end;
              end;
          4 : begin  //  - 
                  if RqEven and ((Ind and $01) = 0)
                  then begin
                     RqArrGrm[Ind].Amp := BaseAmp
                                       *  Cos(4 * Pi * Ind/High(RqArrGrm))
                                       / Ind;
                     PhaseProfile(Ind, RqArrGrm);
                  end;
                  if RqNotEven and ((Ind and $01) <> 0)
                  then begin
                     RqArrGrm[Ind].Amp := BaseAmp
                                       *  Cos(4 * Pi * Ind/High(RqArrGrm))
                                       /Ind;
                     PhaseProfile(Ind, RqArrGrm);
                  end;
              end;
          5 : begin  //  - 
                  if RqEven and ((Ind and $01) = 0)
                  then begin
                     RqArrGrm[Ind].Amp := BaseAmp
                                       *  Sin(4 * Pi * Ind/High(RqArrGrm))
                                       / Ind;
                     PhaseProfile(Ind, RqArrGrm);
                  end;
                  if RqNotEven and ((Ind and $01) <> 0)
                  then begin
                     RqArrGrm[Ind].Amp := BaseAmp
                                       *  Sin(4 * Pi * Ind/High(RqArrGrm))
                                       /Ind;
                     PhaseProfile(Ind, RqArrGrm);
                  end;
              end;
       end; // of case
       //      
       RqArrGrm[Ind].AmpM := RqArrGrm[Ind].Amp;
       RqArrGrm[Ind].PhsM := RqArrGrm[Ind].Phs;
    end;
  end;
end;
// -------------------------------------------------------------------------
//   
function InitNewGarmonics (RqGrmNum   : integer;  //  
                       var RqMP       : TMainParm) : boolean;
begin
  Result := False;
  Randomize;
  // BaseAmp  
  if BaseAmp <=0 then BaseAmp := DefBaseAmp;
  with RqMP do
  begin
     try //     
       SetLength(ArrGrm, RqGrmNum);
       NumGrm := RqGrmNum;
       //        
       AmpAndPhsProfile (ArrGrm);
       Result := True;
     except
       NumGrm := 0;
       MessageDlg('    ', mtError, [mbYes], 0);
     end;
  end;
end;

// =========================================================================
// 
// =========================================================================
//    
procedure TNewSpectrFrm.BtnRunClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrmNum.ItemIndex;
  //      NewGrmNums  
  if (Ind >= Low(NewGrmNums)) and (Ind <= High(NewGrmNums))
  then begin
     //    
     MainParm.RqNew := True;
     if InitNewGarmonics(NewGrmNums[Ind], MainParm)
     then MainParm.NumGrm := NewGrmNums[Ind]
     else MainParm.NumGrm := 0;
  end;
  Close;  //  
end;
// -------------------------------------------------------------------------
//    
procedure TNewSpectrFrm.BtnCancelClick(Sender: TObject);
begin
  //    
  MainParm.RqNew := False;
  Close;  //  
end;
// -------------------------------------------------------------------------
//   
procedure TNewSpectrFrm.EditAmpChange(Sender: TObject);
begin
  if EditAmp.Tag = 0
  then EditTextToDouble(EditAmp, BaseAmp);
end;
// -------------------------------------------------------------------------
//   
procedure TNewSpectrFrm.CmbBoxBasePhsClick(Sender: TObject);
begin
   case CmbBoxBasePhs.ItemIndex of
   0 : BasePhs := 0;
   1 : BasePhs := Pi/2;
   2 : BasePhs := Pi;
   3 : BasePhs := (3/2)*Pi;
   end;
end;
// -------------------------------------------------------------------------
//       
procedure TNewSpectrFrm.ChBoxEvenClick(Sender: TObject);
begin
  RqEven := ChBoxEven.Checked;  //   

end;
// -------------------------------------------------------------------------
//       
procedure TNewSpectrFrm.ChBoxNotEvenClick(Sender: TObject);
begin
  RqNotEven := ChBoxNotEven.Checked;  //   
end;
// -------------------------------------------------------------------------
//     
procedure TNewSpectrFrm.CmbBoxPhsProfileClick(Sender: TObject);
begin
  PhsProfInd := CmbBoxPhsProfile.ItemIndex;
end;
// -------------------------------------------------------------------------
//     
procedure TNewSpectrFrm.CmbBoxAmpProfileClick(Sender: TObject);
begin
  AmpProfInd := CmbBoxAmpProfile.ItemIndex;
  //     
  //      
  if AmpProfInd > 1
  then PanelEvens.Visible := True
  else PanelEvens.Visible := False;
end;

// =========================================================================
//  
// =========================================================================
//       
procedure InitNewGrmData();
begin
  //  
  BaseAmp    := DefBaseAmp;
  BasePhs    := 0;
  RqEven     := True;  //   
  RqNotEven  := True;  //   
  AmpProfInd := 0;     //    
  PhsProfInd := 0;     //    
end;

procedure TNewSpectrFrm.FormCreate(Sender: TObject);
begin
  //       
  InitNewGrmData();
  //   BaseAmp
  EditAmp.Tag := 1;
  EditAmp.Text := FloatToStr(BaseAmp);
  EditAmp.Tag := 0;
  //    
  CmbBoxAmpProfile.ItemIndex := AmpProfInd;
  CmbBoxPhsProfile.ItemIndex := PhsProfInd;
  //     
  InitCmbBoxGrmNum(MainParm);
end;
// =========================================================================


end.
