unit GeneratorMAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, ExtDlgs, ComCtrls,
  GlobalDATA,
  GeneratorDATA,
  GeneratorSignal,
  GeneratorLoadSave,
  GeneratorNewSpectr,
  GeneratorGrmImport,
  GeneratorDisplay,
  GeneratorReport,
  GeneratorToExcel,
  GeneratorAbout,
  SpectrumMAIN, Menus;

type
  TGeneratorFrm = class(TForm)
    Timer1: TTimer;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SavePictureDialog1: TSavePictureDialog;
    PageControl2: TPageControl;
    TabSheet3: TTabSheet;
    PanelModAmp: TPanel;
    LblModAmpType: TLabel;
    CmbBoxAmpMod: TComboBox;
    PanelModAmpParm: TPanel;
    LbSeriesAmpLen: TLabel;
    LabelModAmpDeep: TLabel;
    CmbBoxAmpLen: TComboBox;
    CmbBoxAmpDeep: TComboBox;
    BitBtnResetAmpMod: TBitBtn;
    CheckBoxAmpMod: TCheckBox;
    TabSheet4: TTabSheet;
    PanelModPhase: TPanel;
    LbModPhsType: TLabel;
    CmbBoxPhaseMod: TComboBox;
    CheckBoxPhsMod: TCheckBox;
    PanelModPhaseParm: TPanel;
    Label4: TLabel;
    LabelModPhsWd: TLabel;
    CmbBoxPhsLen: TComboBox;
    CmbBoxPhsWidth: TComboBox;
    BitBtnResetPhsMod: TBitBtn;
    TabSheet5: TTabSheet;
    PanelModPeriod: TPanel;
    LbModPeriodType: TLabel;
    CmbBoxPeriodMod: TComboBox;
    CheckBoxPrdMod: TCheckBox;
    PanelModPeriodParm: TPanel;
    Label3: TLabel;
    Label2: TLabel;
    CmbBoxPrdLen: TComboBox;
    CmbBoxPrdWidth: TComboBox;
    BitBtnResetPrdMod: TBitBtn;
    PanelNewLoadSave: TPanel;
    LbGrmNum: TLabel;
    LbFrequence: TLabel;
    BitBtnLoadSpectr: TBitBtn;
    BitBtnNewSpectr: TBitBtn;
    StTxtGrmNum: TStaticText;
    CmbBoxFreq: TComboBox;
    BitBtnSaveSpectr: TBitBtn;
    PanelGrmData: TPanel;
    LbGrmFreq: TLabel;
    LbGrmSel: TLabel;
    LbGrmPeriod: TLabel;
    CmbBoxGrm: TComboBox;
    StTxtFreq: TStaticText;
    StTxtTGrm: TStaticText;
    RadGroupAng: TRadioGroup;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    LbGrmSetAmp: TLabel;
    LbGrmSetPhase: TLabel;
    EditAmp: TEdit;
    EditPhase: TEdit;
    TabSheet2: TTabSheet;
    Label6: TLabel;
    Label7: TLabel;
    EditAmpM: TEdit;
    EditPhaseM: TEdit;
    Panel2: TPanel;
    PanelDPolar: TPanel;
    ImgDPolar: TImage;
    BitBtnSavePicPhase: TBitBtn;
    Panel3: TPanel;
    SpBtnStart: TSpeedButton;
    SpBtnStop: TSpeedButton;
    SpBtnGoStep: TSpeedButton;
    Label8: TLabel;
    BitBtnReSetAllMod: TBitBtn;
    PanelDSignal: TPanel;
    ImgDSignal: TImage;
    PanelSpectrBtns: TPanel;
    Label5: TLabel;
    BitBtnImportSpectr: TBitBtn;
    BitBtnToTxt: TBitBtn;
    BitBtnSavePicSpectr: TBitBtn;
    BitBtnToXls: TBitBtn;
    PanelSignanlBtns: TPanel;
    SpBtnSin: TSpeedButton;
    SpBtnCos: TSpeedButton;
    Label1: TLabel;
    StTxtSinCos: TStaticText;
    BitBtnScaleSignal: TBitBtn;
    BitBtnSavePicSignal: TBitBtn;
    PanelDSpectr: TPanel;
    ImgDSpectr: TImage;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N4: TMenuItem;
    MMHelp: TMenuItem;
    MMAbout: TMenuItem;
    Label9: TLabel;
    TabSheet6: TTabSheet;
    Panel1: TPanel;
    stTxtLampAmpM: TStaticText;
    stTxtLampPhsM: TStaticText;
    stTxtLampPrdM: TStaticText;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    MMNewSpectr: TMenuItem;
    MMLoadSpectr: TMenuItem;
    N7: TMenuItem;
    MMSaveSpectrAs: TMenuItem;
    N9: TMenuItem;
    MMClose: TMenuItem;
    Label13: TLabel;
    Label14: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CmbBoxGrmClick(Sender: TObject);
    procedure EditAmpChange(Sender: TObject);
    procedure EditPhaseChange(Sender: TObject);
    procedure RadGroupAngClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CmbBoxAmpModClick(Sender: TObject);
    procedure CmbBoxAmpDeepClick(Sender: TObject);
    procedure CmbBoxPhaseModClick(Sender: TObject);
    procedure CmbBoxPhsWidthClick(Sender: TObject);
    procedure ImgDSpectrMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtnResetAmpModClick(Sender: TObject);
    procedure BitBtnResetPhsModClick(Sender: TObject);
    procedure BitBtnReSetAllModClick(Sender: TObject);
    procedure BitBtnToXlsClick(Sender: TObject);
    procedure SpBtnSinClick(Sender: TObject);
    procedure SpBtnCosClick(Sender: TObject);
    procedure CmbBoxFreqClick(Sender: TObject);
    procedure BitBtnNewSpectrClick(Sender: TObject);
    procedure BitBtnScaleSignalClick(Sender: TObject);
    procedure BitBtnSaveSpectrClick(Sender: TObject);
    procedure BitBtnLoadSpectrClick(Sender: TObject);
    procedure BitBtnToTxtClick(Sender: TObject);
    procedure BitBtnSavePicSignalClick(Sender: TObject);
    procedure BitBtnSavePicSpectrClick(Sender: TObject);
    procedure BitBtnSavePicPhaseClick(Sender: TObject);
    procedure CheckBoxAmpModClick(Sender: TObject);
    procedure CmbBoxAmpLenClick(Sender: TObject);
    procedure CheckBoxPhsModClick(Sender: TObject);
    procedure CmbBoxPhsLenClick(Sender: TObject);
    procedure CmbBoxPeriodModClick(Sender: TObject);
    procedure CheckBoxPrdModClick(Sender: TObject);
    procedure BitBtnResetPrdModClick(Sender: TObject);
    procedure CmbBoxPrdLenClick(Sender: TObject);
    procedure CmbBoxPrdWidthClick(Sender: TObject);
    procedure SpBtnGoStepClick(Sender: TObject);
    procedure BitBtnImportSpectrClick(Sender: TObject);
    procedure MMAboutClick(Sender: TObject);
    procedure MMNewSpectrClick(Sender: TObject);
    procedure MMLoadSpectrClick(Sender: TObject);
    procedure MMSaveSpectrAsClick(Sender: TObject);
    procedure MMCloseClick(Sender: TObject);
  private
    // ------------    --------------------
    //       
    procedure InitCmbBoxFreq(var RqMP : TMainParm);
    //       
    procedure InitCmbBoxesDeep();
    //       
    procedure InitCmbBoxesModLen();
    //     
    procedure InitCmbBoxGrm(RqMP : TMainParm);
    // ------------    ----------------
    //    
    function InitGenerator (var RqMP : TMainParm) : boolean;
    //      
    procedure InitAndShowAllDisplay (var RqMP : TMainParm);
    // ------------    ------------------------------
    //       
    procedure ClearAmpModCicle (RqInd : integer; var RqMP : TMainParm);
    //       
    procedure ClearPhsModCicle (RqInd : integer; var RqMP : TMainParm);
    //       
    procedure ClearPrdModCicle (RqInd : integer; var RqMP : TMainParm);
    // ------------   ----------------------------
    //      
    procedure ShowAmpModOnOff (RqOn : boolean);
    //     
    procedure ShowPhsModOnOff (RqOn : boolean);
    //     
    procedure ShowPrdModOnOff (RqOn : boolean);
    //    
    procedure ShowModulattion (RqLamp : TStaticText; RqOn : boolean);
    //    
    procedure ShowGrmParm (Ind : integer; var RqMP : TMainParm);
    //        
    procedure ShowNewOrLoadSpectr(var RqMP : TMainParm);
    //      
    procedure ShowFrqAndPrd (var RqMP : TMainParm);
    //        
    procedure CalcAndShowSignalAndGrm (var RqMP : TMainParm);
    // ------------   -----------------------
    //       
    procedure SaveGraphReport (RqImg : TImage);
    // --------------------------------------------------------------
  public
    { Public declarations }
  end;

var
  GeneratorFrm: TGeneratorFrm;

//  Edit.Text  
function EditTextToDouble (RqEdit : TEdit; var OutDbl : double) : boolean;


implementation
{$R *.dfm}

//        
const DefStartGrmInd = 1;

//  
const SaveWarning = '  '
                   + #13#10
                   + '  ';

// =========================================================================
//  
// =========================================================================
//  Edit.Text  
function EditTextToDouble (RqEdit : TEdit; var OutDbl : double) : boolean;
var BufDbl  : double;
begin
  Result := False;     //   
  BufDbl := OutDbl;
  try
    if RqEdit.Text <> ''
    then OutDbl := StrToFloat(RqEdit.Text)
    else OutDbl := 0;
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    OutDbl := BufDbl;
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;
// =========================================================================
//      
//     
//       
//    unit GlobalDATA.  GeneratorSignalReady
//        
//  .
// =========================================================================
// 11.03.2013
//      
procedure GeneratorSignalReady (RqMP : TMainParm);
var Ind : integer;
begin
   with RqMP
   do begin
      //       
      for Ind := Low(GLSignalBufer.Signal) to High(GLSignalBufer.Signal)
      do begin
         //       
         // ,     
         if (Ind >= Low(ArrSg)) and (Ind <= High(ArrSg))
         then GLSignalBufer.Signal[Ind] := ArrSg[Ind].Y
         else GLSignalBufer.Signal[Ind] := 0;
      end;
      //        
      GLSignalBufer.Period := ArrGrm[1].Prd;
      //       
      GLGeneratorSignalReady();
   end;
end;

// =========================================================================
//   
// =========================================================================
//   
procedure TGeneratorFrm.FormCreate(Sender: TObject);
begin
  //    ()  
  MainParm.DigNum := DigMaxNum;
  //   
  InitCmbBoxFreq(MainParm);
  InitCmbBoxesDeep();
  InitCmbBoxesModLen();
  //     
  MainParm.Frequency := ArrFreq[FreqIndDef];
  //  Image   
  SetImgToAllDisplays(ImgDSpectr, ImgDPolar, ImgDSignal, MainParm);
  //     
  SpBtnSin.Down := True;
  StTxtSinCos.Caption := SumSinTxt;
  //   
  if InitGenerator(MainParm)
  then begin
    LoadFileName := 'NoName';
    Self.Caption := cAppTitle + LoadFileName;
  end else Close;
end;

// =========================================================================
//    
// =========================================================================
//       
procedure TGeneratorFrm.InitCmbBoxFreq(var RqMP : TMainParm);
var   Ind     : integer;
begin
    CmbBoxFreq.Clear;
    for Ind := Low(ArrFreq) to High(ArrFreq)
    do CmbBoxFreq.Items.Add(' ' + IntToStr(ArrFreq[Ind]) + ' Hz',);
    CmbBoxFreq.ItemIndex := FreqIndDef;
end;
// -------------------------------------------------------------------------
//      
//       
procedure TGeneratorFrm.InitCmbBoxesDeep();
const DefInd   = 0;       //    
var   Ind : integer;      //  
begin
   //        
   CmbBoxAmpDeep.Clear;
   for Ind := Low(ArrModAmp) to High(ArrModAmp)
   do CmbBoxAmpDeep.Items.Add (' ' + IntToStr(ArrModAmp[Ind]) + ' %');
   CmbBoxAmpDeep.ItemIndex   := DefInd;
   //        
   CmbBoxPhsWidth.Clear;
   for Ind := Low(ArrModPhs) to High(ArrModPhs)
   do CmbBoxPhsWidth.Items.Add (' ' + IntToStr(ArrModPhs[Ind]) + ' %');
   CmbBoxPhsWidth.ItemIndex := DefInd;
   //        
   CmbBoxPrdWidth.Clear;
   for Ind := Low(ArrModPrd) to High(ArrModPrd)
   do CmbBoxPrdWidth.Items.Add (' ' + IntToStr(ArrModPrd[Ind]) + ' %');
   CmbBoxPrdWidth.ItemIndex := DefInd;
end;
// -------------------------------------------------------------------------
//       (  ),
//        (,
// , )
procedure TGeneratorFrm.InitCmbBoxesModLen();
var Ind : integer;
begin
   CmbBoxAmpLen.Clear;  //      
   CmbBoxPrdLen.Clear;  //      
   CmbBoxPhsLen.Clear;  //      
   for Ind := Low(ArrModLen) to High(ArrModLen)
   do begin
      CmbBoxAmpLen.Items.Add (ArrModLen[Ind].Tit);
      CmbBoxPrdLen.Items.Add (ArrModLen[Ind].Tit);
      CmbBoxPhsLen.Items.Add (ArrModLen[Ind].Tit);
   end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.InitCmbBoxGrm(RqMP : TMainParm);
var Ind : integer;
begin
  CmbBoxGrm.Tag := 1;  //    
  CmbBoxGrm.Clear;
  if (RqMP.IndGrm >= 0)
  then begin
     for Ind := Low(RqMP.ArrGrm) to High(RqMP.ArrGrm)
     do CmbBoxGrm.Items.Add ('  ' + IntToStr(Ind));
     CmbBoxGrm.ItemIndex := DefStartGrmInd;
  end;
  CmbBoxGrm.Tag := 0;  //    
end;

// =========================================================================
//   
// =========================================================================
//   
function InitSignal(var RqMP : TMainParm) : boolean;
begin
  Result := False;
  try
    SetLength(RqMP.ArrSg, DigMaxNum);
    Result := True;
  except
    MessageDlg('    '
              + #13#10
              + 'Win-API' + SysErrorMessage(GetLastError),
               mtError, [mbOk], 0);
  end;
end;
// -------------------------------------------------------------------------
//     
function TGeneratorFrm.InitGenerator (var RqMP : TMainParm) : boolean;
begin
  Result := False;
  with RqMP do
  begin
     //       
     // (        )
     InitNewGrmData();
     //   
     if InitNewGarmonics(NewGrmNums[Low(NewGrmNums)],RqMP)
     then begin
       //     
       RqMP.NumGrm := NewGrmNums[Low(NewGrmNums)];
       StTxtGrmNum.Caption := ' ' + IntToStr(RqMP.NumGrm) + ' .';
       //    
       if not InitSignal(RqMP) then Close;
       //        
       ShowNewOrLoadSpectr(RqMP);
       //      
       GeneratorSignalReady(RqMP);
       Result := True;
     end;
  end;
end;

// =========================================================================
//      
// =========================================================================
//      
procedure TGeneratorFrm.ShowFrqAndPrd (var RqMP : TMainParm);
var wPhsM : double;
begin
  with RqMP
  do begin
    if (Length(ArrGrm)  >=  0)  and
       (IndGrm >=  Low(ArrGrm)) and
       (IndGrm <= High(ArrGrm))
    then begin
       //    
       StTxtFreq.Caption := ' '
                         + Format('%3f',[ArrGrm[IndGrm].Frq])
                         + ' Hz';
       //     ms
       StTxtTGrm.Caption := ' '
                         + Format('%3.3f',[ArrGrm[IndGrm].Prd])
                         + ' ms';

       EditAmpM.Text := FloatToStr(ArrGrm[IndGrm].AmpM);
       //    " "
       wPhsM := NormalizePhase(ArrGrm[IndGrm].PhsM);
       if RadGroupAng.ItemIndex > 0
       then begin
          wPhsM := wPhsM * 180 / Pi;
          EditPhaseM.Text := FloatToStr(wPhsM);
       end
       else EditPhaseM.Text := FloatToStr(wPhsM);
     end;
  end;
end;
// -------------------------------------------------------------------------
//        
procedure TGeneratorFrm.CalcAndShowSignalAndGrm (var RqMP : TMainParm);
begin
  if (Length(MainParm.ArrGrm) >= 0)
  then begin
    //   
    MakeSignal (RqMP);
    //        
    ReShowDSpectr (RqMP);
    //      Polar - 
    ReShowDPolar (RqMP);
    //    Signal - 
    ReShowDSignal (RqMP);
    //      
    ShowFrqAndPrd (RqMP);
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.InitAndShowAllDisplay (var RqMP : TMainParm);
begin
  if (Length(RqMP.ArrGrm) > 0) and (Length(RqMP.ArrSg) > 0)
  then begin
    //   
    MakeSignal (MainParm);
    //   
    ShowDSpectr (RqMP);
    //    
    ShowDSpectrXCaption(RqMP);
    //       Polar - 
    ShowDPolar  (RqMP);
    //     Signal - 
    ShowDSignal (RqMP);
    //      
    ShowFrqAndPrd (RqMP);
  end;
end;
// -------------------------------------------------------------------------
//        
procedure TGeneratorFrm.ShowNewOrLoadSpectr(var RqMP : TMainParm);
begin
   if Length(RqMP.ArrGrm) > 0
   then begin
     //      
     StTxtGrmNum.Caption := ' ' + IntToStr(Length(RqMP.ArrGrm));
     //      
     InitGrmFreqPrd(RqMP);
     //     
     InitCmbBoxGrm(RqMP);
     //     
     ShowGrmParm (DefStartGrmInd, RqMP);
     //     
     InitAndShowAllDisplay (RqMP);
     //      
     GeneratorSignalReady(RqMP);
   end;
end;

// =========================================================================
//     (, )
// =========================================================================
// 11.03.2013
//       
procedure TGeneratorFrm.Timer1Timer(Sender: TObject);
begin
  if SpBtnStart.Down
  then begin
     //        
     CalcAndShowSignalAndGrm (MainParm);
     //      
     GeneratorSignalReady (MainParm);
  end;
end;
// -------------------------------------------------------------------------
// 11.03.2013
//       
procedure TGeneratorFrm.SpBtnGoStepClick(Sender: TObject);
begin
  if SpBtnStart.Down = False
  then begin
     //        
     CalcAndShowSignalAndGrm (MainParm);
     //      
     GeneratorSignalReady (MainParm);
  end;
end;
// =========================================================================
//   
// =========================================================================
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.ShowAmpModOnOff (RqOn : boolean);
begin
   PanelModAmpParm.Visible := RqOn;
   CheckBoxAmpMod.Enabled := RqOn;
   if RqOn = False
   then begin
     CmbBoxAmpLen.ItemIndex  := 0;
     CmbBoxAmpDeep.ItemIndex := 0;
   end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.ShowPhsModOnOff (RqOn : boolean);
begin
   PanelModPhaseParm.Visible := RqOn;
   CheckBoxPhsMod.Enabled := RqOn;
   if RqOn = False
   then begin
     CmbBoxPhsLen.ItemIndex  := 0;
     CmbBoxPhsWidth.ItemIndex := 0;
   end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.ShowPrdModOnOff (RqOn : boolean);
begin
   PanelModPeriodParm.Visible := RqOn;
   CheckBoxPrdMod.Enabled := RqOn;
   if RqOn = False
   then begin
     CmbBoxPrdLen.ItemIndex  := 0;
     CmbBoxPrdWidth.ItemIndex := 0;
   end;
end;
// -------------------------------------------------------------------------
//    
procedure TGeneratorFrm.ShowModulattion (RqLamp : TStaticText; RqOn : boolean);
begin
   if RqOn
   then RqLamp.Color := clLime
   else RqLamp.Color := clBtnFace;
end;
// -------------------------------------------------------------------------
//    
procedure TGeneratorFrm.ShowGrmParm (Ind : integer; var RqMP : TMainParm);
var Ang  : double;
begin
  with RqMP do
  begin
   if (Ind >= Low(ArrGrm)) and (Ind <= High(ArrGrm))
   then begin
      //  
      EditAmp.Tag := 1;       //   onChange
      EditAmp.Text := FloatToStr(ArrGrm[Ind].Amp);
      EditAmp.Tag := 0;       //   onChange
      //   
      Ang := NormalizePhase(ArrGrm[Ind].Phs);
      //Ang := ArrGrm[Ind].Phs;
      //     ,   
      if RadGroupAng.ItemIndex = 1 then Ang := Ang * 180 / Pi;
      //  
      EditPhase.Tag := 1;    //   onChange
      EditPhase.Text := FloatToStr(Ang);
      EditPhase.Tag := 0;    //   onChange
      // -----------------------------------------
      //    
      CmbBoxAmpMod.ItemIndex := ArrGrm[Ind].ModATp;
      //      
      if MainParm.ArrGrm[Ind].ModATp > 0
      then ShowAmpModOnOff (True)
      else ShowAmpModOnOff (False);
      //   
      CheckBoxAmpMod.Checked := ArrGrm[Ind].ModAOn;
      //     
      CmbBoxAmpLen.ItemIndex := ArrGrm[Ind].ModALn;
      //    
      CmbBoxAmpDeep.ItemIndex := ArrGrm[Ind].ModADp;
      //  -  
      ShowModulattion(stTxtLampAmpM, ArrGrm[Ind].ModAOn);
      // -----------------------------------------
      //    
      CmbBoxPhaseMod.ItemIndex := ArrGrm[Ind].ModPTp;
      //      
      if MainParm.ArrGrm[Ind].ModPTp > 0
      then ShowPhsModOnOff(True)
      else ShowPhsModOnOff(False);
      //    
      CheckBoxPhsMod.Checked := ArrGrm[Ind].ModPOn;
      //     
      CmbBoxPhsLen.ItemIndex := ArrGrm[Ind].ModPLn;
      //    
      CmbBoxPhsWidth.ItemIndex := ArrGrm[Ind].ModPWd;
      //  -  
      ShowModulattion(stTxtLampPhsM, ArrGrm[Ind].ModPOn);
      // -----------------------------------------
      //    
      CmbBoxPeriodMod.ItemIndex := ArrGrm[Ind].ModTTp;
      //      
      if MainParm.ArrGrm[Ind].ModTTp > 0
      then ShowPrdModOnOff(True)
      else ShowPrdModOnOff(False);
      //    
      CheckBoxPrdMod.Checked := ArrGrm[Ind].ModTOn;
      //     
      CmbBoxPrdLen.ItemIndex := ArrGrm[Ind].ModTLn;
      //    
      CmbBoxPrdWidth.ItemIndex := ArrGrm[Ind].ModTWd;
      //  -   
      ShowModulattion(stTxtLampPrdM, ArrGrm[Ind].ModTOn);
      // -----------------------------------------
      //    
      RqMP.IndGrm := Ind;
      // -----------------------------------------
      //      
      ShowFrqAndPrd (RqMP);
   end;
  end;
end;

// -------------------------------------------------------------------------
//      
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//     ComboBox
procedure TGeneratorFrm.CmbBoxGrmClick(Sender: TObject);
begin
  if (CmbBoxGrm.Tag = 0) and (CmbBoxGrm.ItemIndex >= 0)
  then begin
     //    
     ShowGrmParm(CmbBoxGrm.ItemIndex, MainParm);
     //   Polar - 
     ShowDPolar (MainParm);
     ShowDSpectrXCaption(MainParm);
  end;
end;
// -------------------------------------------------------------------------
//     Image
procedure TGeneratorFrm.ImgDSpectrMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var wX, Ind, RqInd : integer;
begin
  RqInd := -1;
  with MainParm.DSpectr do
  begin
    if (Length(MainParm.ArrGrm) < 1) or (XSc <= 0) then Exit;
    for Ind := Low(MainParm.ArrGrm) to High(MainParm.ArrGrm) do
    begin
      wX := OffX + Trunc(XSc * Ind);
      if (X >= wX - 4) and (X <= wX + 4)
      then RqInd := Ind;
    end;
    if RqInd >=0
    then begin
       //    
       CmbBoxGrm.Tag := 1;
       CmbBoxGrm.ItemIndex := RqInd;
       CmbBoxGrm.Tag := 0;
       //    
       ShowGrmParm (RqInd, MainParm);
       //   Polar - 
       ShowDPolar (MainParm);
       ShowDSpectrXCaption(MainParm);
    end;
  end;
end;

// -------------------------------------------------------------------------
//      
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.EditAmpChange(Sender: TObject);
var Ind : integer;
begin
  if EditAmp.Tag = 0 //  onChange ?
  then begin
    Ind := CmbBoxGrm.ItemIndex;
    if Ind >=0
    then begin
       if EditTextToDouble(EditAmp, MainParm.ArrGrm[Ind].Amp)
       //      
       then begin
          MainParm.ArrGrm[Ind].AmpM := MainParm.ArrGrm[Ind].Amp;
          MainParm.ArrGrm[Ind].ModACt := 0;
          MainParm.ArrGrm[Ind].ModASw := True;
          InitAndShowAllDisplay (MainParm);
       end;
    end;
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.EditPhaseChange(Sender: TObject);
var Ind : integer;
    Ang : double;
begin
  if EditPhase.Tag = 0 //  onChange ?
  then begin
    Ind := CmbBoxGrm.ItemIndex;
    if Ind >=0
    then begin
       Ang := MainParm.ArrGrm[Ind].Phs;
       if EditTextToDouble(EditPhase, Ang)
       then begin
         //        
         if RadGroupAng.ItemIndex = 1
         then Ang := Ang * Pi / 180;
         //   
         MainParm.ArrGrm[Ind].Phs := Ang;
         //     
         with MainParm.ArrGrm[Ind] do
         begin
            ModPCt := 0;    //     
            PhsM   := Phs;  //    
         end;
         //      
         InitAndShowAllDisplay (MainParm);
         ShowDSpectrXCaption(MainParm);
       end;
    end;
  end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//     ( / )
procedure TGeneratorFrm.RadGroupAngClick(Sender: TObject);
const MGrad = 180 / Pi;
var Ind : integer;
    Ang : double;
begin
   with MainParm
   do begin
     Ind := CmbBoxGrm.ItemIndex;
     if (Ind >= Low(ArrGrm)) and (Ind <= High(ArrGrm))
     then begin
        //    " " Phs
        Ang := NormalizePhase(MainParm.ArrGrm[Ind].Phs);
        //     ,   
        if RadGroupAng.ItemIndex > 0
        then Ang := Ang * MGrad;
        EditPhase.Tag := 1;           //   onChange
        EditPhase.Text := FloatToStr(Ang);
        EditPhase.Tag := 0;           //   onChange
        //    " " PhsM
        Ang := NormalizePhase(ArrGrm[IndGrm].PhsM);
        if RadGroupAng.ItemIndex > 0
        then EditPhaseM.Text := FloatToStr(Ang * MGrad)
        else EditPhaseM.Text := FloatToStr(Ang);
     end;
   end;
end;
// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.ClearAmpModCicle (RqInd : integer;
                                       var RqMP : TMainParm);
begin
  with RqMP do begin
     if (RqInd >= Low(ArrGrm)) and (RqInd <= High(ArrGrm))
     then begin
       //     
       ArrGrm[RqInd].ModACt := 0;
       ArrGrm[RqInd].ModASw := True;
       //      
       ArrGrm[RqInd].AmpM := ArrGrm[RqInd].Amp;
     end;
  end;
end;
// -------------------------------------------------------------------------
//  /      
procedure TGeneratorFrm.CheckBoxAmpModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
    // ./.  
    MainParm.ArrGrm[Ind].ModAOn := CheckBoxAmpMod.Checked;
    //       
    if not CheckBoxAmpMod.Checked
    then //       
         ClearAmpModCicle (Ind, MainParm);
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.CmbBoxAmpModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
    //    
    MainParm.ArrGrm[Ind].ModATp := CmbBoxAmpMod.ItemIndex;
    //     . 
    if MainParm.ArrGrm[Ind].ModATp > 0
    then ShowAmpModOnOff (True)
    else ShowAmpModOnOff (False);
    //       
    ClearAmpModCicle (Ind, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//        
procedure TGeneratorFrm.CmbBoxAmpLenClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
     MainParm.ArrGrm[Ind].ModALn := CmbBoxAmpLen.ItemIndex;
     //       
     ClearAmpModCicle (Ind, MainParm);
     //        
     CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.CmbBoxAmpDeepClick(Sender: TObject);
var Ind1, Ind2 : integer;
begin
  Ind1 := CmbBoxGrm.ItemIndex;      //   
  Ind2 := CmbBoxAmpDeep.ItemIndex;  //   
  if (Ind1 >= 0) and (Ind2 >=0)
  then begin
    //    
    MainParm.ArrGrm[Ind1].ModADp := Ind2;
    //       
    ClearAmpModCicle (Ind1, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.BitBtnResetAmpModClick(Sender: TObject);
begin
   if MainParm.IndGrm >=0
   then begin
      //       
      ClearAmpModCicle (MainParm.IndGrm, MainParm);
      //        
      CalcAndShowSignalAndGrm (MainParm);
   end;
end;

// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.ClearPhsModCicle (RqInd : integer;
                                       var RqMP : TMainParm);
begin
  with RqMP do begin
     if (RqInd >= Low(ArrGrm)) and (RqInd <= High(ArrGrm))
     then begin
       //     
       ArrGrm[RqInd].ModPCt := 0;
       ArrGrm[RqInd].ModPSw := True;
       //      
       ArrGrm[RqInd].PhsM := ArrGrm[RqInd].Phs;
     end;
  end;
end;
// -------------------------------------------------------------------------
//  /      
procedure TGeneratorFrm.CheckBoxPhsModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
    // ./.  
    MainParm.ArrGrm[Ind].ModPOn := CheckBoxPhsMod.Checked;
    //       
    if not CheckBoxPhsMod.Checked
    then //       
         ClearPhsModCicle (Ind, MainParm);
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.CmbBoxPhaseModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0   //   
  then begin
    //    
    MainParm.ArrGrm[Ind].ModPTp := CmbBoxPhaseMod.ItemIndex;
    //      
    if MainParm.ArrGrm[Ind].ModPTp > 0
    then ShowPhsModOnOff(True)
    else ShowPhsModOnOff(False);
    //       
    ClearPhsModCicle (Ind, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//        
procedure TGeneratorFrm.CmbBoxPhsLenClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
     MainParm.ArrGrm[Ind].ModPLn := CmbBoxPhsLen.ItemIndex;
     //       
    ClearPhsModCicle (Ind, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.CmbBoxPhsWidthClick(Sender: TObject);
var Ind1, Ind2 : integer;
begin
  Ind1 := CmbBoxGrm.ItemIndex;
  Ind2 := CmbBoxPhsWidth.ItemIndex;
  if (Ind1 >= 0) and (Ind2 >= 0)
  then begin
    //     
    MainParm.ArrGrm[Ind1].ModPWd := Ind2;
    //       
    ClearPhsModCicle (Ind1, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.BitBtnResetPhsModClick(Sender: TObject);
begin
   if MainParm.IndGrm >=0
   then begin
      //       
      ClearPhsModCicle (MainParm.IndGrm, MainParm);
      //        
      CalcAndShowSignalAndGrm (MainParm);
   end;
end;
// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.ClearPrdModCicle (RqInd : integer;
                                       var RqMP : TMainParm);
begin
  with RqMP do begin
     if (RqInd >= Low(ArrGrm)) and (RqInd <= High(ArrGrm))
     then begin
       //    
       ArrGrm[RqInd].ModTCt := 0;
       ArrGrm[RqInd].ModTSw := True;
       //        
       ArrGrm[RqInd].PrdMM := 0;  //     
       ArrGrm[RqInd].FrqM := ArrGrm[RqInd].Frq;
       ArrGrm[RqInd].PrdM := ArrGrm[RqInd].Prd;
     end;
  end;
end;
//  /      
procedure TGeneratorFrm.CheckBoxPrdModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
    // ./.  
    MainParm.ArrGrm[Ind].ModTOn := CheckBoxPrdMod.Checked;
    //       
    if not CheckBoxPrdMod.Checked
    then //       
         ClearPrdModCicle (Ind, MainParm);
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.CmbBoxPeriodModClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0   //   
  then begin
    //    
    MainParm.ArrGrm[Ind].ModTTp := CmbBoxPeriodMod.ItemIndex;
    //      
    if MainParm.ArrGrm[Ind].ModTTp > 0
    then ShowPrdModOnOff(True)
    else ShowPrdModOnOff(False);
    //       
     ClearPrdModCicle (Ind, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//        
procedure TGeneratorFrm.CmbBoxPrdLenClick(Sender: TObject);
var Ind : integer;
begin
  Ind := CmbBoxGrm.ItemIndex;
  if Ind >= 0  //   
  then begin
     MainParm.ArrGrm[Ind].ModTLn := CmbBoxPrdLen.ItemIndex;
     //       
     ClearPrdModCicle (Ind, MainParm);
     //        
     CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.CmbBoxPrdWidthClick(Sender: TObject);
var Ind1, Ind2 : integer;
begin
  Ind1 := CmbBoxGrm.ItemIndex;
  Ind2 := CmbBoxPrdWidth.ItemIndex;
  if (Ind1 >= 0) and (Ind2 >= 0)
  then begin
    //     
    MainParm.ArrGrm[Ind1].ModTWd := Ind2;
    //       
    ClearPrdModCicle (Ind1, MainParm);
    //        
    CalcAndShowSignalAndGrm (MainParm);
  end;
end;
// -------------------------------------------------------------------------
//       
procedure TGeneratorFrm.BitBtnResetPrdModClick(Sender: TObject);
begin
   if MainParm.IndGrm >=0
   then begin
     //       
     ClearPrdModCicle (MainParm.IndGrm, MainParm);
     //        
     CalcAndShowSignalAndGrm (MainParm);
   end;
end;

// -------------------------------------------------------------------------
//    
// -------------------------------------------------------------------------
//      ,   
//  
procedure TGeneratorFrm.BitBtnReSetAllModClick(Sender: TObject);
var Ind : integer;
begin
  for Ind := Low(MainParm.ArrGrm) to High(MainParm.ArrGrm)
  do begin
      //       
      ClearAmpModCicle (Ind, MainParm);
      //       
      ClearPhsModCicle (Ind, MainParm);
      //       
      ClearPrdModCicle (Ind, MainParm);
  end;
  //        
  CalcAndShowSignalAndGrm (MainParm);
end;

// =========================================================================
//     
// =========================================================================
//    Y = SUM ( A [ n ] * SIN ( n * X  + P [ n ] )
procedure TGeneratorFrm.SpBtnSinClick(Sender: TObject);
begin
  MainParm.RqCos := not SpBtnSin.Down;
  if not MainParm.RqCos
  then StTxtSinCos.Caption := SumSinTxt;
  MakeSignal (MainParm);
  ShowDSignal (MainParm);
end;
// -------------------------------------------------------------------------
//    Y = SUM ( A [ n ] *  ( n * X  + P [ n ] )
procedure TGeneratorFrm.SpBtnCosClick(Sender: TObject);
begin
  MainParm.RqCos := SpBtnCos.Down;
  if MainParm.RqCos
  then StTxtSinCos.Caption := SumCosTxt;
  MakeSignal (MainParm);
  ShowDSignal (MainParm);
end;

// =========================================================================
// 
// =========================================================================
// -------------------------------------------------------------------------
//      
procedure TGeneratorFrm.BitBtnScaleSignalClick(Sender: TObject);
begin
  ShowDSignal (MainParm);
end;
// -------------------------------------------------------------------------
//   
procedure TGeneratorFrm.CmbBoxFreqClick(Sender: TObject);
var Ind : integer;
begin
   Ind := CmbBoxFreq.ItemIndex;
   if Ind >= 0
   then begin
     MainParm.Frequency := ArrFreq[Ind];
     InitGrmFreqPrd(MainParm);
     //    
     ShowGrmParm(CmbBoxGrm.ItemIndex, MainParm);
     //     
     InitAndShowAllDisplay(MainParm);
     //      
     GeneratorSignalReady(MainParm);
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TGeneratorFrm.MMAboutClick(Sender: TObject);
begin
   GeneratorAboutBox.ShowModal;
end;
// =========================================================================
//    EXCEL
// =========================================================================
//  
procedure TGeneratorFrm.BitBtnToXlsClick(Sender: TObject);
begin
   //     Excel
   if SpBtnStop.Down
   then ExportToExcel()
   else MessageDlg('  Excel  '
                   + #13#10
                   + '  ',
                   mtWarning, [mbYes], 0);
end;

// =========================================================================
//    
// =========================================================================
//   
procedure TGeneratorFrm.BitBtnNewSpectrClick(Sender: TObject);
begin
   NewSpectrFrm.ShowModal;
   //    
   if  MainParm.RqNew
   then begin
     //        
     ShowNewOrLoadSpectr(MainParm);
     MainParm.RqNew := False;
     Self.Caption := cAppTitle + 'NoName';
   end;
end;
// -------------------------------------------------------------------------
//   
procedure TGeneratorFrm.BitBtnSaveSpectrClick(Sender: TObject);
const UExt = '.SP1';
      LExt = '.sp1';
var   wFileName : string;
begin
  //    
  if not SpBtnStop.Down
  then begin
    MessageDlg(SaveWarning, mtWarning, [mbYes], 0);
    Exit;
  end;
  //     
  SaveDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  //    
  SaveDialog1.Filter := 'Spectr files (*' + LExt + ')|*' + UExt;
  if SaveDialog1.Execute
  then begin
      wFileName := SaveDialog1.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> UExt
      then wFileName := wFileName + LExt;
      //  
      if FileExists(wFileName)
      then begin
        if MessageDlg('   ! '
                     + #13#10
                     + '  : '
                     + ExtractFileName(wFileName),
                     mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
          //    
          if SaveStectrToFile (wFileName, MainParm)
          then LoadFileName := ExtractFileName(wFileName)
          else LoadFileName := 'NoName';
          Self.Caption := cAppTitle + LoadFileName;
        end;
      end
      else begin
        //    
          if SaveStectrToFile (wFileName, MainParm)
          then LoadFileName := ExtractFileName(wFileName)
          else LoadFileName := 'NoName';
          Self.Caption := cAppTitle + LoadFileName;
      end;
  end;
end;
// -------------------------------------------------------------------------
//    
procedure TGeneratorFrm.BitBtnLoadSpectrClick(Sender: TObject);
begin
   //     
  OpenDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  OpenDialog1.Filter := 'Spectr files (*.sp1)|*.SP1';
  if OpenDialog1.Execute
  then begin
     if LoadStectrFromFile (OpenDialog1.FileName, MainParm) = 0
     then begin
       //       
       ShowNewOrLoadSpectr(MainParm);
       LoadFileName := ExtractFileName(OpenDialog1.FileName);
       Self.Caption := cAppTitle + LoadFileName;
     end
     else begin     //  I/O
       //   
       if InitGenerator(MainParm)
       then begin
           LoadFileName := 'NoName';
           Self.Caption := cAppTitle + LoadFileName;
       end else Self.Close;
     end;
  end;
end;
// -------------------------------------------------------------------------
//     
procedure TGeneratorFrm.BitBtnImportSpectrClick(Sender: TObject);
begin
   FormGrmImp.ShowModal;
   if MainParm.RqNew and (Length(MainParm.ArrGrm) > 0)
   then begin
     //      
     StTxtGrmNum.Caption := ' ' + IntToStr(MainParm.NumGrm) + ' .';
     //      
     InitGrmFreqPrd(MainParm);
     //     
     InitCmbBoxGrm(MainParm);
     //    
     ShowGrmParm (0, MainParm);
     //     
     InitAndShowAllDisplay (MainParm);
   end;
   MainParm.RqNew := False;
end;
// -------------------------------------------------------------------------
//       
// -------------------------------------------------------------------------
//   
procedure TGeneratorFrm.MMNewSpectrClick(Sender: TObject);
begin
   BitBtnNewSpectrClick(nil);
end;
// -------------------------------------------------------------------------
//    
procedure TGeneratorFrm.MMLoadSpectrClick(Sender: TObject);
begin
   BitBtnLoadSpectrClick(nil);
end;
// -------------------------------------------------------------------------
//   
procedure TGeneratorFrm.MMSaveSpectrAsClick(Sender: TObject);
begin
   BitBtnSaveSpectrClick(nil);
end;
// -------------------------------------------------------------------------
//   
procedure TGeneratorFrm.MMCloseClick(Sender: TObject);
begin
 Self.Close;
end;

// =========================================================================
//     
// =========================================================================
//       
procedure TGeneratorFrm.BitBtnToTxtClick(Sender: TObject);
const UExt = '.TXT';
      LExt = '.txt';
var   wFileName : string;
begin
  //    
  if not SpBtnStop.Down
  then begin
    MessageDlg(SaveWarning, mtWarning, [mbYes], 0);
    Exit;
  end;
  //     
  SaveDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  //    
  SaveDialog1.Filter := 'Report files (*' + LExt + ')|*' + UExt;
  if SaveDialog1.Execute
  then begin
      wFileName := SaveDialog1.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> UExt
      then wFileName := wFileName + LExt;
      //  
      if FileExists(wFileName)
      then begin
        if MessageDlg('   ! '
                     + #13#10
                     + '  : '
                     + ExtractFileName(wFileName),
                     mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
          //    
          ReportToFile (wFileName, MainParm)
        end;
      end
      else ReportToFile (wFileName, MainParm);
  end;
end;

// =========================================================================
//     
// =========================================================================
//       
procedure TGeneratorFrm.SaveGraphReport (RqImg : TImage);
const UExt = '.JPG';
      LExt = '.jpg';
var   wFileName : string;
begin
  //    
  if not SpBtnStop.Down
  then begin
    MessageDlg(SaveWarning, mtWarning, [mbYes], 0);
    Exit;
  end;
  //     
  SavePictureDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  //    
  SavePictureDialog1.Filter := 'Report files (*' + LExt + ')|*' + UExt;
  if SavePictureDialog1.Execute
  then begin
      wFileName := SavePictureDialog1.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> UExt
      then wFileName := wFileName + LExt;
      //  
      if FileExists(wFileName)
      then begin
        if MessageDlg('   ! '
                     + #13#10
                     + '  : '
                     + ExtractFileName(wFileName),
                     mtWarning, [mbYes, mbNo], 0) = mrYes
        then begin
          //     
          SavePicture(wFileName, RqImg, 'J');
        end;
      end
      //     
      else SavePicture(wFileName, RqImg, 'J');
  end;
end;
// -------------------------------------------------------------------------
//     jpg - 
procedure TGeneratorFrm.BitBtnSavePicSignalClick(Sender: TObject);
begin
   SaveGraphReport (MainParm.DSignal.Img);
end;
// -------------------------------------------------------------------------
//     jpg - 
procedure TGeneratorFrm.BitBtnSavePicSpectrClick(Sender: TObject);
begin
  SaveGraphReport (MainParm.DSpectr.Img);
end;
// -------------------------------------------------------------------------
//     jpg - 
procedure TGeneratorFrm.BitBtnSavePicPhaseClick(Sender: TObject);
begin
  SaveGraphReport (MainParm.DSpectr.DPolar.Img);
end;
// -------------------------------------------------------------------------

// =========================================================================
// 
// =========================================================================

end.
