unit GeneratorLoadSave;

interface
uses SysUtils, Dialogs,
     GeneratorDATA;

//    
function SaveStectrToFile (FileName : string; RqMP : TMainParm) : boolean;

//    
function LoadStectrFromFile (FileName : string; var RqMP : TMainParm) : integer;

implementation
// -------------------------------------------------------------------------
//    
function SaveStectrToFile (FileName : string; RqMP : TMainParm) : boolean;
var FCB    : file;
    OpenOK : boolean;
    RqNum  : integer;
begin
   Result  := False;
   OpenOK  := False;
   RqNum   := Length(RqMP.ArrGrm);
   if RqNum > 0
   then begin
     try
       AssignFile(FCB, FileName);
       Rewrite(FCB, SizeOF(TGarmonics));
       OpenOK  := True;
       BlockWrite(FCB, RqMP.ArrGrm[Low(RqMP.ArrGrm)], RqNum);
       CloseFile(FCB);
       MessageDlg('    '
                    + #13#10
                    + ' : ' + ExtractFileName(FileName),
                    mtInformation, [mbOk], 0);
       Result := True;
     except
       if OpenOK then CloseFile(FCB);
       MessageDlg('    '
                    + #13#10
                    + ' : ' + ExtractFileName(FileName)
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
     end;
   end;
end;
// -------------------------------------------------------------------------
//    
function LoadStectrFromFile (FileName : string; var RqMP : TMainParm) : integer;
var FCB    : file;
    OpenOK : boolean;
    RqNum  : integer;
    RdNum  : integer;
begin
    Result := 2;                 //   BlockRead
    OpenOK := False;             //    Reset
    try
       AssignFile(FCB, FileName);
       Reset(FCB, SizeOF(TGarmonics));
       OpenOK := True;
       RqNum := FileSize(FCB);
       if (RqNum >= NewGrmNums[Low(NewGrmNums)]) and
          (RqNum <= NewGrmNums[High(NewGrmNums)])
       then begin
          SetLength(RqMP.ArrGrm, RqNum);
          BlockRead(FCB, RqMP.ArrGrm[Low(RqMP.ArrGrm)], RqNum, RdNum);
          CloseFile(FCB);
          if RqNum = RdNum
          then begin
               Result := 0;      //  
               MessageDlg('    '
                          + #13#10
                          + ' : ' + ExtractFileName(FileName),
                          mtInformation, [mbOk], 0);
          end
          else begin
               Result := 1;      //   Reset
               MessageDlg('    '
                          + #13#10
                          + ' : ' + ExtractFileName(FileName)
                          + #13#10
                          + 'Win-API : ' + SysErrorMessage(GetLastError),
                          mtWarning, [mbOk], 0);
          end;
       end;
    except
       if OpenOK then CloseFile(FCB);
       MessageDlg('    '
                    + #13#10
                    + ' : ' + ExtractFileName(FileName)
                    + #13#10
                    + 'Win-API : ' + SysErrorMessage(GetLastError),
                    mtWarning, [mbOk], 0);
   end;
end;
// -------------------------------------------------------------------------

end.
