unit GeneratorGrmImport;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, StrUtils,
  GlobalDATA,
  GeneratorDATA;

type
  TFormGrmImp = class(TForm)
    LbGrmImport: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    PanelImportSep: TPanel;
    RadioGroupSep: TRadioGroup;
    EditSep: TEdit;
    OpenDialog1: TOpenDialog;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
    //     
    procedure ImportSpectr();
  public
    { Public declarations }
  end;

var
  FormGrmImp: TFormGrmImp;

implementation

{$R *.dfm}

//      
var BufArrGrm : array [0..GrmMaxNum-1] of TGarmonics;

//  
var AmpErrCt, PhsErrCt : integer;

// -------------------------------------------------------------------------
//       
function TextToDouble (Text : string; var Digit : Double) : boolean;
begin
  TextToDouble := False;
  try
    Digit := StrToFloat(Text);
    TextToDouble := True;
  except
    Digit := 0;
  end;
end; // of function

// -------------------------------------------------------------------------
//  Amp  Phs       
procedure OneGrmToBufArrGrm (RqIndG : integer; RqSep, RqStr : string);
var  wPos : integer;
     wStr : string;
     wDbl : double;
begin
  //   
  // Pos = 0    
  // Pos = 1        
  wPos := Pos(RqSep, RqStr);
  if wPos > 1
  then begin
    //   ,    
    wStr := Trim(Copy(RqStr, 1, wPos - 1));
    if wStr <> ''
    then begin
       //    Amp
       if TextToDouble(wStr, wDbl)
       then begin
           //    BufArrGrm[RqIndG]
           BufArrGrm[RqIndG].Amp  := wDbl;
           BufArrGrm[RqIndG].AmpM := wDbl;
       end
       else Inc(AmpErrCt);
    end;
    //     
    wStr := RqStr;
    Delete(wStr, 1, wPos);
    wStr := Trim(wStr);
    if wStr <> ''
    then begin
       //    Phs
       if TextToDouble(wStr, wDbl)
       then begin
           //    BufArrGrm[RqIndG]
           BufArrGrm[RqIndG].Phs  := wDbl;
           BufArrGrm[RqIndG].PhsM := wDbl;
       end
       else Inc(PhsErrCt);
    end;
  end;
end;

// -------------------------------------------------------------------------
//     
function LoadTxtToBufArrGrm (RqSep : string; RqList : TStringList) : boolean;
var IndG : integer;   //     BufArrGrm
    IndL : integer;   //     RqList
    wStr : string;
begin
   Result := False;
   //   
   AmpErrCt := 0; PhsErrCt := 0;
   //     RqList
   IndL := 0;
   for IndG := Low(BufArrGrm) to High(BufArrGrm)
   do begin
     //     
     FillChar(BufArrGrm[IndG], SizeOf(BufArrGrm[IndG]), #0);
     //      RqList
     wStr := '';
     if IndL <= (RqList.Count - 1)
     then begin
       repeat
         wStr := Trim(RqList.Strings[IndL]);
         //  
         if Length(wStr) > 0 then if wStr[1] ='/' then wStr := '';
         Inc(IndL);
       until wStr <> '';
     end;
     //  Amp  Phs   
     if wStr <> ''
     then begin
       OneGrmToBufArrGrm (IndG, RqSep, wStr);
     end;
   end;
   if (AmpErrCt = 0) and (PhsErrCt = 0)
   then Result := True;                //  
end;

// -------------------------------------------------------------------------
//      
function ImportStectrFromFile (RqFileName : string;
                               RqSep      : string) : boolean;
//    
var wList : TStringList;
begin
  Result := False;
  wList  := nil;
  try
    wList  := TStringList.Create;     //    
    wList.LoadFromFile(RqFileName);   //    
    if wList.Count > 0
    then begin
       if LoadTxtToBufArrGrm (RqSep, wList)
       then Result := True;           //  
    end;
  finally
     if wList <> nil then wList.Free;
  end;
end;

// -------------------------------------------------------------------------
//      
function InitAndLoadArrGrm (var RqMP : TMainParm) : boolean;
var IndG : integer;
begin
  Result := False;
  with RqMP do begin
     try //     
       SetLength(ArrGrm, GrmMaxNum);
       //      
       for IndG := Low(ArrGrm) to High(ArrGrm)
       do ArrGrm[IndG] := BufArrGrm[IndG];
       NumGrm := GrmMaxNum;
       Result := True;
     except
       NumGrm := 0;
       MessageDlg('    ', mtError, [mbYes], 0);
     end;
  end;
end;

// -------------------------------------------------------------------------
//     
procedure TFormGrmImp.ImportSpectr();
var wSep : string;
begin
   //     
  OpenDialog1.InitialDir := ExtractFilePath(Application.ExeName);
  OpenDialog1.Filter := 'Import spectr files (*.txt)|*.TXT';
  if OpenDialog1.Execute
  then begin
     //   ,  Amp  Phs
     case RadioGroupSep.ItemIndex of
       0 : wSep := #09;  // 
       1 : wSep := ' ';
       2 : wSep := ';';
       3 : wSep := LeftStr(Trim(EditSep.Text),1);
       else wSep := ' ';
     end; // of case
     //       
     if ImportStectrFromFile (OpenDialog1.FileName, wSep)
     then begin
       //    
       MainParm.RqNew := True;
       //  ,      
       InitAndLoadArrGrm (MainParm);
     end
     else begin  // 
       MessageDlg('     :'
                   + #13#10 + '  - ' + IntToStr(AmpErrCt)
                   + #13#10 + ' .  - ' + IntToStr(PhsErrCt)
                   + #13#10 + '  ',
                   mtWarning, [mbYes], 0);
     end;
  end;
end;
// -------------------------------------------------------------------------
//  
procedure TFormGrmImp.CancelBtnClick(Sender: TObject);
begin
  //     
  MainParm.RqNew := False;
  //     
  FormGrmImp.Close;
end;
// -------------------------------------------------------------------------
//  
procedure TFormGrmImp.OKBtnClick(Sender: TObject);
begin
  //     
  ImportSpectr();
  //     
  FormGrmImp.Close;
end;

end.
