unit GeneratorDATA;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  GlobalDATA;

// =========================================================================
const cAppVersion   = ' v.5.3 2013.';
const cAppTitle = ' Freeware.'
                   + ' .'
                   + cAppVersion
                   + '  : ';
// =========================================================================
//       
type TSignal = record
     //     ( Y := Func(X))
     X   : double;       //  X  
     Y   : double;       //  Y
     //   
     T   : double;       //     (ms)
     //   
     XP  : integer;      //  X - 
     YP  : integer;      //  Y - 
end;
//    
type TArrSignal = array of TSignal;

//        
type TGarmonics = record
   //-----------------------
   //   
   Amp    : double;         //   
   //   
   AmpM   : double;         //   
   //    
   ModATp : integer;        // -   
   ModAOn : boolean;        // . / .    
   ModALn : integer;        // -   
   ModADp : integer;        // -   
   ModASw : boolean;        //    
   ModACt : integer;        //     
   //-----------------------
   //    
   Phs    : double;         //   
   PGrd   : boolean;        // (False)/(True)
   //    
   PhsM   : double;         //    
   PhsG   : double;         //     
   PhsT   : double;         //     (ms)
   //    
   ModPTp : integer;        // -   
   ModPOn : boolean;        // . / .    
   ModPLn : integer;        // -   
   ModPWd : integer;        // -   
   ModPSw : boolean;        //    
   ModPCt : integer;        //     
   //-----------------------
   //     
   Frq    : double;         //     
   Prd    : double;         //    ms
   //      
   FrqM   : double;         //     
   PrdM   : double;         //    ms
   //     (   )
   PrdMM  : double;         //    (GrmInd (+..-) 0,X)
   ModTTp : integer;        // -   
   ModTOn : boolean;        // . / .    
   ModTLn : integer;        // -   
   ModTWd : integer;        // -   
   ModTSw : boolean;        //    
   ModTCt : integer;        //     
   //-----------------------
   //      
   DXP    : integer;        //  X - 
   DYP    : integer;        //  Y - 
   DCL    : TColor;         //   
end;
//     
type TArrGarmonics = array of TGarmonics;

//      
type TDPolar = record
     Img    : TImage;       // Image   
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     cnX    : integer;      // X -    
     cnY    : integer;      // Y -    
     PShow  : boolean;      //     
     VX     : integer;      //  X -   
     VY     : integer;      //  Y -   
end;
//    
type TDSpectr = record
     Img    : TImage;       // Image   
     MaxYPn : byte;         // .    Y
     PntL   : byte;         //    
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     AmpMax : double;       //    
     YSc    : double;       // .   Y
     XSc    : double;       // .   X
     DSShow : boolean;      //     
     //       
     DPolar : TDPolar;
end;
//   
type TDSignal = record
     Img    : TImage;       // Image   
     MaxXPn : byte;         // .    X
     MaxYPn : byte;         // .    Y
     PntL   : byte;         //    
     OffX   : integer;      // X -       Img
     OffY   : integer;      // Y -       Img
     LenX   : integer;      // X -     
     LenY   : integer;      // Y -     
     XZero  : integer;      // X -     
     YZero  : integer;      // Y -     
     AmpMax : double;       //    
     YSc    : double;       // .   Y
     XSc    : double;       // .   X
     SgShow : boolean;      //    
end;

//   
type TMainParm = record
   //  
   RqNew     : boolean;     //  -    
   Frequency : integer;     //    
   Period    : double;      //     (ms)
   DigNum    : integer;     //    
   //   
   NumGrm    : integer;     //   
   IndGrm    : integer;     //   
   ArrGrm    : TArrGarmonics;  //   
   maxGrm    : double;      //     
   //      
   RqCos     : boolean;     //  Y[n,X] = AmpM[n] * COS(n*X + PhsM[n])
   ArrSg     : TArrSignal;  //  
   //   
   minSY     : double;      //   
   maxSY     : double;      //   
   MAAmp     : double;      //   
   MRAmp     : double;      //  () 
   //    
   LenSer    : integer;     //     
   minYSer   : double;      //    
   maxYSer   : double;      //    
   //       
   DSpectr   : TDSpectr;    //    
   DSignal   : TDSignal;    //    
end;

// =========================================================================
//    
// =========================================================================

//     
const GrmMaxNum  = GlobalGrmMaxNum;

//      (8   32 )
// !         
const DigMaxNum = 8 * GrmMaxNum + 1;

// =========================================================================
//      
// =========================================================================
//       
// const NewGrmNums : array [0..3] of integer = (8,16,24,GrmMaxNum);

//      
const ArrFreq : array [0..4] of integer = (48,49,50,51,52);
//        
const FreqIndDef = 2;

//     ,
//      .
const ArrModAmp : array [0..10] of integer = (0,10,20,30,40,50,60,70,80,90,100);

//     ,
//      .
const ArrModPhs : array [0..4] of integer = (0,25,50,75,100);

//     ,
//      .
const ArrModPrd : array [0..10] of integer = (0,10,20,30,40,50,60,70,80,90,100);

//    (  ),  
//      (, , )
const ArrModLen : array [0..6] of record
  Tit : string;   //    
  Len : integer;  //    
end = (
 (Tit : ' 10  '; Len :  10),
 (Tit : ' 25  '; Len :  25),
 (Tit : ' 50  '; Len :  50),
 (Tit : ' 75  '; Len :  75),
 (Tit : ' 100 '; Len : 100),
 (Tit : ' 150 '; Len : 150),
 (Tit : ' 200 '; Len : 200)
      );

//     
const SumSinTxt = '  Y = Ao + SUM ( An * SIN ( n * X  + Pn ) )';
      SumCosTxt = '  Y = Ao + SUM ( An * COS ( n * X  + Pn ) )';

// =========================================================================
//     
// =========================================================================
//   
var AppStartDir : string;

//    
var  MainParm     : TMainParm;

//    
var  LoadFileName : string;

// =========================================================================
//     
// =========================================================================
//       
var NewGrmNums : array  of integer;

// =========================================================================
//    
// =========================================================================

//     " "
function NormalizePhase (RqPhs : double) : double;

implementation

//     " "
function NormalizePhase (RqPhs : double) : double;
const TwoPi = 2 * Pi;
begin
  if RqPhs > TwoPi
  then Result := Frac(RqPhs / TwoPi) * TwoPi
  else Result := RqPhs;
end;

end.
