unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Menus, ExtDlgs, Buttons,

  //GDIPAPI,
  AnimeGif01;

type
  TForm1 = class(TForm)
    StTxtFileName: TStaticText;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    MMOpen: TMenuItem;
    MMExit: TMenuItem;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    SpdBttStart: TSpeedButton;
    SpdBttStop: TSpeedButton;
    ChBoxCycle: TCheckBox;
    Panel1: TPanel;
    Label3: TLabel;
    Label1: TLabel;
    CmbBoxIMode: TComboBox;
    CmbBoxZoom: TComboBox;
    Panel3: TPanel;
    Image2: TImage;
    EdDelay: TEdit;
    Label2: TLabel;
    Label4: TLabel;
    StTxtFrCount: TStaticText;
    Label5: TLabel;
    EdFrIndex: TEdit;
    StTxtFrTime: TStaticText;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    StTxtLoopCount: TStaticText;
    StTxtLCountDown: TStaticText;
    Label9: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    ChkBoxIncrm: TCheckBox;
    procedure MMOpenClick(Sender: TObject);
    procedure ChBoxCycleClick(Sender: TObject);
    procedure CmbBoxIModeClick(Sender: TObject);
    procedure CmbBoxZoomClick(Sender: TObject);
    procedure SpdBttStartClick(Sender: TObject);
    procedure SpdBttStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EdDelayChange(Sender: TObject);
    procedure MMExitClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EdFrIndexChange(Sender: TObject);
    procedure ChkBoxIncrmClick(Sender: TObject);
  private
    { Private declarations }
    procedure ClearImg(RqImg : TImage);
    procedure StartStop();
    //      
    procedure ShowCountDown(const LoopCount : integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// --------------------------------------------------------------------------
//  http://www.gifs.net  (   GIF)
// --------------------------------------------------------------------------

var AnimeGif : TAnimeGif;

// --------------------------------------------------------------------------
//  Edit.Text      
function EditTextToFloat (RqEdit : TEdit;
                      var RqFloat : single) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result  := True;    //   
  except
    RqEdit.Color := RGB(255,200,200);
    ShowMessage('    ');
  end;
end;

// --------------------------------------------------------------------------
//  Edit.Text      
function EditTextToInt (RqEdit : TEdit;
                      var RqFloat : integer) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToInt(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result  := True;    //   
  except
    RqEdit.Color := RGB(255,200,200);
    ShowMessage('    ');
  end;
end;

// --------------------------------------------------------------------------
//     
procedure TForm1.EdDelayChange(Sender: TObject);
var DelayAdd : integer;
begin
  if EditTextToInt(EdDelay, DelayAdd)
  then AnimeGif.DelayAdd := DelayAdd;
end;

// --------------------------------------------------------------------------
//       
procedure TForm1.ChkBoxIncrmClick(Sender: TObject);
begin
  AnimeGif.Incrm := ChkBoxIncrm.Checked;
end;

// --------------------------------------------------------------------------
//     
procedure TForm1.EdFrIndexChange(Sender: TObject);
var Ind : integer;
begin
   if EditTextToInt (EdFrIndex, Ind)
   then begin
     if (Ind < 0)
     then begin
        Ind := 0;
        EdFrIndex.Enabled := False;
        EdFrIndex.Text := IntToStr(Ind);
        EdFrIndex.Enabled := True;
     end;
     if (Cardinal(Ind) >= AnimeGif.FrCount)
     then begin
        Ind := AnimeGif.FrCount - 1;
        EdFrIndex.Enabled := False;
        EdFrIndex.Text := IntToStr(Ind);
        EdFrIndex.Enabled := True;
     end;
     StTxtFrTime.Caption := IntToStr(AnimeGif.FrTime[Ind]);
   end;
end;

// --------------------------------------------------------------------------
//   
procedure TForm1.CmbBoxIModeClick(Sender: TObject);
var Indx : integer;
begin
  Indx := CmbBoxIMode.ItemIndex;
  AnimeGif.SetIMode(Indx);
end;

// --------------------------------------------------------------------------
//   Zoom ()
procedure TForm1.CmbBoxZoomClick(Sender: TObject);
begin
  with AnimeGif do
  begin
  case CmbBoxZoom.ItemIndex of
  0  : Zoom := 0.1;
  1  : Zoom := 0.3;
  2  : Zoom := 0.5;
  3  : Zoom := 0.7;
  4  : Zoom := 1;
  5  : Zoom := 1.3;
  6  : Zoom := 1.5;
  7  : Zoom := 1.7;
  8  : Zoom := 2;
  9  : Zoom := 2.3;
  10 : Zoom := 3;
  else Zoom := 1;
  end;
  end;
  ClearImg(Image1);
end;

// --------------------------------------------------------------------------
//  
procedure TForm1.ClearImg(RqImg : TImage);
begin
   //   Image   
  RqImg.Picture.Bitmap.Height := Screen.Height;
  RqImg.Picture.Bitmap.Width  := Screen.Width;
  //  Image   
  RqImg.Canvas.Brush.Color := Self.Canvas.Brush.Color;
  RqImg.Canvas.FillRect(Rect(0, 0, RqImg.Width, RqImg.Height));
end;

// --------------------------------------------------------------------------
//   /  
procedure TForm1.StartStop();
begin
   if not AnimeGif.Run then Exit;
   if not Assigned(AnimeGif.GDbmp)
   then begin
      ShowMessage('    GIF');
      Exit;
   end;
   //   
   CmbBoxIModeClick(Self);
   //   Zoom ()
   CmbBoxZoomClick(Self);
   ClearImg(Image1);
   //   GIF
   if Assigned(AnimeGif) then AnimeGif.ShowZoomGif(Image1);
   //
   SpdBttStop.Down := True;
   Panel1.Visible  := True;
end;

// --------------------------------------------------------------------------
//  
procedure TForm1.SpdBttStartClick(Sender: TObject);
begin
  if SpdBttStart.Down
  then begin
    AnimeGif.Run :=  True;
    Panel1.Visible := False;
    StartStop();
  end;
end;

// --------------------------------------------------------------------------
//  
procedure TForm1.SpdBttStopClick(Sender: TObject);
begin
  AnimeGif.Run :=  False;
end;

// --------------------------------------------------------------------------
//   
procedure TForm1.ChBoxCycleClick(Sender: TObject);
begin
  AnimeGif.Cycle := ChBoxCycle.Checked;
end;

// --------------------------------------------------------------------------
//    
procedure TForm1.ShowCountDown(const LoopCount : integer);
begin
   StTxtLCountDown.Caption := IntToStr(LoopCount);
end;

// --------------------------------------------------------------------------
//  GIF
procedure TForm1.MMOpenClick(Sender: TObject);
begin
   if AnimeGif.LoadGifFile(OpenDialog1)
   then begin

      StTxtFrCount.Caption := IntToStr(AnimeGif.FrCount);
      StTxtLoopCount.Caption := IntToStr(AnimeGif.LoopCount);
      EdFrIndex.Text := '0';
      EdFrIndexChange(Self); 
      
      if SpdBttStart.Down
      then begin
         SpdBttStop.Down := True;
         SpdBttStopClick(Self);
         AnimeGif.Run := False;
      end;
      ClearImg(Image2);
      AnimeGif.ShowThumbnailImage(Image2,
                                  Panel3.Width,
                                  Panel3.Height);

      ClearImg(Image1);
      StTxtFileName.Caption := OpenDialog1.FileName;
      Panel2.Visible := True;
   end;
end;

// --------------------------------------------------------------------------
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
   AnimeGif := TAnimeGif.Create(Application);
   AnimeGif.onCountDown := ShowCountDown;
   Panel2.Visible := False;
   ChBoxCycle.Checked := False;
   AnimeGif.Cycle := ChBoxCycle.Checked;
end;
// 
procedure TForm1.FormDestroy(Sender: TObject);
begin
   if Assigned(AnimeGif) then AnimeGif.Free;
end;
// --------------------------------------------------------------------------
//  
procedure TForm1.MMExitClick(Sender: TObject);
begin
   if SpdBttStart.Down
   then begin
         SpdBttStop.Down := True;
         SpdBttStopClick(Self);
         AnimeGif.Run := False;
   end;
   Self.Close;
end;
// --------------------------------------------------------------------------




end.
