unit SwitchScope03;
(*
                        SWITCH - 
                    
                          (TSwitchScope)

          TCustomScope
       (. unit CustomScope03).

    TSwitchScope     
   ,     , 
   ,      ..

           
     TImage ( -  Image).

      // -----------------------------------------------------
      // ,    
      // -----------------------------------------------------
      MaxScope    -    
                    (     
                       )
      // --------------------------------------------------
      //    
      // --------------------------------------------------
      XBeg        - X- ( )    Image
      YBeg        - Y- ( )    Image
       // -----------
      Compact     -   
      Transparent -  
      // --------------------------------------------------
      //     
      // --------------------------------------------------
      Visible     -  
      Value       -    

           unit CustomScope03
    type TCustomScope = class(TObject)

   // -----------------------------------------------------
   //   :
   Scope := TSwitchScope.Create(Image1, RqXB, RqYB);
   // -----------------------------------------------------
   //     :
   if Assigned(Scope) then Scope.Value := ...;   //  
   // -----------------------------------------------------
    3.00. ()  , , , 2018.
                () Source code  ..
     04.07.2018
*)
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls, CustomScope03;

type TSwitchScope = class(TCustomScope)
private
  // ------------------------
  fTimer       : TTimer;    //   
  // ------------------------
  //    
  fIRect       : TRect;     //     fBmp
  fSRect       : TRect;     //     fBmp
  // ------------------------
  //       
  procedure CalcAreas();
  // ------------------------
  procedure onTimer(Sender : TObject);

protected
  //        
  procedure ReSizeScope();  override;
  // ------------------------
  //     fBmp
  procedure PaintToBmp(Bmp : TBitMap); override;
public
  // ------------------------
  //  / 
  constructor  Create(RqImage : TImage; RqXB, RqYB : integer);
  procedure Free();
end;

implementation

// -------------------------------------------------------------------------
//     
//(       cMaxValue + 1)
const cMaxValue = 1;

//   
const cWIcon  = 22;         //   
      cHIcon  = 16;         //   
      cWText  = 40;         //    
      cHText  = cHIcon;     //    
      cWBound = 6;          // W -   
      cHBound = 6;          //  -   
      cWLenI  = cWIcon + 2 * cWBound;
      cHLenI  = cHIcon + 2 * cHBound;
      cWLenIT = cWIcon + cWText + 4 * cWBound;
      cHLenIT = cHIcon + 2 * cHBound;
// -------------------------------------------------------------------------
constructor TSwitchScope.Create(RqImage : TImage; RqXB, RqYB : integer);
begin
   inherited Create(RqImage, RqXB, RqYB, cWLenIT, cHLenIT) ;
   // -----------------------
   //     
   fTimer := TTimer.Create(nil);
   fTimer.Interval := 100;
   fTimer.OnTimer  := onTimer;
   fTimer.Enabled  := False;
   // -----------------------
   //   
   Transparent  := False;
   // -----------------------
   ScopeName := ' ';
   //       
   CalcAreas();
   // -----------------------
   //       
   MaxScope  := 1;
   MinScope  := 0;
   Value     := 0;
   // -----------------------
   //  
   Visible := True;
end;

// -------------------------------------------------------------------------
//
procedure TSwitchScope.Free();
begin
   // -----------------------
   if Assigned(fTimer)
   then fTimer.Free;
   // -----------------------
   inherited Free();
end;
// -------------------------------------------------------------------------
//       
procedure TSwitchScope.CalcAreas();
var wBmp : TBitMap;
    wWLen, wHLen : integer;
begin
   // -----------------------
   //   
   wBmp  := Bmp;
   wWLen := wBmp.Canvas.TextWidth (ScopeName) + 2 * cWBound;
   wHLen := wBmp.Canvas.TextHeight(ScopeName);
   // -----------------------
   //   
   if Compact
   then begin
        //    
        ScopeSize(cWLenI, cHLenI);
        fSRect := Rect(0, 0, cWLenI,  cHLenI)
   end
   else begin
      //    
      if wWLen < (ScopeRect.Right - ScopeRect.Left)
      then wWLen := (ScopeRect.Right - ScopeRect.Left);
      //    
      if wWLen < cWLenIT then wWLen := cWLenIT;
      wHLen := wHLen + cHLenIT;
      //    
      ScopeSize(wWLen, wHLen);
      fSRect := Rect(0, 0, wWLen, wHLen);
   end;
   // -----------------------
   //    
   fIRect := Rect(cWBound, cHBound, cWIcon + cWBound, cHIcon + cHBound);
end;

// -------------------------------------------------------------------------
//        
procedure TSwitchScope.ReSizeScope();
begin
   if Visible then Visible := False;
   CalcAreas();
   Visible := True;
end;

// -------------------------------------------------------------------------
//       Bmp
procedure TSwitchScope.PaintToBmp(Bmp : TBitMap);
const clTransp = clTeal;
var wValue  : integer;
    CFields : TColor;
    CValue  : TColor;
    wText   : string;
begin
   wValue := Round(Value);
   if Assigned(fTimer) then fTimer.Enabled := False;
   //     
   CFields := RGB(200,220,240);
   if (Value >= 0) and (Value <= MaxScope)
   then begin
      if Value = 0
      then begin
          CValue := clSilver; wText  := 'OFF';
      end
      else begin
          CValue := clLime;    wText  := 'ON';
      end;
   end
   else begin
      CValue  := clRed;
      wText  := 'ERROR';
      if Assigned(fTimer) then fTimer.Enabled := True;
   end;
   //  
   with Bmp.Canvas
   do begin
      // ----------------
     if (not Transparent)
     then begin
         //    
         Pen.Width := 2;
         Pen.Color   := clWhite;
         Brush.Color := CFields;
         Brush.Style := bsSolid;
         Rectangle(fSRect);
         //   
         Pen.Color := clBlack;
         MoveTo(fSRect.Left,    fSRect.Bottom-1);
         LineTo(fSRect.Right-1, fSRect.Bottom-1);
         MoveTo(fSRect.Right-1, fSRect.Top);
         LineTo(fSRect.Right-1, fSRect.Bottom);
      end;
      //-----------------
      //  
      // ----------------
      //  
      Pen.Width := 2;
      Pen.Color := clBlack;
      Brush.Color := CValue;
      Brush.Style := bsSolid;
      Rectangle(fIRect);
      //   
      Pen.Color := clWhite;
      MoveTo(fIRect.Left,    fIRect.Bottom-1);
      LineTo(fIRect.Right-1, fIRect.Bottom-1);
      MoveTo(fIRect.Right-1, fIRect.Top);
      LineTo(fIRect.Right-1, fIRect.Bottom);
      // ----------------
      //  
      Font.Name := 'Tahoma';
      Font.Size := 8;
      Font.Style := [fsBold];
      Brush.Style := bsClear;
      TextOut(fIRect.Left + 4, fIRect.Top + 1, IntToStr(wValue));
      if not Compact
      then begin
           TextOut(fIRect.Right + 4, fIRect.Top + 1, wText);
           Font.Style := [];
           TextOut(4, fIRect.Bottom + 1, ScopeName);
      end;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TSwitchScope.onTimer(Sender : TObject);
begin
   if Visible
   then Visible := False
   else Visible := True;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.
