unit Oscillograph03;
// ====================================================================
(*                       

        
       .

    TOscillograph       
       (TPanel).
        
      ,     ,
           .

         3.02 ()  , , , , 2018.
                     () Source code  ..
          16.06.2018
*)
// ====================================================================

interface

uses Windows, Messages, Classes, Controls, SysUtils, Graphics, Dialogs,
     Forms, StdCtrls, ExtCtrls, Menus;


// ====================================================================
//                TOscillograph
//            
// ====================================================================
// ,     
type TPumStyle =   (pumValue,     //  
                    pumInc,       //  
                    pumMean,      //   
                    pumMax,       //   
                    pumMin,       //   
                    pumDispers);  //   

//       
type TOsWallStyle  = (oswsNotUse,     //  
                      oswsDam,        //    
                      oswsLimit);     //    

type TOscillograph = class(TObject)
private
   // -----------------------------
   fDFRM        : TForm;        //  
   // -----------------------------
   fPanel       : TPanel;       //  
   fPanelCreate : boolean;      //  :    
   // --------------------------
   fList        : TList;        //     FIFO
   // --------------------------
   fImg         : TImage;       // Image  
   fBMP         : TBitMap;      //  
   fPM          : TPopupMenu;   // PopUpMenu  
   // --------------------------
   fLbT         : TLabel;       // Label  
   fLbV         : TLabel;       // Label  
   // --------------------------
   fTimer       : TTimer;       //     ReSize
   fLook        : boolean;      //    ReSize
   // --------------------------
   fTitle       : string;       //  
   fDigit       : boolean;      //   
   // --------------------------
   //  
   fYMes        : string;       //    
   fYMax        : extended;     // .    
   fXMaxNum     : integer;      // .    
   // --------------------------
   //  
   fYLast       : extended;     //    FIFO 
   fYLastP      : extended;     //    FIFO 
   //  
   fPumStyle    : TPumStyle;
   fMSum        : extended;     //    
   fMean        : extended;     //   
   fCurrYMax    : extended;     //   
   fCurrYMin    : extended;     //   
   fDispersion  : extended;     //   
   // --------------------------
   //  
   fXCount      : integer;       //    
   fYPrev       : extended;      //    
   // --------------------------
   //  
   fGridY       : extended;      //      Y
   fGridX       : integer;       //      X
   // --------------------------
   //  
   fBeamColor   : TColor;        //  
   fFonColor    : TColor;        //   
   fGridColor   : TColor;        //    
   fTextColor   : TColor;        //    
   // --------------------------
   //     
   fP2Wall      : extended;      //      
   fP1Wall      : extended;      //     
   fN1Wall      : extended;      //     
   fN2Wall      : extended;      //      
   fWallStyle   : TOsWallStyle;  //     
   fc1Alarm     : TColor;        //     1
   fc2Alarm     : TColor;        //     2
   // --------------------------
   fRecording   : boolean;       //     
   fFileNumPnt  : integer;       //       
   fFileCount   : integer;       //     
   fListFilePnt : TStringList;   //      
   // -----------------------------
   //     ""   
   procedure onDFRMClose(Sender: TObject; var Action: TCloseAction);
   //     Show
   procedure onDFRMShow(Sender: TObject);
   //     Hide
   procedure onDFRMHide(Sender: TObject);
   //   biSystemMenu : biMaximize
   procedure onDFRMActivate(Sender: TObject);
   //   biSystemMenu : biMinimize
   procedure onDFRMDeactivate(Sender: TObject);
   // --------------------------
   //    
   procedure CreateDynComponents();
   // --------------------------
   //  ReSize
   procedure onPanelReSize(Sender: TObject);
   //    ReSize
   procedure onReSizeTimer(Sender: TObject);
   //        
   procedure ReSize();
   // --------------------------
   //     PopupMenu
   procedure  GreateAndConnecPoUpMenu();
   //    PopupMenu
   procedure MenuClick(Sender : TObject);
   // --------------------------
   //    FIFO
   procedure ClearFIFO();
   //        
   procedure SetFIFONumPoint();
   //      FIFO
   procedure AddDataToFIFO(RqData : extended);
   // --------------------------
   //      
   procedure SetP2Wall (RqP2Wall  : extended);
   //     
   procedure SetP1Wall (RqP1Wall  : extended);
   //     
   procedure  SetN1Wall(RqN1Wall : extended);
   //      
   procedure  SetN2Wall(RqN2Wall : extended);
   //       
   procedure  SetWallStyle(RqWallStyle : TOsWallStyle);
   // --------------------------
   //    fBMP  fImg
   procedure BmpToImg ();
   //        fBMP
   procedure ShowGrids();
   //    fBMP
   procedure ImageClear(RqColor : TColor);
   //      X
   function  CalcX() : integer;
   //      Y
   function  CalcY(RqData : extended) : integer;
   //    
   function GetColorByValue (RqValue : extended) : TColor;
   //      fBMP
   procedure ShowFirstPoint(RqData : extended);
   //      fBMP
   procedure ShowNextPoint(RqData : extended);
   //     fBMP     fImg
   procedure ShowBeam();
   // --------------------------
   //       
   procedure SetFileNumPoint();
   //       
   procedure DialogSaveToFile();
   //      
   procedure AddDataToList(RqData : extended);
   //  
   procedure ShowTitle();
   //   
   procedure ShowAdditionalValue();
   // --------------------------
   //  property
   procedure SetTitle(RqTitle : string);
   procedure SetYMax (RqYMax  : extended);
   procedure SetXMaxNum (RqXMaxNum  : integer);
public
   // -----------------------------
   //      
   constructor Create(RqWidth, RqHeight : integer); overload;
   //      
   constructor Create(RqPanel : TPanel); overload;
   //   
   procedure   Free;
   // -----------------------------
   //    
   procedure AddNewData (RqData : extended);
   //  
   procedure Clear();
   //  
   procedure ReShow();
   // -----------------------------
   //  
   property Title      : string    read fTitle     write SetTitle;
   // --------------------------
   //    
   property  YMes      : string    read fYMes      write fYMes;
   //   
   property  YMax       : extended read fYMax      write SetYMax;
   //      X
   property XMaxNum  : integer     read fXMaxNum  write SetXMaxNum;
   //      
   property P2Wall   : extended    read fP2Wall   write SetP2Wall;
   //     
   property P1Wall   : extended    read fP1Wall   write SetP1Wall;
   //     
   property N1Wall   : extended    read fN1Wall   write SetN1Wall;
   //      
   property N2Wall   : extended    read fN2Wall   write SetN2Wall;
   //      
   property WallStyle : TOsWallStyle  read fWallStyle write SetWallStyle;
   // --------------------------
   //   
   property Digit      : boolean  read fDigit     write fDigit;
   //   
   property BeamColor  : TColor   read fBeamColor write fBeamColor;
   //   
   property FonColor   : TColor   read fFonColor  write fFonColor;
   //   
   property GridColor  : TColor   read fGridColor write fGridColor;
   //    
   property TextColor  : TColor   read fTextColor write fTextColor;
   //     Y (   )
   property GridY      : extended read fGridY     write fGridY;
   //     X ( )
   property GridX      : integer  read fGridX     write fGridX;
   //     
   property Alarm1Color  : TColor read fc1Alarm   write fc1Alarm;
   //     
   property Alarm2Color  : TColor read fc2Alarm   write fc2Alarm;

end;

// ====================================================================
// ====================================================================
implementation
// ====================================================================
// ====================================================================
const TimeReSizeOut = 400;  //     ReSize


//       TList ( FIFO)
type Data  = extended;
type AData = ^Data;

// ====================================================================
//                TOscillograph
//            
// ====================================================================
const DFRM_MinW   = 250;        // .   
      DFRM_MinH   = 160;        // .   
      MinPanelW   = DFRM_MinW;  // .   
      MinPanelH   = DFRM_MinH;  // .   
      TopAreaH    = 20;         //    fImg
      DownAreaH   = 20;         //    fImg
      ImgBordX    = 2;          //  fImg     
      YGaugeAreaW = 50;         //       Y
      YBlankAreaW = 5;          //       
      PixStepX    = 15;         //       
      eps         = 1e-14;      //  YMax
// ====================================================================
//   / 
// ====================================================================
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TOscillograph.Create(RqWidth, RqHeight : integer);
begin
   inherited Create;
   // -----------------------------------
   //    
   fDFRM := TForm.Create(nil);
   with fDFRM do
   begin
      BorderIcons := [biSystemMenu,biMinimize,biMaximize];
      // -------------------
      onClose   := onDFRMClose;
      onShow    := onDFRMShow;
      onHide    := onDFRMHide;
      onActivate := onDFRMActivate;
      onDeactivate := onDFRMDeActivate;
      // -------------------
      Caption   := '  v.3.0 ';
      Position  := poDesktopCenter;
      FormStyle :=  fsStayOnTop;
      AutoSize  := False;
      if RqWidth < DFRM_MinW
      then  ClientWidth := DFRM_MinW
      else  ClientWidth := RqWidth;
      if RqHeight < DFRM_MinH
      then  ClientHeight := DFRM_MinH
      else  ClientHeight := RqHeight;
   end;
   // -----------------------------
   fPanel := TPanel.Create(fDFRM);
   fPanel.Parent := fDFRM;
   fPanel.SetBounds(0,0, fDFRM.ClientWidth, fDFRM.ClientHeight);
   //    
   fPanel.Constraints.MinHeight  := DFRM_MinH;
   fPanel.Constraints.MinWidth   := DFRM_MinW;
   //    ReSize
   fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   //  :    
   fPanelCreate := True;
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
   fDFRM.Show
end;
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TOscillograph.Create(RqPanel : TPanel);
begin
   inherited Create;
   // -----------------------------
   fPanelCreate := False;  //  :    
   fPanel := RqPanel;
   //    
   fPanel.Constraints.MinHeight  := MinPanelH;
   fPanel.Constraints.MinWidth   := MinPanelW;
   //    ReSize
   fPanel.Anchors := [akLeft,akTop,akRight,akBottom];
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
end;
// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
//    
procedure TOscillograph.CreateDynComponents();
begin
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(ImgBordX,TopAreaH,
                  fPanel.Width - 2 * ImgBordX,
                  fPanel.Height - TopAreaH - DownAreaH);
   //     PopupMenu
   GreateAndConnecPoUpMenu();
   // -----------------------------
   //   
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Height := fImg.Height;
   fBMP.Width  := fImg.Width;
   // -----------------------------
   //  Label    
   fLbV := TLabel.Create(fPanel);
   fLbV.Parent := fPanel;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   fLbV.AutoSize := False;
   // -----------------------------
   //  Label   
   fLbT := TLabel.Create(fPanel);
   fLbT.Parent := fPanel;
   fLbT.SetBounds(2,3,fPanel.Width-4,16);
   fLbT.AutoSize := False;
   fLbT.Alignment := taLeftJustify;
   // -----------------------------
   //     ReSize
   fTimer := TTimer.Create(nil);
   fTimer.Enabled := False;
   fTimer.onTimer := onReSizeTimer;
   // 
   fLook  := True;
   //  OnResize   
   fPanel.OnResize := onPanelResize;
   // -----------------------------
   //  FIFO    
   fList := TList.Create;
   fXMaxNum    := 100;   //    
   // -----------------------------
   //   
   fYMax       := 100;   //   
   // -----------------------------
   fYLast      := 0;     //    FIFO 
   fYLastP     := 0;     //    FIFO 
   fMSum       := 0;     //   
   fMean       := 0;     //   
   fDispersion := 0;     //   
   // -----------------------------
   //  
   fPumStyle    := pumValue;
   fP2Wall      :=   fYMax * 0.9;  //    1
   fP1Wall      :=   fYMax * 0.8;  //    2
   fN2Wall      := - fYMax * 0.9;  //    1
   fN1Wall      := - fYMax * 0.8;  //    2
   fc1Alarm     := clYellow;       //      
   fc2Alarm     := clRed;          //      
   fWallStyle   := oswsNotUse;     //     
   // -----------------------------
   fDigit       := False;          //    
   // -----------------------------
   //    
   fGridY := fYMax / 5;
   fGridX := PixStepX;
   // -----------------------------
   //    
   fBeamColor   := clLime;
   fFonColor    := RGB(64,64,64);
   fGridColor   := clGray;
   fTextColor   := clWhite;
   ImageClear(fFonColor);
   // -----------------------------
   fRecording   := False;          //     
   fFileNumPnt  := 200;            //       
   fFileCount   := 0;              //     
   //      
   fListFilePnt := TStringList.Create;
   //  
   fTitle       := '   3.0.';
   ShowTitle();
   fLook  := False;  // 
end;
// --------------------------------------------------------------------
//  
procedure TOscillograph.Free;
begin
   // ---------------------------------
   if Assigned(fTimer) then fTimer.Free;
   if Assigned(fList)
   then begin
      ClearFIFO();
      fList.Free;
   end;
   if Assigned(fListFilePnt)
   then begin
     fListFilePnt.Free;
     fListFilePnt := nil;
   end;
   if Assigned(fPM)      then fPM.Free;
   if Assigned(fLbV)     then fLbV.Free;
   if Assigned(fLbT)     then fLbT.Free;
   if Assigned(fBMP)
   then begin
      fBMP.Free;
      fBMP := nil;
   end;
   if Assigned(fImg)    then fImg.Free;
   //  :    
   if fPanelCreate and Assigned(fPanel)
   then fPanel.Free;
   // ---------------------------------
   if Assigned(fDFRM)   then  fDFRM.Free;
   // ---------------------------------
   inherited Free;
end;
// =================================================================
//      
// =================================================================
// -----------------------------------------------------------------
//    (   )   
procedure TOscillograph.onDFRMClose(Sender: TObject; var Action: TCloseAction);
// TCloseAction = (caNone, caHide, caFree, caMinimize);
begin
   Action := caMinimize;
end;
//     Show
procedure TOscillograph.onDFRMShow(Sender: TObject);
begin
end;
//     Hide
procedure TOscillograph.onDFRMHide(Sender: TObject);
begin
end;
//   biSystemMenu :biMaximize
procedure TOscillograph.onDFRMActivate(Sender: TObject);
begin
  //  
  fDFRM.FormStyle := fsStayOnTop;
end;
//   biSystemMenu : biMinimize
procedure TOscillograph.onDFRMDeactivate(Sender: TObject);
begin
end;
// ==================================================================
//    
// ==================================================================
// ------------------------------------------------------------------
//     PopupMenu
procedure  TOscillograph.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
    SubItems0 : array of TMenuItem;   //   
    SubItems1 : array of TMenuItem;   //   
begin
   // ---------------------------------
   //   -   
   // ---------------------------------
   //  SubMenu0 Items
   SetLength(SubItems0,3);
   // -------
   SubItems0[0]:= NewItem('  ', TextToShortCut(''),
                          True, True, MenuClick, 0, '');
   SubItems0[0].Tag := 101;
   SubItems0[0].RadioItem := True;
      // -------
   SubItems0[1]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, '');
   SubItems0[1].Tag := 102;
      // -------
   SubItems0[2]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, '');
   SubItems0[2].Tag := 103;
   // ---------------------------------
   //   -   
   // ---------------------------------
   //  SubMenu1 Items
   SetLength(SubItems1,6);
   // -------
   SubItems1[0]:= NewItem(' ', TextToShortCut(''),
                          True, True, MenuClick, 0, 'M_VAL');
   SubItems1[0].Tag := 201;
   SubItems1[0].RadioItem := True;
   // ---------
   SubItems1[1]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_INC');
   SubItems1[1].Tag := 202;
   // ---------
   SubItems1[2]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_MEAN');
   SubItems1[2].Tag := 203;
   // ---------
   SubItems1[3]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_MAX');
   SubItems1[3].Tag := 204;
   // ---------
   SubItems1[4]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_MIN');
   SubItems1[4].Tag := 205;
   // ---------
   SubItems1[5]:= NewItem('  ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_DISPR');
   SubItems1[5].Tag := 206;
   // =================================
   //    (PopupMenu)
   // =================================
   SetLength(MenuItems, 11);
   // --------------------
   MenuItems[0]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_DIGIT');
   MenuItems[0].Tag := 1;
   // --------------------
   MenuItems[1]:= NewItem('-', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SEP');
   // --------------------
   MenuItems[2]:= NewSubMenu('   ...',
                              0, 'mVerify', SubItems0, True);
   MenuItems[2].Tag := 0;
   // --------------------
   MenuItems[3]:= NewItem('-', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SEP');
   // --------------------
   MenuItems[4]:= NewSubMenu('   ...',
                              0, 'mAddParm', SubItems1, True);
   MenuItems[4].Tag := 0;
   // --------------------
   MenuItems[5]:= NewItem('-', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SEP');
   // --------------------
   MenuItems[6]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_CLEAR');
   MenuItems[6].Tag := 2;
   // --------------------
   MenuItems[7]:= NewItem('   ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_OS_PNT');
   MenuItems[7].Tag := 3;
   // --------------------
   MenuItems[8]:= NewItem('-', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SEP');
   // --------------------
   MenuItems[9]:= NewItem('     ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_FILE_PNT');
   MenuItems[9].Tag := 4;
   // --------------------
   MenuItems[10]:= NewItem('    ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_SAV_PNT');
   MenuItems[10].Tag := 5;

   // =================================
   //    (PopupMenu)
   fPM := NewPopupMenu(fImg, 'Menu',
                       paLeft, True, MenuItems);
   fImg.PopupMenu := fPM;
   // =================================
   SetLength(SubItems0,0);
   SetLength(SubItems1,0);
   SetLength(MenuItems,0);
end;

// --------------------------------------------------------------------
//  RadioItem  RqItem
procedure ResetRadioItem(RqMenu : TPopupMenu;  RqItem : TMenuItem);
var Ind : integer;
begin
   with RqMenu.Items do
   begin
     for Ind :=0 to Count - 1
     do begin
        case RqItem.Tag of
        100..199 : begin
                if (Items[Ind].Tag >= 100) and (Items[Ind].Tag <= 199)
                then begin
                     Items[Ind].RadioItem := False;
                     Items[Ind].Checked   := False;
                end;
            end;
        200..299 : begin
                if (Items[Ind].Tag >= 200) and (Items[Ind].Tag <= 299)
                then begin
                     Items[Ind].RadioItem := False;
                     Items[Ind].Checked   := False;
                end;
            end;
        end;
     end;
     RqItem.RadioItem := True;
     RqItem.Checked   := True;
   end;
end;
// --------------------------------------------------------------------
//   TItem
procedure FindItemByTag(RqItems  : TMenuItem;
                        RqTag    : integer;
                    var Item     : TMenuItem);
var Ind : integer;
begin
   if Item <> nil then Exit;               //  - Item 
   if RqItems.Count = 0 then Exit;         //  -  
      for Ind :=0 to RqItems.Count - 1
      do if RqItems.Items[Ind].Tag = RqTag
         then begin
            Item := RqItems.Items[Ind];
            Exit;
         end
         else if RqItems.Items[Ind].Count <> 0
              then FindItemByTag(RqItems.Items[Ind], RqTag, Item);
end;
// --------------------------------------------------------------------
//    RadioItem
function FindAndResetRadioItem(RqMenu : TPopupMenu;
                               RqTag  : integer) : TMenuItem;
begin
   Result := nil;
   FindItemByTag(RqMenu.Items, RqTag, Result);
   if Result <> nil then ResetRadioItem(RqMenu,  Result);
end;

// --------------------------------------------------------------------
//    
procedure TOscillograph.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item :=  TMenuItem(Sender);
   case Item.Tag of
   1  :  begin //  
           if not Item.Checked
           then begin
             fDigit := True;
             Item.Checked := True;
             //   
             ShowBeam();
           end
           else begin
             fDigit := False;
             Item.Checked := False;
             //   
             ShowBeam();
           end;
         end;
   2  :  begin  //  
           self.Clear();
         end;
   3  :  begin  //       
           SetFIFONumPoint();
         end;
   4  :  begin  //         
           SetFileNumPoint();
         end;
   5  :  begin  //     
           fRecording := True;
         end;
         // ===========================
         //     
   101 : begin  //  
           fWallStyle := oswsNotUse;
           ResetRadioItem(fPM, Item);
         end;
   102 : begin  //  
           fWallStyle := oswsDam;
           ResetRadioItem(fPM, Item);
         end;
   103 : begin  //  
           fWallStyle := oswsLimit;
           ResetRadioItem(fPM, Item);
         end;
         // ===========================
         //    
   201 : begin  //  
           fPumStyle := pumValue;
           ResetRadioItem(fPM, Item);
         end;
   202 : begin  //  
           fPumStyle := pumInc;
           ResetRadioItem(fPM, Item);
         end;
   203 : begin  //   
           fPumStyle := pumMean;
           ResetRadioItem(fPM, Item);
         end;
   204 : begin  //   
           fPumStyle := pumMax;
           ResetRadioItem(fPM, Item);
         end;
   205 : begin  //   
           fPumStyle := pumMin;
           ResetRadioItem(fPM, Item);
         end;
   206 : begin  //   
           fPumStyle :=  pumDispers;
           ResetRadioItem(fPM, Item);
         end;
   end;
   //    
   ShowBeam();
end;
// ====================================================================
//    FIFO   
// ====================================================================
//    FIFO
procedure TOscillograph.ClearFIFO();
var wPDataDel : AData;
begin
   while fList.Count > 0
   do begin
     wPDataDel := fList.Items[0];
     if wPDataDel <> nil then Dispose(wPDataDel);
     fList.Delete(0);
   end;
   fYLast       := 0;     //    FIFO 
   fYLastP      := 0;     //    FIFO 
   fMSum        := 0;     //     
   fMean        := 0;     //   
   fCurrYMax    := 0;     //   
   fCurrYMin    := 0;     //   
   fDispersion  := 0;     //   
   fLbV.Caption := '';
end;
// --------------------------------------------------------------------
//      FIFO
procedure TOscillograph.AddDataToFIFO(RqData : extended);
var wPAdd, wPDel : AData;
    wAdd,  wDel  : extended;
    wDSum        : extended;     //   
    Ind : integer;
begin
   //  YMax
   if Abs(fYMax) <  eps   then Exit;
   if not Assigned(fList) then Exit;
   // ---------------
   //    
   New(wPAdd);
   wPAdd^ := RqData;
   wAdd   := RqData;
   wDel   := 0;
   if fList.Count > fXMaxNum
   then begin
       wPDel := fList.Items[0];
       if wPDel <> nil
       then begin
           wDel := wPDel^;
           Dispose(wPDel);
       end;
       fList.Delete(0);
   end
   else begin
     if fList.Count = 0
     then begin
        fCurrYMax := RqData;
        fCurrYMin := RqData;
     end;
   end;
   fList.Add(wPAdd);
   // ---------------
   fYLastP := fYLast;     //  
   fYLast  := RqData;     //  
   // ---------------
   //   
   fMSum := fMSum + wAdd - wDel;
   fMean := fMSum / fList.Count;
   // ---------------
   //   
   if fCurrYMax < RqData then fCurrYMax := RqData;
   //   
   if fCurrYMin > RqData then fCurrYMin := RqData;
   // ---------------
   //   
   if fPumStyle = pumDispers
   then begin
      wDSum := 0;
      for Ind := 0 to fList.Count -1
      do begin
          wPAdd := fList.Items[Ind];
          wDSum :=  wDSum + (wPAdd^-fMean)*(wPAdd^-fMean);
      end;
      fDispersion := wDSum / fList.Count;
   end;
end;
// --------------------------------------------------------------------
//        
procedure TOscillograph.SetFIFONumPoint();
var wStr  : string;
    wNum  : integer;
begin
   if InputQuery('    ',
                 '    : ' + IntToStr(fXMaxNum),
                 wStr)
   then begin
      if TryStrToInt(wStr, wNum)
      then begin
           SetXMaxNum(wNum);
      end
      else MessageDlg ('   '
           +  #13#10 + '    ...'
           +  #13#10 + '   .  ',
           mtInformation, [mbOk], 0);
   end;
   ShowTitle();  //  
end;
// ====================================================================
//     
// ====================================================================
//      
procedure TOscillograph.SetP2Wall (RqP2Wall : extended);
begin
  //    
  if (RqP2Wall = fP2Wall) then Exit;
  // 
  if (RqP2Wall <= 0) or (RqP2Wall > fYMax)
  then begin
      //   
      fP2Wall := 0;
      fP1Wall := 0;
  end else fP2Wall := RqP2Wall;
end;
// --------------------------------------------------------------------
//     
procedure TOscillograph.SetP1Wall (RqP1Wall : extended);
begin
  //    
  if (RqP1Wall = fP1Wall) then Exit;
  // 
  if fP2Wall > 0
  then begin
    if RqP1Wall < fP2Wall
    then fP1Wall := RqP1Wall
    else fP1Wall := 0;
  end
  else fP1Wall := 0;
end;
// --------------------------------------------------------------------
//     
procedure TOscillograph.SetN1Wall(RqN1Wall : extended);
begin
  //    
  if (RqN1Wall = fN1Wall) then Exit;
  //   
  if (RqN1Wall <= 0) and (RqN1Wall > fN2Wall)
  then fN1Wall := RqN1Wall
  else fN1Wall := 0;
end;
// --------------------------------------------------------------------
//      
procedure TOscillograph.SetN2Wall(RqN2Wall : extended);
begin
  //    
  if (RqN2Wall = fN2Wall) then Exit;
  //    
  if (RqN2Wall >= 0) or (RqN2Wall < -fYMax)
  then begin
     //     
     fN1Wall := 0;
     fN1Wall := 0;
  end else fN2Wall := RqN2Wall;
end;
// --------------------------------------------------------------------
//       
procedure  TOscillograph.SetWallStyle(RqWallStyle : TOsWallStyle);
begin
  if (RqWallStyle = fWallStyle)
  then Exit; //    
  // 
  fWallStyle := RqWallStyle;
  //    RadioItem
  case fWallStyle of
     oswsNotUse : FindAndResetRadioItem(fImg.PopupMenu, 101);
     oswsDam    : FindAndResetRadioItem(fImg.PopupMenu, 102);
     oswsLimit  : FindAndResetRadioItem(fImg.PopupMenu, 103);
  end;
  //    
  ShowBeam();
end;
// ====================================================================
//         fBMP
// ====================================================================
//         Y
function YFormatString(RqVal : extended): string;
begin
   Result := '%5.5f';
   if (RqVal > 10000)
   then begin Result := '%5.0f'; Exit; end;
   if (RqVal >= 1000)
   then begin Result := '%5.1f'; Exit; end;
   if (RqVal >= 100)
   then begin Result := '%5.2f'; Exit; end;
   if (RqVal >= 10)
   then begin Result := '%5.3f'; Exit; end;
   if (RqVal >= 1)
   then begin Result := '%5.4f'; Exit; end;
   if (RqVal >= 0.1)
   then begin Result := '%5.5f'; Exit; end;
end;
// --------------------------------------------------------------------
//      
procedure TOscillograph.ShowGrids();
var wY     : extended;
    wX     : integer;
    wH     : integer;
    wFrmStr : string;
begin
    // ----------------------
    //  YMax
    if Abs(fYMax) < eps then Exit;
    // ----------------------
    with fBMP.Canvas
    do begin
       Pen.Color  := fGridColor;
       Font.Color := fTextColor;
       Font.Name  := 'Tahoma';
       Font.Size  := 8;
       wFrmStr := YFormatString(fYMax);
       // ----------------------
       //    X
       wX := 0;
       repeat
          MoveTo(YGaugeAreaW + wX, 0,);
          LineTo(YGaugeAreaW + wX, fBMP.Height);
          wX := wX + fGridX;
       until (wX > fBMP.Width);
       // ----------------------
       //    Y
       //  
       wH := CalcY(0);
       MoveTo(0, wH);
       LineTo(fBMP.Width - YBlankAreaW,wH);
       TextOut(4, wH-6, '0');
       //  
       Pen.Color := fGridColor;
       //    
       wY := - fGridY;
       repeat
          wH := CalcY(wY);
          MoveTo(0, wH);
          LineTo(fBMP.Width - YBlankAreaW,wH);
          if wY > - fYMax
          then TextOut(4, wH-6, Format(wFrmStr,[wY]));
          wY := wY - fGridY;
       until (wY < - fYMax);
       //    
       wY := fGridY;
       repeat
          wH := CalcY(wY);
          MoveTo(0, wH);
          LineTo(fBMP.Width - YBlankAreaW,wH);
          if wY <  fYMax
          then TextOut(4, wH-6, Format(wFrmStr,[wY]));
          wY := wY + fGridY;
       until (wY > fYMax);
    end;
end;
// --------------------------------------------------------------------
//     fImg
procedure TOscillograph.BmpToImg ();
var wImgRect : TRect;
begin
  if (not Assigned(fImg)) or (not Assigned(fBMP)) then Exit;
  //     fImg
  wImgRect := Rect(0, 0, fImg.Width, fImg.Height);
  fImg.Canvas.CopyRect(wImgRect,fBMP.Canvas,wImgRect);
end;
// --------------------------------------------------------------------
//     
procedure TOscillograph.ImageClear(RqColor : TColor);
begin
  if (fImg.Width <> fBMP.Width) or (fImg.Height <> fBMP.Height)
  then begin
      fBMP.Height := fImg.Height;
      fBMP.Width  := fImg.Width;
  end;
  with fBMP.Canvas do
  begin
    Brush.Color := RqColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0,0, fBMP.Width, fBMP.Height));
  end;
  //    
  fXCount := 0;
end;
// --------------------------------------------------------------------
//  X -   
function TOscillograph.CalcX() : integer;
begin
  Result := YGaugeAreaW
         + Trunc(((fBMP.Width - YGaugeAreaW - YBlankAreaW)
         / fXMaxNum) * fXCount);
end;
// --------------------------------------------------------------------
//  Y -   
function TOscillograph.CalcY(RqData : extended) : integer;
begin
  Result := (fBMP.Height div 2);
  try
     Result := Result - Trunc((Result / fYMax) * RqData);
  except
     Result := 0;
  end;
end;
// --------------------------------------------------------------------
//    
function TOscillograph.GetColorByValue (RqValue : extended) : TColor;
begin
   Result := fBeamColor;
   //    
   case fWallStyle of
   //--------
   oswsNotUse: Exit; //   
   //--------
   oswsDam   : begin //   
                if RqValue >= 0
                then begin
                   if fP2Wall <= 0 then Exit;  //   
                   if (fP1Wall > 0) and (RqValue >= fP1Wall) and
                      (RqValue < fP2Wall)
                   then begin
                        //  fP1Wall     
                        Result := fc1Alarm;
                        Exit;
                   end;
                   if (RqValue >= fP2Wall)  then Result := fc2Alarm;
                end
                else begin
                   if fN2Wall >= 0 then Exit;  //   
                   if (fN1Wall < 0) and (RqValue <= fN1Wall) and
                      (RqValue > fN2Wall)
                   then begin
                      //  fN1Wall     
                      Result := fc1Alarm;
                      Exit;
                   end;
                   if (RqValue <= fN2Wall) then Result := fc2Alarm;
                end;
              end;
   //--------
   oswsLimit : begin //   
                if RqValue >= 0
                then begin
                   if fP2Wall <= 0 then Exit; //   
                   if not ((fP1Wall > 0) and
                           (RqValue >= fP1Wall) and
                           (RqValue < fP2Wall))
                   then Result := fc2Alarm;
                end
                else begin
                   if fN2Wall >= 0 then Exit;  //   
                   if not ((fN1Wall < 0) and
                           (RqValue <= fN1Wall) and
                           (RqValue > fN2Wall))
                   then Result := fc2Alarm;
                end;
              end;
   end;
end;
 // --------------------------------------------------------------------
//    
procedure TOscillograph.ShowFirstPoint(RqData : extended);
begin
   //   
  ImageClear(fFonColor);
  ShowGrids();
  //   
  fBMP.Canvas.MoveTo(CalcX(),CalcY(RqData));
  fYPrev  := RqData;
  fXCount := fXCount + 1;
end;
// --------------------------------------------------------------------
//    
procedure TOscillograph.ShowNextPoint(RqData : extended);
begin
   if fDigit
   then begin
       fBMP.Canvas.Pen.Color := GetColorByValue(fYPrev);
       fBMP.Canvas.LineTo(CalcX(),CalcY(fYPrev));
   end;
   fBMP.Canvas.Pen.Color := GetColorByValue(RqData);
   fBMP.Canvas.LineTo(CalcX(),CalcY(RqData));
   fYPrev  := RqData;
   fXCount := fXCount + 1;
end;
// --------------------------------------------------------------------
//     fBMP     fImg
procedure TOscillograph.ShowBeam();
var Ind    : integer;
    wPData : AData;
begin
   // ----------------------
  //  YMax
  if Abs(fYMax) >  eps
  then begin
     for Ind := 0 to fList.Count - 1
     do begin
        wPData := fList.Items[Ind];
        if Ind = 0
        then ShowFirstPoint(wPData^)
        else ShowNextPoint (wPData^);
     end;
   end;
   //     fImg
   BmpToImg ();
end;
// --------------------------------------------------------------------
//  
procedure TOscillograph.ShowTitle();
const RXB  = 8;
      REL  = 14;
      BLNK = 4;
begin
  if fRecording
  then begin
     //   fLbT.Caption  Recording 
     with fLbT.Canvas
     do begin
        //  fLbT
        Brush.Color := fLbT.Color;
        FillRect(Rect(1,1,fLbT.Width - 1,fLbT.Height - 1));
        // 
        Brush.Style := bsSolid;
        Brush.Color := clAqua;
        Ellipse(RXB, 1, RXB + REL, 1 + REL);
        Brush.Style := bsClear;
        TextOut(RXB + REL + BLNK, 1, 'REC // ' + fTitle);
     end;
  end
  else begin
     //   fLbT.Caption
     fLbT.Caption := fTitle;
     fLbT.Repaint;
  end;
end;
// --------------------------------------------------------------------
//   
procedure TOscillograph.ShowAdditionalValue();
begin
   if Assigned(fLbV)
   then begin
      if not fLbV.Visible then Exit;
      case fPumStyle of
          pumValue   : fLbV.Caption := '   : '
                            + Format('%6.3f',[fYLast]) + ' ' + YMes;
          pumInc     : fLbV.Caption := '   : '
                            + Format('%6.3f',[fYLast-fYLastP]) + ' ' + YMes;
          pumMean    : fLbV.Caption := '    : '
                            + Format('%6.3f',[fMean]) + ' ' + YMes;
          pumMax     : fLbV.Caption := '    : '
                            + Format('%6.3f',[fCurrYMax]) + ' ' + YMes;
          pumMin     : fLbV.Caption := '    : '
                            + Format('%6.3f',[fCurrYMin]) + ' ' + YMes;
          pumDispers : fLbV.Caption := '    : '
                            + Format('%6.3f',[self.fDispersion]);
          else  fLbV.Caption := '';
     end;
   end;
end;
// ====================================================================
//        
// ====================================================================
//       
procedure TOscillograph.SetFileNumPoint();
var wStr  : string;
    wNum  : integer;
begin
   if InputQuery('      ',
                 '    : ' + IntToStr(fFileNumPnt),
                 wStr)
   then begin
      if TryStrToInt(wStr, wNum)
      then begin
           fFileNumPnt := wNum;
      end
      else MessageDlg ('   '
           +  #13#10 + '    ...'
           +  #13#10 + '   .  ',
           mtInformation, [mbOk], 0);
   end;
   ShowTitle();  //  
end;
// --------------------------------------------------------------------
//       
procedure TOscillograph.DialogSaveToFile();
var wName   : string;
    wExt    : string;
    wDialog : TSaveDialog;
    wFileExt : string;     //   
begin
  wExt   := '.txt';
  wDialog := TSaveDialog.Create(nil);
  //  
  wDialog.Filter := 'Oscillogramma (*'
                    + LowerCase(wExt) + ')|*' + UpperCase(wExt);
  //   
  if wDialog.Execute
  then begin
     wName := wDialog.FileName;
     wFileExt  := UpperCase(ExtractFileExt(wName));
     //     ,    
     if not (wFileExt = UpperCase(wExt))
     then wName := wName + LowerCase(wExt);
     //  
     try
        fListFilePnt.SaveToFile(wName);
     except
        MessageDlg ('    : '
                    +  #13#10 + wName,
                    mtError, [mbOk], 0);
     end;
  end;
  wDialog.Free;
end;
// --------------------------------------------------------------------
//      
procedure TOscillograph.AddDataToList(RqData : extended);
begin
   if not fRecording then Exit;
   if fFileCount = 0                 //    
   then begin
      //  
      with fListFilePnt
      do begin
         Clear;
         Add('//  : ' + fTitle);
         Add('//     : ' + DateTimeToStr(Now));
         Add('// ' + #09 + '');
         Add('   ' + IntToStr(fFileCount)
             + #09 + FloatToStr(RqData));
         Inc(fFileCount);
      end;
   end
   else begin
      //   
      fListFilePnt.Add('   ' + IntToStr(fFileCount)
                       + #09 + FloatToStr(RqData));
      Inc(fFileCount);
      //     
      if fFileCount >= fFileNumPnt
      then begin
         fRecording := False;       //  
         //       
         DialogSaveToFile();
         //       
         fListFilePnt.Clear;
         fFileCount := 0;          //     
         ShowTitle();              //  
      end;
   end;
end;
// ====================================================================
//  ReSize
// ====================================================================
procedure TOscillograph.onPanelResize(Sender: TObject);
begin
   if fImg.Visible
   then begin
       fLbT.Visible := False;
       fLbV.Visible := False;
       fImg.Visible := False;
       fTimer.Enabled := True;
   end;
   fTimer.Interval := TimeReSizeOut;
end;
// --------------------------------------------------------------------
procedure TOscillograph.onReSizeTimer(Sender: TObject);
begin
   fTimer.Enabled := False;
   ReSize;
end;
// --------------------------------------------------------------------
//        
procedure TOscillograph.ReSize();
begin
   //    ReSize
   fLook := True;
   with fImg do
   begin
      Picture.Bitmap.Width  := fPanel.Width  - 2 * ImgBordX;
      Picture.Bitmap.Height := fPanel.Height - TopAreaH - DownAreaH;
      fBMP.Width  :=  Picture.Bitmap.Width;
      fBMP.Height :=  Picture.Bitmap.Height;
      Width  :=  Picture.Bitmap.Width;
      Height :=  Picture.Bitmap.Height;
   end;
   fLbV.SetBounds(2,fPanel.Height-18,fPanel.Width-4,16);
   ImageClear(fFonColor);
   ShowGrids();
   //     fImg
   BmpToImg ();
   fLook := False;
   fImg.Visible := True;
   fLbV.Visible := True;
   fLbT.Visible := True;
end;
// ====================================================================
//  PROPERTY
// ====================================================================
// --------------------------------------------------------------------
//   
procedure TOscillograph.SetTitle(RqTitle : string);
begin
   if Assigned(fLbT)
   then begin
       fTitle := '  ' + RqTitle;
       fLbT.Caption := fTitle;
       //  
       ShowTitle();
   end;
end;
// --------------------------------------------------------------------
//      
procedure TOscillograph.SetYMax(RqYMax : extended);
begin
   fYMax := Abs(RqYMax);
   fGridY     := fYMax / 5;
   //    
   ShowBeam();
end;
// --------------------------------------------------------------------
//      
procedure TOscillograph.SetXMaxNum(RqXMaxNum : integer);
begin
  ClearFIFO;
  if RqXMaxNum < 8
  then fXMaxNum := 8
  else fXMaxNum := RqXMaxNum;
  //  ,    FIFO
  ImageClear(fFonColor);
end;
// ====================================================================
//   
// ====================================================================
// --------------------------------------------------------------------
//     
procedure TOscillograph.AddNewData(RqData : extended);
begin
   //    ReSize
   if fLook then Exit;
   // ---------------
   //    
   AddDataToFIFO(RqData);
   // ---------------
   //   
   ShowAdditionalValue();
   // ---------------
   //      
   if fRecording then AddDataToList(RqData);
   // ---------------
   //    
   ShowBeam();
end;
// --------------------------------------------------------------------
//  
procedure TOscillograph.Clear();

begin
   ClearFIFO();           //   
   fRecording := False;   //         
   fListFilePnt.Clear;    //       
   fFileCount := 0;       //     
   ShowTitle();           //  
   // ---------------------
   ImageClear(fFonColor);
   ShowGrids();
   //     fImg
   BmpToImg ();
end;
// --------------------------------------------------------------------
//  
procedure TOscillograph.ReShow();
begin
   //    
   ShowBeam();
end;

// ====================================================================
// ====================================================================

end.
