unit DnDigits03;
// ====================================================================
(*
         3.00 ()  , , , , 2018.
                     () Source code  ..
          30.06.2018
*)
// ====================================================================

interface

uses Windows, Messages, Classes, Controls, SysUtils, Graphics, Dialogs,
     Forms, StdCtrls, ExtCtrls, Menus;

//    
type TRadix  = (rdxDecimal, //   
                rdxHex,     //   
                rdxBit);    //   

//   
type TDFrame = (dfrmNone,   //  
                dfrmUp,     //  
                dfrmDown);  //  

// --------------------------------------------------------------------
//       
type TSCode = (scdClear,
               scdText,
               scdBit,
               scdWord,
               scdLongWord,
               scdInteger,
               scdInt64,
               scdExtended);

// ====================================================================
//                TDnDigits
//
// ====================================================================

type TDnDigits = class(TObject)
private
   // -----------------------------
   fDFRM        : TForm;        //  
   // -----------------------------
   fPanel       : TPanel;       //  
   fPanelCreate : boolean;      //  :    
   // --------------------------
   fImg         : TImage;       // Image  
   fImgCreate   : boolean;      //  : Image   
   // --------------------------
   fBmpSave     : TBitMap;      // 
   fBMP         : TBitMap;      //  
   fPM          : TPopupMenu;   // PopUpMenu  
   // --------------------------
   fXBeg        : integer;      // X -    fImg
   fYBeg        : integer;      // Y -    fImg
   fTxtH        : integer;      //    
   fTxtW        : integer;      //    
   fCharW       : integer;      //    
   // --------------------------
   fScopeRect   : TRect;        //    fImg
   fVisible     : boolean;      //     fImg
   fTransparent : boolean;      //     fImg
   // --------------------------
   fTitle       : string;       //   (  fDFRM)
   fYMes        : string;       //   
   fText        : string;       //   
   // --------------------------
   //  
   fDFrame      : TDFrame;      //   
   fFonColor    : TColor;       //   
   fTxtColor    : TColor;       //    
   // -----------------------------
   fSCode       : TSCode;       //     
   // -----------------------------
   //     ""   
   procedure onDFRMClose(Sender: TObject; var Action: TCloseAction);
   //     Show
   procedure onDFRMShow(Sender: TObject);
   //     Hide
   procedure onDFRMHide(Sender: TObject);
   //   biSystemMenu : biMaximize
   procedure onDFRMActivate(Sender: TObject);
   //   biSystemMenu : biMinimize
   procedure onDFRMDeactivate(Sender: TObject);
   // --------------------------
   //     
   function GetCharWidth(RqChar : char) : integer;
   //     
   procedure SetDsplWH(RqW, RqH : integer);
   //        
   procedure ResizeDSPL(RqStr : string); overload;
   procedure ResizeDSPL(RqW, RqH : integer); overload;
   //   
   procedure CreateDSPL();
   // --------------------------
   //    
   procedure CreateDynComponents();
   // --------------------------
   //     fImg
   // --------------------------
   //    Image   
   procedure RestoreBkGround();
   //    Image   
   procedure SaveBkGround();
   //      
   //     Image
   procedure SetTransparent(RqTransparent : boolean);
   //      Image
   procedure SetVisible(RqVisible : boolean);
   // --------------------------
   //   
   // --------------------------
   //    Image
   procedure ShowDsplToImg();
   //  fBMP
   procedure DsplClear(RqColor : TColor);
   //  
   procedure ShowTitle();
   //    fBMP     fImg
   procedure ShowText();
   // --------------------------
   //     PopupMenu
   procedure  GreateAndConnecPoUpMenu();
   //     
   function ColorDlg(RqOldColor : TColor) : TColor;
   //    PopupMenu
   procedure MenuClick(Sender : TObject);
   // --------------------------
   //  property
   // --------------------------
   //     
   procedure SetDFrame (RqDFrame : TDFrame);
   //      
   procedure SetFonColor(RqColor : TColor);
   //      
   procedure SetTxtColor(RqColor : TColor);
   //     (  fDFRM)
   procedure SetTitle(RqTitle : string);
   // --------------------------
   //   
   procedure SetTextValue(RqTextValue  : string);
   // --------------------------
public
   // -----------------------------
   //      
   constructor Create(); overload;
   //      
   constructor Create(RqPanel : TPanel); overload;
   //      Image
   constructor Create(RqImg : TImage; RqXBeg, RqYBeg : integer); overload;
   //   
   procedure   Free;
   // -----------------------------
   //  XBeg  YBeg     fImg
   procedure ScopePosition(RqXBeg, RqYBeg : integer);
   //  
   procedure Clear();
   //        DIGITs - 
   function ShowTextValue(RqValue : string) : string;
   //     Byte   
   function  ShowByteValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Word   
   function  ShowWordValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     LongWord   
   function ShowLongWordValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Integer   
   function ShowIntegerValue(RqRadix : TRadix; RqValue : Int64) : string;
   //     Int64   
   function ShowInt64Value(RqRadix : TRadix; RqValue : Int64) : string;
   //    Extended   
   function ShowExtendedValue(RqValue : extended) : string;
   // --------------------------
   property Visible     : boolean   read fVisible      write SetVisible;
   property Transparent : boolean   read fTransparent  write SetTransparent;
   // --------------------------
   //  
   property Title      : string    read fTitle     write SetTitle;
   //   
   property  YMes      : string    read fYMes      write fYMes;
   // --------------------------
   //    ()
   property DFrame     : TDFrame read fDFrame  write SetDFrame;
   //  
   property FonColor   : TColor read fFonColor write SetFonColor;
   //   
   property TxtColor   : TColor read fTxtColor write SetTxtColor;
   // --------------------------
   //   
   property TextValue   : string    read fText;
end;

// ====================================================================
// ====================================================================
implementation
// ====================================================================
// ====================================================================

// ====================================================================
//                TDnDigits
//                
// ====================================================================
const Scope_MinW  = 80;         // .   
      Scope_MinH  = 26;         // .   
const cBorderW    = 8;          //   
      cBorderH    = 4;          //   
// --------------------------------------------------------------------
//   
const prefDEC     = 'dec : ';
      prefHEX     = 'hex : ';
      prefBIT     = 'bit : ';

// ====================================================================
//   / 
// ====================================================================
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TDnDigits.Create();
begin
   inherited Create;
   // -----------------------------------
   //    
   fDFRM := TForm.Create(nil);
   with fDFRM do
   begin
      BorderIcons := [biSystemMenu,biMinimize,biMaximize];
      // -------------------
      onClose      := onDFRMClose;
      onShow       := onDFRMShow;
      onHide       := onDFRMHide;
      onActivate   := onDFRMActivate;
      onDeactivate := onDFRMDeActivate;
      // -------------------
      Caption   := ' DIGITs -   3.0. ';
      Position  := poDesktopCenter;
      FormStyle := fsStayOnTop;
      AutoSize  := False;
      ClientHeight := Scope_MinH;
      ClientWidth  := Scope_MinW;
   end;
   // -----------------------------
   fPanel := TPanel.Create(fDFRM);
   fPanel.Parent := fDFRM;
   fPanel.SetBounds(0,0, fDFRM.ClientWidth, fDFRM.ClientHeight);
   fPanel.Align := alClient;
   //  :    
   fPanelCreate := True;
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(0,0, fPanel.Width, fPanel.Height);
   //   : Image   
   fImgCreate := True;
   // -----------------------------
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
   fDFRM.Show;
end;
// --------------------------------------------------------------------
//       (OVERLOAD)
constructor TDnDigits.Create(RqPanel : TPanel);
begin
   inherited Create;
   fDFRM := nil;
   // -----------------------------
   //   :    
   fPanelCreate := False;
   fPanel := RqPanel;
   // ---------------------
   //    
   fPanel.Height  := Scope_MinH;
   fPanel.Width   := Scope_MinW;
   // -----------------------------
   //  Image  
   fImg  := TImage.Create(fPanel);
   fImg.Parent := fPanel;
   fImg.SetBounds(0,0, fPanel.Width, fPanel.Height);
   //   : Image   
   fImgCreate := True;
   // -----------------------------
   //    
   CreateDynComponents();
   // -----------------------------
end;
// --------------------------------------------------------------------
//      Image (OVERLOAD)
constructor TDnDigits.Create(RqImg : TImage; RqXBeg, RqYBeg : integer);
begin
   inherited Create;
   fDFRM  := nil;
   fPanel := nil;
   // -----------------------------
   //   : Image   
   fImgCreate := False;  //   : Image   
   fImg := RqImg;
   if (RqXBeg >= 0) or (RqXBeg < fImg.Width)  then fXBeg := RqXBeg;
   if (RqYBeg >= 0) or (RqYBeg < fImg.Height) then fYBeg := RqYBeg;
   // -----------------------------
   //    
   CreateDynComponents();
end;

// =================================================================
//    
// =================================================================
// -----------------------------------------------------------------
//  XBeg  YBeg     fImg
procedure TDnDigits.ScopePosition(RqXBeg, RqYBeg : integer);
var wVisible : boolean;
begin
   if (not Assigned(fBmpSave)) or
      (not Assigned(fBMP))     or
      (not Assigned(fImg)) then Exit;
   if (RqXBeg < 0) or (RqXBeg > fImg.Width)  then Exit;
   if (RqYBeg < 0) or (RqYBeg > fImg.Height) then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fXBeg := RqXBeg;
   fYBeg := RqYBeg;
   fScopeRect := Rect(fXBeg, fYBeg, fXBeg + fTxtW, fYBeg + fTxtH);
   Visible := wVisible;
end;
// -----------------------------------------------------------------
//     
function TDnDigits.GetCharWidth(RqChar : char) : integer;
begin
   Result := 0;
   if (not Assigned(fBMP)) then Exit;
   Result := fBMP.Canvas.TextWidth(RqChar);
end;
// -----------------------------------------------------------------
//     
procedure TDnDigits.SetDsplWH(RqW, RqH : integer);
var wH, wW : integer;
begin
   if (not Assigned(fBMP)) or (not Assigned(fImg)) then Exit;
   if RqH < Scope_MinH then wH := Scope_MinH else wH := RqH;
   if RqW < Scope_MinW then wW := Scope_MinW else wW := RqW;
   // ---------------------------------------
   Visible := False;
   //    
   fBMP.Height := wH + 2 * cBorderH;
   fBMP.Width  := wW + 2 * cBorderW;
   // ---------------------------------------
   if Assigned(fBmpSave) and (not fImgCreate)
   then begin
      //   fImg
      fBmpSave.Height := fBMP.Height;
      fBmpSave.Width  := fBMP.Width;
      fScopeRect := Rect(fXBeg, fYBeg,
                         fXBeg + fBMP.Width, fYBeg + fBMP.Height);
   end
   else begin
      //   fImg
      with fImg
      do begin
         Picture.Bitmap.Height := fBMP.Height;
         Picture.Bitmap.Width  := fBMP.Width;
         fImg.Height := fBMP.Height;
         fImg.Width  := fBMP.Width;
      end;
      fScopeRect := Rect(0, 0, fBMP.Width, fBMP.Height);
   end;
    Visible := True;
   // ---------------------------------------
   if Assigned(fPanel)
   then begin
      fPanel.Height := fImg.Height;
      fPanel.Width  := fImg.Width;
   end;
   if Assigned(fDFRM)
   then begin
      fDFRM.ClientHeight := fImg.Height;
      fDFRM.ClientWidth  := fImg.Width;
   end;
end;
// -----------------------------------------------------------------
//   
procedure TDnDigits.ResizeDSPL(RqStr : string);
var wTxtH, wTxtW : integer;
begin
   if (not Assigned(fBMP)) or (not Assigned(fImg)) then Exit;

   with fBMP
   do begin
      fCharW := GetCharWidth('0');
      wTxtH := Canvas.TextHeight(RqStr);
      wTxtW := Canvas.TextWidth (RqStr);
      if (wTxtH > fTxtH) or (wTxtW > fTxtW)
      then begin
         if (wTxtH > fTxtH) then fTxtH := wTxtH;
         if (wTxtW > fTxtW) then fTxtW := wTxtW + fCharW;
         //     
         SetDsplWH(fTxtW, fTxtH);
      end;
   end;
end;
//   
procedure TDnDigits.ResizeDSPL(RqW, RqH : integer);
begin
   if (not Assigned(fBMP)) or (not Assigned(fImg)) then Exit;
   with fBMP
   do begin
      fCharW := GetCharWidth('0');
      if (RqH <> fTxtH) or (RqW <> fTxtW)
      then begin
         fTxtH := RqH;
         if (fTxtH < Scope_MinH) then fTxtH := Scope_MinH;
         fTxtW := RqW + fCharW;
         if (fTxtW < Scope_MinW) then fTxtW := Scope_MinW;
         //     
         SetDsplWH(fTxtW, fTxtH);
      end;
   end;
end;
// -----------------------------------------------------------------
//   
procedure TDnDigits.CreateDSPL();
begin
   // --------------------------------
   //  BMP  
   if (not fImgCreate)
   then begin
      fBmpSave := TBitMap.Create;
      fBmpSave.PixelFormat := pf24bit;
   end
   else fBmpSave := nil;
   // --------------------------------
   //  BMP  
   fBMP := TBitMap.Create;
   fBMP.PixelFormat := pf24bit;
   fBMP.Canvas.Font.Name := 'Tahoma';
   fBMP.Canvas.Font.Size := 14;
   fCharW := GetCharWidth('0');
end;
// -----------------------------------------------------------------
//    
procedure TDnDigits.CreateDynComponents();
begin
   // -----------------------------
   //   
   CreateDSPL();
   // -----------------------------
   //     PopupMenu
   if fImgCreate then GreateAndConnecPoUpMenu();
   // -----------------------------
   //   
   fText  := 'DIGITs - ';
   fTitle := ' ';
   // -----------------------------
   //    
   fDFrame     := dfrmDown;
   //    
   fFonColor   := RGB(90,120,150);
   fTxtColor   := clAqua;
   // -----------------------------
   fSCode := scdClear;
   //  
   ShowTextValue(fText);
   // -----------------------------
   //  
   Visible := True;
end;
// --------------------------------------------------------------------
//  
procedure TDnDigits.Free;
begin
   // ---------------------------------
   if Assigned(fPM) then fPM.Free;
   // ---------------------------------
   if Assigned(fBmpSave)
   then begin
       RestoreBkGround();
       fBmpSave.Free();
       fBmpSave := nil;
   end;
   if Assigned(fBMP)
   then begin
      fBMP.Free;
      fBMP := nil;
   end;
   // ---------------------------------
   //  : Image   
   if fImgCreate and Assigned(fImg)
   then begin
      fImg.Free;
      fImg := nil;
      fImgCreate := False;
   end;
   //  :    
   if fPanelCreate and Assigned(fPanel)
   then begin
      fPanel.Free;
      fPanel := nil;
      fPanelCreate := False;
   end;
   // ---------------------------------
   if Assigned(fDFRM)   then  fDFRM.Free;
   // ---------------------------------
   inherited Free;
end;
// =================================================================
//      
// =================================================================
// -----------------------------------------------------------------
//    (   )   
procedure TDnDigits.onDFRMClose(Sender: TObject; var Action: TCloseAction);
// TCloseAction = (caNone, caHide, caFree, caMinimize);
begin
   Action := caMinimize;
end;
//     Show
procedure TDnDigits.onDFRMShow(Sender: TObject);
begin
end;
//     Hide
procedure TDnDigits.onDFRMHide(Sender: TObject);
begin
end;
//   biSystemMenu :biMaximize
procedure TDnDigits.onDFRMActivate(Sender: TObject);
begin
  //  
  fDFRM.FormStyle := fsStayOnTop;
end;
//   biSystemMenu : biMinimize
procedure TDnDigits.onDFRMDeactivate(Sender: TObject);
begin
end;

// ==================================================================
//    
// ==================================================================
// ------------------------------------------------------------------
//     PopupMenu
procedure  TDnDigits.GreateAndConnecPoUpMenu();
var MenuItems : array of TMenuItem;
begin
   // =================================
   //    (PopupMenu)
   // =================================
   SetLength(MenuItems, 2);
   // --------------------
   MenuItems[0]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_TXT');
   MenuItems[0].Tag := 1;
   // --------------------
   MenuItems[1]:= NewItem(' ', TextToShortCut(''),
                          False, True, MenuClick, 0, 'M_FON');
   MenuItems[1].Tag := 2;
   // =================================
   //    (PopupMenu)
   fPM := NewPopupMenu(fImg, 'Menu', paLeft, True, MenuItems);
   fImg.PopupMenu := fPM;
   // =================================
   SetLength(MenuItems,0);
end;
// --------------------------------------------------------------------
procedure ResetRadioItem(RqMenu : TPopupMenu;  RqItem : TMenuItem);
var Ind : integer;
begin
   with RqMenu.Items do
   begin
     for Ind :=0 to Count - 1
     do begin
        Items[Ind].RadioItem := False;
        Items[Ind].Checked   := False;
     end;
     RqItem.RadioItem := True;
     RqItem.Checked   := True;
   end;
end;
// --------------------------------------------------------------------
//     
function TDnDigits.ColorDlg(RqOldColor : TColor) : TColor;
var  wDialog : TColorDialog;
begin
  wDialog := TColorDialog.Create(nil);
  //   
  if wDialog.Execute
  then Result := wDialog.Color
  else Result := RqOldColor;
  wDialog.Destroy;
end;
// --------------------------------------------------------------------
//    
procedure TDnDigits.MenuClick(Sender : TObject);
var Item  : TMenuItem;
begin
   Item :=  TMenuItem(Sender);
   case Item.Tag of
   1  :  begin //   
           fTxtColor := ColorDlg(fTxtColor);
           ShowDsplToImg();
         end;
   2  :  begin  //   
           fFonColor := ColorDlg(fFonColor);
           ShowDsplToImg();
         end;
    end;
end;
// ====================================================================
//         fBMP
// ====================================================================
// --------------------------------------------------------------------
//    Image   
procedure TDnDigits.RestoreBkGround();
var wRect : TRect;
begin
   if (not Assigned(fBmpSave)) or (not Assigned(fImg)) then Exit;
   if fVisible
   then begin
      //  Rect 
      wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
      //     fImg
      fImg.Canvas.CopyRect(fScopeRect, fBmpSave.Canvas,wRect);
   end;
end;
// --------------------------------------------------------------------
//    Image   
procedure TDnDigits.SaveBkGround();
var wRect : TRect;
begin
   if (not Assigned(fBmpSave)) or (not Assigned(fImg)) then Exit;
   //    
   fBmpSave.Height := fScopeRect.Bottom - fScopeRect.Top  + 1;
   fBmpSave.Width  := fScopeRect.Right  - fScopeRect.Left + 1;
   //  Rect 
   wRect := Rect(0,0, fBmpSave.Width, fBmpSave.Height);
   //  
   fBmpSave.Canvas.CopyRect(wRect, fImg.Canvas, fScopeRect);
   //    
   fBmp.Height := fBmpSave.Height;
   fBmp.Width  := fBmpSave.Width;
end;
// --------------------------------------------------------------------
//      Image
procedure TDnDigits.SetVisible(RqVisible : boolean);
begin
  if Assigned(fPanel) and (not Assigned(fDFRM))
  then begin
     if RqVisible
     then begin
        //   
        if not fVisible then fPanel.Visible := True;
     end
     else begin
        //    
        if fVisible then fPanel.Visible := False;
     end;
     fVisible := RqVisible;
     Exit;
  end;
  if (not Assigned(fBmpSave)) or (not Assigned(fImg)) then Exit;
  if RqVisible = fVisible then Exit;
  if RqVisible //   
  then begin
      if not fVisible
      then begin
         SaveBkGround();
         //    fImg
         fVisible := RqVisible;
         ShowDsplToImg();
      end;
  end
  else begin   //    
      if fVisible
      then begin
          //    fImg
          RestoreBkGround();
          fVisible := RqVisible;
       end;
  end;
end;
// --------------------------------------------------------------------
//      
//     Image
procedure TDnDigits.SetTransparent(RqTransparent : boolean);
var wVisible : boolean;
begin
   if (not Assigned(fBmpSave)) or (not Assigned(fImg)) then Exit;
   if RqTransparent = fTransparent then Exit;
   wVisible := fVisible;
   if fVisible then Visible := False;
   fTransparent := RqTransparent;
   ShowDsplToImg();
   Visible := wVisible;
end;
// ====================================================================
//   
// ====================================================================
//    Image
procedure TDnDigits.ShowDsplToImg();
var wRect : TRect;
begin
   if (not Assigned(fImg)) or (not Assigned(fBMP))then Exit;
   if  Assigned(fBmpSave)
   then begin
      if not fVisible then Exit;
      //   fBmp   
      fBmp.Assign(fBmpSave);
      // --------------
      //      fBMP
       ShowText();
      // --------------
      //  Rect 
      wRect := Rect(0,0, fBmp.Width, fBmp.Height);
      //     fImg
      fImg.Canvas.CopyRect(fScopeRect, fBmp.Canvas, wRect);
   end
   else begin
      //      fBMP
      ShowText();
      //  Rect  = 
      wRect := Rect(0, 0, fImg.Width, fImg.Height);
      //     fImg
      fImg.Canvas.CopyRect(wRect, fBMP.Canvas, wRect);
   end;
end;
// ====================================================================
//
// ====================================================================
// --------------------------------------------------------------------
//     
procedure TDnDigits.DsplClear(RqColor : TColor);
begin
  if Assigned(fBmpSave) and fTransparent then Exit;
  with fBMP.Canvas do
  begin
    Brush.Color := RqColor;
    Brush.Style := bsSolid;
    FillRect(Rect(0, 0, fBMP.Width, fBMP.Height));
  end;
end;
// --------------------------------------------------------------------
//    
procedure TDnDigits.ShowTitle();
begin
  if not Assigned(fDFRM) then Exit;
  fDFRM.Caption := fTitle;
end;
// --------------------------------------------------------------------
//     
procedure DigitFrame(RqBMP : TBitMap; RqDFrame : TDFrame; dHW : byte);
begin
   if RqDFrame = dfrmNone then Exit;
   with RqBMP.Canvas do
   begin
      Pen.Width := 2;
      if RqDFrame = dfrmUp   then Pen.Color := clBlack;
      if RqDFrame = dfrmDown then Pen.Color := clWhite;
      Rectangle(0,0, RqBMP.Width-dHW, RqBMP.Height-dHW);
      Pen.Width := 1;
      if RqDFrame = dfrmUp   then Pen.Color := clWhite;
      if RqDFrame = dfrmDown then Pen.Color := clBlack;
      MoveTo(0, RqBMP.Height);
      LineTo(0, 0);
      LineTo(RqBMP.Width, 0);
      MoveTo(1, RqBMP.Height-2-dHW);
      LineTo(1, 1);
      LineTo(RqBMP.Width-1-dHW, 1);
   end;
end;
// --------------------------------------------------------------------
//    fBMP     fImg
procedure TDnDigits.ShowText();

begin
   ShowTitle();
   DsplClear(fFonColor);
   with fBMP.Canvas do
   begin
      Brush.Style := bsClear;
      Font.Color  := fTxtColor;
      TextOut(cBorderW + 2, cBorderH, fText);
      if not Assigned(fDFRM)
      then begin
         if Assigned(fPanel)
         then begin
            // ,  fImg   
            DigitFrame(fBMP, fDFrame, 0);
         end
         else begin
            // ,  fImg 
            if not fTransparent then DigitFrame(fBMP, fDFrame, 1);
         end;
      end;
   end;
end;

// ====================================================================
//  PROPERTY
// ====================================================================
// --------------------------------------------------------------------
//     
procedure TDnDigits.SetDFrame (RqDFrame : TDFrame);
begin
   fDFrame := RqDFrame;
   ShowDsplToImg();
end;
// --------------------------------------------------------------------
//      
procedure TDnDigits.SetFonColor(RqColor : TColor);
begin
   fFonColor := RqColor;
   ShowDsplToImg();
end;
// --------------------------------------------------------------------
//      
procedure TDnDigits.SetTxtColor(RqColor : TColor);
begin
   fTxtColor := RqColor;
   ShowDsplToImg();
end;
// --------------------------------------------------------------------
//   
procedure TDnDigits.SetTextValue(RqTextValue  : string);
begin
    fText := RqTextValue;
    if fYMes <> '' then fText := fText + ' ' +  fYMes;
    ResizeDSPL(fText);
    ShowDsplToImg();
end;

// --------------------------------------------------------------------
//  
procedure TDnDigits.SetTitle(RqTitle : string);
begin
   if not Assigned(fDFRM) then Exit;
   fTitle := ' ' + RqTitle;
   fDFRM.Caption := fTitle;
   ShowTitle();
end;
// ====================================================================
//
// ====================================================================
// --------------------------------------------------------------------
//        
function HexToBitStr(RqHexStr : string): string;
const cSep = ' ';
var Indx : integer;
begin
   Result := '';
   if Trim(RqHexStr) = '' then Exit;
   for  Indx := 1 to Length(RqHexStr)
   do case RqHexStr[Indx] of
       // ----------
       '0' : Result := Result + '0000' + cSep;
       '1' : Result := Result + '0001' + cSep;
       '2' : Result := Result + '0010' + cSep;
       '3' : Result := Result + '0011' + cSep;
       '4' : Result := Result + '0100' + cSep;
       '5' : Result := Result + '0101' + cSep;
       '6' : Result := Result + '0110' + cSep;
       '7' : Result := Result + '0111' + cSep;
       // ----------
       '8' : Result := Result + '1000' + cSep;
       '9' : Result := Result + '1001' + cSep;
       'A' : Result := Result + '1010' + cSep;
       'B' : Result := Result + '1011' + cSep;
       'C' : Result := Result + '1100' + cSep;
       'D' : Result := Result + '1101' + cSep;
       'E' : Result := Result + '1110' + cSep;
       'F' : Result := Result + '1111' + cSep;
    end;
end;
// ====================================================================
//   
// ====================================================================
// --------------------------------------------------------------------
//  
procedure TDnDigits.Clear();
begin
   fText := ' ';
   ResizeDSPL(Scope_MinW, Scope_MinH);
   ShowDsplToImg();
   fSCode := scdClear;
end;
// --------------------------------------------------------------------
//        DIGITs - 
function TDnDigits.ShowTextValue(RqValue : string) : string;
begin
    if (fSCode <> scdClear) then Clear();
    Result := RqValue;
    SetTextValue(Result);
    fSCode := scdText;
end;
// --------------------------------------------------------------------
//     Byte   
function TDnDigits.ShowByteValue(RqRadix : TRadix; RqValue : Int64) : string;
var wByte : word;
begin
   if (fSCode <> scdClear) and (fSCode <> scdBit) then Clear();
   if (RqValue >= 0) and (RqValue <= 255)
   then begin
      try
         wByte := Byte(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX + IntToHex(wByte, SizeOF(Byte) * 2);
            rdxBit     : begin
                           Result := IntToHex(wByte, SizeOF(Byte) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   SetTextValue(Result);
   fSCode := scdBit;
end;
// --------------------------------------------------------------------
//     Word   
function TDnDigits.ShowWordValue(RqRadix : TRadix; RqValue : Int64) : string;
var wWord : word;
begin
   if fSCode <> scdWord then Clear();
   if (RqValue >= 0) and (RqValue <= 65535)
   then begin
      try
         wWord := Word(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX + IntToHex(wWord, SizeOF(Word) * 2);
            rdxBit     : begin
                           Result := IntToHex(wWord, SizeOF(Word) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   SetTextValue(Result);
   fSCode := scdWord;
end;
// --------------------------------------------------------------------
//     LongWord   
function TDnDigits.ShowLongWordValue(RqRadix : TRadix; RqValue : Int64) : string;
var wLongWord : LongWord;
begin
   if fSCode <> scdLongWord then Clear();
   if (RqValue >= 0) and (RqValue <= 4294967295)
   then begin
      try
         wLongWord := LongWord(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX +
                                   IntToHex(wLongWord, SizeOF(LongWord) * 2);
            rdxBit     : begin
                           Result := IntToHex(wLongWord, SizeOF(LongWord) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   SetTextValue(Result);
   fSCode := scdLongWord;
end;
// --------------------------------------------------------------------
//     Integer   
function TDnDigits.ShowIntegerValue(RqRadix : TRadix; RqValue : Int64) : string;
var wInteger : Integer;
begin
   if fSCode <> scdInteger then Clear();
   if (RqValue >= -2147483647) and (RqValue <= 2147483647)
   then begin
      try
         wInteger := Integer(RqValue);
         case RqRadix of
            rdxDecimal : Result := prefDEC + IntToStr(RqValue);
            rdxHex     : Result := prefHEX +
                                   IntToHex(wInteger, SizeOF(Integer) * 2);
            rdxBit     : begin
                           Result := IntToHex(wInteger, SizeOF(Integer) * 2);
                           Result := prefBIT + HexToBitStr(Result);
                         end;
         end;
      except Result := 'error'; end;
   end else Result  := 'out range';
   SetTextValue(Result);
   fSCode := scdInteger;
end;
// --------------------------------------------------------------------
//     Int64   
function TDnDigits.ShowInt64Value(RqRadix : TRadix; RqValue : Int64) : string;
begin
   if fSCode <> scdInt64 then Clear();
   try
      case RqRadix of
        rdxDecimal : Result := prefDEC + IntToStr(RqValue);
        rdxHex     : Result := prefHEX + IntToHex(RqValue, SizeOF(Int64) * 2);
        rdxBit     : begin
                       Result := IntToHex(RqValue, SizeOF(Int64) * 2);
                       Result := prefBIT + HexToBitStr(Result);
                     end;
       end;
   except Result := 'error'; end;
   SetTextValue(Result);
   fSCode := scdInt64;
end;
// --------------------------------------------------------------------
//    Extended   
function TDnDigits.ShowExtendedValue(RqValue : extended) : string;
begin
   if fSCode <> scdExtended then Clear();
   Result := prefDEC + FloatToStr(RqValue);
   SetTextValue(Result);
   fSCode := scdExtended;
end;
// ====================================================================
// 
// ====================================================================

end.
