unit SolveESet;
//       
interface
uses SysUtils, Dialogs, MAINDATA, ComplexOp, Reports;

function SolveComplexESet(var RqESetCTRL : TESetCTRL) : boolean;

implementation

const  cGDelta = 1e-10;  //    
       cEDelta = 1e-10;  //       

//    
const  cSolveErrMsg1 =  '    '
                         + #13#10 +
                         '    ';

      cSolveErrMsg2 =  '   .'
                        + #13#10 +
                        '  .'
                        + #13#10 +
                        '     :'
                        + #13#10 +
                        '1.     ;'
                        + #13#10 +
                        '2.    ;';

       cSolveErrMsg3 =  '  .'
                        + #13#10 +
                        '  .'
                        + #13#10 +
                        '(  )';

// --------------------------------------------------------------------------
//       
//        
function TestMatrixRange (var RqESetCTRL : TESetCTRL) : boolean;
var RowInd : LongInt;   //  
begin
  Result := False;      //  
  with RqESetCTRL do
  begin
     if Assigned(ESetSRC) and Assigned(ESetWRK) and Assigned(ESetRoots)
     then begin
        if ( Length(ESetWRK)  >= MinNewESetRow ) and
           ( Length(ESetRoots) = Length(ESetWRK) )
        then begin
           for RowInd := Low(ESetWRK) to High(ESetWRK) do
           begin
               if High(ESetWRK[RowInd]) <> ( High(ESetWRK) + 1)
               then begin
                  //   . SYSTEM ERROR.'
                  ESetSolveOK    := False;  //  -  
                  ESetSolveError := 3;      //   
                  ESetSolveMsg   := cSolveErrMsg3;
                  Exit;  //    
               end;
           end; // of for RowInd
           Result := True;
        end;
     end
     else begin
        //    
        ESetSolveOK    := False;  //  -  
        ESetSolveError := -1;      //   
        ESetSolveMsg   := cSolveErrMsg1;
     end;
  end; // of with RqESetCTRL
end; // of function

// --------------------------------------------------------------------------
//   
function BuildGausseMatrix (var RqESetCTRL : TESetCTRL) : boolean;
//---------------
var MInd : LongInt;   //  
    KInd : LongInt;   //      
    Ind  : LongInt;   //  
//---------------
var sRow : LongInt;   //    
//---------------
var mWork : Extended;  //    
    CWork : T2Complex; //    
//---------------
begin
  //  
  Result := False;
  with RqESetCTRL do
  begin
     ESetSolveOK := False;
     //    
     SetRunProress('BuildGausseMatrix', 0, 1, High(ESetWRK) - 1);
     // -----------------
     //     ,  
     for MInd := Low(ESetWRK) to High(ESetWRK) - 1 do
     begin
        //     
        ProressOneStep();
        // 1 --------------------
        //    (master)   
        mWork := ModuleDC(ESetWRK[MInd, MInd]);
        sRow  := MInd;
        for Ind := MInd to High(ESetWRK) do
        begin
           if mWork < ModuleDC(ESetWRK[Ind, MInd]) then
           begin
              mWork := ModuleDC(ESetWRK[Ind, MInd]);
              sRow := Ind;
           end;
        end; // of for Ind
        // sRow -      
        // 2 --------------------
        //      
        //    .
        if MInd <> sRow then
        begin
           for Ind := Low(ESetWRK[sRow]) to High(ESetWRK[sRow]) do
           begin
              //   
              ComplexToComplex(ESetWRK[MInd, Ind], CWork);
              ComplexToComplex(ESetWRK[sRow, Ind], ESetWRK[MInd, Ind]);
              ComplexToComplex(CWork, ESetWRK[sRow, Ind]);
           end; // of for Ind
        end; // of if MInd
        // 3 --------------------
        if ModuleDC (ESetWRK[MInd, MInd]) < cGDelta
        then begin
           //    .
           ESetSolveOK    := False;  //  -  
           ESetSolveError := 2;      //   
           ESetSolveMsg := cSolveErrMsg2;
           Exit; //    
        end; // of if ModuleDC
        // 4 --------------------
        //  X  m-      
        for KInd := MInd + 1 To High(ESetWRK) do
        begin
           //    (Scale)
           CWork := DivDC(ESetWRK[KInd, MInd], ESetWRK[MInd, MInd]);
           //  X  m-  k-   
           for Ind := Low(ESetWRK[KInd]) To High(ESetWRK[KInd]) do
           begin
             //  
             //     
             // ESetWRK[KInd, Ind]:= SubDC( ESetWRK[KInd, Ind],
             //                            MulDC(CWork, ESetWRK[MInd, Ind]));
             //  
             //     
             // :  Coeff := Coeff - (Scale * MCoeff)
             NewGausseCoeff (CWork,                // Scale
                             ESetWRK[MInd,Ind],    // MCoeff
                             ESetWRK[KInd,Ind]);   // Coeff
           end; // of for Ind
        end; // of for KInd
     end; // of for MInd

     // --------------------
     //      
     //     
     // --------------------
     //     
     for sRow := Low(ESetWRK) to High(ESetWRK) do
     begin
        mWork := 0;  //    
        //     
        for Ind := Low(ESetWRK[sRow]) to High(ESetWRK[sRow]) do
        begin
           DecartToPolar (ESetWRK[sRow, Ind]);
           mWork := mWork + ESetWRK[sRow, Ind].m;
        end;
        if mWork < cGDelta
        then begin
           //      
           //    .
           ESetSolveOK    := False;  //  -  
           ESetSolveError := 2;      //   
           ESetSolveMsg := cSolveErrMsg2;
           Exit; //    
        end;
     end;
     //       
     //   
     ESetSolveOK := True;  //    
     Result := True;       //   
  end; // of with RqESetCTRL
  //   
  ProressToMin();
end; // of function

// --------------------------------------------------------------------------
//     
procedure SolveRoots (var RqESetCTRL : TESetCTRL);
var RInd : LongInt;    //   
    wInd  : LongInt;   //  
    PSum : T2Complex;  //   
begin
  with RqESetCTRL do
  begin
    //    
    SetRunProress('SolveRoots', 0, 1, High(ESetWRK));
    for RInd := High(ESetWRK) downto Low(ESetWRK) do
    begin
      //     
      ProressOneStep();
      //   
      ZeroToComplex(PSum);
      if RInd < High(ESetWRK)
      then begin
         for wInd := (RInd + 1) to High(ESetWRK) do
         begin
           //  
           //      
           // PSum  := SumDC( PSum, MulDC(ESetWRK[RInd,Ind], ESetRoots[Ind]) );
           //  
           //      
           //  : PSum = PSum + Coeff[RInd, Ind] * Root[Ind]
           PartPolynom (ESetWRK[RInd, wInd], ESetRoots[wInd], PSum);
         end; // of for Ind
      end;
      //  
      //   
      // ESetRoots[RInd] := DivDC( SubDC(ESetWRK[RInd,High(ESetWRK)+1], PSum),
      //                           ESetWRK[RInd, RInd] );
      //  
      //      
      // NextRoot (const Y, PSum, Coeff : T2Complex; var Root : T2Complex);
      NextRoot (ESetWRK[RInd,High(ESetWRK)+1], PSum,
                ESetWRK[RInd, RInd],
                ESetRoots[RInd]);
      //    
      DecartToPolar (ESetRoots[RInd]);
    end; // of for RInd
  end; // of with RqESetCTRL
  //   
  ProressToMin();
end; // of procedure

// --------------------------------------------------------------------------
function SolveComplexESet(var RqESetCTRL : TESetCTRL) : boolean;
var wInd   : LongInt;    //  
    PSum   : T2Complex;  //     
    mDelta : Extended;   //   
begin
  Result := False;
  DebugMsgToReport('    ');
  //       
  //        
  if TestMatrixRange (RqESetCTRL)
  then begin
     DebugMsgToReport('    ');
     //   
     if BuildGausseMatrix (RqESetCTRL)
     then begin
        DebugMsgToReport('  ()  ');
        //     
        SolveRoots (RqESetCTRL);
        DebugMsgToReport('    ');
        //       
        with RqESetCTRL do
        begin
            //     
            ZeroToComplex(PSum);
            for wInd := Low(ESetWRK) to High (ESetWRK) do
            begin
              //       
              //  : PSum = PSum + Coeff[RInd, Ind] * Root[Ind]
              PartPolynom (ESetWRK[Low(ESetWRK), wInd],
                           ESetRoots[wInd], PSum);
            end;
            //      
            mDelta :=   ModuleDC(ESetWRK[Low(ESetWRK), High(ESetWRK)+1])
                      - ModuleDC(PSum);
            //  
            Result := True;            //  
            DebugMsgToReport('    ');
            if (mDelta < cEDelta)
            then begin
               //  
               ESetSolveOK    := True;  //  -  
               ESetSolveError := 0;     //   
               ESetSolveMsg   := '   .'
                                + #13#10 +
                                '     '
                                + FloatToStr(mDelta);
               // Showmessage(ESetSoleMsg);
            end
            else begin
              //   
              ESetSolveOK    := True;  //  -  
              ESetSolveError := 1;     //    
              ESetSolveMsg   := 'C  c  .'
                                + #13#10 +
                                '     '
                                + FloatToStr(mDelta);
              //     
              ErrorMsgToReport
                   (True,   //    
                    True,   //   
                    ESetSolveMsg);
            end;
        end; // of with RqESetCTRL
     end;
  end;
end; // of procedure

end.
