unit ShowGraphXY01;

interface
uses Windows, ExtCtrls, Graphics, Dialogs, SysUtils, Grids,
     MAINDATA, ESetGridService;
// --------------------------------------------------------------------------

//    
procedure InitShowGraph01(RqPanel : TPanel);

//    UNIT ShowGraphXY01
procedure CloseShowGraph01();

//   
procedure ClearRootGraph();

//      JPEG
procedure SaveRootGraph(RqFileName : string);

//       
procedure ShowGraphAllRoot(RqESetCTRL : TESetCTRL); //   ESet

//         
procedure ShowGraphSelectData(
               RqRootGrid : TStringGrid;
               RqESetCTRL : TESetCTRL;   //   ESet
               RqYScale   : extended     //    
                             );

// ==========================================================================
// ==========================================================================
implementation
// ==========================================================================
// ==========================================================================
uses GraphXYv03;

const cRootsColor = clBlue;
      cFreeBColor = clRed;

//      
var GraphVectors  : TGraphXY;

//     
var VectorsArr : array of TPointXY;

//   
type TSSign = record
  SColor : TColor;
  SText  : string;
end;

//      VectorsArr
var SSignArr : array of TSSign;

// --------------------------------------------------------------------------
//    
procedure InitShowGraph01(RqPanel : TPanel);
begin
    if GraphVectors = nil
    then begin
      //      
      GraphVectors := TGraphXY.Create();
      GraphVectors.OpenGraphXY(RqPanel, 'Vectors');
      // 
      GraphVectors.GraphTitul:='   ';
      GraphVectors.BackGroundColor := RGB(200,200,200);
    end;
end;

// --------------------------------------------------------------------------
//    UNIT ShowGraphXY01
procedure CloseShowGraph01();
begin
   if GraphVectors <> nil
   then begin
     GraphVectors:=GraphVectors.CloseGraphXY(GraphVectors);
   end;
end;

// --------------------------------------------------------------------------
//   
procedure ClearRootGraph();
begin
   if GraphVectors <> nil
   then GraphVectors.ReSetBitMapAndEraseGraphXY();
end;

// --------------------------------------------------------------------------
//      JPEG
procedure SaveRootGraph(RqFileName : string);
begin
   if GraphVectors <> nil
   then GraphVectors.SaveGraphXY(RqFileName, 'J');
end;

// --------------------------------------------------------------------------
//       
procedure ShowGraphAllRoot(RqESetCTRL : TESetCTRL); //   ESet
var wRow : LongInt;
begin
  if Assigned(RqESetCTRL.ESetRoots) and (GraphVectors <> nil)
  then begin
    GraphVectors.ReSetBitMapAndEraseGraphXY();
    try
       with RqESetCTRL
       do begin
         //    
         SetLength(VectorsArr, Length(ESetRoots));
         for wRow := Low(VectorsArr) to High(VectorsArr)
         do begin
           VectorsArr[wRow].X := ESetRoots[wRow].r;
           VectorsArr[wRow].Y := ESetRoots[wRow].i
         end;
       end; // of with RqESetCTRL
       //       
       GraphVectors.FindOptimalScale(True, True, VectorsArr);
       //     
       for wRow := Low(VectorsArr) to High(VectorsArr)
       do begin
         //  
         GraphVectors.VectotToGraphXY(0, 0,
                                      VectorsArr[wRow].X,
                                      VectorsArr[wRow].Y,
                                      cRootsColor);
         //  
         GraphVectors.SubscriptPointXY(VectorsArr[wRow].X,
                                       VectorsArr[wRow].Y,
                                       cRootsColor,
                                       'X' + IntToStr(wRow));
       end;
       GraphVectors.ShowTextXY(8,4, clNavy,
                    '    (. = 1)');
    except
       MessageDlg('   ', mtWarning, [mbOk], 0);
    end;
  end; // of if Assigned
end;

// --------------------------------------------------------------------------
//         
procedure ShowGraphSelectData(
               RqRootGrid : TStringGrid;
               RqESetCTRL : TESetCTRL;   //   ESet
               RqYScale   : extended     //    
                             );
var wRow, wArrRow, wVctRow, XCount, YCount : LongInt;
begin
  if Assigned(RqESetCTRL.ESetSRC)   and
     Assigned(RqESetCTRL.ESetRoots) and
    (GraphVectors <> nil)
  then begin
    //  
    GraphVectors.ReSetBitMapAndEraseGraphXY();
    with RqESetCTRL
    do begin
       if (Length(ESetSRC) = Length(ESetRoots)) and
          ((RqRootGrid.RowCount - RqRootGrid.FixedRows)= Length(ESetSRC))
       then begin
          //    
          XCount := 0; YCount := 0;
          for wRow := RqRootGrid.FixedRows to (RqRootGrid.RowCount -1)
          do begin
             //  
             if (RqRootGrid.Cells[cRGridColSelX, wRow] <> '')
             then XCount := XCount + 1;
             //   
             if (RqRootGrid.Cells[cRGridColSelY, wRow] <> '')
             then YCount := YCount + 1;
          end;
          if (XCount + YCount) > 1
          then begin
             //  ,   
             try
               //    
               SetLength(VectorsArr, (XCount + YCount));
               //     
               SetLength(SSignArr, (XCount + YCount));
               wVctRow := Low(VectorsArr);
               for wRow := RqRootGrid.FixedRows to (RqRootGrid.RowCount -1)
               do begin
                  //    Grid    
                  wArrRow := WRow - RqRootGrid.FixedRows;
                  if (RqRootGrid.Cells[cRGridColSelX, wRow] <> '')
                  then begin
                     //      
                     VectorsArr[wVctRow].X := ESetRoots[wArrRow].r;
                     VectorsArr[wVctRow].Y := ESetRoots[wArrRow].i;
                     SSignArr[wVctRow].SColor := cRootsColor;
                     SSignArr[wVctRow].SText  := 'X' + IntToStr(wArrRow);
                     //    
                     wVctRow := wVctRow + 1;
                  end;
                  if (RqRootGrid.Cells[cRGridColSelY, wRow] <> '')
                  then begin
                     //       
                     VectorsArr[wVctRow].X :=  RqYScale
                           * ESetSRC[wArrRow, High(ESetSRC[wArrRow])].r;
                     VectorsArr[wVctRow].Y :=  RqYScale
                           * ESetSRC[wArrRow, High(ESetSRC[wArrRow])].i;
                     SSignArr[wVctRow].SColor := cFreeBColor;
                     SSignArr[wVctRow].SText  := 'b' + IntToStr(wArrRow);
                     //    
                     wVctRow := wVctRow + 1;
                  end;
               end;
               //       
               GraphVectors.FindOptimalScale(True, True, VectorsArr);
               //     
               for wVctRow := Low(VectorsArr) to High(VectorsArr)
               do begin
                  //  
                  GraphVectors.VectotToGraphXY
                               (0, 0,
                                VectorsArr[wVctRow].X,
                                VectorsArr[wVctRow].Y,
                                SSignArr[wVctRow].SColor);
                  //  
                  GraphVectors.SubscriptPointXY
                              (VectorsArr[wVctRow].X,
                               VectorsArr[wVctRow].Y,
                               SSignArr[wVctRow].SColor,
                               SSignArr[wVctRow].SText);
               end;
               GraphVectors.ShowTextXY(8,4, clNavy,
                    '   (. = 1) '
                  + '     (. = '
                  + FloatToStr(RqYScale)
                  + ')');
             except
               MessageDlg('   ',
                           mtWarning, [mbOk], 0);
             end;
          end
          else begin
             MessageDlg('     ',
                         mtWarning, [mbOk], 0);
          end;  // of if (XCount + YCount) > 1
       end;  // of if (Length(ESetSRC) ...
    end;  // of with RqESetCTRL
  end; // of if Assigned
end;


end.
