unit ShowCTRLDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
     Buttons, ExtCtrls,
     MAINDATA;

type
  TFormShowCTRL = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    CBoxMSel: TComboBox;
    CBoxVPMod: TComboBox;
    CBoxVPPrc: TComboBox;
    Label4: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CBoxVPCrd: TComboBox;
    CBoxVPPG: TComboBox;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CBoxMSelClick(Sender: TObject);
    procedure CBoxVPCrdClick(Sender: TObject);
    procedure CBoxVPModClick(Sender: TObject);
    procedure CBoxVPPrcClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CBoxVPPGClick(Sender: TObject);
  private
     { Private declarations }
      //   ComboBox
      procedure InitCBoxes();
      //   ComboBox
      procedure PreSetCBoxes();

  public
    { Public declarations }
  end;

var
  FormShowCTRL: TFormShowCTRL;

implementation

{$R *.dfm}
//   ComboBox
procedure TFormShowCTRL.InitCBoxes();
var   Ind : integer; //  
begin
  // ComboBox  ESet   
  CBoxMSel.Clear;
  for Ind:=Low(cShowMSelArr) to High(cShowMSelArr)
  do CBoxMSel.Items.Add(cShowMSelArr[Ind]);
  // ComboBox     
  CBoxVPCrd.Clear;
  for Ind:=Low(cShowVPCrdArr) to High(cShowVPCrdArr)
  do CBoxVPCrd.Items.Add(cShowVPCrdArr[Ind]);
  // ComboBox     
  CBoxVPMod.Clear;
  for Ind:=Low(cShowVPModArr) to High(cShowVPModArr)
  do CBoxVPMod.Items.Add(cShowVPModArr[Ind]);
  // ComboBox     
  CBoxVPPrc.Clear;
  for Ind:=Low(cShowVPPrcArr) to High(cShowVPPrcArr)
  do CBoxVPPrc.Items.Add(cShowVPPrcArr[Ind]);
  // ComboBox      ( /  (True))
  CBoxVPPG.Clear;
  for Ind:=Low(cShowVPPGArr) to High(cShowVPPGArr)
  do CBoxVPPG.Items.Add(cShowVPPGArr[Ind]);

end;

//   ComboBox
procedure TFormShowCTRL.PreSetCBoxes();
begin
  // ComboBox  ESet   
  case IdShowGridESET of
    cShowESetSRC : CBoxMSel.ItemIndex := 0;
    cShowESetWRK : CBoxMSel.ItemIndex := 1;
  end;
  // ComboBox     
  CBoxVPCrd.ItemIndex := VPESet.VPCrd;
  if VPESet.VPCrd = Low(cShowVPCrdArr)
  then begin
     //   
     CBoxVPPG.Enabled   := False;
     CBoxVPPG.ItemIndex := -1;
  end
  else begin
     //   
     CBoxVPPG.Enabled := True;
     // ComboBox     
     //  (False) /  (True)
     if VPESet.VPPG
     then CBoxVPPG.ItemIndex := High(cShowVPPGArr)
     else CBoxVPPG.ItemIndex := Low(cShowVPPGArr);
  end;
  // ComboBox     
  CBoxVPMod.ItemIndex := VPESet.VPMod;
  // ComboBox     
  CBoxVPPrc.ItemIndex := VPESet.VPPrc;
end;

procedure TFormShowCTRL.FormCreate(Sender: TObject);
begin
   //   ComboBox
   InitCBoxes();
end;

procedure TFormShowCTRL.FormActivate(Sender: TObject);
begin
   //   ComboBox
   PreSetCBoxes();
end;

//   ESet
procedure TFormShowCTRL.CBoxMSelClick(Sender: TObject);
begin
  case CBoxMSel.ItemIndex of
    0 :  begin
           //    
           IdShowGridESET := cShowESetSRC;
           //    
           RqShowGridESET := True;
         end;
    1 :   begin
           //    
           IdShowGridESET := cShowESetWRK;
           //    
           RqShowGridESET := True;
          end;
  end; // of case CBoxMSel.ItemIndex
end;

//        ESet
procedure TFormShowCTRL.CBoxVPCrdClick(Sender: TObject);
begin
    VPESet.VPCrd := Byte(CBoxVPCrd.ItemIndex);
    //  /      
    if VPESet.VPCrd = Low(cShowVPCrdArr)
    then begin
       //   
       CBoxVPPG.Enabled   := False;
       CBoxVPPG.ItemIndex := -1;
    end
    else begin
       //   
       CBoxVPPG.Enabled := True;
       // ComboBox     
       //  (False) /  (True)
       if VPESet.VPPG
       //  
       then CBoxVPPG.ItemIndex := High(cShowVPPGArr)
       //  
       else CBoxVPPG.ItemIndex := Low(cShowVPPGArr);
  end;
    //    
    RqShowGridESET := True;
end;

//       ESet
procedure TFormShowCTRL.CBoxVPModClick(Sender: TObject);
begin
    VPESet.VPMod := Byte(CBoxVPMod.ItemIndex);
    //    
    RqShowGridESET := True;
end;

//       ESet
procedure TFormShowCTRL.CBoxVPPrcClick(Sender: TObject);
begin
    VPESet.VPPrc := Byte(CBoxVPPrc.ItemIndex);
    //    
    RqShowGridESET := True;
end;

//   ( / )   
procedure TFormShowCTRL.CBoxVPPGClick(Sender: TObject);
begin
  if CBoxVPPG.ItemIndex >= 0
  then begin
     if CBoxVPPG.ItemIndex <> Low(cShowVPPGArr)
     then VPESet.VPPG := True
     else VPESet.VPPG := False;
     //    
    RqShowGridESET := True;
  end;
end;

end.
