unit Reports;

interface
uses Controls, StdCtrls, ComCtrls, SysUtils, StrUtils, Graphics, Dialogs,
     MAINDATA, ComplexOp;

//  /    (   )
procedure DebugOnOff (RqDebug : boolean);

//===========================================================================
//   
//===========================================================================
//    
procedure InitReport(RqReport : TMemo);

//   
procedure BlankStrToReport();

//   RqSep 
procedure SeparatotToReport(RqSep : string; RqCount : byte);

//   RqSep    
procedure TimeSeparatotToReport(RqSep : string; RqCount : byte);

//    
// ,      
//   
procedure HeadMsgToReport(RqTxt : string);

//    
//      
procedure TailMsgToReport(RqTxt : string);

//    (   )
procedure DebugMsgToReport(RqMsg : string);

//  
procedure InfoMsgToReport
                (RqDlgMsg : boolean; //    
                 RqDlgWrn : boolean; //   
                 RqTxt    : string); //  

//   
procedure ErrorMsgToReport
                (RqDlgMsg : boolean; //    
                 RqDlgWrn : boolean; //   
                 RqTxt    : string); //  

//     TXT
procedure SaveReportAsFileTxt(RqFileName : string);

//===========================================================================
//    
//===========================================================================

//   
procedure InitRunProress(
               RqPrMsg : TStaticText;    //    
               RqPrBar : TProgressBar);  //    ProgressBar

//        (RqMsg)
procedure SetRunProress(RqMsg : string; RqMin, RqStep, RqMax : LongInt);

//     
procedure ProressOneStep();

//   
procedure ProressToMin();

//    .  RqMsg <> ''  On  Off
procedure SetPrMsgInd(RqMsg : string);

//===========================================================================
//===========================================================================
implementation
//===========================================================================
//===========================================================================
//    
const  //     
   cSeparatotDef  = '-';     //     
   cSeparatotLen  = 100;     //      
   cSeparatotTime = ' >>> '; //      

const //   
    cDebugPref    = ' *** DEBUG *** ';
    cDebugDlgOn   = False;    //    ( vDebugOn)

//     
var vDebugOn      : boolean;

//===========================================================================
//    
var WorkReport : TMemo;

//===========================================================================
//     
type TIndicators = record
    PrMsg : TStaticText;    //     
    PrBar : TProgressBar;   //    ProgressBar
end;
//    
var PrInd      : TIndicators;


//===========================================================================
//  /    (   )
procedure DebugOnOff (RqDebug : boolean);
begin
 vDebugOn := RqDebug;
end;

//===========================================================================
//   
//===========================================================================

//    
procedure InitReport(RqReport : TMemo);
begin
   WorkReport := RqReport;
   if Assigned(WorkReport) then with WorkReport do
   begin //  ,  
      Clear;
      Lines.Add(' .');
      Lines.Add('  : ' + DateTimeToStr(Now));
   end;
end;

// --------------------------------------------------------------------------
//   
procedure BlankStrToReport();
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     Lines.Add('');
  end;
end;

// --------------------------------------------------------------------------
//   RqSep 
procedure SeparatotToReport(RqSep : string; RqCount : byte);
var MsgStr : string;
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     MsgStr := DupeString(RqSep, RqCount) + DupeString(RqSep, 15);
     Lines.Add(MsgStr);
  end;
end;

// --------------------------------------------------------------------------
//   RqSep    
procedure TimeSeparatotToReport(RqSep : string; RqCount : byte);
var MsgStr : string;
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     MsgStr := cSeparatotTime + TimeToStr(Time) + ' ';
     MsgStr := MsgStr + DupeString(RqSep, RqCount);
     Lines.Add(MsgStr);
  end;
end;

// --------------------------------------------------------------------------
//    
// ,      
//   
procedure HeadMsgToReport(RqTxt : string);
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
      Lines.Add(' ');   //  
      TimeSeparatotToReport(cSeparatotDef, cSeparatotLen);
      Lines.Add(RqTxt);
  end;
end;

// --------------------------------------------------------------------------
//    
//      
procedure TailMsgToReport(RqTxt : string);
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     Lines.Add(RqTxt);   //  
     TimeSeparatotToReport(cSeparatotDef, cSeparatotLen);
  end;
end;

// --------------------------------------------------------------------------
//    (   )
procedure DebugMsgToReport(RqMsg : string);
begin
  if vDebugOn
  then begin
    if Assigned(WorkReport) then with WorkReport do
    begin //  ,  
       Lines.Add(cDebugPref
               + TimeToStr(Time)
               + ' *** : '
               + RqMsg);
       if cDebugDlgOn
       then MessageDlg(cDebugPref + #09 + RqMsg,
                       mtInformation, [mbOk], 0);
    end;
  end;
end; // of procedure DebugMsgToReport

// --------------------------------------------------------------------------
//  
procedure InfoMsgToReport
                (RqDlgMsg : boolean; //    
                 RqDlgWrn : boolean; //   
                 RqTxt    : string); //  
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     Lines.Add(RqTxt);
     if RqDlgMsg
     then begin
        if RqDlgWrn
        then MessageDlg( RqTxt, mtWarning, [mbOk], 0)
        else MessageDlg( RqTxt, mtInformation, [mbOk], 0);
     end;
  end;
end; // of procedure InfoMsgToReport

// --------------------------------------------------------------------------
//   
procedure ErrorMsgToReport
                (RqDlgMsg : boolean; //    
                 RqDlgWrn : boolean; //   
                 RqTxt    : string); //  
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
     Lines.Add(RqTxt);
     if RqDlgMsg
     then begin
        if RqDlgWrn
        then MessageDlg( RqTxt, mtWarning, [mbOk], 0)
        else MessageDlg( RqTxt, mtError, [mbOk], 0);
     end
     else begin
        if vDebugOn
        then MessageDlg(cDebugPref + #09 + RqTxt, mtInformation, [mbOk], 0);
     end;
  end;
end; // of procedure ErrorMsgToReport

// --------------------------------------------------------------------------
//     TXT
procedure SaveReportAsFileTxt(RqFileName : string);
var FullFileName, ShortFileName : string;
    RunSaveFlag : boolean;
begin
  if Assigned(WorkReport) then with WorkReport do
  begin //  ,  
    RunSaveFlag := False;   //  
    FullFileName := Trim(RqFileName);
    if (FullFileName <> '')
    then begin
         if UpperCase(RightStr(FullFileName,4)) <> '.TXT'
         //      txt
         then FullFileName := FullFileName + '.txt';

         //    
         ShortFileName:= ExtractFileName(FullFileName);
         //    
         if FileExists(FullFileName)
         then begin
           if MessageDlg( ': ' + ShortFileName + #13#10
                        + ' ' + #13#10
                        + '   ?',
                        mtWarning, [mbYes, mbNo], 0) = mrYes
           then RunSaveFlag := True;
         end else RunSaveFlag := True;
         //  
         if RunSaveFlag
         then begin
            HeadMsgToReport('    ');
            try
                Lines.SaveToFile(FullFileName);
                InfoMsgToReport
                     (True,   //    
                      False,  //   
                     '      '
                      + ShortFileName);
            except
                ErrorMsgToReport
                     (True,   //    
                      False,  //   
                     '        '
                     + ShortFileName);
            end;
            TailMsgToReport('    ');
         end;
    end; // of if (FullFileName <> '')
  end; // of if Assigned
end; //of procedure SaveReportAsFileTxt

//===========================================================================
//    
//===========================================================================
//   
procedure InitRunProress(
               RqPrMsg : TStaticText;    //    
               RqPrBar : TProgressBar);  //    ProgressBar
begin
  if Assigned(RqPrMsg)
  then PrInd.PrMsg := RqPrMsg
  else PrInd.PrMsg := nil;
  if Assigned(RqPrBar)
  then PrInd.PrBar:= RqPrBar
  else PrInd.PrBar := nil;
end; // of procedure InitRunProress

//        (RqMsg)
procedure SetRunProress(RqMsg : string; RqMin, RqStep, RqMax : LongInt);
begin
  if Assigned(PrInd.PrBar) then with PrInd.PrBar
  do begin
     Min := RqMin;
     Max := RqMax;
     if (Max - Min)/RqStep > 2
     then Step := RqStep
     else Step := 1;
     Position := RqMin;
  end;
  //     
  if Assigned(PrInd.PrMsg) and vDebugOn
  then PrInd.PrMsg.Caption := RqMsg;
end; // of procedure SetRunProress

//     
procedure ProressOneStep();
begin
  if Assigned(PrInd.PrBar) then with PrInd.PrBar
  do begin
     Position := Position + Step;
  end; // of do Assigned
end; // of procedure ProressOneStep

//   
procedure ProressToMin();
begin
  if Assigned(PrInd.PrBar) then with PrInd.PrBar
  do begin
     //     
     if vDebugOn then Sleep(3000);
     Position := Min;
  end;
end; // of procedure ProressOneStep

// ---------------------------------------------------------------------------
//   .  RqMsg <> ''  On  Off
procedure SetPrMsgInd(RqMsg : string);
begin
   if RqMsg <> ''
   then begin
       if Assigned(PrInd.PrMsg)
       then begin
         PrInd.PrMsg.Color := clMoneyGreen;
         PrInd.PrMsg.Caption := RqMsg;
       end;
   end
   else begin
       if Assigned(PrInd.PrMsg)
       then begin
         PrInd.PrMsg.Color := clBtnFace;
         PrInd.PrMsg.Caption := '';
       end;
       //   
       ProressToMin();
   end;
end;


//===========================================================================
//===========================================================================

end.
