unit NewESetDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Dialogs;

type
  TNewESetForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    UpDownESetRow: TUpDown;
    EditESetRow: TEdit;
    Label1: TLabel;
    STextMatrixRow: TStaticText;
    STextMatrixCol: TStaticText;
    Label2: TLabel;
    Label3: TLabel;
    CheckBoxRqTestData: TCheckBox;
    Label4: TLabel;
    STextMaxMatrixRow: TStaticText;
    Label5: TLabel;
    CBoxMaxReCoeff: TComboBox;
    CBoxMaxImCoeff: TComboBox;
    CBoxMaxReRoots: TComboBox;
    CBoxMaxImRoots: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Bevel2: TBevel;
    procedure FormActivate(Sender: TObject);
    procedure EditESetRowChange(Sender: TObject);
    procedure UpDownESetRowChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure CheckBoxRqTestDataClick(Sender: TObject);
  private
    { Private declarations }
    procedure InitNewESetParm ();
    //     .    
    procedure SetRndParm ();
  public
    { Public declarations }
  end;

var
  NewESetForm: TNewESetForm;

implementation
{$R *.dfm}

uses MAINDATA, CommonService;

//  
var NewESetRow : integer;   //    
    NewESetCol : integer;   //    

//   UpDown
//     
//   
var FlagResetUpDown : boolean;

//     .    
procedure TNewESetForm.SetRndParm ();
begin
     //     
     case CBoxMaxReCoeff.ItemIndex of
     0 : ESetCTRL.TestCoeffReMax := 1000;
     1 : ESetCTRL.TestCoeffReMax := 100;
     2 : ESetCTRL.TestCoeffReMax := 10;
     3 : ESetCTRL.TestCoeffReMax := 1;
     4 : ESetCTRL.TestCoeffReMax := 0.1;
     5 : ESetCTRL.TestCoeffReMax := 0.01;
     6 : ESetCTRL.TestCoeffReMax := 0.001;
     end;
     //     
     case CBoxMaxImCoeff.ItemIndex of
     0 : ESetCTRL.TestCoeffImMax := 1000;
     1 : ESetCTRL.TestCoeffImMax := 100;
     2 : ESetCTRL.TestCoeffImMax := 10;
     3 : ESetCTRL.TestCoeffImMax := 1;
     4 : ESetCTRL.TestCoeffImMax := 0.1;
     5 : ESetCTRL.TestCoeffImMax := 0.01;
     6 : ESetCTRL.TestCoeffImMax := 0.001;
     end;
     //     
     case CBoxMaxReRoots.ItemIndex of
     0 : ESetCTRL.TestRootsReMax := 1000;
     1 : ESetCTRL.TestRootsReMax := 100;
     2 : ESetCTRL.TestRootsReMax := 10;
     3 : ESetCTRL.TestRootsReMax := 1;
     4 : ESetCTRL.TestRootsReMax := 0.1;
     5 : ESetCTRL.TestRootsReMax := 0.01;
     6 : ESetCTRL.TestRootsReMax := 0.001;
     end;
     //     
     case CBoxMaxImRoots.ItemIndex of
     0 : ESetCTRL.TestRootsImMax := 1000;
     1 : ESetCTRL.TestRootsImMax := 100;
     2 : ESetCTRL.TestRootsImMax := 10;
     3 : ESetCTRL.TestRootsImMax := 1;
     4 : ESetCTRL.TestRootsImMax := 0.1;
     5 : ESetCTRL.TestRootsImMax := 0.01;
     6 : ESetCTRL.TestRootsImMax := 0.001;
     end;
end;


//       
//      NewESetParm ( MAINDATA)
procedure TNewESetForm.InitNewESetParm ();
begin
  //  Integer   TEdit     .
  if LoadIntegerFromEdit (
                 EditESetRow,   // TEdit  
                 True,          //  ShowMessage
                 NewESetRow)
  then begin
     if (NewESetRow < MinNewESetRow)
     then begin
         MessageDlg('  '
                     + #13#10 +
                    '    !',
                     mtWarning, [mbOK], 0);
         EditESetRow.Text := '2';
     end
     else begin
         if (NewESetRow > MaxNewESetRow)
         then begin
              MessageDlg('  '
                         + #13#10 +
                         '    !',
                         mtWarning, [mbOK], 0);
              EditESetRow.Text := '100';
          end
          else begin
              //    , 
              //     NewESetParm ( MAINDATA)
              NewESetParm.RqNewESetRow := NewESetRow;
              NewESetParm.RqNewESetCol := NewESetRow + 1;
              STextMatrixRow.Caption := IntToStr(NewESetParm.RqNewESetRow);
              STextMatrixCol.Caption := IntToStr(NewESetParm.RqNewESetCol);
              //      
              NewESetParm.RqInitTestData := CheckBoxRqTestData.Checked;
              if CheckBoxRqTestData.Checked then SetRndParm();
              //  UpDownESetRow
              if UpDownESetRow.Position <> NewESetRow
              then begin
                 FlagResetUpDown := True;
                 UpDownESetRow.Position := NewESetRow;
              end;
          end;
     end;
  end;
end;

//     (   )
procedure TNewESetForm.FormActivate(Sender: TObject);
begin

  STextMaxMatrixRow.Caption := IntToStr(MaxNewESetRow);

  NewESetRow := DefNewESetRow;
  NewESetCol := DefNewESetCol;
  EditESetRow.Text := IntToStr(DefNewESetRow);

  UpDownESetRow.Min := MinNewESetRow;
  UpDownESetRow.Max := MaxNewESetRow;
  UpDownESetRow.Position := DefNewESetRow;
end;

//        
procedure TNewESetForm.EditESetRowChange(Sender: TObject);
begin
  InitNewESetParm ();
end;

procedure TNewESetForm.UpDownESetRowChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
   if not FlagResetUpDown
   then begin
      //     UpDown
      EditESetRow.Text := IntToStr(UpDownESetRow.Position)
   end
   else begin
      //     UpDown
      FlagResetUpDown := False;
   end;
end;

procedure TNewESetForm.CheckBoxRqTestDataClick(Sender: TObject);
begin
  InitNewESetParm ();
end;

end.
