unit MAINService;

interface
uses SysUtils, StdCtrls, Grids, Dialogs,
     MAINDATA, ComplexOp,
     Reports, CommonService,
     ESetArrayService, ESetGridService,
     SolveESet;

//---------------------------------------------------------------------------
//     ESet, ESetRoots,
// Row ,      Grid
function VerifyAllRowIndexes(
              RqRootGrid : TStringGrid; // Grid -   Row  Col
              RqESetCTRL : TESetCTRL    //    
                            ) : boolean;

//   Row  Col 
// (     Grid)   ESet.
//       ESet
function PrepareCellCTRL(RqESetGrid : TStringGrid;
                         RqESetSRC  : TESetArray;
                    var  RqCellCTRL : TESetCellCTRL) : boolean;

//        
function NewESet
           (
        var RqESetCTRL    : TESetCTRL;      //    
        var RqNewESetParm : TNewESetParm;   //   
            RqESetGrid    : TStringGrid;    // Grid  
            RqRootGrid    : TStringGrid;    // Grid   
            RqVPESet      : T2CmpToStrParm  //    
           ) : boolean;

//     
function ShowESet
          ( RqESetCTRL : TESetCTRL;        //    
            RqGrid     : TStringGrid;      //  Grid
            RqVPESet   : T2CmpToStrParm;   //    
            RqInd      : byte              //    
                     ) : boolean;

//    
function SolveCmpESet (
            RqESetCTRL  : TESetCTRL;       //    )
            RqVP        : T2CmpToStrParm;  //    
            RqGridESET  : TStringGrid;     //  Grid  
            RqGridRoot  : TStringGrid      //  Grid  
                      ) : boolean;
// ==========================================================================
// ==========================================================================
implementation
// ==========================================================================
// ==========================================================================

//     ESet, ESetRoots,
// Row ,      Grid
function VerifyAllRowIndexes(
              RqRootGrid : TStringGrid; // Grid -   Row  Col
              RqESetCTRL : TESetCTRL    //    
                            ) : boolean;
var GRow, ArrRow : LongInt; //  
begin
   // c 
   Result := False;
   with RqESetCTRL do
   begin
      if Assigned(ESetSRC) and Assigned(ESetRoots)
      then begin
         //    
         if (Length(ESetSRC)  >= MinNewESetRow) and
            (Length(ESetSRC)  <= MaxNewESetRow) and
            (Length(ESetRoots) = High(ESetSRC) + 1)
         then begin
            //   RqCellCTRL  
            GRow := RqRootGrid.Row;
            ArrRow := GRow - RqRootGrid.FixedRows;
            //    ArrRow   
            if (ArrRow >= Low(ESetSRC)) and (ArrRow <= High(ESetSRC))
            then Result := True; //  ,  
         end;
      end; // of if Assigned
   end;
end; // of function VerifyAllRowIndexes

// ---------------------------------------------------------------------------
//   Row  Col 
// (     Grid)   ESet.
//       ESet
function PrepareCellCTRL(RqESetGrid : TStringGrid;
                         RqESetSRC  : TESetArray;
                    var  RqCellCTRL : TESetCellCTRL) : boolean;
begin
   // c 
   Result := False;
   if Assigned(RqESetSRC)
   then begin
     //    
     if (Length(RqESetSRC) >= MinNewESetRow) and
        (Length(RqESetSRC) <= MaxNewESetRow)
     then begin
        with RqCellCTRL
        do begin
          //   RqCellCTRL  
          GRow := RqESetGrid.Row;
          GCol := RqESetGrid.Col;
          ArrRow := GRow - RqESetGrid.FixedRows;
          ArrCol := GCol - RqESetGrid.FixedCols;
          //    ArrRow   
          if (ArrRow >= Low(RqESetSRC)) and (ArrRow <= High(RqESetSRC))
          then begin
            //    ArrCol   
            if (ArrCol >= Low(RqESetSRC[ArrRow])) and
               (ArrCol <= High(RqESetSRC[ArrRow]))
            then Result := True; //  ,  
          end;
        end;
     end;
   end; // of if Assigned
end; // of function PrepareCellCTRL



//     
function ShowESet
          ( RqESetCTRL : TESetCTRL;       //    
            RqGrid     : TStringGrid;     //  Grid
            RqVPESet   : T2CmpToStrParm;  //    
            RqInd      : byte             //    
                     ) : boolean;
begin
  Result := False; //  
  case RqInd of
  cShowESetSRC : begin
                    ShowESetToGrid
                      (RqESetCTRL.ESetSRC,  //   
                       RqVPESet,            //   
                       RqGrid);             //  Grid
                    //    
                    IdShowGridESET := RqInd;
                    //     
                    RqShowGridESET := False;
                    Result := True;         //  
                 end;
  cShowESetWRK : begin
                    ShowESetToGrid
                      (RqESetCTRL.ESetWRK,  //  () 
                       RqVPESet,            //   
                       RqGrid);             //  Grid
                    //    
                    IdShowGridESET := RqInd;
                    //     
                    RqShowGridESET := False;
                    Result := True;         //  
                 end;
  end; // of function ShowESet
end;

// -------------------------------------------------------------------------
// 31.08.2010 (ver.1.00)
//        
function NewESet
           (
        var RqESetCTRL    : TESetCTRL;      //    
        var RqNewESetParm : TNewESetParm;   //   
            RqESetGrid    : TStringGrid;    // Grid  
            RqRootGrid    : TStringGrid;    // Grid   
            RqVPESet      : T2CmpToStrParm  //    
           ) : boolean;
begin
  Result := False;        //  
  //      
  //     
  if (RqNewESetParm.RqNewESetRow < MinNewESetRow) or
     (RqNewESetParm.RqNewESetRow > MaxNewESetRow)
  then begin
      //  .  .
      //      
      RqNewESetParm.RqNewESetRow := DefNewESetRow;
      RqNewESetParm.RqNewESetCol := DefNewESetRow + 1;
      RqNewESetParm.RqInitTestData := True;
      ErrorMsgToReport
                  (True, //    
                   True, //   
                   '.     .');
  end;
  //   
  InfoMsgToReport (False, //    
                   False, //   
                   '        = '
                   + IntToStr(RqNewESetParm.RqNewESetRow));
  // ------------------
  //   ESet  
  RqESetCTRL.ESetFFileName := '';
  RqESetCTRL.ESetSFileName := '';
  RqESetCTRL.ESetComment   := '';
  // ------------------
  //    
  //    ESetArrays
  if InitESetArrays
          (RqESetCTRL,                  //    
           RqNewESetParm.RqNewESetRow)  //     
  then begin
     //  
     //   Grids,     
     if InitAllESetGrids
          (RqESetCTRL,    //    
           RqESetGrid,    // Grid   
           RqRootGrid)    // Grid    
     then Result := True; //     
  end;
  // ------------------
  //  ( )  
  if Result and (RqNewESetParm.RqInitTestData)
  then begin
     //       
     Result := MakeRandomTestESet (RqESetCTRL);
  end
  else begin
     //      
     RqESetCTRL.TestCoeffReMax := 10;
     RqESetCTRL.TestCoeffImMax := 10;
     RqESetCTRL.TestRootsReMax := 10;
     RqESetCTRL.TestRootsImMax := 10;
  end;
  //    
  if Result
  then begin
       //    
       ShowESet(RqESetCTRL,      //    
                RqESetGrid,      //  Grid
                RqVPESet,        //    
                cShowESetSRC);   //    
       InfoMsgToReport(
                    False,  //    
                    False,  //   
                     '        = '
                    + IntToStr(RqESetCTRL.ESetRowCount));
   end
   else ErrorMsgToReport(
                    True,   //    
                    False,  //   
                      ' SYSERROR(NewESet):'
                    + '     ');
end; // of function NewESet

// ==========================================================================
//     
// ==========================================================================
// 02.09.2010 (ver 1.00)
//     
procedure ESetRootsToReport (RqESetRoots : TESetRoots); //  
//     
const VPDC : T2CmpToStrParm = (VPCrd : 0;      //  
                               VPMod : 0;      //  
                               VPPrc : 4;      // FIX Auto
                               VPPG  : False);
      VPPC : T2CmpToStrParm = (VPCrd : 1;      //  
                               VPMod : 0;      //  
                               VPPrc : 4;      // FIX Auto
                               VPPG  : False); //  
var RowInd : LongInt;     //  
    wStr   : string;      //  
begin
  if Assigned(RqESetRoots)
  then begin
    if Length(RqESetRoots) > 0
    then begin
      //       
      BlankStrToReport();  //  
      InfoMsgToReport
                (False,    //    
                 False,    //   
                 '     '
               + '     ');
      BlankStrToReport();  //  
      //    
      SetRunProress('ESetRootsToReport', 0, 1, High(RqESetRoots));
      for RowInd := Low(RqESetRoots) to High(RqESetRoots) do
      begin
         //     
         ProressOneStep();
         wStr := '  X' + IntToStr(RowInd)
                 + #09 + ComplexToStr (RqESetRoots[RowInd], VPDC)
                 + '      '
                 + #09 + ComplexToStr (RqESetRoots[RowInd], VPPC);
         InfoMsgToReport
                (False, //    
                 False, //   
                 wStr); //  
      end;
      //       
      BlankStrToReport();  //  
    end;
  end;
  //   
  ProressToMin();
end; // of procedure ESetRootsToReport

// --------------------------------------------------------------------------
//    
function SolveCmpESet (
            RqESetCTRL  : TESetCTRL;      //    )
            RqVP        : T2CmpToStrParm; //    
            RqGridESET  : TStringGrid;    //  Grid  
            RqGridRoot  : TStringGrid     //  Grid  
                      ) : boolean;
begin
  Result := False;      //  
  if Assigned(RqESetCTRL.ESetSRC) and
     Assigned(RqESetCTRL.ESetWRK) and
     Assigned(RqESetCTRL.ESetRoots)
  then begin
     with RqESetCTRL do
     begin
       //       
       CopyESetToWork (RqESetCTRL);
       //    
       SolveComplexESet(RqESetCTRL);
       //   
       case ESetSolveError of  // RqDlg  RqWarn  RqMsg
          //    
         -1: ErrorMsgToReport    (True,  True,   ESetSolveMsg);
          //   
          0: begin
                InfoMsgToReport     (True,  False,  ESetSolveMsg);
                Result := True;
             end;
          // C  c  
          1: begin
                ErrorMsgToReport    (True,  True,   ESetSolveMsg);
                Result := True;
             end;
          //    
          2: ErrorMsgToReport    (True,  True,   ESetSolveMsg);
          //   
          3: ErrorMsgToReport    (True,  False,  ESetSolveMsg);
       end;
       //      
       // (    )
       //  RqESetRoots   RqGrid
       ShowESetRootsToGrid
          (ESetRoots,             //   
           RqVP,                  //    
           RqGridRoot);           //  Grid
       //      RqGrid
       ShowESetNEqToGrid
          (RqESetCTRL,            //    
           RqVP,                  //    
           RqGridRoot);           //  Grid
       //     
       ESetRootsToReport (RqESetCTRL.ESetRoots);
     end; // of with RqESetCTRL
  end
  else begin
     RqESetCTRL.ESetSolveOK    := False;  //  -  
     RqESetCTRL.ESetSolveError := -1;      //  
     RqESetCTRL.ESetSolveMsg   := '   '
                                 + #13#10 +
                                 '    ';
     //     
     ErrorMsgToReport
         (True,   //    
          True,   //   
          RqESetCTRL.ESetSolveMsg);
  end;
end; // of procedure SolveCmpESet

// ==========================================================================
// ==========================================================================


end.
