unit MAIN;

interface

//   
uses
//  
  Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  ImgList, ToolWin, Grids, SysUtils,
//    
  MAINDATA,                                      //    
  MAINService,                                   //  
  ComplexOp, Reports, CommonService,             //  
  ShowGraphXY01,
  ESetArrayService, ESetGridService,             //  
  NewESetDialog, ShowCTRLDialog, EditESetDialod, //  
  SolveESet,                                     //  
  About;                                         // 

type
  TSDIAppForm = class(TForm)
    // -----------------------------
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ToolBar1: TToolBar;
    ToolButtNewESet: TToolButton;
    ToolButtLoadSet: TToolButton;
    ToolButtSavESet: TToolButton;
    StatusBar: TStatusBar;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    MMNewESet: TMenuItem;
    MMOpenFile: TMenuItem;
    MMFileSaveFile: TMenuItem;
    MMSaveAs: TMenuItem;
    N1: TMenuItem;
    MMExit: TMenuItem;
    MMHelp1: TMenuItem;
    MMHelpAbout: TMenuItem;
    PageControl1: TPageControl;
    TSheetESet: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    GridESET: TStringGrid;
    PopupMenuGridESET: TPopupMenu;
    PMESetCellEdit: TMenuItem;
    PMESetCellClear: TMenuItem;
    PMESetCellToCalc: TMenuItem;
    PMESetCellFromCalc: TMenuItem;
    TSheetESetRoots: TTabSheet;
    TSheetReport: TTabSheet;
    PanGridRoot: TPanel;
    PanVectors: TPanel;
    PanVectorsControl: TPanel;
    GridROOT: TStringGrid;
    Panel6: TPanel;
    PanReportControls: TPanel;
    MemoReport: TMemo;
    ToolButtSeparator1: TToolButton;
    ToolButtRunSolve: TToolButton;
    MMView1: TMenuItem;
    MMReportClear: TMenuItem;
    MMReportSaveAs: TMenuItem;
    MMRunSolve1: TMenuItem;
    STextShowRM: TStaticText;
    STextShowIP: TStaticText;
    LabelReMd: TLabel;
    LabelImPh: TLabel;
    STextShowMSel: TStaticText;
    ToolButtSeparator2: TToolButton;
    SButtToBegCol: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SButtToEndCol: TSpeedButton;
    SButtToEndRow: TSpeedButton;
    SButtToBegRow: TSpeedButton;
    ToolButton1: TToolButton;
    PanIndicators: TPanel;
    PrBarRun: TProgressBar;
    STxtPrMsg: TStaticText;
    ChBoxDebugOn: TCheckBox;
    SButtNewReport: TSpeedButton;
    SButtSaveReport: TSpeedButton;
    PopupMenuGridRoot: TPopupMenu;
    PM2SelectX: TMenuItem;
    PM2DeSelectX: TMenuItem;
    PM2SelectB: TMenuItem;
    PM2DeSelectB: TMenuItem;
    PM2CopyRootToCalc: TMenuItem;
    ToolBarVectors: TToolBar;
    TBVectorsSave: TToolButton;
    ToolButton2: TToolButton;
    TBVectorsClear: TToolButton;
    ToolButton3: TToolButton;
    TBVectorsShow: TToolButton;
    CBoxVectSelect: TComboBox;
    ToolButton4: TToolButton;
    CBoxYScale: TComboBox;
    Label1: TLabel;
    STextShowVPCrd: TStaticText;
    STextShowVPMod: TStaticText;
    STextShowVPPrc: TStaticText;
    STextShowVPPG: TStaticText;
    SButtShowParm: TSpeedButton;

    // -----------------------------
    procedure FileExit1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure PMESetCellEditClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GridESETClick(Sender: TObject);
    procedure MMRunSolve1Click(Sender: TObject);
    procedure ToolButtRunSolveClick(Sender: TObject);
    procedure ToolButtNewESetClick(Sender: TObject);
    procedure MMNewESetClick(Sender: TObject);
    procedure MMSaveAsClick(Sender: TObject);
    procedure MMFileSaveFileClick(Sender: TObject);
    procedure MMOpenFileClick(Sender: TObject);
    procedure ToolButtLoadSetClick(Sender: TObject);
    procedure SButtToBegColClick(Sender: TObject);
    procedure SButtToEndColClick(Sender: TObject);
    procedure SButtToBegRowClick(Sender: TObject);
    procedure SButtToEndRowClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure ChBoxDebugOnClick(Sender: TObject);
    procedure ToolButtSavESetClick(Sender: TObject);
    procedure SButtNewReportClick(Sender: TObject);
    procedure SButtSaveReportClick(Sender: TObject);
    procedure MMReportClearClick(Sender: TObject);
    procedure MMReportSaveAsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PMESetCellClearClick(Sender: TObject);
    procedure PM2SelectXClick(Sender: TObject);
    procedure PM2DeSelectXClick(Sender: TObject);
    procedure PM2SelectBClick(Sender: TObject);
    procedure PM2DeSelectBClick(Sender: TObject);
    procedure TBVectorsClearClick(Sender: TObject);
    procedure TBVectorsSaveClick(Sender: TObject);
    procedure TBVectorsShowClick(Sender: TObject);
    procedure SButtShowParmClick(Sender: TObject);
  private
    { Private declarations }
    // ----------------------------
    //     
    //   
    procedure AppFormRepaint();
    //   
    procedure ShowFormCaption();
    //   IdShowGridESET
    procedure ShowESetMSel();
    //     ESet
    procedure ShowESetViewParm (RqViewParm : T2CmpToStrParm);
    //    ESet    
    procedure GoToTabSheetESet();
    //    Roots    
    procedure GoToTabSheetRoots();
    //    
    procedure ResetShowParm();

    // -----------------------------
    //  
    //     
    procedure ExNewESet();
    //      
    procedure ExLoadESetSRC();
    //  " "  
    procedure ExSaveAsESetSRC();
    //    
    procedure ExReSaveESetSRC();
    //    
    procedure ExSolveESet();
    // -----------------------------
    //  
    //    ...
    procedure ExSaveAsReport();
    //   jpeg   
    procedure ExSaveRootGraph();

  public
    { Public declarations }
  end;

var
  SDIAppForm: TSDIAppForm;

implementation
{$R *.dfm}

// ===========================================================================
//   
procedure TSDIAppForm.FormCreate(Sender: TObject);
begin
  //    
  //    ESetCTRL
  FillChar (ESetCTRL, SizeOf(ESetCTRL),#0);
  //   (   UNIT ShowGraphXY01)
  InitShowGraph01(PanVectors);
  //    
  InitReport(MemoReport);
  //   
  InitRunProress(STxtPrMsg, PrBarRun);
  //   
  ShowFormCaption();
end;
//  
procedure TSDIAppForm.FormDestroy(Sender: TObject);
begin
  //    UNIT ShowGraphXY01
  CloseShowGraph01();
end;

// ===========================================================================
//    
procedure TSDIAppForm.ChBoxDebugOnClick(Sender: TObject);
begin
  //  /   
  // (   )
  DebugOnOff (ChBoxDebugOn.Checked);
end;

// ===========================================================================
//      
// ===========================================================================
// ---------------------------------------------------------------------------
//   
procedure TSDIAppForm.AppFormRepaint();
begin
  Self.Repaint;
end;

// ---------------------------------------------------------------------------
//   
procedure TSDIAppForm.ShowFormCaption();
begin
   if  (ESetCTRL.ESetSFileName <> '')
   then Self.Caption := ProgramFName + '  : '
                    + ESetCTRL.ESetSFileName
   else Self.Caption := ProgramFName + '  : ()';
end;

// ---------------------------------------------------------------------------
//   IdShowGridESET
procedure TSDIAppForm.ShowESetMSel();
begin
  case IdShowGridESET of
    cShowESetSRC : STextShowMSel.Caption := cShowMSelArr[0];
    cShowESetWRK : STextShowMSel.Caption := cShowMSelArr[1];
    else STextShowMSel.Caption := '';
  end;
end;

// ---------------------------------------------------------------------------
//     ESet
procedure TSDIAppForm.ShowESetViewParm (RqViewParm : T2CmpToStrParm);
begin
  STextShowVPCrd.Caption := cShowVPCrdArr[RqViewParm.VPCrd];
  STextShowVPMod.Caption := cShowVPModArr[RqViewParm.VPMod];
  STextShowVPPrc.Caption := cShowVPPrcArr[RqViewParm.VPPrc];
  if RqViewParm.VPCrd = Low(cShowVPCrdArr)
  then begin
     //  
     STextShowVPPG.Caption := '';
  end
  else begin
     //  
     if RqViewParm.VPPG
     //     
     then STextShowVPPG.Caption := cShowVPPGArr[High(cShowVPPGArr)]
     //     
     else STextShowVPPG.Caption := cShowVPPGArr[Low(cShowVPPGArr)];
  end;
end;

// ---------------------------------------------------------------------------
//    ESet    
procedure TSDIAppForm.GoToTabSheetESet();
begin
  //   IdShowGridESET
  ShowESetMSel();
  //    ESet
  ShowESetViewParm (VPESet);
  //  TabSheet ' '
  PageControl1.TabIndex := 0;
end;

// ---------------------------------------------------------------------------
//    Roots    
procedure TSDIAppForm.GoToTabSheetRoots();
begin
  //  TabSheet '  '
  PageControl1.TabIndex := 1;
end;

// ---------------------------------------------------------------------------
//    
procedure TSDIAppForm.ResetShowParm();
var SaveVPESet : T2CmpToStrParm;
begin
  //   
  Move (VPESet, SaveVPESet, SizeOf(VPESet));
  //    
  if (FormShowCTRL.ShowModal = mrOK)
  then begin
    //   
    AppFormRepaint();
    if RqShowGridESET
    then begin
       //    
       SetPrMsgInd('  ');
       //     
       ShowESet (ESetCTRL,         //    
                 GridESET,         //  Grid
                 VPESet,           //    
                 IdShowGridESET);  //    
       //    
       SetPrMsgInd('');
   end
   else begin
      //   
      RqShowGridESET := False;
      //   
      Move (SaveVPESet, VPESet, SizeOf(VPESet));
   end;
   //   IdShowGridESET
  ShowESetMSel();
  //    ESet
  ShowESetViewParm (VPESet);
 end;
end; // of procedure ResetShowParm

// :
//    SButtShowParm   Panel1
procedure TSDIAppForm.SButtShowParmClick(Sender: TObject);
begin
  ResetShowParm;
end;

// ===========================================================================
//     
// ===========================================================================
// ===========================================================================
// 01.09.2010 (ver 1.00)
//     
procedure TSDIAppForm.ExNewESet();
begin
  //       
  if (NewESetForm.ShowModal = mrOK)
  then begin
     //    
     SetPrMsgInd('  ');
     //   
     AppFormRepaint();
     //     
     HeadMsgToReport('      ');
     NewESet(ESetCTRL,      //    
             NewESetParm,   //   
             GridESET,      // Grid  
             GridROOT,      // Grid   
             VPESet);       //    
    //    TSheetESet    
    GoToTabSheetESet();
    //   
    ShowFormCaption();
    //    
     SetPrMsgInd('');
    //     
    TailMsgToReport('      ');
 end;
end; // of procedure TSDIAppForm.ExNewESet

//  :     
//   MainMenu1
procedure TSDIAppForm.MMNewESetClick(Sender: TObject);
begin
  ExNewESet();
end;
//     ToolBar1
procedure TSDIAppForm.ToolButtNewESetClick(Sender: TObject);
begin
  ExNewESet();
end;

// ===========================================================================
//       
// ===========================================================================
// 01.09.2010 (ver 1.00)
//      
procedure TSDIAppForm.ExLoadESetSRC();
begin
    HeadMsgToReport('       ');
    OpenDialog.Title := ' ESet  ';
    OpenDialog.Filter:='ESet matrix files (*.esm)|*.esm';
    if OpenDialog.Execute
    then begin
      //    
      SetPrMsgInd('   ');
      //   
      AppFormRepaint();
      //    ESetSRC   *.esm
      if not LoadESetSRC(
                OpenDialog.FileName, //    
                ESetCTRL,            //    
                VPESet,              //    
                GridESET,            // Grid  
                GridROOT)            // Grid  
      then ErrorMsgToReport
                (True,  //    
                 False, //   
                '    ');
      //    TSheetESet    
      GoToTabSheetESet();
      //   
      ShowFormCaption();
      //    
      SetPrMsgInd('');
    end;
    TailMsgToReport('     ');
end; // of procedure ExLoadESetSRC

//  :      
//    MainMenu1
procedure TSDIAppForm.MMOpenFileClick(Sender: TObject);
begin
   ExLoadESetSRC();
end;
//     ToolBar1
procedure TSDIAppForm.ToolButtLoadSetClick(Sender: TObject);
begin
   ExLoadESetSRC();
end;

// ===========================================================================
//      
// ===========================================================================
// 05.09.2010 (ver 1.00)
//    
procedure TSDIAppForm.ExReSaveESetSRC();
begin
   //    
   SetPrMsgInd('   ');
   ReSaveESetSRC (ESetCTRL);
   //    
   SetPrMsgInd('');
end;

// 05.09.2010 (ver 1.00)
//  " "  
procedure TSDIAppForm.ExSaveAsESetSRC();
begin
    SaveDialog.Title := ' ESet  ...';
    SaveDialog.Filter:='ESet files (*.esm)|*.esm';
    if SaveDialog.Execute
    then begin
        //    
        SetPrMsgInd('   ');
        //   
        AppFormRepaint();
        //  " "  ESetSRC   *.esm
        SaveAsESetSRC
                 (SaveDialog.FileName,  //   
                  ESetCTRL);            //    ESet
        //   
        ShowFormCaption();
        //    
        SetPrMsgInd('');
    end;
end; // of procedure TSDIAppForm.ExSaveAsESetSRC

//  : //   ESetSRC  
//    MainMenu1
procedure TSDIAppForm.MMFileSaveFileClick(Sender: TObject);
begin
  ExReSaveESetSRC();
end;
//     ToolBar1
procedure TSDIAppForm.ToolButtSavESetClick(Sender: TObject);
begin
  ExReSaveESetSRC();
end;

//  : //  " " ESetSRC  
//    MainMenu1
procedure TSDIAppForm.MMSaveAsClick(Sender: TObject);
begin
   ExSaveAsESetSRC();
end;

// ===========================================================================
//     
// ===========================================================================
// 02.09.2010 (ver 1.00)
//    
procedure TSDIAppForm.ExSolveESet();
begin
  //    
  SetPrMsgInd('  ');
  //   
  ClearRootGraph();
  HeadMsgToReport('    ');
  //    
  if SolveCmpESet(ESetCTRL,         //    
                  VPESet,           //    
                  GridESET,         //  Grid  
                  GridROOT)         // Grid   
  then begin
     //    Roots    
     GoToTabSheetRoots();
  end;
  TailMsgToReport('     ');
  //    
  SetPrMsgInd('');
end; // of procedure ExSolveESet

//  :    
//   MainMenu1
procedure TSDIAppForm.MMRunSolve1Click(Sender: TObject);
begin
  ExSolveESet();
end;
//     ToolBar1
procedure TSDIAppForm.ToolButtRunSolveClick(Sender: TObject);
begin
  ExSolveESet();
end;

// ===========================================================================
//       
// ===========================================================================
// ---------------------------------------------------------------------------
//     
//    GridESET
procedure TSDIAppForm.GridESETClick(Sender: TObject);
var ARow, ACol : LongInt;   //   
begin
  with (Sender as TStringGrid)
  do begin
    ARow := Row - FixedRows;
    ACol := Col - FixedCols;
  end;
  //    RqESet    RqGrid
  ShowCellESet
        (ESetCTRL.ESetSRC,  //   
         ARow,              //    
         ACol,              //    
         STextShowRM,       //    Re  Module
         STextShowIP);      //    Im  Phase
end;

// ---------------------------------------------------------------------------
//     Grid
//    PopupMenuGridESet
procedure TSDIAppForm.PMESetCellEditClick(Sender: TObject);
begin
  if IdShowGridESET = cShowESetSRC
  then begin
     with ESetCellCTRL
     do begin
        //     
        //     
        RqGrid := GridESET;          //  Grid
        RqESet := ESetCTRL.ESetSRC;  //   ;
        //    ESetSRC
        if (ESetEditForm.ShowModal = mrOK)
        then begin
           if ChFlag
              and (ArrRow >= 0) and (ArrCol >= 0)
              and (GRow >= RqGrid.FixedRows) and (GCol >= RqGrid.FixedCols)
           then begin
              //     
              ComplexToComplex(NewX, ESetCTRL.ESetSRC[ArrRow,ArrCol]);
              //      Grid
              GridESET.Cells[GCol,GRow]:= ComplexToStr
                                           (ESetCTRL.ESetSRC[ArrRow,ArrCol],
                                            VPESet);
           end;
        end;
     end; // of with ESetCellCTRL
  end;
end;

// ---------------------------------------------------------------------------
procedure TSDIAppForm.PMESetCellClearClick(Sender: TObject);
begin
  if IdShowGridESET = cShowESetSRC
  then begin
     with ESetCellCTRL
     do begin
        //     Grid   ESetCellCTRL
        if PrepareCellCTRL(GridESET, ESetCTRL.ESetSRC, ESetCellCTRL)
        then begin
           //       ESetCellCTRL
           //  
           ChFlag := False;
           //  
           if mrYes = MessageDlg('    = '
                                + IntToStr(ArrRow)
                                + ',  = '
                                + IntToStr(ArrCol)
                                + ' ?',
                                mtConfirmation, [mbYes, mbNo], 0)
           then ChFlag := True;
           if ChFlag
               and (ArrRow >= 0) and (ArrCol >= 0)
               and (GRow >= GridESET.FixedRows) and (GCol >= GridESET.FixedCols)
           then begin
               //   
               ZeroToComplex (ESetCTRL.ESetSRC[ArrRow,ArrCol]);
               //      Grid
               GridESET.Cells[GCol,GRow]:= ComplexToStr
                                           (ESetCTRL.ESetSRC[ArrRow,ArrCol],
                                            VPESet);
           end;
        end;  // of if VerifyGridIndexes
     end;  // of with ESetCellCTRL
  end;  // of if IdShowGridESET
end;  

// ===========================================================================
//   Grid
// ===========================================================================
//   GridESET
procedure FastGridScroll (RqGrid : TStringGrid; RqRow, RqCol : LongInt);
begin
  with RqGrid do
  begin
      //      Grid
      if (RqRow <= (RowCount - FixedRows)) and
         (RqCol <= (ColCount - FixedCols)) and
         (RqRow >= FixedRows) and
         (RqCol >= FixedCols)
      then begin
         //   Grid,  
         // Grid    onClick
         Row := RqRow;
         Col := RqCol;
      end;
  end;
end;

//   GridESET   
procedure TSDIAppForm.SButtToBegColClick(Sender: TObject);
begin
  with GridESET do FastGridScroll(GridESET, Row, FixedCols);
end;
//   GridESET   
procedure TSDIAppForm.SButtToEndColClick(Sender: TObject);
begin
  with GridESET do FastGridScroll(GridESET, Row, ColCount-FixedCols);
end;
//   GridESET   
procedure TSDIAppForm.SButtToBegRowClick(Sender: TObject);
begin
  with GridESET do FastGridScroll(GridESET, FixedRows, Col);
end;
//   GridESET   
procedure TSDIAppForm.SButtToEndRowClick(Sender: TObject);
begin
  with GridESET do FastGridScroll(GridESET, RowCount-FixedRows, Col);
end;
//   GridESET    
procedure TSDIAppForm.SpeedButton1Click(Sender: TObject);
begin
  with GridESET do FastGridScroll(GridESET,
                                  ESetCellCTRL.GRow,
                                  ESetCellCTRL.GCol);
end;

// ===========================================================================
//  
// ===========================================================================
//    ...
procedure TSDIAppForm.ExSaveAsReport();
begin
    SaveDialog.Title := '   ...';
    SaveDialog.Filter:='Report text files (*.txt)|*.txt';
    if SaveDialog.Execute
    then begin
       //    
       SetPrMsgInd('  ');
       //   
       AppFormRepaint();
       SaveReportAsFileTxt(SaveDialog.FileName);
       //    
       SetPrMsgInd('');
    end;
end; // of procedure TSDIAppForm.ExSaveAsReport

//  : //    
//     ( )
procedure TSDIAppForm.SButtNewReportClick(Sender: TObject);
begin
  InitReport(MemoReport);
end;
//    MainMenu1
procedure TSDIAppForm.MMReportClearClick(Sender: TObject);
begin
  InitReport(MemoReport);
end;

//  :    ...
//     ( )
procedure TSDIAppForm.MMReportSaveAsClick(Sender: TObject);
begin
ExSaveAsReport();
end;
//    MainMenu1
procedure TSDIAppForm.SButtSaveReportClick(Sender: TObject);
begin
ExSaveAsReport();
end;

// ===========================================================================
//     
// ===========================================================================
//     ...
procedure TSDIAppForm.ExSaveRootGraph();
begin
    SaveDialog.Title := '    ...';
    SaveDialog.Filter:='JPEG files (*.jpg)|*.jpg';
    if SaveDialog.Execute
    then begin
       //    
       SetPrMsgInd('  ');
       //   
       AppFormRepaint();
       //  
       SaveRootGraph(SaveDialog.FileName);
       //    
       SetPrMsgInd('');
    end;
end; // of procedure TSDIAppForm.ExSaveRootGraph

//  :
//    ToolBarVectors
procedure TSDIAppForm.TBVectorsClearClick(Sender: TObject);
begin
  //   
  ClearRootGraph();
end;
//    ToolBarVectors
procedure TSDIAppForm.TBVectorsSaveClick(Sender: TObject);
begin
  //   jpeg   
  ExSaveRootGraph();
end;
//    ToolBarVectors
procedure TSDIAppForm.TBVectorsShowClick(Sender: TObject);
var YScale : extended;
begin
  YScale := 1;
  case CBoxVectSelect.ItemIndex of
  //      
  0 : ShowGraphAllRoot(ESetCTRL);
  //         
  1 : begin
        //      
        case CBoxYScale.ItemIndex of
          0 : YScale := 100;
          1 : YScale := 10;
          2 : YScale := 1;
          3 : YScale := 0.1;
          4 : YScale := 0.01;
        end;
        //      
        ShowGraphSelectData(GridROOT, ESetCTRL, YScale);
      end;
  end;
end;
// --------------------------------------------------------------------------
//     
// : (    ToolBarVectors)
//    
procedure TSDIAppForm.PM2SelectXClick(Sender: TObject);
begin
  if VerifyAllRowIndexes(GridROOT, ESetCTRL)
  then begin
    with GridROOT do Cells[1,Row] := ' +++';
  end;
end;
//    
procedure TSDIAppForm.PM2DeSelectXClick(Sender: TObject);
begin
  if VerifyAllRowIndexes(GridROOT, ESetCTRL)
  then begin
    with GridROOT do Cells[1,Row] := '';
  end;
end;
//     
procedure TSDIAppForm.PM2SelectBClick(Sender: TObject);
begin
  if VerifyAllRowIndexes(GridROOT, ESetCTRL)
  then begin
    with GridROOT do Cells[3,Row] := ' +++';
  end;
end;
//     
procedure TSDIAppForm.PM2DeSelectBClick(Sender: TObject);
begin
  if VerifyAllRowIndexes(GridROOT, ESetCTRL)
  then begin
    with GridROOT do Cells[3,Row] := '';
  end;
end;

// ===========================================================================
//  
// ===========================================================================
procedure TSDIAppForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

// ===========================================================================
//   
// ===========================================================================
procedure TSDIAppForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

// ===========================================================================
// ===========================================================================
// ===========================================================================
// ===========================================================================




end.
