unit EditESetDialod;

interface

uses
//  
  Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs,
//  
  MAINDATA, ComplexOp, CommonService;

type
  TESetEditForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    EditNewXrm: TEdit;
    EditNewXip: TEdit;
    STextOldXrm: TStaticText;
    STextOldXip: TStaticText;
    CBoxCVPCrd: TComboBox;
    STextArrRow: TStaticText;
    STextArrCol: TStaticText;
    STextOldXrmIdn: TStaticText;
    STextOldXipIdn: TStaticText;
    STextNewXrmIdn: TStaticText;
    STextNewXipIdn: TStaticText;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CBoxCVPPG: TComboBox;
    Label6: TLabel;
    STextCoeffName: TStaticText;
    Label7: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure CBoxCVPCrdClick(Sender: TObject);
    procedure EditNewXrmChange(Sender: TObject);
    procedure EditNewXipChange(Sender: TObject);
    procedure CBoxCVPPGClick(Sender: TObject);
  private
    { Private declarations }
    //      
    //  (Row, Col),   Grid
    function  VerifyInexs () : boolean;
    //  OldX  NewX   
    procedure ShowDecartRqCell();
    //  OldX  NewX   
    procedure ShowPolarRqCell();

    procedure ShowRqCell  ();
    procedure ReadESetCell();
  public
    { Public declarations }
  end;

var
  ESetEditForm: TESetEditForm;

implementation
{$R *.dfm}

// --------------------------------------------------------------------------
//     
const VPRe : T2CmpToStrParm = (VPCrd  : 0;      // 
                               VPMod  : 1;      //  Re
                               VPPrc  : 4;      // FIX Auto
                               VPPG   : False);
      VPIm : T2CmpToStrParm = (VPCrd  : 0;      // 
                               VPMod  : 3;      //  Im ( J)
                               VPPrc  : 4;      // FIX Auto
                               VPPG   : False);
      VPMd : T2CmpToStrParm = (VPCrd  : 1;      // 
                               VPMod  : 1;      //  Md
                               VPPrc  : 4;      // FIX Auto
                               VPPG   : False);
      VPPh : T2CmpToStrParm = (VPCrd  : 1;      // 
                               VPMod  : 3;      //  Ph ( J)
                               VPPrc  : 4;      // FIX Auto
                               VPPG   : False); //  
      VPPhG : T2CmpToStrParm = (VPCrd  : 1;     // 
                               VPMod  : 3;      //  Ph ( J)
                               VPPrc  : 4;      // FIX Auto
                               VPPG   : True);  //  
// --------------------------------------------------------------------------                           VPrecision   : 4); // FIX Auto
//     
var ptESetCellCTRL     : ^TESetCellCTRL;

//   
var EWork : Extended;

//  -     TEdit.
//     onChange   
var FlagShow : boolean;

// -------------------------------------------------------------------------
//   
procedure TESetEditForm.FormActivate(Sender: TObject);
begin
  //      
  ptESetCellCTRL := Addr(ESetCellCTRL);
  //    RqESet   
  ReadESetCell();
end;

//   
procedure NegativeReport();
begin
  with ptESetCellCTRL^
  do begin
    ChFlag := False;       //  -  
    GRow := -1;            // (-1)   Row -  Grid
    GCol := -1;            // (-1)   Col -  Grid
    ArrRow := -1;          // (-1)      ESet
    ArrCol := -1;          // (-1)      ESet
    ZeroToComplex (OldX);  //    
    ZeroToComplex (NewX);  //    
  end; // of with ptESetCellCTRL^
end; // of procedure

// -------------------------------------------------------------------------
//      
//  (Row, Col),   Grid
function  TESetEditForm.VerifyInexs () : boolean;
begin
  // c 
  Result := False;
  NegativeReport();
  //  
  with ptESetCellCTRL^
  do begin
    //    
    if Assigned(RqGrid) and Assigned(RqESet)
    then begin
       //    
       if (Length(RqESet) >= MinNewESetRow) and
          (Length(RqESet) <= MaxNewESetRow)
       then begin
         //   RqESetCellCTRL  
         GRow := RqGrid.Row;
         GCol := RqGrid.Col;
         ArrRow := GRow - RqGrid.FixedRows;
         ArrCol := GCol - RqGrid.FixedCols;
         //    ArrRow   
         if (ArrRow >= Low(RqESet)) and (ArrRow <= High(RqESet))
         then begin
            //    ArrCol   
            if (ArrCol >= Low(RqESet[ArrRow])) and
               (ArrCol <= High(RqESet[ArrRow]))
            then begin
               if ArrCol = High(RqESet[ArrRow])
               then STextCoeffName.Caption := ' b '
               else STextCoeffName.Caption := ' a ';
               Result := True; //  ,  
            end;
         end;
       end;
       if not Result
       then begin
            //   
            NegativeReport();
            MessageDlg('SYSTYM PROBLEMS:'
                       + #13#10 +
                       '   '
                       + #13#10 +
                       '  !',
                       mtWarning, [mbOK], 0);
       end;
    end
    else begin
       if not Assigned(ESetCellCTRL.RqGrid)
       then MessageDlg('SYSTYM PROBLEMS:'
                      + #13#10 +
                      ' '
                      + #13#10 +
                      ' ESetCellCTRL',
                       mtWarning, [mbOK], 0)
       else MessageDlg('  '
                      + #13#10 +
                      '  !'
                      + #13#10 +
                      ' :  \  ',
                      mtWarning, [mbOK], 0);
    end; // of if Assigned
  end; // of with ptESetCellCTRL^
end; // of procedure

// --------------------------------------------------------------------------
//  OldX  NewX   
procedure TESetEditForm.ShowDecartRqCell();
begin
   //   onChange   TEdit
   FlagShow := True;
   with ptESetCellCTRL^
   do begin
      //  OldX
      STextOldXrm.Caption := ComplexToStr(OldX, VPRe);
      STextOldXip.Caption := ComplexToStr(OldX, VPIm);
      //  NewX
      EditNewXrm.Text := ComplexToStr(OldX, VPRe);
      EditNewXip.Text := ComplexToStr(OldX, VPIm);
      //   
      STextOldXrmIdn.Caption := ' Real';
      STextOldXipIdn.Caption := ' Img';
      //    Edit
      STextNewXrmIdn.Caption := STextOldXrmIdn.Caption;
      STextNewXipIdn.Caption := STextOldXipIdn.Caption;
   end; // of with ptESetCellCTRL^
   //   onChange   TEdit
   FlagShow := False;
end; // of procedure TESetEditForm.ShowPolarRqCell

// --------------------------------------------------------------------------
//  OldX  NewX   
procedure TESetEditForm.ShowPolarRqCell();
begin
   //   onChange   TEdit
   FlagShow := True;
   with ptESetCellCTRL^
   do begin
      //  
      STextOldXrm.Caption := ComplexToStr(OldX, VPMd);
      EditNewXrm.Text     := ComplexToStr(NewX, VPMd);
      STextOldXrmIdn.Caption := ' Module';
      //  
      if CBoxCVPPG.ItemIndex > 0
      then begin
          //    
          STextOldXip.Caption := ComplexToStr(OldX, VPPhG);
          EditNewXip.Text     := ComplexToStr(NewX, VPPhG);
          STextOldXipIdn.Caption := ' Phase(grad)';
      end
      else begin
         //    
         STextOldXip.Caption := ComplexToStr(OldX, VPPh);
         EditNewXip.Text     := ComplexToStr(NewX, VPPh);
         STextOldXipIdn.Caption := ' Phase(rad)';
      end;
      //    Edit
      STextNewXrmIdn.Caption := STextOldXrmIdn.Caption;
      STextNewXipIdn.Caption := STextOldXipIdn.Caption;
   end; // of with ptESetCellCTRL^
   //   onChange   TEdit
   FlagShow := False;
end; // of procedure TESetEditForm.ShowPolarRqCell

// --------------------------------------------------------------------------
//    ESetCell   
procedure TESetEditForm.ShowRqCell();
begin
   if CBoxCVPCrd.ItemIndex > 0
   then //    
        ShowPolarRqCell()
   else //    
        ShowDecartRqCell();
end; // of procedure TESetEditForm.ShowRqCell();

// -------------------------------------------------------------------------
//      ( / )
procedure TESetEditForm.CBoxCVPCrdClick(Sender: TObject);
begin
  if CBoxCVPCrd.ItemIndex > 0
  then begin
     //    
     CBoxCVPPG.Enabled := True;
     //     
     CBoxCVPPG.ItemIndex := 0;
  end
  else begin
     //    
     CBoxCVPPG.Enabled := False;
     //    
     CBoxCVPPG.ItemIndex := -1;
  end;
  ShowRqCell(); //   
end;

//      ( / )
procedure TESetEditForm.CBoxCVPPGClick(Sender: TObject);
begin
  ShowRqCell(); //   
end;

// -------------------------------------------------------------------------
//    RqESet   
procedure TESetEditForm.ReadESetCell();
begin
  if VerifyInexs()
  then begin
    //   ,  OldX  NewX
     with ptESetCellCTRL^
     do begin
         //     
         STextArrRow.Caption := IntToStr(ArrRow);
         STextArrCol.Caption := IntToStr(ArrCol);
         //  RqESet[ArrRow,ArrCol]  OldX
         ComplexToComplex(RqESet[ArrRow,ArrCol], OldX);
         //  OldX  NewX
         ComplexToComplex(OldX, NewX);
         //    
         CBoxCVPCrd.ItemIndex := 0;
         //    
         CBoxCVPPG.Enabled := False;
         //    
         CBoxCVPPG.ItemIndex := -1;
         //   
         ShowRqCell();
     end; // of with ptESetCellCTRL^
  end;
end; // of procedure

// -------------------------------------------------------------------------
//   Real  Module
procedure TESetEditForm.EditNewXrmChange(Sender: TObject);
begin
  //   onChange   TEdit  
  if not FlagShow
  then begin
     //  Extended   TEdit     .
     if LoadFloatFromEdit ( EditNewXrm,  // TEdit  
                            True,        //  ShowMessage
                            EWork)
     then begin
        with ptESetCellCTRL^
        do begin
           if CBoxCVPCrd.ItemIndex > 0
           then begin
              //      
              NewX.m := EWork;
              PolarToDecart(NewX);
           end
           else begin
              //      
              NewX.r := EWork;
              DecartToPolar(NewX);
           end;
           ChFlag := True; //   -   
        end; // of with ptESetCellCTRL^
     end; // of if LoadFloatFromEdit
  end; // of if not FlagShow
end; // of procedure

// -------------------------------------------------------------------------
//   Img  Phase
procedure TESetEditForm.EditNewXipChange(Sender: TObject);
begin
  //   onChange   TEdit  
  if not FlagShow
  then begin
     //  Extended   TEdit     .
     if LoadFloatFromEdit ( EditNewXip,  // TEdit  
                            True,        //  ShowMessage
                            EWork)
     then begin
        with ptESetCellCTRL^
        do begin
           if CBoxCVPCrd.ItemIndex > 0
           then begin
              //      
              if CBoxCVPPG.ItemIndex > 0
              then NewX.p := cGradToRad * EWork //    
              else NewX.p := EWork;
              PolarToDecart(NewX);
           end
           else begin
              //      
              NewX.i := EWork;
              DecartToPolar(NewX);
           end;
           ChFlag := True; //   -   
        end; // of with ptESetCellCTRL^
     end; // of if LoadFloatFromEdit
  end; // of if not FlagShow
end; // of procedure

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------


end.
