unit ESetGridService;

interface
uses StdCtrls, Grids, SysUtils,
    MAINDATA, ComplexOp, Reports, CommonService;

//     Grid
const
      cTitleRowWidth  = 60;      //     
      cTitleColWidth  = 250;     //     
      cSelectColWidth = 40;      //   

//  Grid   
const cRGridFixRow  = 1;         //     
      cRGridFixCol  = 1;         //     

      cRGridColSelX = cRGridFixCol;        //    X
      cRGridColX    = cRGridColSelX + 1;   //   X
      cRGridColSelY = cRGridColX + 1;      //    y
      cRGridColY    = cRGridColSelY + 1;   //   Y
      cRGridColB    = cRGridColY + 1;      //    
const
      //     Grid 
      cRGridMaxCol  = cRGridColB;
      //     Grid 
      cRGridColTitle : array[0..cRGridMaxCol] of string =
      (' i  k',
       ' X - on',
       '   X [ i ]',
       ' b - on',
       '  b [ k ]',
       ' k -  ');

//---------------------------------------------------------------------------
//     
//---------------------------------------------------------------------------

//  Grid    
function InitESetGrid
          (
           ESetGrid : TStringGrid;    // Grid   
           MaxRow   : LongInt;        //   
           MaxCol   : LongInt         //   
           ) : boolean;

//  Grid      
function InitRootGrid
           (
            RqGrid    : TStringGrid;  // Grid    
            RqMaxRow  : LongInt       //    
           ) : boolean;

//    (Grids),     
function InitAllESetGrids
           (
            RqESetCTRL : TESetCTRL;    //    
            RqESetGrid : TStringGrid;  // Grid   
            RqRootGrid : TStringGrid   // Grid    
            ) : boolean;

//---------------------------------------------------------------------------
//      
//---------------------------------------------------------------------------

//    RqESet    RqGrid
procedure ShowCellESet
        (RqESet  : TESetArray;    //   
         RqRow   : LongInt;       //    
         RqCol   : LongInt;       //    
         RqRM    : TStaticText;   //    Re  Module
         RqIP    : TStaticText);  //    Im  Phase

//  RqESet   RqGrid
procedure ShowESetToGrid
        (RqESet     : TESetArray;       //   
         RqVP       : T2CmpToStrParm;   //    
         RqGrid     : TStringGrid);     //  Grid

//  RqESetRoots   RqGrid
procedure ShowESetRootsToGrid
        (RqESetRoots : TESetRoots;      //   
         RqVP        : T2CmpToStrParm;  //    
         RqGrid      : TStringGrid);    //  Grid

//   RqGridRoot     
//   (  =  )   ESetSRC
procedure ShowESetNEqToGrid
        (RqESetCTRL  : TESetCTRL;       //    
         RqVP        : T2CmpToStrParm;  //    
         RqGrid      : TStringGrid);    //  Grid

//===========================================================================
//===========================================================================
implementation
//===========================================================================
//===========================================================================
//---------------------------------------------------------------------------
//     
//---------------------------------------------------------------------------

// 31.08.2010 (ver.1.00)
//  Grid    
function InitESetGrid
          (
           ESetGrid : TStringGrid;    // Grid   
           MaxRow   : LongInt;        //   
           MaxCol   : LongInt         //   
           ) : boolean;
var Row, Col : LongInt;
begin
 Result := False;        //  
 try
    //    
    SetRunProress('InitESetGrid', 0, 1, MaxRow);
    //      Grid   
    ESetGrid.RowCount := MaxRow + 1;
    ESetGrid.ColCount := MaxCol + 1;
    //        Grid
    ESetGrid.FixedRows := 1;
    ESetGrid.FixedCols := 1;
    //   Grid
    for Row := 0 to MaxRow do
    begin
       //     
       ProressOneStep();
       for Col := 0 to MaxCol do
       begin
          if Row = 0
          then begin
             //      Grid
             if Col = 0
             then begin
                ESetGrid.ColWidths[Col]:= cTitleRowWidth;
                ESetGrid.Cells[Col,Row]:= '';
             end
             else begin
                if Col = MaxCol
                then begin
                   ESetGrid.ColWidths[Col]:= cTitleColWidth;
                   ESetGrid.Cells[Col,Row]:= ' b [ k ] =  ';
                end
                else begin
                   ESetGrid.ColWidths[Col]:= cTitleColWidth;
                   ESetGrid.Cells[Col,Row]:= 'X'
                                           + IntToStr(Col-1)
                                           + '   ( i = '
                                           + IntToStr(Col-1)
                                           + ' )';
                end;
             end;
          end {if Row = 0 then}
          else begin
            //      Grid
            if Col = 0
            then begin
               ESetGrid.Cells[0,Row]:= 'A [ ' + IntToStr(Row-1) + ', i ]';
            end;
          end ; {if Row = 0 then}
       end; {for Col}
    end; {for Row}
    //  
    Result := True;
    DebugMsgToReport(' Grid    ');
 except
    ErrorMsgToReport (True,  //    
                      False, //   
                      ' SYSERROR(InitESetGrid):'
                    + '   GRID   ');
 end;
 //   
 ProressToMin();
end; // of function InitESetGrid

//---------------------------------------------------------------------------
// 31.08.2010 (ver.1.00)
//  Grid      
function InitRootGrid
           (
            RqGrid    : TStringGrid;  // Grid    
            RqMaxRow  : LongInt       //    
           ) : boolean;
var Row, Col : integer;
begin
 Result := False;        //  
 try
   //        Grid
   RqGrid.FixedRows := cRGridFixRow;
   RqGrid.FixedCols := cRGridFixCol;
   //      Grid   
   RqGrid.RowCount := RqMaxRow + RqGrid.FixedRows;
   RqGrid.ColCount := cRGridMaxCol + 1;
   //   Grid
   for Row := 0 to RqGrid.RowCount - 1 do
   begin
      for Col := 0 to RqGrid.ColCount - 1 do
      begin
         case Row of
         0: begin
                //   
                case Col of
                  0 : begin
                     RqGrid.ColWidths[Col]:= cTitleRowWidth;
                  end;
                  cRGridColSelX : begin  //    X
                     RqGrid.ColWidths[Col]:= cSelectColWidth;
                  end;
                  cRGridColX    : begin  //   X
                     RqGrid.ColWidths[Col]:= cTitleColWidth;
                  end;
                  cRGridColSelY : begin   //    y
                     RqGrid.ColWidths[Col]:= cSelectColWidth;
                  end;
                  cRGridColY    : begin  //   Y
                     RqGrid.ColWidths[Col]:= cTitleColWidth;
                  end;
                  cRGridColB    : begin  //    
                     RqGrid.ColWidths[Col]:= cTitleColWidth;
                  end;
                end; // of case Col
                //    
                RqGrid.Cells[Col,Row]:= cRGridColTitle[Col];
            end;
            else begin
                case Col of
                0 : begin
                      //   
                      RqGrid.Cells[Col,Row]:= IntToStr(Row -1);
                    end;
                    else begin
                      //   
                      RqGrid.Cells[Col,Row]:= '';
                    end;
                end; // of case Col
            end;
         end; // of case Row
      end; {for Col}
   end; {for Row}
   //  
   Result := True;
   DebugMsgToReport(' Grid     ');
 except
   ErrorMsgToReport (True,  //    
                     False, //   
                     ' SYSERROR(InitRootGrid):'
                   + '   GRID    ');
 end;
end; // of function InitRootGrid

//---------------------------------------------------------------------------
// 31.08.2010 (ver.1.00)
//    (Grids),     
function InitAllESetGrids
           (
            RqESetCTRL : TESetCTRL;    //    
            RqESetGrid : TStringGrid;  // Grid   
            RqRootGrid : TStringGrid   // Grid    
            ) : boolean;
begin
  Result := False;                        //  
  //  RqESetGrid      
  if InitESetGrid
             (RqESetGrid,                 // Grid   
              RqESetCTRL.ESetRowCount,    //    
              RqESetCTRL.ESetColCount)    //   
  then begin
     //  RqRootGrid      
     if InitRootGrid
             (RqRootGrid,                 // Grid    
              RqESetCTRL.ESetRowCount)    //   
     then Result := True;   //  
  end;
end; // of function InitAllESetGrids

//---------------------------------------------------------------------------
//      
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//    RqESet    RqGrid
procedure ShowCellESet
        (RqESet  : TESetArray;    //   
         RqRow   : LongInt;       //    
         RqCol   : LongInt;       //    
         RqRM    : TStaticText;   //    Re  Module
         RqIP    : TStaticText);  //    Im  Phase
//    
//      ESet
const VPRM : T2CmpToStrParm = (VPCrd : 0;      // 
                               VPMod : 1;      //  Re
                               VPPrc : 4;      // FIX Auto
                               VPPG  : False);
      VPIP : T2CmpToStrParm = (VPCrd : 0;      // 
                               VPMod : 2;      //  Im
                               VPPrc : 4;      // FIX Auto
                               VPPG  : False);
begin
  if (RqRow >= Low(RqESet)) and (RqRow <= High(RqESet))
  then begin
    if (RqCol >= Low(RqESet[RqRow])) and (RqCol <= High(RqESet[RqRow]))
    then begin
       RqRM.Caption := ComplexToStr(RqESet[RqRow,RqCol], VPRM);
       RqIP.Caption := ComplexToStr(RqESet[RqRow,RqCol], VPIP);
    end;
  end;
end; // of procedure

//---------------------------------------------------------------------------
//  RqESet   RqGrid
procedure ShowESetToGrid
        (RqESet  : TESetArray;      //   
         RqVP    : T2CmpToStrParm;  //    
         RqGrid  : TStringGrid);    //  Grid
var MRow, MCol,                     //   
    GRow, GCol : LongInt;           //   Grid
    CWork      : T2Complex;
begin
 with RqGrid do
 begin
   if (Length(RqESet)  = RqGrid.RowCount - RqGrid.FixedRows)  and
      (RqGrid.ColCount = RqGrid.RowCount + 1)
   then begin
     //    
     SetRunProress('ShowESetToGrid', 0, 1, High(RqESet));
     for MRow := Low(RqESet) to High(RqESet) do
     begin
       //     
       ProressOneStep();
       GRow := MRow + FixedRows;
       for MCol := Low(RqESet[MRow]) to High(RqESet[MRow]) do
       begin
         GCol := MCol + FixedCols;
         ComplexToComplex(RqESet[MRow,MCol],CWork);
         Cells[GCol, GRow] := ComplexToStr(CWork, RqVP);
       end; // of for MCol
     end; // of for MRow
   end;
 end; // of with RqGrid
 //   
 ProressToMin();
end; // of procedure

//---------------------------------------------------------------------------
//   RqESetRoots  RqGrid
procedure ShowESetRootsToGrid
        (RqESetRoots : TESetRoots;      //   
         RqVP        : T2CmpToStrParm;  //    
         RqGrid      : TStringGrid);    //  Grid

var   ARow,             //   
      GRow : LongInt;   //   Grid
begin
 with RqGrid do
 begin
    if Length(RqESetRoots) = RqGrid.RowCount - RqGrid.FixedRows
    then begin
      //    
      SetRunProress('ShowESetRootsToGrid', 0, 1, High(RqESetRoots));
      for ARow := Low(RqESetRoots) to High(RqESetRoots) do
      begin
         //     
         ProressOneStep();
         GRow := ARow + FixedRows;
         RqGrid.Cells[cRGridColX, GRow] :=
                      ComplexToStr(RqESetRoots[ARow], RqVP);
      end; // of for ARow
    end;
 end; // of with RqGrid
 //   
 ProressToMin();
end; {of procedure}

//---------------------------------------------------------------------------
//   RqGridRoot     
//   (  =  )   ESetSRC
procedure ShowESetNEqToGrid
        (RqESetCTRL  : TESetCTRL;       //    
         RqVP        : T2CmpToStrParm;  //    
         RqGrid      : TStringGrid);    //  Grid
var   ARow, ACol,              //    
      GRow       : LongInt;    //     Grid
      CWork      : T2Complex;  //    
begin
   with RqESetCTRL
   do begin
      //    
      SetRunProress('ShowESetNEqToGrid', 0, 1, High(ESetSRC));
      //      
      for ARow := Low(ESetSRC) to High(ESetSRC) do
      begin
        //     
         ProressOneStep();
        // -------------------------------
        //      
        //      
        ZeroToComplex(CWork);
        for ACol := Low(ESetSRC) to High(ESetSRC) do
        begin
          CWork  := SumDC (
                           MulDC(ESetSRC[ARow, ACol], ESetRoots[ACol]),
                           CWork
                          );
        end; // of for ACol
        //      
        //     ( )
        CWork := SubDC ( ESetSRC[ARow, High(ESetSRC)+1], CWork);
        DecartToPolar(CWork);
        // -------------------------------

        GRow :=  ARow + RqGrid.FixedRows;
        //   
        RqGrid.Cells[cRGridColY, GRow] := ComplexToStr
                     (ESetSRC[ARow, High(ESetSRC)+1], RqVP);
        //   
        RqGrid.Cells[cRGridColB, GRow] := ComplexToStr (CWork, RqVP);

        // -------------------------------
      end; // of for ARow
   end; // of with RqESetCTRL
   //   
   ProressToMin();
end; {of procedure}


end.
